/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.security.Credentials;
import android.security.KeyPairGeneratorSpec;
import android.security.KeyStore;
import com.android.org.bouncycastle.x509.X509V3CertificateGenerator;
import com.android.org.conscrypt.OpenSSLEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;

public class AndroidKeyPairGenerator
extends KeyPairGeneratorSpi {
    private KeyStore mKeyStore;
    private KeyPairGeneratorSpec mSpec;

    public KeyPair generateKeyPair() {
        byte[] certBytes;
        X509Certificate cert;
        PublicKey pubKey;
        PrivateKey privKey;
        if (this.mKeyStore == null || this.mSpec == null) {
            throw new IllegalStateException("Must call initialize with an android.security.KeyPairGeneratorSpec first");
        }
        if ((this.mSpec.getFlags() & 1) != 0 && this.mKeyStore.state() != KeyStore.State.UNLOCKED) {
            throw new IllegalStateException("Android keystore must be in initialized and unlocked state if encryption is required");
        }
        String alias = this.mSpec.getKeystoreAlias();
        Credentials.deleteAllTypesForAlias(this.mKeyStore, alias);
        int keyType = KeyStore.getKeyTypeForAlgorithm(this.mSpec.getKeyType());
        byte[][] args = AndroidKeyPairGenerator.getArgsForKeyType(keyType, this.mSpec.getAlgorithmParameterSpec());
        String privateKeyAlias = "USRPKEY_" + alias;
        if (!this.mKeyStore.generate(privateKeyAlias, -1, keyType, this.mSpec.getKeySize(), this.mSpec.getFlags(), args)) {
            throw new IllegalStateException("could not generate key in keystore");
        }
        OpenSSLEngine engine = OpenSSLEngine.getInstance((String)"keystore");
        try {
            privKey = engine.getPrivateKeyById(privateKeyAlias);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Can't get key", e);
        }
        byte[] pubKeyBytes = this.mKeyStore.getPubkey(privateKeyAlias);
        try {
            KeyFactory keyFact = KeyFactory.getInstance(this.mSpec.getKeyType());
            pubKey = keyFact.generatePublic(new X509EncodedKeySpec(pubKeyBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Can't instantiate key generator", e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException("keystore returned invalid key encoding", e);
        }
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setPublicKey(pubKey);
        certGen.setSerialNumber(this.mSpec.getSerialNumber());
        certGen.setSubjectDN(this.mSpec.getSubjectDN());
        certGen.setIssuerDN(this.mSpec.getSubjectDN());
        certGen.setNotBefore(this.mSpec.getStartDate());
        certGen.setNotAfter(this.mSpec.getEndDate());
        certGen.setSignatureAlgorithm(AndroidKeyPairGenerator.getDefaultSignatureAlgorithmForKeyType(this.mSpec.getKeyType()));
        try {
            cert = certGen.generate(privKey);
        }
        catch (Exception e) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, alias);
            throw new IllegalStateException("Can't generate certificate", e);
        }
        try {
            certBytes = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, alias);
            throw new IllegalStateException("Can't get encoding of certificate", e);
        }
        if (!this.mKeyStore.put("USRCERT_" + alias, certBytes, -1, this.mSpec.getFlags())) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, alias);
            throw new IllegalStateException("Can't store certificate in AndroidKeyStore");
        }
        return new KeyPair(pubKey, privKey);
    }

    private static String getDefaultSignatureAlgorithmForKeyType(String keyType) {
        if ("RSA".equalsIgnoreCase(keyType)) {
            return "sha256WithRSA";
        }
        if ("DSA".equalsIgnoreCase(keyType)) {
            return "sha1WithDSA";
        }
        if ("EC".equalsIgnoreCase(keyType)) {
            return "sha256WithECDSA";
        }
        throw new IllegalArgumentException("Unsupported key type " + keyType);
    }

    private static byte[][] getArgsForKeyType(int keyType, AlgorithmParameterSpec spec) {
        switch (keyType) {
            case 6: {
                if (!(spec instanceof RSAKeyGenParameterSpec)) break;
                RSAKeyGenParameterSpec rsaSpec = (RSAKeyGenParameterSpec)spec;
                return new byte[][]{rsaSpec.getPublicExponent().toByteArray()};
            }
            case 116: {
                if (!(spec instanceof DSAParameterSpec)) break;
                DSAParameterSpec dsaSpec = (DSAParameterSpec)spec;
                return new byte[][]{dsaSpec.getG().toByteArray(), dsaSpec.getP().toByteArray(), dsaSpec.getQ().toByteArray()};
            }
        }
        return null;
    }

    public void initialize(int keysize, SecureRandom random) {
        throw new IllegalArgumentException("cannot specify keysize with AndroidKeyPairGenerator");
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        KeyPairGeneratorSpec spec;
        if (params == null) {
            throw new InvalidAlgorithmParameterException("must supply params of type android.security.KeyPairGeneratorSpec");
        }
        if (!(params instanceof KeyPairGeneratorSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type android.security.KeyPairGeneratorSpec");
        }
        this.mSpec = spec = (KeyPairGeneratorSpec)params;
        this.mKeyStore = KeyStore.getInstance();
    }
}

