/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.ScanResult;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class BatchedScanResult
implements Parcelable {
    private static final String TAG = "BatchedScanResult";
    public boolean truncated;
    public final List<ScanResult> scanResults = new ArrayList<ScanResult>();
    public static final Parcelable.Creator<BatchedScanResult> CREATOR = new Parcelable.Creator<BatchedScanResult>(){

        @Override
        public BatchedScanResult createFromParcel(Parcel in) {
            BatchedScanResult result = new BatchedScanResult();
            result.truncated = in.readInt() == 1;
            int count = in.readInt();
            while (count-- > 0) {
                result.scanResults.add(ScanResult.CREATOR.createFromParcel(in));
            }
            return result;
        }

        public BatchedScanResult[] newArray(int size) {
            return new BatchedScanResult[size];
        }
    };

    public BatchedScanResult() {
    }

    public BatchedScanResult(BatchedScanResult source) {
        this.truncated = source.truncated;
        for (ScanResult s : source.scanResults) {
            this.scanResults.add(new ScanResult(s));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("BatchedScanResult: ").append("truncated: ").append(String.valueOf(this.truncated)).append("scanResults: [");
        for (ScanResult s : this.scanResults) {
            sb.append(" <").append(s.toString()).append("> ");
        }
        sb.append(" ]");
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.truncated ? 1 : 0);
        dest.writeInt(this.scanResults.size());
        for (ScanResult s : this.scanResults) {
            s.writeToParcel(dest, flags);
        }
    }
}

