/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import android.net.dhcp.DhcpStateMachine;
import java.net.InetAddress;
import java.nio.ByteBuffer;

class DhcpInformPacket
extends DhcpPacket {
    DhcpInformPacket(int transId, InetAddress clientIp, InetAddress yourIp, InetAddress nextIp, InetAddress relayIp, byte[] clientMac) {
        super(transId, clientIp, yourIp, nextIp, relayIp, clientMac, false);
    }

    public String toString() {
        String s = super.toString();
        return s + " INFORM";
    }

    public ByteBuffer buildPacket(int encap, short destUdp, short srcUdp) {
        ByteBuffer result = ByteBuffer.allocate(1500);
        this.fillInPacket(encap, this.mClientIp, this.mYourIp, destUdp, srcUdp, result, (byte)1, false);
        result.flip();
        return result;
    }

    void finishPacket(ByteBuffer buffer) {
        byte[] clientId = new byte[7];
        clientId[0] = 1;
        System.arraycopy(this.mClientMac, 0, clientId, 1, 6);
        this.addTlv(buffer, (byte)53, (byte)3);
        this.addTlv(buffer, (byte)55, this.mRequestedParams);
        this.addTlvEnd(buffer);
    }

    public void doNextOp(DhcpStateMachine machine) {
        InetAddress clientRequest = this.mRequestedIp == null ? this.mClientIp : this.mRequestedIp;
        machine.onInformReceived(this.mTransId, this.mClientMac, clientRequest, this.mRequestedParams);
    }
}

