/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.IConnectivityManager;
import android.net.LinkAddress;
import android.net.RouteInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.net.VpnConfig;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class VpnService
extends Service {
    public static final String SERVICE_INTERFACE = "android.net.VpnService";

    private static IConnectivityManager getService() {
        return IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity"));
    }

    public static Intent prepare(Context context) {
        try {
            if (VpnService.getService().prepareVpn(context.getPackageName(), null)) {
                return null;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return VpnConfig.getIntentForConfirmation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean protect(int socket) {
        ParcelFileDescriptor dup = null;
        try {
            dup = ParcelFileDescriptor.fromFd(socket);
            boolean bl = VpnService.getService().protectVpn(dup);
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dup.close();
            }
            catch (Exception e) {}
        }
    }

    public boolean protect(Socket socket) {
        return this.protect(socket.getFileDescriptor$().getInt$());
    }

    public boolean protect(DatagramSocket socket) {
        return this.protect(socket.getFileDescriptor$().getInt$());
    }

    public IBinder onBind(Intent intent) {
        if (intent != null && SERVICE_INTERFACE.equals(intent.getAction())) {
            return new Callback();
        }
        return null;
    }

    public void onRevoke() {
        this.stopSelf();
    }

    public class Builder {
        private final VpnConfig mConfig = new VpnConfig();
        private final List<LinkAddress> mAddresses = new ArrayList<LinkAddress>();
        private final List<RouteInfo> mRoutes = new ArrayList<RouteInfo>();

        public Builder() {
            this.mConfig.user = VpnService.this.getClass().getName();
        }

        public Builder setSession(String session) {
            this.mConfig.session = session;
            return this;
        }

        public Builder setConfigureIntent(PendingIntent intent) {
            this.mConfig.configureIntent = intent;
            return this;
        }

        public Builder setMtu(int mtu) {
            if (mtu <= 0) {
                throw new IllegalArgumentException("Bad mtu");
            }
            this.mConfig.mtu = mtu;
            return this;
        }

        private void check(InetAddress address, int prefixLength) {
            if (address.isLoopbackAddress()) {
                throw new IllegalArgumentException("Bad address");
            }
            if (address instanceof Inet4Address) {
                if (prefixLength < 0 || prefixLength > 32) {
                    throw new IllegalArgumentException("Bad prefixLength");
                }
            } else if (address instanceof Inet6Address) {
                if (prefixLength < 0 || prefixLength > 128) {
                    throw new IllegalArgumentException("Bad prefixLength");
                }
            } else {
                throw new IllegalArgumentException("Unsupported family");
            }
        }

        public Builder addAddress(InetAddress address, int prefixLength) {
            this.check(address, prefixLength);
            if (address.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Bad address");
            }
            this.mAddresses.add(new LinkAddress(address, prefixLength));
            return this;
        }

        public Builder addAddress(String address, int prefixLength) {
            return this.addAddress(InetAddress.parseNumericAddress(address), prefixLength);
        }

        public Builder addRoute(InetAddress address, int prefixLength) {
            int offset;
            this.check(address, prefixLength);
            byte[] bytes = address.getAddress();
            if (offset < bytes.length) {
                int n = offset;
                bytes[n] = (byte)(bytes[n] << prefixLength % 8);
                for (offset = prefixLength / 8; offset < bytes.length; ++offset) {
                    if (bytes[offset] == 0) continue;
                    throw new IllegalArgumentException("Bad address");
                }
            }
            this.mRoutes.add(new RouteInfo(new LinkAddress(address, prefixLength), null));
            return this;
        }

        public Builder addRoute(String address, int prefixLength) {
            return this.addRoute(InetAddress.parseNumericAddress(address), prefixLength);
        }

        public Builder addDnsServer(InetAddress address) {
            if (address.isLoopbackAddress() || address.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Bad address");
            }
            if (this.mConfig.dnsServers == null) {
                this.mConfig.dnsServers = new ArrayList<String>();
            }
            this.mConfig.dnsServers.add(address.getHostAddress());
            return this;
        }

        public Builder addDnsServer(String address) {
            return this.addDnsServer(InetAddress.parseNumericAddress(address));
        }

        public Builder addSearchDomain(String domain) {
            if (this.mConfig.searchDomains == null) {
                this.mConfig.searchDomains = new ArrayList<String>();
            }
            this.mConfig.searchDomains.add(domain);
            return this;
        }

        public ParcelFileDescriptor establish() {
            this.mConfig.addresses = this.mAddresses;
            this.mConfig.routes = this.mRoutes;
            try {
                return VpnService.getService().establishVpn(this.mConfig);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private class Callback
    extends Binder {
        private Callback() {
        }

        protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) {
            if (code == 0xFFFFFF) {
                VpnService.this.onRevoke();
                return true;
            }
            return false;
        }
    }
}

