/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Credentials;
import android.net.LocalSocketAddress;
import android.net.LocalSocketImpl;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LocalSocket
implements Closeable {
    private LocalSocketImpl impl;
    private volatile boolean implCreated;
    private LocalSocketAddress localAddress;
    private boolean isBound;
    private boolean isConnected;
    private final int sockType;
    static final int SOCKET_UNKNOWN = 0;
    public static final int SOCKET_DGRAM = 1;
    public static final int SOCKET_STREAM = 2;
    public static final int SOCKET_SEQPACKET = 3;

    public LocalSocket() {
        this(2);
    }

    public LocalSocket(int sockType) {
        this(new LocalSocketImpl(), sockType);
        this.isBound = false;
        this.isConnected = false;
    }

    public LocalSocket(FileDescriptor fd) throws IOException {
        this(new LocalSocketImpl(fd), 0);
        this.isBound = true;
        this.isConnected = true;
    }

    LocalSocket(LocalSocketImpl impl, int sockType) {
        this.impl = impl;
        this.sockType = sockType;
        this.isConnected = false;
        this.isBound = false;
    }

    public String toString() {
        return super.toString() + " impl:" + this.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implCreateIfNeeded() throws IOException {
        if (!this.implCreated) {
            LocalSocket localSocket = this;
            synchronized (localSocket) {
                if (!this.implCreated) {
                    try {
                        this.impl.create(this.sockType);
                    }
                    finally {
                        this.implCreated = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(LocalSocketAddress endpoint) throws IOException {
        LocalSocket localSocket = this;
        synchronized (localSocket) {
            if (this.isConnected) {
                throw new IOException("already connected");
            }
            this.implCreateIfNeeded();
            this.impl.connect(endpoint, 0);
            this.isConnected = true;
            this.isBound = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(LocalSocketAddress bindpoint) throws IOException {
        this.implCreateIfNeeded();
        LocalSocket localSocket = this;
        synchronized (localSocket) {
            if (this.isBound) {
                throw new IOException("already bound");
            }
            this.localAddress = bindpoint;
            this.impl.bind(this.localAddress);
            this.isBound = true;
        }
    }

    public LocalSocketAddress getLocalSocketAddress() {
        return this.localAddress;
    }

    public InputStream getInputStream() throws IOException {
        this.implCreateIfNeeded();
        return this.impl.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        this.implCreateIfNeeded();
        return this.impl.getOutputStream();
    }

    public void close() throws IOException {
        this.implCreateIfNeeded();
        this.impl.close();
    }

    public void shutdownInput() throws IOException {
        this.implCreateIfNeeded();
        this.impl.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.implCreateIfNeeded();
        this.impl.shutdownOutput();
    }

    public void setReceiveBufferSize(int size) throws IOException {
        this.impl.setOption(4098, size);
    }

    public int getReceiveBufferSize() throws IOException {
        return (Integer)this.impl.getOption(4098);
    }

    public void setSoTimeout(int n) throws IOException {
        this.impl.setOption(4102, n);
    }

    public int getSoTimeout() throws IOException {
        return (Integer)this.impl.getOption(4102);
    }

    public void setSendBufferSize(int n) throws IOException {
        this.impl.setOption(4097, n);
    }

    public int getSendBufferSize() throws IOException {
        return (Integer)this.impl.getOption(4097);
    }

    public LocalSocketAddress getRemoteSocketAddress() {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean isConnected() {
        return this.isConnected;
    }

    public boolean isClosed() {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean isBound() {
        return this.isBound;
    }

    public boolean isOutputShutdown() {
        throw new UnsupportedOperationException();
    }

    public boolean isInputShutdown() {
        throw new UnsupportedOperationException();
    }

    public void connect(LocalSocketAddress endpoint, int timeout) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setFileDescriptorsForSend(FileDescriptor[] fds) {
        this.impl.setFileDescriptorsForSend(fds);
    }

    public FileDescriptor[] getAncillaryFileDescriptors() throws IOException {
        return this.impl.getAncillaryFileDescriptors();
    }

    public Credentials getPeerCredentials() throws IOException {
        return this.impl.getPeerCredentials();
    }

    public FileDescriptor getFileDescriptor() {
        return this.impl.getFileDescriptor();
    }
}

