/*
 * Decompiled with CFR 0.152.
 */
package android.media.videoeditor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class WaveformData {
    private final int mFrameDurationMs;
    private final int mFramesCount;
    private final short[] mGains;

    private WaveformData() throws IOException {
        this.mFrameDurationMs = 0;
        this.mFramesCount = 0;
        this.mGains = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WaveformData(String audioWaveformFilename) throws IOException {
        if (audioWaveformFilename == null) {
            throw new IllegalArgumentException("WaveformData : filename is null");
        }
        FileInputStream audioGraphFileReadHandle = null;
        try {
            int i;
            File audioGraphFileContext = new File(audioWaveformFilename);
            audioGraphFileReadHandle = new FileInputStream(audioGraphFileContext);
            byte[] tempFrameDuration = new byte[4];
            audioGraphFileReadHandle.read(tempFrameDuration, 0, 4);
            int tempFrameDurationMs = 0;
            int tempFramesCounter = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                tempFrameDurationMs <<= 8;
                tempFrameDurationMs |= tempFrameDuration[i2] & 0xFF;
            }
            this.mFrameDurationMs = tempFrameDurationMs;
            byte[] tempFramesCount = new byte[4];
            audioGraphFileReadHandle.read(tempFramesCount, 0, 4);
            for (i = 0; i < 4; ++i) {
                tempFramesCounter <<= 8;
                tempFramesCounter |= tempFramesCount[i] & 0xFF;
            }
            this.mFramesCount = tempFramesCounter;
            this.mGains = new short[this.mFramesCount];
            for (i = 0; i < this.mFramesCount; ++i) {
                this.mGains[i] = (short)audioGraphFileReadHandle.read();
            }
        }
        finally {
            if (audioGraphFileReadHandle != null) {
                audioGraphFileReadHandle.close();
            }
        }
    }

    public int getFrameDuration() {
        return this.mFrameDurationMs;
    }

    public int getFramesCount() {
        return this.mFramesCount;
    }

    public short[] getFrameGains() {
        return this.mGains;
    }
}

