/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraMetadata;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.Face;
import android.hardware.camera2.Rational;
import android.hardware.camera2.impl.MetadataMarshalClass;
import android.hardware.camera2.impl.MetadataMarshalRect;
import android.hardware.camera2.impl.MetadataMarshalSize;
import android.hardware.camera2.impl.MetadataMarshalString;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CameraMetadataNative
extends CameraMetadata
implements Parcelable {
    private static final String TAG = "CameraMetadataJV";
    private static final boolean VERBOSE = Log.isLoggable("CameraMetadataJV", 2);
    private static final int NATIVE_JPEG_FORMAT = 33;
    public static final Parcelable.Creator<CameraMetadataNative> CREATOR = new Parcelable.Creator<CameraMetadataNative>(){

        @Override
        public CameraMetadataNative createFromParcel(Parcel in) {
            CameraMetadataNative metadata = new CameraMetadataNative();
            metadata.readFromParcel(in);
            return metadata;
        }

        public CameraMetadataNative[] newArray(int size) {
            return new CameraMetadataNative[size];
        }
    };
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_INT32 = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_INT64 = 3;
    public static final int TYPE_DOUBLE = 4;
    public static final int TYPE_RATIONAL = 5;
    public static final int NUM_TYPES = 6;
    private long mMetadataPtr;
    private static final HashMap<Class<? extends Enum>, int[]> sEnumValues = new HashMap();
    static HashMap<Class<?>, MetadataMarshalClass<?>> sMarshalerMap = new HashMap();

    public CameraMetadataNative() {
        this.mMetadataPtr = this.nativeAllocate();
        if (this.mMetadataPtr == 0L) {
            throw new OutOfMemoryError("Failed to allocate native CameraMetadata");
        }
    }

    public CameraMetadataNative(CameraMetadataNative other) {
        this.mMetadataPtr = this.nativeAllocateCopy(other);
        if (this.mMetadataPtr == 0L) {
            throw new OutOfMemoryError("Failed to allocate native CameraMetadata");
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.nativeWriteToParcel(dest);
    }

    @Override
    public <T> T get(CameraMetadata.Key<T> key) {
        T value = this.getOverride(key);
        if (value != null) {
            return value;
        }
        return this.getBase(key);
    }

    public void readFromParcel(Parcel in) {
        this.nativeReadFromParcel(in);
    }

    public <T> void set(CameraMetadata.Key<T> key, T value) {
        if (this.setOverride(key, value)) {
            return;
        }
        this.setBase(key, value);
    }

    private void close() {
        this.nativeClose();
        this.mMetadataPtr = 0L;
    }

    private static int getTypeSize(int nativeType) {
        switch (nativeType) {
            case 0: {
                return 1;
            }
            case 1: 
            case 2: {
                return 4;
            }
            case 3: 
            case 4: 
            case 5: {
                return 8;
            }
        }
        throw new UnsupportedOperationException("Unknown type, can't get size " + nativeType);
    }

    private static Class<?> getExpectedType(int nativeType) {
        switch (nativeType) {
            case 0: {
                return Byte.TYPE;
            }
            case 1: {
                return Integer.TYPE;
            }
            case 2: {
                return Float.TYPE;
            }
            case 3: {
                return Long.TYPE;
            }
            case 4: {
                return Double.TYPE;
            }
            case 5: {
                return Rational.class;
            }
        }
        throw new UnsupportedOperationException("Unknown type, can't map to Java type " + nativeType);
    }

    private static <T> int packSingleNative(T value, ByteBuffer buffer, Class<T> type, int nativeType, boolean sizeOnly) {
        if (!sizeOnly) {
            if (nativeType == 0 && type == Boolean.TYPE) {
                boolean asBool = (Boolean)value;
                byte asByte = (byte)(asBool ? 1 : 0);
                value = asByte;
            } else if (nativeType == 0 && type == Integer.TYPE) {
                int asInt = (Integer)value;
                byte asByte = (byte)asInt;
                value = asByte;
            } else if (type != CameraMetadataNative.getExpectedType(nativeType)) {
                throw new UnsupportedOperationException("Tried to pack a type of " + type + " but we expected the type to be " + CameraMetadataNative.getExpectedType(nativeType));
            }
            if (nativeType == 0) {
                buffer.put((Byte)value);
            } else if (nativeType == 1) {
                buffer.putInt((Integer)value);
            } else if (nativeType == 2) {
                buffer.putFloat(((Float)value).floatValue());
            } else if (nativeType == 3) {
                buffer.putLong((Long)value);
            } else if (nativeType == 4) {
                buffer.putDouble((Double)value);
            } else if (nativeType == 5) {
                Rational r = (Rational)value;
                buffer.putInt(r.getNumerator());
                buffer.putInt(r.getDenominator());
            }
        }
        return CameraMetadataNative.getTypeSize(nativeType);
    }

    private static <T> int packSingle(T value, ByteBuffer buffer, Class<T> type, int nativeType, boolean sizeOnly) {
        int size = 0;
        size = type.isPrimitive() || type == Rational.class ? CameraMetadataNative.packSingleNative(value, buffer, type, nativeType, sizeOnly) : (type.isEnum() ? CameraMetadataNative.packEnum((Enum)value, buffer, type, nativeType, sizeOnly) : (type.isArray() ? CameraMetadataNative.packArray(value, buffer, type, nativeType, sizeOnly) : CameraMetadataNative.packClass(value, buffer, type, nativeType, sizeOnly)));
        return size;
    }

    private static <T extends Enum<T>> int packEnum(T value, ByteBuffer buffer, Class<T> type, int nativeType, boolean sizeOnly) {
        return CameraMetadataNative.packSingleNative(CameraMetadataNative.getEnumValue(value), buffer, Integer.TYPE, nativeType, sizeOnly);
    }

    private static <T> int packClass(T value, ByteBuffer buffer, Class<T> type, int nativeType, boolean sizeOnly) {
        MetadataMarshalClass<T> marshaler = CameraMetadataNative.getMarshaler(type, nativeType);
        if (marshaler == null) {
            throw new IllegalArgumentException(String.format("Unknown Key type: %s", type));
        }
        return marshaler.marshal(value, buffer, nativeType, sizeOnly);
    }

    private static <T> int packArray(T value, ByteBuffer buffer, Class<T> type, int nativeType, boolean sizeOnly) {
        int size = 0;
        int arrayLength = Array.getLength(value);
        Class<?> componentType = type.getComponentType();
        for (int i = 0; i < arrayLength; ++i) {
            size += CameraMetadataNative.packSingle(Array.get(value, i), buffer, componentType, nativeType, sizeOnly);
        }
        return size;
    }

    private static <T> T unpackSingleNative(ByteBuffer buffer, Class<T> type, int nativeType) {
        Object val;
        if (nativeType == 0) {
            val = buffer.get();
        } else if (nativeType == 1) {
            val = buffer.getInt();
        } else if (nativeType == 2) {
            val = Float.valueOf(buffer.getFloat());
        } else if (nativeType == 3) {
            val = buffer.getLong();
        } else if (nativeType == 4) {
            val = buffer.getDouble();
        } else if (nativeType == 5) {
            val = new Rational(buffer.getInt(), buffer.getInt());
        } else {
            throw new UnsupportedOperationException("Unknown type, can't unpack a native type " + nativeType);
        }
        if (nativeType == 0 && type == Boolean.TYPE) {
            byte asByte = (Byte)val;
            boolean asBool = asByte != 0;
            val = asBool;
        } else if (nativeType == 0 && type == Integer.TYPE) {
            byte asByte;
            byte asInt = asByte = ((Byte)val).byteValue();
            val = (int)asInt;
        } else if (type != CameraMetadataNative.getExpectedType(nativeType)) {
            throw new UnsupportedOperationException("Tried to unpack a type of " + type + " but we expected the type to be " + CameraMetadataNative.getExpectedType(nativeType));
        }
        return (T)val;
    }

    private static <T> T unpackSingle(ByteBuffer buffer, Class<T> type, int nativeType) {
        if (type.isPrimitive() || type == Rational.class) {
            return CameraMetadataNative.unpackSingleNative(buffer, type, nativeType);
        }
        if (type.isEnum()) {
            return CameraMetadataNative.unpackEnum(buffer, type, nativeType);
        }
        if (type.isArray()) {
            return CameraMetadataNative.unpackArray(buffer, type, nativeType);
        }
        T instance = CameraMetadataNative.unpackClass(buffer, type, nativeType);
        return instance;
    }

    private static <T extends Enum<T>> T unpackEnum(ByteBuffer buffer, Class<T> type, int nativeType) {
        int ordinal = CameraMetadataNative.unpackSingleNative(buffer, Integer.TYPE, nativeType);
        return CameraMetadataNative.getEnumFromValue(type, ordinal);
    }

    private static <T> T unpackClass(ByteBuffer buffer, Class<T> type, int nativeType) {
        MetadataMarshalClass<T> marshaler = CameraMetadataNative.getMarshaler(type, nativeType);
        if (marshaler == null) {
            throw new IllegalArgumentException("Unknown class type: " + type);
        }
        return marshaler.unmarshal(buffer, nativeType);
    }

    private static <T> T unpackArray(ByteBuffer buffer, Class<T> type, int nativeType) {
        Object[] array2;
        Class<?> componentType = type.getComponentType();
        int elementSize = CameraMetadataNative.getTypeSize(nativeType);
        MetadataMarshalClass<?> marshaler = CameraMetadataNative.getMarshaler(componentType, nativeType);
        if (marshaler != null) {
            elementSize = marshaler.getNativeSize(nativeType);
        }
        if (elementSize != -1) {
            int remaining = buffer.remaining();
            int arraySize = remaining / elementSize;
            if (VERBOSE) {
                Log.v(TAG, String.format("Attempting to unpack array (count = %d, element size = %d, bytes remaining = %d) for type %s", arraySize, elementSize, remaining, type));
            }
            array2 = Array.newInstance(componentType, arraySize);
            for (int i = 0; i < arraySize; ++i) {
                Object elem = CameraMetadataNative.unpackSingle(buffer, componentType, nativeType);
                Array.set(array2, i, elem);
            }
        } else {
            ArrayList arrayList = new ArrayList();
            int primitiveSize = CameraMetadataNative.getTypeSize(nativeType);
            while (buffer.remaining() >= primitiveSize) {
                Object elem = CameraMetadataNative.unpackSingle(buffer, componentType, nativeType);
                arrayList.add(elem);
            }
            array2 = arrayList.toArray((Object[])Array.newInstance(componentType, 0));
        }
        if (buffer.remaining() != 0) {
            Log.e(TAG, "Trailing bytes (" + buffer.remaining() + ") left over after unpacking " + type);
        }
        return (T)array2;
    }

    private <T> T getBase(CameraMetadata.Key<T> key) {
        int tag = key.getTag();
        byte[] values = this.readValues(tag);
        if (values == null) {
            return null;
        }
        int nativeType = CameraMetadataNative.getNativeType(tag);
        ByteBuffer buffer = ByteBuffer.wrap(values).order(ByteOrder.nativeOrder());
        return CameraMetadataNative.unpackSingle(buffer, key.getType(), nativeType);
    }

    private <T> T getOverride(CameraMetadata.Key<T> key) {
        if (key.equals(CameraCharacteristics.SCALER_AVAILABLE_FORMATS)) {
            return (T)this.getAvailableFormats();
        }
        if (key.equals(CaptureResult.STATISTICS_FACES)) {
            return (T)this.getFaces();
        }
        if (key.equals(CaptureResult.STATISTICS_FACE_RECTANGLES)) {
            return (T)this.fixFaceRectangles();
        }
        return null;
    }

    private int[] getAvailableFormats() {
        int[] availableFormats = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_FORMATS);
        for (int i = 0; i < availableFormats.length; ++i) {
            if (availableFormats[i] != 33) continue;
            availableFormats[i] = 256;
        }
        return availableFormats;
    }

    private Face[] getFaces() {
        int i;
        int FACE_LANDMARK_SIZE = 6;
        Integer faceDetectMode = this.get(CaptureResult.STATISTICS_FACE_DETECT_MODE);
        if (faceDetectMode == null) {
            Log.w(TAG, "Face detect mode metadata is null, assuming the mode is SIMPLE");
            faceDetectMode = 1;
        } else {
            if (faceDetectMode == 0) {
                return new Face[0];
            }
            if (faceDetectMode != 1 && faceDetectMode != 2) {
                Log.w(TAG, "Unknown face detect mode: " + faceDetectMode);
                return new Face[0];
            }
        }
        byte[] faceScores = this.get(CaptureResult.STATISTICS_FACE_SCORES);
        Rect[] faceRectangles = this.get(CaptureResult.STATISTICS_FACE_RECTANGLES);
        if (faceScores == null || faceRectangles == null) {
            Log.w(TAG, "Expect face scores and rectangles to be non-null");
            return new Face[0];
        }
        if (faceScores.length != faceRectangles.length) {
            Log.w(TAG, String.format("Face score size(%d) doesn match face rectangle size(%d)!", faceScores.length, faceRectangles.length));
        }
        int numFaces = Math.min(faceScores.length, faceRectangles.length);
        int[] faceIds = this.get(CaptureResult.STATISTICS_FACE_IDS);
        int[] faceLandmarks = this.get(CaptureResult.STATISTICS_FACE_LANDMARKS);
        if (faceDetectMode == 2) {
            if (faceIds == null || faceLandmarks == null) {
                Log.w(TAG, "Expect face ids and landmarks to be non-null for FULL mode,fallback to SIMPLE mode");
                faceDetectMode = 1;
            } else {
                if (faceIds.length != numFaces || faceLandmarks.length != numFaces * 6) {
                    Log.w(TAG, String.format("Face id size(%d), or face landmark size(%d) don'tmatch face number(%d)!", faceIds.length, faceLandmarks.length * 6, numFaces));
                }
                numFaces = Math.min(numFaces, faceIds.length);
                numFaces = Math.min(numFaces, faceLandmarks.length / 6);
            }
        }
        ArrayList<Face> faceList = new ArrayList<Face>();
        if (faceDetectMode == 1) {
            for (i = 0; i < numFaces; ++i) {
                if (faceScores[i] > 100 || faceScores[i] < 1) continue;
                faceList.add(new Face(faceRectangles[i], faceScores[i]));
            }
        } else {
            for (i = 0; i < numFaces; ++i) {
                if (faceScores[i] > 100 || faceScores[i] < 1 || faceIds[i] < 0) continue;
                Point leftEye = new Point(faceLandmarks[i * 6], faceLandmarks[i * 6 + 1]);
                Point rightEye = new Point(faceLandmarks[i * 6 + 2], faceLandmarks[i * 6 + 3]);
                Point mouth = new Point(faceLandmarks[i * 6 + 4], faceLandmarks[i * 6 + 5]);
                Face face = new Face(faceRectangles[i], faceScores[i], faceIds[i], leftEye, rightEye, mouth);
                faceList.add(face);
            }
        }
        Face[] faces = new Face[faceList.size()];
        faceList.toArray(faces);
        return faces;
    }

    private Rect[] fixFaceRectangles() {
        Rect[] faceRectangles = this.getBase(CaptureResult.STATISTICS_FACE_RECTANGLES);
        if (faceRectangles == null) {
            return null;
        }
        Rect[] fixedFaceRectangles = new Rect[faceRectangles.length];
        for (int i = 0; i < faceRectangles.length; ++i) {
            fixedFaceRectangles[i] = new Rect(faceRectangles[i].left, faceRectangles[i].top, faceRectangles[i].right - faceRectangles[i].left, faceRectangles[i].bottom - faceRectangles[i].top);
        }
        return fixedFaceRectangles;
    }

    private <T> void setBase(CameraMetadata.Key<T> key, T value) {
        int tag = key.getTag();
        if (value == null) {
            this.writeValues(tag, null);
            return;
        }
        int nativeType = CameraMetadataNative.getNativeType(tag);
        int size = CameraMetadataNative.packSingle(value, null, key.getType(), nativeType, true);
        byte[] values = new byte[size];
        ByteBuffer buffer = ByteBuffer.wrap(values).order(ByteOrder.nativeOrder());
        CameraMetadataNative.packSingle(value, buffer, key.getType(), nativeType, false);
        this.writeValues(tag, values);
    }

    private <T> boolean setOverride(CameraMetadata.Key<T> key, T value) {
        if (key.equals(CameraCharacteristics.SCALER_AVAILABLE_FORMATS)) {
            return this.setAvailableFormats((int[])value);
        }
        return false;
    }

    private boolean setAvailableFormats(int[] value) {
        int[] availableFormat = value;
        if (value == null) {
            return false;
        }
        int[] newValues = new int[availableFormat.length];
        for (int i = 0; i < availableFormat.length; ++i) {
            newValues[i] = availableFormat[i];
            if (availableFormat[i] != 256) continue;
            newValues[i] = 33;
        }
        this.setBase(CameraCharacteristics.SCALER_AVAILABLE_FORMATS, newValues);
        return true;
    }

    private native long nativeAllocate();

    private native long nativeAllocateCopy(CameraMetadataNative var1) throws NullPointerException;

    private synchronized native void nativeWriteToParcel(Parcel var1);

    private synchronized native void nativeReadFromParcel(Parcel var1);

    private synchronized native void nativeSwap(CameraMetadataNative var1) throws NullPointerException;

    private synchronized native void nativeClose();

    private synchronized native boolean nativeIsEmpty();

    private synchronized native int nativeGetEntryCount();

    private synchronized native byte[] nativeReadValues(int var1);

    private synchronized native void nativeWriteValues(int var1, byte[] var2);

    private static native int nativeGetTagFromKey(String var0) throws IllegalArgumentException;

    private static native int nativeGetTypeFromTag(int var0) throws IllegalArgumentException;

    private static native void nativeClassInit();

    public void swap(CameraMetadataNative other) {
        this.nativeSwap(other);
    }

    public int getEntryCount() {
        return this.nativeGetEntryCount();
    }

    public boolean isEmpty() {
        return this.nativeIsEmpty();
    }

    public static int getTag(String key) {
        return CameraMetadataNative.nativeGetTagFromKey(key);
    }

    public static int getNativeType(int tag) {
        return CameraMetadataNative.nativeGetTypeFromTag(tag);
    }

    public void writeValues(int tag, byte[] src) {
        this.nativeWriteValues(tag, src);
    }

    public byte[] readValues(int tag) {
        return this.nativeReadValues(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public static <T extends Enum<T>> void registerEnumValues(Class<T> enumType, int[] values) {
        if (((Enum[])enumType.getEnumConstants()).length != values.length) {
            throw new IllegalArgumentException("Expected values array to be the same size as the enumTypes values " + values.length + " for type " + enumType);
        }
        if (VERBOSE) {
            Log.v(TAG, "Registered enum values for type " + enumType + " values");
        }
        sEnumValues.put(enumType, values);
    }

    private static <T extends Enum<T>> int getEnumValue(T enumValue) {
        int[] values = sEnumValues.get(enumValue.getClass());
        int ordinal = enumValue.ordinal();
        if (values != null) {
            return values[ordinal];
        }
        return ordinal;
    }

    private static <T extends Enum<T>> T getEnumFromValue(Class<T> enumType, int value) {
        int ordinal;
        int[] registeredValues = sEnumValues.get(enumType);
        if (registeredValues != null) {
            ordinal = -1;
            for (int i = 0; i < registeredValues.length; ++i) {
                if (registeredValues[i] != value) continue;
                ordinal = i;
                break;
            }
        } else {
            ordinal = value;
        }
        Enum[] values = (Enum[])enumType.getEnumConstants();
        if (ordinal < 0 || ordinal >= values.length) {
            throw new IllegalArgumentException(String.format("Argument 'value' (%d) was not a valid enum value for type %s (registered? %b)", value, enumType, registeredValues != null));
        }
        return (T)values[ordinal];
    }

    private static <T> void registerMarshaler(MetadataMarshalClass<T> marshaler) {
        sMarshalerMap.put(marshaler.getMarshalingClass(), marshaler);
    }

    private static <T> MetadataMarshalClass<T> getMarshaler(Class<T> type, int nativeType) {
        MetadataMarshalClass<?> marshaler = sMarshalerMap.get(type);
        if (marshaler != null && !marshaler.isNativeTypeSupported(nativeType)) {
            throw new UnsupportedOperationException("Unsupported type " + nativeType + " to be marshalled to/from a " + type);
        }
        return marshaler;
    }

    static {
        CameraMetadataNative.nativeClassInit();
        if (VERBOSE) {
            Log.v(TAG, "Shall register metadata marshalers");
        }
        CameraMetadataNative.registerMarshaler(new MetadataMarshalRect());
        CameraMetadataNative.registerMarshaler(new MetadataMarshalSize());
        CameraMetadataNative.registerMarshaler(new MetadataMarshalString());
        if (VERBOSE) {
            Log.v(TAG, "Registered metadata marshalers");
        }
    }
}

