/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;

public class NinePatch {
    private final Bitmap mBitmap;
    public final int mNativeChunk;
    private Paint mPaint;
    private String mSrcName;

    public NinePatch(Bitmap bitmap, byte[] chunk) {
        this(bitmap, chunk, null);
    }

    public NinePatch(Bitmap bitmap, byte[] chunk, String srcName) {
        this.mBitmap = bitmap;
        this.mSrcName = srcName;
        this.mNativeChunk = NinePatch.validateNinePatchChunk(this.mBitmap.ni(), chunk);
    }

    public NinePatch(NinePatch patch) {
        this.mBitmap = patch.mBitmap;
        this.mSrcName = patch.mSrcName;
        if (patch.mPaint != null) {
            this.mPaint = new Paint(patch.mPaint);
        }
        this.mNativeChunk = patch.mNativeChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            NinePatch.nativeFinalize(this.mNativeChunk);
        }
        finally {
            super.finalize();
        }
    }

    public String getName() {
        return this.mSrcName;
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public void setPaint(Paint p) {
        this.mPaint = p;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void draw(Canvas canvas, RectF location) {
        canvas.drawPatch(this, location, this.mPaint);
    }

    public void draw(Canvas canvas, Rect location) {
        canvas.drawPatch(this, location, this.mPaint);
    }

    public void draw(Canvas canvas, Rect location, Paint paint) {
        canvas.drawPatch(this, location, paint);
    }

    void drawSoftware(Canvas canvas, RectF location, Paint paint) {
        NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mNativeChunk, paint != null ? paint.mNativePaint : 0, canvas.mDensity, this.mBitmap.mDensity);
    }

    void drawSoftware(Canvas canvas, Rect location, Paint paint) {
        NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mNativeChunk, paint != null ? paint.mNativePaint : 0, canvas.mDensity, this.mBitmap.mDensity);
    }

    public int getDensity() {
        return this.mBitmap.mDensity;
    }

    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    public int getHeight() {
        return this.mBitmap.getHeight();
    }

    public final boolean hasAlpha() {
        return this.mBitmap.hasAlpha();
    }

    public final Region getTransparentRegion(Rect bounds) {
        int r = NinePatch.nativeGetTransparentRegion(this.mBitmap.ni(), this.mNativeChunk, bounds);
        return r != 0 ? new Region(r) : null;
    }

    public static native boolean isNinePatchChunk(byte[] var0);

    private static native int validateNinePatchChunk(int var0, byte[] var1);

    private static native void nativeFinalize(int var0);

    private static native void nativeDraw(int var0, RectF var1, int var2, int var3, int var4, int var5, int var6);

    private static native void nativeDraw(int var0, Rect var1, int var2, int var3, int var4, int var5, int var6);

    private static native int nativeGetTransparentRegion(int var0, int var1, Rect var2);
}

