/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BitmapRegionDecoder {
    private int mNativeBitmapRegionDecoder;
    private boolean mRecycled;
    private final Object mNativeLock = new Object();

    public static BitmapRegionDecoder newInstance(byte[] data, int offset, int length, boolean isShareable) throws IOException {
        if ((offset | length) < 0 || data.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return BitmapRegionDecoder.nativeNewInstance(data, offset, length, isShareable);
    }

    public static BitmapRegionDecoder newInstance(FileDescriptor fd, boolean isShareable) throws IOException {
        return BitmapRegionDecoder.nativeNewInstance(fd, isShareable);
    }

    public static BitmapRegionDecoder newInstance(InputStream is, boolean isShareable) throws IOException {
        if (is instanceof AssetManager.AssetInputStream) {
            return BitmapRegionDecoder.nativeNewInstance(((AssetManager.AssetInputStream)is).getAssetInt(), isShareable);
        }
        byte[] tempStorage = new byte[16384];
        return BitmapRegionDecoder.nativeNewInstance(is, tempStorage, isShareable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BitmapRegionDecoder newInstance(String pathName, boolean isShareable) throws IOException {
        BitmapRegionDecoder decoder = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(pathName);
            decoder = BitmapRegionDecoder.newInstance(stream, isShareable);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
        return decoder;
    }

    private BitmapRegionDecoder(int decoder) {
        this.mNativeBitmapRegionDecoder = decoder;
        this.mRecycled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap decodeRegion(Rect rect, BitmapFactory.Options options) {
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("decodeRegion called on recycled region decoder");
            if (rect.right <= 0 || rect.bottom <= 0 || rect.left >= this.getWidth() || rect.top >= this.getHeight()) {
                throw new IllegalArgumentException("rectangle is outside the image");
            }
            return BitmapRegionDecoder.nativeDecodeRegion(this.mNativeBitmapRegionDecoder, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("getWidth called on recycled region decoder");
            return BitmapRegionDecoder.nativeGetWidth(this.mNativeBitmapRegionDecoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("getHeight called on recycled region decoder");
            return BitmapRegionDecoder.nativeGetHeight(this.mNativeBitmapRegionDecoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Object object = this.mNativeLock;
        synchronized (object) {
            if (!this.mRecycled) {
                BitmapRegionDecoder.nativeClean(this.mNativeBitmapRegionDecoder);
                this.mRecycled = true;
            }
        }
    }

    public final boolean isRecycled() {
        return this.mRecycled;
    }

    private void checkRecycled(String errorMessage) {
        if (this.mRecycled) {
            throw new IllegalStateException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.recycle();
        }
        finally {
            super.finalize();
        }
    }

    private static native Bitmap nativeDecodeRegion(int var0, int var1, int var2, int var3, int var4, BitmapFactory.Options var5);

    private static native int nativeGetWidth(int var0);

    private static native int nativeGetHeight(int var0);

    private static native void nativeClean(int var0);

    private static native BitmapRegionDecoder nativeNewInstance(byte[] var0, int var1, int var2, boolean var3);

    private static native BitmapRegionDecoder nativeNewInstance(FileDescriptor var0, boolean var1);

    private static native BitmapRegionDecoder nativeNewInstance(InputStream var0, byte[] var1, boolean var2);

    private static native BitmapRegionDecoder nativeNewInstance(int var0, boolean var1);
}

