/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.geometry.Point;
import android.filterfw.geometry.Quad;

public class StraightenFilter
extends Filter {
    @GenerateFieldPort(name="angle", hasDefault=true)
    private float mAngle = 0.0f;
    @GenerateFieldPort(name="maxAngle", hasDefault=true)
    private float mMaxAngle = 45.0f;
    @GenerateFieldPort(name="tile_size", hasDefault=true)
    private int mTileSize = 640;
    private Program mProgram;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mTarget = 0;
    private static final float DEGREE_TO_RADIAN = (float)Math.PI / 180;

    public StraightenFilter(String name) {
        super(name);
    }

    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    public void initProgram(FilterContext context, int target) {
        switch (target) {
            case 3: {
                ShaderProgram shaderProgram = ShaderProgram.createIdentity(context);
                shaderProgram.setMaximumTileSize(this.mTileSize);
                this.mProgram = shaderProgram;
                break;
            }
            default: {
                throw new RuntimeException("Filter Sharpen does not support frames of target " + target + "!");
            }
        }
        this.mTarget = target;
    }

    public void fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mProgram != null) {
            this.updateParameters();
        }
    }

    public void process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        if (this.mProgram == null || inputFormat.getTarget() != this.mTarget) {
            this.initProgram(context, inputFormat.getTarget());
        }
        if (inputFormat.getWidth() != this.mWidth || inputFormat.getHeight() != this.mHeight) {
            this.mWidth = inputFormat.getWidth();
            this.mHeight = inputFormat.getHeight();
            this.updateParameters();
        }
        Frame output = context.getFrameManager().newFrame(inputFormat);
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }

    private void updateParameters() {
        float cosTheta = (float)Math.cos(this.mAngle * ((float)Math.PI / 180));
        float sinTheta = (float)Math.sin(this.mAngle * ((float)Math.PI / 180));
        if (this.mMaxAngle <= 0.0f) {
            throw new RuntimeException("Max angle is out of range (0-180).");
        }
        this.mMaxAngle = this.mMaxAngle > 90.0f ? 90.0f : this.mMaxAngle;
        Point p0 = new Point(-cosTheta * (float)this.mWidth + sinTheta * (float)this.mHeight, -sinTheta * (float)this.mWidth - cosTheta * (float)this.mHeight);
        Point p1 = new Point(cosTheta * (float)this.mWidth + sinTheta * (float)this.mHeight, sinTheta * (float)this.mWidth - cosTheta * (float)this.mHeight);
        Point p2 = new Point(-cosTheta * (float)this.mWidth - sinTheta * (float)this.mHeight, -sinTheta * (float)this.mWidth + cosTheta * (float)this.mHeight);
        Point p3 = new Point(cosTheta * (float)this.mWidth - sinTheta * (float)this.mHeight, sinTheta * (float)this.mWidth + cosTheta * (float)this.mHeight);
        float maxWidth = Math.max(Math.abs(p0.x), Math.abs(p1.x));
        float maxHeight = Math.max(Math.abs(p0.y), Math.abs(p1.y));
        float scale = 0.5f * Math.min((float)this.mWidth / maxWidth, (float)this.mHeight / maxHeight);
        p0.set(scale * p0.x / (float)this.mWidth + 0.5f, scale * p0.y / (float)this.mHeight + 0.5f);
        p1.set(scale * p1.x / (float)this.mWidth + 0.5f, scale * p1.y / (float)this.mHeight + 0.5f);
        p2.set(scale * p2.x / (float)this.mWidth + 0.5f, scale * p2.y / (float)this.mHeight + 0.5f);
        p3.set(scale * p3.x / (float)this.mWidth + 0.5f, scale * p3.y / (float)this.mHeight + 0.5f);
        Quad quad = new Quad(p0, p1, p2, p3);
        ((ShaderProgram)this.mProgram).setSourceRegion(quad);
    }
}

