/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.Program;
import android.filterfw.format.ImageFormat;
import java.lang.reflect.Field;

public abstract class SimpleImageFilter
extends Filter {
    protected int mCurrentTarget = 0;
    protected Program mProgram;
    protected String mParameterName;

    public SimpleImageFilter(String name, String parameterName) {
        super(name);
        this.mParameterName = parameterName;
    }

    public void setupPorts() {
        if (this.mParameterName != null) {
            try {
                Field programField = SimpleImageFilter.class.getDeclaredField("mProgram");
                this.addProgramPort(this.mParameterName, this.mParameterName, programField, Float.TYPE, false);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Internal Error: mProgram field not found!");
            }
        }
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    public FrameFormat getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    public void process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        Frame output = context.getFrameManager().newFrame(inputFormat);
        this.updateProgramWithTarget(inputFormat.getTarget(), context);
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }

    protected void updateProgramWithTarget(int target, FilterContext context) {
        if (target != this.mCurrentTarget) {
            switch (target) {
                case 2: {
                    this.mProgram = this.getNativeProgram(context);
                    break;
                }
                case 3: {
                    this.mProgram = this.getShaderProgram(context);
                    break;
                }
                default: {
                    this.mProgram = null;
                }
            }
            if (this.mProgram == null) {
                throw new RuntimeException("Could not create a program for image filter " + this + "!");
            }
            this.initProgramInputs(this.mProgram, context);
            this.mCurrentTarget = target;
        }
    }

    protected abstract Program getNativeProgram(FilterContext var1);

    protected abstract Program getShaderProgram(FilterContext var1);
}

