/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.GraphRunner;
import android.filterfw.core.Scheduler;
import android.filterfw.core.StopWatchMap;
import android.os.ConditionVariable;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SyncRunner
extends GraphRunner {
    private Scheduler mScheduler = null;
    private GraphRunner.OnRunnerDoneListener mDoneListener = null;
    private ScheduledThreadPoolExecutor mWakeExecutor = new ScheduledThreadPoolExecutor(1);
    private ConditionVariable mWakeCondition = new ConditionVariable();
    private StopWatchMap mTimer = null;
    private final boolean mLogVerbose = Log.isLoggable("SyncRunner", 2);
    private static final String TAG = "SyncRunner";

    public SyncRunner(FilterContext context, FilterGraph graph, Class schedulerClass) {
        super(context);
        if (this.mLogVerbose) {
            Log.v(TAG, "Initializing SyncRunner");
        }
        if (Scheduler.class.isAssignableFrom(schedulerClass)) {
            try {
                Constructor schedulerConstructor = schedulerClass.getConstructor(FilterGraph.class);
                this.mScheduler = (Scheduler)schedulerConstructor.newInstance(graph);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Scheduler does not have constructor <init>(FilterGraph)!", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not instantiate the Scheduler instance!", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot access Scheduler constructor!", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Scheduler constructor threw an exception", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate Scheduler", e);
            }
        } else {
            throw new IllegalArgumentException("Class provided is not a Scheduler subclass!");
        }
        this.mFilterContext = context;
        this.mFilterContext.addGraph(graph);
        this.mTimer = new StopWatchMap();
        if (this.mLogVerbose) {
            Log.v(TAG, "Setting up filters");
        }
        graph.setupFilters();
    }

    public FilterGraph getGraph() {
        return this.mScheduler != null ? this.mScheduler.getGraph() : null;
    }

    public int step() {
        this.assertReadyToStep();
        if (!this.getGraph().isReady()) {
            throw new RuntimeException("Trying to process graph that is not open!");
        }
        return this.performStep() ? 1 : this.determinePostRunState();
    }

    public void beginProcessing() {
        this.mScheduler.reset();
        this.getGraph().beginProcessing();
    }

    public void close() {
        if (this.mLogVerbose) {
            Log.v(TAG, "Closing graph.");
        }
        this.getGraph().closeFilters(this.mFilterContext);
        this.mScheduler.reset();
    }

    public void run() {
        if (this.mLogVerbose) {
            Log.v(TAG, "Beginning run.");
        }
        this.assertReadyToStep();
        this.beginProcessing();
        boolean glActivated = this.activateGlContext();
        boolean keepRunning = true;
        while (keepRunning) {
            keepRunning = this.performStep();
        }
        if (glActivated) {
            this.deactivateGlContext();
        }
        if (this.mDoneListener != null) {
            if (this.mLogVerbose) {
                Log.v(TAG, "Calling completion listener.");
            }
            this.mDoneListener.onRunnerDone(this.determinePostRunState());
        }
        if (this.mLogVerbose) {
            Log.v(TAG, "Run complete");
        }
    }

    public boolean isRunning() {
        return false;
    }

    public void setDoneCallback(GraphRunner.OnRunnerDoneListener listener) {
        this.mDoneListener = listener;
    }

    public void stop() {
        throw new RuntimeException("SyncRunner does not support stopping a graph!");
    }

    public synchronized Exception getError() {
        return null;
    }

    protected void waitUntilWake() {
        this.mWakeCondition.block();
    }

    protected void processFilterNode(Filter filter) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Processing filter node");
        }
        filter.performProcess(this.mFilterContext);
        if (filter.getStatus() == 6) {
            throw new RuntimeException("There was an error executing " + filter + "!");
        }
        if (filter.getStatus() == 4) {
            if (this.mLogVerbose) {
                Log.v(TAG, "Scheduling filter wakeup");
            }
            this.scheduleFilterWake(filter, filter.getSleepDelay());
        }
    }

    protected void scheduleFilterWake(Filter filter, int delay) {
        this.mWakeCondition.close();
        final Filter filterToSchedule = filter;
        final ConditionVariable conditionToWake = this.mWakeCondition;
        this.mWakeExecutor.schedule(new Runnable(){

            public void run() {
                filterToSchedule.unsetStatus(4);
                conditionToWake.open();
            }
        }, (long)delay, TimeUnit.MILLISECONDS);
    }

    protected int determinePostRunState() {
        boolean isBlocked = false;
        for (Filter filter : this.mScheduler.getGraph().getFilters()) {
            if (!filter.isOpen()) continue;
            if (filter.getStatus() == 4) {
                return 3;
            }
            return 4;
        }
        return 2;
    }

    boolean performStep() {
        Filter filter;
        if (this.mLogVerbose) {
            Log.v(TAG, "Performing one step.");
        }
        if ((filter = this.mScheduler.scheduleNextNode()) != null) {
            this.mTimer.start(filter.getName());
            this.processFilterNode(filter);
            this.mTimer.stop(filter.getName());
            return true;
        }
        return false;
    }

    void assertReadyToStep() {
        if (this.mScheduler == null) {
            throw new RuntimeException("Attempting to run schedule with no scheduler in place!");
        }
        if (this.getGraph() == null) {
            throw new RuntimeException("Calling step on scheduler with no graph in place!");
        }
    }
}

