/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import java.io.FileDescriptor;
import java.io.IOException;

public class BackupDataOutput {
    int mBackupWriter;

    public BackupDataOutput(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException();
        }
        this.mBackupWriter = BackupDataOutput.ctor(fd);
        if (this.mBackupWriter == 0) {
            throw new RuntimeException("Native initialization failed with fd=" + fd);
        }
    }

    public int writeEntityHeader(String key, int dataSize) throws IOException {
        int result = BackupDataOutput.writeEntityHeader_native(this.mBackupWriter, key, dataSize);
        if (result >= 0) {
            return result;
        }
        throw new IOException("result=0x" + Integer.toHexString(result));
    }

    public int writeEntityData(byte[] data, int size) throws IOException {
        int result = BackupDataOutput.writeEntityData_native(this.mBackupWriter, data, size);
        if (result >= 0) {
            return result;
        }
        throw new IOException("result=0x" + Integer.toHexString(result));
    }

    public void setKeyPrefix(String keyPrefix) {
        BackupDataOutput.setKeyPrefix_native(this.mBackupWriter, keyPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            BackupDataOutput.dtor(this.mBackupWriter);
        }
        finally {
            super.finalize();
        }
    }

    private static native int ctor(FileDescriptor var0);

    private static native void dtor(int var0);

    private static native int writeEntityHeader_native(int var0, String var1, int var2);

    private static native int writeEntityData_native(int var0, byte[] var1, int var2);

    private static native void setKeyPrefix_native(int var0, String var1);
}

