/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.FragmentManager;
import android.app.MediaRouteButton;
import android.content.Context;
import android.content.ContextWrapper;
import android.media.MediaRouter;
import android.util.Log;
import android.view.ActionProvider;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.app.MediaRouteChooserDialogFragment;
import java.lang.ref.WeakReference;

public class MediaRouteActionProvider
extends ActionProvider {
    private static final String TAG = "MediaRouteActionProvider";
    private Context mContext;
    private MediaRouter mRouter;
    private MenuItem mMenuItem;
    private MediaRouteButton mView;
    private int mRouteTypes;
    private View.OnClickListener mExtendedSettingsListener;
    private RouterCallback mCallback;

    public MediaRouteActionProvider(Context context) {
        super(context);
        this.mContext = context;
        this.mRouter = (MediaRouter)context.getSystemService("media_router");
        this.mCallback = new RouterCallback(this);
        this.setRouteTypes(1);
    }

    public void setRouteTypes(int types) {
        if (this.mRouteTypes == types) {
            return;
        }
        if (this.mRouteTypes != 0) {
            this.mRouter.removeCallback(this.mCallback);
        }
        this.mRouteTypes = types;
        if (types != 0) {
            this.mRouter.addCallback(types, this.mCallback);
        }
        if (this.mView != null) {
            this.mView.setRouteTypes(this.mRouteTypes);
        }
    }

    public View onCreateActionView() {
        throw new UnsupportedOperationException("Use onCreateActionView(MenuItem) instead.");
    }

    public View onCreateActionView(MenuItem item) {
        if (this.mMenuItem != null || this.mView != null) {
            Log.e(TAG, "onCreateActionView: this ActionProvider is already associated with a menu item. Don't reuse MediaRouteActionProvider instances! Abandoning the old one...");
        }
        this.mMenuItem = item;
        this.mView = new MediaRouteButton(this.mContext);
        this.mView.setCheatSheetEnabled(true);
        this.mView.setRouteTypes(this.mRouteTypes);
        this.mView.setExtendedSettingsClickListener(this.mExtendedSettingsListener);
        this.mView.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
        return this.mView;
    }

    public boolean onPerformDefaultAction() {
        FragmentManager fm = this.getActivity().getFragmentManager();
        MediaRouteChooserDialogFragment dialogFragment = (MediaRouteChooserDialogFragment)fm.findFragmentByTag("android:MediaRouteChooserDialogFragment");
        if (dialogFragment != null) {
            Log.w(TAG, "onPerformDefaultAction(): Chooser dialog already showing!");
            return false;
        }
        dialogFragment = new MediaRouteChooserDialogFragment();
        dialogFragment.setExtendedSettingsClickListener(this.mExtendedSettingsListener);
        dialogFragment.setRouteTypes(this.mRouteTypes);
        dialogFragment.show(fm, "android:MediaRouteChooserDialogFragment");
        return true;
    }

    private Activity getActivity() {
        Context context = this.mContext;
        while (context instanceof ContextWrapper && !(context instanceof Activity)) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (!(context instanceof Activity)) {
            throw new IllegalStateException("The MediaRouteActionProvider's Context is not an Activity.");
        }
        return (Activity)context;
    }

    public void setExtendedSettingsClickListener(View.OnClickListener listener) {
        this.mExtendedSettingsListener = listener;
        if (this.mView != null) {
            this.mView.setExtendedSettingsClickListener(listener);
        }
    }

    public boolean overridesItemVisibility() {
        return true;
    }

    public boolean isVisible() {
        return this.mRouter.getRouteCount() > 1;
    }

    private static class RouterCallback
    extends MediaRouter.SimpleCallback {
        private WeakReference<MediaRouteActionProvider> mAp;

        RouterCallback(MediaRouteActionProvider ap) {
            this.mAp = new WeakReference<MediaRouteActionProvider>(ap);
        }

        public void onRouteAdded(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteActionProvider ap = (MediaRouteActionProvider)this.mAp.get();
            if (ap == null) {
                router.removeCallback(this);
                return;
            }
            ap.refreshVisibility();
        }

        public void onRouteRemoved(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteActionProvider ap = (MediaRouteActionProvider)this.mAp.get();
            if (ap == null) {
                router.removeCallback(this);
                return;
            }
            ap.refreshVisibility();
        }
    }
}

