/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.harmony.xml.dom.AttrImpl;
import org.apache.harmony.xml.dom.DocumentImpl;
import org.apache.harmony.xml.dom.InnerNodeImpl;
import org.apache.harmony.xml.dom.NodeImpl;
import org.apache.harmony.xml.dom.NodeListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends InnerNodeImpl
implements Element {
    boolean namespaceAware;
    String namespaceURI;
    String prefix;
    String localName;
    private List<AttrImpl> attributes = new ArrayList<AttrImpl>();

    ElementImpl(DocumentImpl document, String namespaceURI, String qualifiedName) {
        super(document);
        ElementImpl.setNameNS(this, namespaceURI, qualifiedName);
    }

    ElementImpl(DocumentImpl document, String name) {
        super(document);
        ElementImpl.setName(this, name);
    }

    private int indexOfAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttrImpl attr2 = this.attributes.get(i);
            if (!Objects.equals(name, attr2.getNodeName())) continue;
            return i;
        }
        return -1;
    }

    private int indexOfAttributeNS(String namespaceURI, String localName) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttrImpl attr2 = this.attributes.get(i);
            if (!Objects.equals(namespaceURI, attr2.getNamespaceURI()) || !Objects.equals(localName, attr2.getLocalName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getAttribute(String name) {
        AttrImpl attr2 = this.getAttributeNode(name);
        if (attr2 == null) {
            return "";
        }
        return attr2.getValue();
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        AttrImpl attr2 = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr2 == null) {
            return "";
        }
        return attr2.getValue();
    }

    @Override
    public AttrImpl getAttributeNode(String name) {
        int i = this.indexOfAttribute(name);
        if (i == -1) {
            return null;
        }
        return this.attributes.get(i);
    }

    @Override
    public AttrImpl getAttributeNodeNS(String namespaceURI, String localName) {
        int i = this.indexOfAttributeNS(namespaceURI, localName);
        if (i == -1) {
            return null;
        }
        return this.attributes.get(i);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new ElementAttrNamedNodeMapImpl();
    }

    Element getElementById(String name) {
        for (Attr attr2 : this.attributes) {
            if (!attr2.isId() || !name.equals(attr2.getValue())) continue;
            return this;
        }
        if (name.equals(this.getAttribute("id"))) {
            return this;
        }
        for (NodeImpl nodeImpl : this.children) {
            Element element;
            if (nodeImpl.getNodeType() != 1 || (element = ((ElementImpl)nodeImpl).getElementById(name)) == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        NodeListImpl result = new NodeListImpl();
        this.getElementsByTagName(result, name);
        return result;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        NodeListImpl result = new NodeListImpl();
        this.getElementsByTagNameNS(result, namespaceURI, localName);
        return result;
    }

    @Override
    public String getLocalName() {
        return this.namespaceAware ? this.localName : null;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getTagName() {
        return this.prefix != null ? this.prefix + ":" + this.localName : this.localName;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.indexOfAttribute(name) != -1;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.indexOfAttributeNS(namespaceURI, localName) != -1;
    }

    @Override
    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        int i = this.indexOfAttribute(name);
        if (i != -1) {
            this.attributes.remove(i);
        }
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        int i = this.indexOfAttributeNS(namespaceURI, localName);
        if (i != -1) {
            this.attributes.remove(i);
        }
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        AttrImpl oldAttrImpl = (AttrImpl)oldAttr;
        if (oldAttrImpl.getOwnerElement() != this) {
            throw new DOMException(8, null);
        }
        this.attributes.remove(oldAttrImpl);
        oldAttrImpl.ownerElement = null;
        return oldAttrImpl;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        AttrImpl attr2 = this.getAttributeNode(name);
        if (attr2 == null) {
            attr2 = this.document.createAttribute(name);
            this.setAttributeNode(attr2);
        }
        attr2.setValue(value);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        AttrImpl attr2 = this.getAttributeNodeNS(namespaceURI, qualifiedName);
        if (attr2 == null) {
            attr2 = this.document.createAttributeNS(namespaceURI, qualifiedName);
            this.setAttributeNodeNS(attr2);
        }
        attr2.setValue(value);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        AttrImpl newAttrImpl = (AttrImpl)newAttr;
        if (newAttrImpl.document != this.document) {
            throw new DOMException(4, null);
        }
        if (newAttrImpl.getOwnerElement() != null) {
            throw new DOMException(10, null);
        }
        AttrImpl oldAttrImpl = null;
        int i = this.indexOfAttribute(newAttr.getName());
        if (i != -1) {
            oldAttrImpl = this.attributes.get(i);
            this.attributes.remove(i);
        }
        this.attributes.add(newAttrImpl);
        newAttrImpl.ownerElement = this;
        return oldAttrImpl;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        AttrImpl newAttrImpl = (AttrImpl)newAttr;
        if (newAttrImpl.document != this.document) {
            throw new DOMException(4, null);
        }
        if (newAttrImpl.getOwnerElement() != null) {
            throw new DOMException(10, null);
        }
        AttrImpl oldAttrImpl = null;
        int i = this.indexOfAttributeNS(newAttr.getNamespaceURI(), newAttr.getLocalName());
        if (i != -1) {
            oldAttrImpl = this.attributes.get(i);
            this.attributes.remove(i);
        }
        this.attributes.add(newAttrImpl);
        newAttrImpl.ownerElement = this;
        return oldAttrImpl;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = ElementImpl.validatePrefix(prefix, this.namespaceAware, this.namespaceURI);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return NULL_TYPE_INFO;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        AttrImpl attr2 = this.getAttributeNode(name);
        if (attr2 == null) {
            throw new DOMException(8, "No such attribute: " + name);
        }
        attr2.isId = isId;
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        AttrImpl attr2 = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr2 == null) {
            throw new DOMException(8, "No such attribute: " + namespaceURI + " " + localName);
        }
        attr2.isId = isId;
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        ((AttrImpl)idAttr).isId = isId;
    }

    public class ElementAttrNamedNodeMapImpl
    implements NamedNodeMap {
        @Override
        public int getLength() {
            return ElementImpl.this.attributes.size();
        }

        private int indexOfItem(String name) {
            return ElementImpl.this.indexOfAttribute(name);
        }

        private int indexOfItemNS(String namespaceURI, String localName) {
            return ElementImpl.this.indexOfAttributeNS(namespaceURI, localName);
        }

        @Override
        public Node getNamedItem(String name) {
            return ElementImpl.this.getAttributeNode(name);
        }

        @Override
        public Node getNamedItemNS(String namespaceURI, String localName) {
            return ElementImpl.this.getAttributeNodeNS(namespaceURI, localName);
        }

        @Override
        public Node item(int index) {
            return (Node)ElementImpl.this.attributes.get(index);
        }

        @Override
        public Node removeNamedItem(String name) throws DOMException {
            int i = this.indexOfItem(name);
            if (i == -1) {
                throw new DOMException(8, null);
            }
            return (Node)ElementImpl.this.attributes.remove(i);
        }

        @Override
        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            int i = this.indexOfItemNS(namespaceURI, localName);
            if (i == -1) {
                throw new DOMException(8, null);
            }
            return (Node)ElementImpl.this.attributes.remove(i);
        }

        @Override
        public Node setNamedItem(Node arg) throws DOMException {
            if (!(arg instanceof Attr)) {
                throw new DOMException(3, null);
            }
            return ElementImpl.this.setAttributeNode((Attr)arg);
        }

        @Override
        public Node setNamedItemNS(Node arg) throws DOMException {
            if (!(arg instanceof Attr)) {
                throw new DOMException(3, null);
            }
            return ElementImpl.this.setAttributeNodeNS((Attr)arg);
        }
    }
}

