/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import android.icu.util.TimeZone;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import libcore.util.CountryTimeZones;
import libcore.util.CountryZonesFinder;
import libcore.util.TimeZoneDataFiles;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TimeZoneFinder
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TZLOOKUP_FILE_NAME = "tzlookup.xml";
    private static String TIMEZONES_ELEMENT = "timezones";
    private static String IANA_VERSION_ATTRIBUTE = "ianaversion";
    private static String COUNTRY_ZONES_ELEMENT = "countryzones";
    private static String COUNTRY_ELEMENT = "country";
    private static String COUNTRY_CODE_ATTRIBUTE = "code";
    private static String DEFAULT_TIME_ZONE_ID_ATTRIBUTE = "default";
    private static String EVER_USES_UTC_ATTRIBUTE = "everutc";
    private static String ZONE_ID_ELEMENT = "id";
    private static String ZONE_SHOW_IN_PICKER_ATTRIBUTE = "picker";
    private static String ZONE_NOT_USED_AFTER_ATTRIBUTE = "notafter";
    private static String TRUE_ATTRIBUTE_VALUE = "y";
    private static String FALSE_ATTRIBUTE_VALUE = "n";
    private static TimeZoneFinder instance;
    private ReaderSupplier xmlSource;
    private CountryTimeZones lastCountryTimeZones;

    private void $$robo$$libcore_util_TimeZoneFinder$__constructor__(ReaderSupplier xmlSource) {
        this.xmlSource = xmlSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TimeZoneFinder $$robo$$libcore_util_TimeZoneFinder$getInstance() {
        Class<TimeZoneFinder> clazz = TimeZoneFinder.class;
        synchronized (TimeZoneFinder.class) {
            if (instance == null) {
                String[] tzLookupFilePaths = TimeZoneDataFiles.getTimeZoneFilePaths("tzlookup.xml");
                instance = TimeZoneFinder.createInstanceWithFallback(tzLookupFilePaths[0], tzLookupFilePaths[1]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static final TimeZoneFinder $$robo$$libcore_util_TimeZoneFinder$createInstanceWithFallback(String ... tzLookupFilePaths) {
        IOException lastException = null;
        for (String tzLookupFilePath : tzLookupFilePaths) {
            try {
                return TimeZoneFinder.createInstance(tzLookupFilePath);
            }
            catch (IOException e) {
                if (lastException != null) {
                    e.addSuppressed(lastException);
                }
                lastException = e;
            }
        }
        InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("No valid file found in set: " + Arrays.toString(tzLookupFilePaths) + " Printing exceptions and falling back to empty map."), (Throwable)lastException);
        return TimeZoneFinder.createInstanceForTests("<timezones><countryzones /></timezones>");
    }

    private static final TimeZoneFinder $$robo$$libcore_util_TimeZoneFinder$createInstance(String path) throws IOException {
        ReaderSupplier xmlSupplier = ReaderSupplier.forFile(path, StandardCharsets.UTF_8);
        return new TimeZoneFinder(xmlSupplier);
    }

    private static final TimeZoneFinder $$robo$$libcore_util_TimeZoneFinder$createInstanceForTests(String xml2) {
        return new TimeZoneFinder(ReaderSupplier.forString(xml2));
    }

    private final void $$robo$$libcore_util_TimeZoneFinder$validate() throws IOException {
        try {
            this.processXml(new TimeZonesValidator(null));
        }
        catch (XmlPullParserException e) {
            throw new IOException("Parsing error", e);
        }
    }

    private final String $$robo$$libcore_util_TimeZoneFinder$getIanaVersion() {
        IanaVersionExtractor ianaVersionExtractor = new IanaVersionExtractor(null);
        try {
            this.processXml(ianaVersionExtractor);
            return ianaVersionExtractor.getIanaVersion();
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    private final CountryZonesFinder $$robo$$libcore_util_TimeZoneFinder$getCountryZonesFinder() {
        CountryZonesLookupExtractor extractor = new CountryZonesLookupExtractor(null);
        try {
            this.processXml(extractor);
            return extractor.getCountryZonesLookup();
        }
        catch (IOException | XmlPullParserException e) {
            InvokeDynamicSupport.bootstrapIntrinsic("logW", "java.lang.System", (String)"Error reading country zones ", (Throwable)e);
            return null;
        }
    }

    private final TimeZone $$robo$$libcore_util_TimeZoneFinder$lookupTimeZoneByCountryAndOffset(String countryIso, int offsetMillis, boolean isDst, long whenMillis, TimeZone bias) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        if (countryTimeZones == null) {
            return null;
        }
        CountryTimeZones.OffsetResult offsetResult = countryTimeZones.lookupByOffsetWithBias(offsetMillis, isDst, whenMillis, bias);
        return offsetResult != null ? offsetResult.mTimeZone : null;
    }

    private final String $$robo$$libcore_util_TimeZoneFinder$lookupDefaultTimeZoneIdByCountry(String countryIso) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        return countryTimeZones == null ? null : countryTimeZones.getDefaultTimeZoneId();
    }

    private final List<TimeZone> $$robo$$libcore_util_TimeZoneFinder$lookupTimeZonesByCountry(String countryIso) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        return countryTimeZones == null ? null : countryTimeZones.getIcuTimeZones();
    }

    private final List<String> $$robo$$libcore_util_TimeZoneFinder$lookupTimeZoneIdsByCountry(String countryIso) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        return countryTimeZones == null ? null : TimeZoneFinder.extractTimeZoneIds(countryTimeZones.getTimeZoneMappings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CountryTimeZones $$robo$$libcore_util_TimeZoneFinder$lookupCountryTimeZones(String countryIso) {
        TimeZoneFinder timeZoneFinder = this;
        synchronized (timeZoneFinder) {
            if (this.lastCountryTimeZones != null && this.lastCountryTimeZones.isForCountryCode(countryIso)) {
                return this.lastCountryTimeZones;
            }
        }
        SelectiveCountryTimeZonesExtractor extractor = new SelectiveCountryTimeZonesExtractor(countryIso, null);
        try {
            this.processXml(extractor);
            CountryTimeZones countryTimeZones = extractor.getValidatedCountryTimeZones();
            if (countryTimeZones == null) {
                return null;
            }
            TimeZoneFinder timeZoneFinder2 = this;
            synchronized (timeZoneFinder2) {
                this.lastCountryTimeZones = countryTimeZones;
            }
            return countryTimeZones;
        }
        catch (IOException | XmlPullParserException e) {
            InvokeDynamicSupport.bootstrapIntrinsic("logW", "java.lang.System", (String)"Error reading country zones ", (Throwable)e);
            return null;
        }
    }

    private final void $$robo$$libcore_util_TimeZoneFinder$processXml(TimeZonesProcessor processor) throws XmlPullParserException, IOException {
        try (Reader reader = this.xmlSource.get();){
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(false);
            XmlPullParser parser = xmlPullParserFactory.newPullParser();
            parser.setInput(reader);
            TimeZoneFinder.findRequiredStartTag(parser, "timezones");
            String ianaVersion = parser.getAttributeValue(null, "ianaversion");
            if (!processor.processHeader(ianaVersion)) {
                return;
            }
            TimeZoneFinder.findRequiredStartTag(parser, "countryzones");
            if (!TimeZoneFinder.processCountryZones(parser, processor)) {
                return;
            }
            TimeZoneFinder.checkOnEndTag(parser, "countryzones");
            parser.next();
            TimeZoneFinder.consumeUntilEndTag(parser, "timezones");
            TimeZoneFinder.checkOnEndTag(parser, "timezones");
        }
    }

    private static final boolean $$robo$$libcore_util_TimeZoneFinder$processCountryZones(XmlPullParser parser, TimeZonesProcessor processor) throws IOException, XmlPullParserException {
        while (TimeZoneFinder.findOptionalStartTag(parser, "country")) {
            if (processor == null) {
                TimeZoneFinder.consumeUntilEndTag(parser, "country");
            } else {
                String code = parser.getAttributeValue(null, "code");
                if (code == null || code.isEmpty()) {
                    throw new XmlPullParserException("Unable to find country code: " + parser.getPositionDescription());
                }
                String defaultTimeZoneId = parser.getAttributeValue(null, "default");
                if (defaultTimeZoneId == null || defaultTimeZoneId.isEmpty()) {
                    throw new XmlPullParserException("Unable to find default time zone ID: " + parser.getPositionDescription());
                }
                Boolean everUsesUtc = TimeZoneFinder.parseBooleanAttribute(parser, "everutc", null);
                if (everUsesUtc == null) {
                    throw new XmlPullParserException("Unable to find UTC hint attribute (everutc): " + parser.getPositionDescription());
                }
                String debugInfo = parser.getPositionDescription();
                List<CountryTimeZones.TimeZoneMapping> timeZoneMappings = TimeZoneFinder.parseTimeZoneMappings(parser);
                boolean result = processor.processCountryZones(code, defaultTimeZoneId, everUsesUtc, timeZoneMappings, debugInfo);
                if (!result) {
                    return false;
                }
            }
            TimeZoneFinder.checkOnEndTag(parser, "country");
        }
        return true;
    }

    private static final List<CountryTimeZones.TimeZoneMapping> $$robo$$libcore_util_TimeZoneFinder$parseTimeZoneMappings(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<CountryTimeZones.TimeZoneMapping> timeZoneMappings = new ArrayList<CountryTimeZones.TimeZoneMapping>();
        while (TimeZoneFinder.findOptionalStartTag(parser, "id")) {
            boolean showInPicker = TimeZoneFinder.parseBooleanAttribute(parser, "picker", true);
            Long notUsedAfter = TimeZoneFinder.parseLongAttribute(parser, "notafter", null);
            String zoneIdString = TimeZoneFinder.consumeText(parser);
            TimeZoneFinder.checkOnEndTag(parser, "id");
            if (zoneIdString == null || zoneIdString.length() == 0) {
                throw new XmlPullParserException("Missing text for id): " + parser.getPositionDescription());
            }
            CountryTimeZones.TimeZoneMapping timeZoneMapping = new CountryTimeZones.TimeZoneMapping(zoneIdString, showInPicker, notUsedAfter);
            timeZoneMappings.add(timeZoneMapping);
        }
        return Collections.unmodifiableList(timeZoneMappings);
    }

    private static final Long $$robo$$libcore_util_TimeZoneFinder$parseLongAttribute(XmlPullParser parser, String attributeName, Long defaultValue) throws XmlPullParserException {
        String attributeValueString = parser.getAttributeValue(null, attributeName);
        if (attributeValueString == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(attributeValueString);
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Attribute \"" + attributeName + "\" is not a long value: " + parser.getPositionDescription());
        }
    }

    private static final Boolean $$robo$$libcore_util_TimeZoneFinder$parseBooleanAttribute(XmlPullParser parser, String attributeName, Boolean defaultValue) throws XmlPullParserException {
        String attributeValueString = parser.getAttributeValue(null, attributeName);
        if (attributeValueString == null) {
            return defaultValue;
        }
        boolean isTrue = "y".equals(attributeValueString);
        if (!isTrue && !"n".equals(attributeValueString)) {
            throw new XmlPullParserException("Attribute \"" + attributeName + "\" is not \"y\" or \"n\": " + parser.getPositionDescription());
        }
        return isTrue;
    }

    private static final void $$robo$$libcore_util_TimeZoneFinder$findRequiredStartTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        TimeZoneFinder.findStartTag(parser, elementName, true);
    }

    private static final boolean $$robo$$libcore_util_TimeZoneFinder$findOptionalStartTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        return TimeZoneFinder.findStartTag(parser, elementName, false);
    }

    private static final boolean $$robo$$libcore_util_TimeZoneFinder$findStartTag(XmlPullParser parser, String elementName, boolean elementRequired) throws IOException, XmlPullParserException {
        int type;
        block4: while ((type = parser.next()) != 1) {
            switch (type) {
                case 2: {
                    String currentElementName = parser.getName();
                    if (elementName.equals(currentElementName)) {
                        return true;
                    }
                    parser.next();
                    TimeZoneFinder.consumeUntilEndTag(parser, currentElementName);
                    continue block4;
                }
                case 3: {
                    if (elementRequired) {
                        throw new XmlPullParserException("No child element found with name " + elementName);
                    }
                    return false;
                }
            }
        }
        throw new XmlPullParserException("Unexpected end of document while looking for " + elementName);
    }

    private static final void $$robo$$libcore_util_TimeZoneFinder$consumeUntilEndTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        if (parser.getEventType() == 3 && elementName.equals(parser.getName())) {
            return;
        }
        int requiredDepth = parser.getDepth();
        if (parser.getEventType() == 2) {
            --requiredDepth;
        }
        while (parser.getEventType() != 1) {
            int type = parser.next();
            int currentDepth = parser.getDepth();
            if (currentDepth < requiredDepth) {
                throw new XmlPullParserException("Unexpected depth while looking for end tag: " + parser.getPositionDescription());
            }
            if (currentDepth != requiredDepth || type != 3) continue;
            if (elementName.equals(parser.getName())) {
                return;
            }
            throw new XmlPullParserException("Unexpected eng tag: " + parser.getPositionDescription());
        }
        throw new XmlPullParserException("Unexpected end of document");
    }

    private static final String $$robo$$libcore_util_TimeZoneFinder$consumeText(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type = parser.next();
        if (type != 4) {
            throw new XmlPullParserException("Text not found. Found type=" + type + " at " + parser.getPositionDescription());
        }
        String text = parser.getText();
        type = parser.next();
        if (type != 3) {
            throw new XmlPullParserException("Unexpected nested tag or end of document when expecting text: type=" + type + " at " + parser.getPositionDescription());
        }
        return text;
    }

    private static final void $$robo$$libcore_util_TimeZoneFinder$checkOnEndTag(XmlPullParser parser, String elementName) throws XmlPullParserException {
        if (parser.getEventType() != 3 || !parser.getName().equals(elementName)) {
            throw new XmlPullParserException("Unexpected tag encountered: " + parser.getPositionDescription());
        }
    }

    private static final List<String> $$robo$$libcore_util_TimeZoneFinder$extractTimeZoneIds(List<CountryTimeZones.TimeZoneMapping> timeZoneMappings) {
        ArrayList<String> zoneIds = new ArrayList<String>(timeZoneMappings.size());
        for (CountryTimeZones.TimeZoneMapping timeZoneMapping : timeZoneMappings) {
            zoneIds.add(timeZoneMapping.timeZoneId);
        }
        return Collections.unmodifiableList(zoneIds);
    }

    private static final String $$robo$$libcore_util_TimeZoneFinder$normalizeCountryIso(String countryIso) {
        return countryIso.toLowerCase(Locale.US);
    }

    private void __constructor__(ReaderSupplier readerSupplier) {
        this.$$robo$$libcore_util_TimeZoneFinder$__constructor__(readerSupplier);
    }

    public TimeZoneFinder(ReaderSupplier readerSupplier) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder$__constructor__(libcore.util.TimeZoneFinder$ReaderSupplier ), this, readerSupplier);
    }

    public static TimeZoneFinder getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$libcore_util_TimeZoneFinder$getInstance());
    }

    public static TimeZoneFinder createInstanceWithFallback(String ... stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("createInstanceWithFallback", $$robo$$libcore_util_TimeZoneFinder$createInstanceWithFallback(java.lang.String[] ), (String[])stringArray);
    }

    public static TimeZoneFinder createInstance(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createInstance", $$robo$$libcore_util_TimeZoneFinder$createInstance(java.lang.String ), (String)string2);
    }

    public static TimeZoneFinder createInstanceForTests(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createInstanceForTests", $$robo$$libcore_util_TimeZoneFinder$createInstanceForTests(java.lang.String ), (String)string2);
    }

    public void validate() throws IOException {
        InvokeDynamicSupport.bootstrap("validate", $$robo$$libcore_util_TimeZoneFinder$validate(), this);
    }

    public String getIanaVersion() {
        return InvokeDynamicSupport.bootstrap("getIanaVersion", $$robo$$libcore_util_TimeZoneFinder$getIanaVersion(), this);
    }

    public CountryZonesFinder getCountryZonesFinder() {
        return InvokeDynamicSupport.bootstrap("getCountryZonesFinder", $$robo$$libcore_util_TimeZoneFinder$getCountryZonesFinder(), this);
    }

    public TimeZone lookupTimeZoneByCountryAndOffset(String string2, int n, boolean bl, long l, TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrap("lookupTimeZoneByCountryAndOffset", $$robo$$libcore_util_TimeZoneFinder$lookupTimeZoneByCountryAndOffset(java.lang.String int boolean long android.icu.util.TimeZone ), this, string2, n, bl, l, timeZone);
    }

    public String lookupDefaultTimeZoneIdByCountry(String string2) {
        return InvokeDynamicSupport.bootstrap("lookupDefaultTimeZoneIdByCountry", $$robo$$libcore_util_TimeZoneFinder$lookupDefaultTimeZoneIdByCountry(java.lang.String ), this, string2);
    }

    public List<TimeZone> lookupTimeZonesByCountry(String string2) {
        return InvokeDynamicSupport.bootstrap("lookupTimeZonesByCountry", $$robo$$libcore_util_TimeZoneFinder$lookupTimeZonesByCountry(java.lang.String ), this, string2);
    }

    public List<String> lookupTimeZoneIdsByCountry(String string2) {
        return InvokeDynamicSupport.bootstrap("lookupTimeZoneIdsByCountry", $$robo$$libcore_util_TimeZoneFinder$lookupTimeZoneIdsByCountry(java.lang.String ), this, string2);
    }

    public CountryTimeZones lookupCountryTimeZones(String string2) {
        return InvokeDynamicSupport.bootstrap("lookupCountryTimeZones", $$robo$$libcore_util_TimeZoneFinder$lookupCountryTimeZones(java.lang.String ), this, string2);
    }

    private void processXml(TimeZonesProcessor timeZonesProcessor) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("processXml", $$robo$$libcore_util_TimeZoneFinder$processXml(libcore.util.TimeZoneFinder$TimeZonesProcessor ), this, timeZonesProcessor);
    }

    private static boolean processCountryZones(XmlPullParser xmlPullParser, TimeZonesProcessor timeZonesProcessor) throws IOException, XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("processCountryZones", $$robo$$libcore_util_TimeZoneFinder$processCountryZones(org.xmlpull.v1.XmlPullParser libcore.util.TimeZoneFinder$TimeZonesProcessor ), (XmlPullParser)xmlPullParser, (TimeZonesProcessor)timeZonesProcessor);
    }

    private static List<CountryTimeZones.TimeZoneMapping> parseTimeZoneMappings(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseTimeZoneMappings", $$robo$$libcore_util_TimeZoneFinder$parseTimeZoneMappings(org.xmlpull.v1.XmlPullParser ), (XmlPullParser)xmlPullParser);
    }

    private static Long parseLongAttribute(XmlPullParser xmlPullParser, String string2, Long l) throws XmlPullParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseLongAttribute", $$robo$$libcore_util_TimeZoneFinder$parseLongAttribute(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.Long ), (XmlPullParser)xmlPullParser, (String)string2, (Long)l);
    }

    private static Boolean parseBooleanAttribute(XmlPullParser xmlPullParser, String string2, Boolean bl) throws XmlPullParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseBooleanAttribute", $$robo$$libcore_util_TimeZoneFinder$parseBooleanAttribute(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.Boolean ), (XmlPullParser)xmlPullParser, (String)string2, (Boolean)bl);
    }

    private static void findRequiredStartTag(XmlPullParser xmlPullParser, String string2) throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrapStatic("findRequiredStartTag", $$robo$$libcore_util_TimeZoneFinder$findRequiredStartTag(org.xmlpull.v1.XmlPullParser java.lang.String ), (XmlPullParser)xmlPullParser, (String)string2);
    }

    private static boolean findOptionalStartTag(XmlPullParser xmlPullParser, String string2) throws IOException, XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("findOptionalStartTag", $$robo$$libcore_util_TimeZoneFinder$findOptionalStartTag(org.xmlpull.v1.XmlPullParser java.lang.String ), (XmlPullParser)xmlPullParser, (String)string2);
    }

    private static boolean findStartTag(XmlPullParser xmlPullParser, String string2, boolean bl) throws IOException, XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("findStartTag", $$robo$$libcore_util_TimeZoneFinder$findStartTag(org.xmlpull.v1.XmlPullParser java.lang.String boolean ), (XmlPullParser)xmlPullParser, (String)string2, (boolean)bl);
    }

    private static void consumeUntilEndTag(XmlPullParser xmlPullParser, String string2) throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrapStatic("consumeUntilEndTag", $$robo$$libcore_util_TimeZoneFinder$consumeUntilEndTag(org.xmlpull.v1.XmlPullParser java.lang.String ), (XmlPullParser)xmlPullParser, (String)string2);
    }

    private static String consumeText(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrapStatic("consumeText", $$robo$$libcore_util_TimeZoneFinder$consumeText(org.xmlpull.v1.XmlPullParser ), (XmlPullParser)xmlPullParser);
    }

    private static void checkOnEndTag(XmlPullParser xmlPullParser, String string2) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrapStatic("checkOnEndTag", $$robo$$libcore_util_TimeZoneFinder$checkOnEndTag(org.xmlpull.v1.XmlPullParser java.lang.String ), (XmlPullParser)xmlPullParser, (String)string2);
    }

    private static List<String> extractTimeZoneIds(List<CountryTimeZones.TimeZoneMapping> list) {
        return InvokeDynamicSupport.bootstrapStatic("extractTimeZoneIds", $$robo$$libcore_util_TimeZoneFinder$extractTimeZoneIds(java.util.List<libcore.util.CountryTimeZones$TimeZoneMapping> ), list);
    }

    static String normalizeCountryIso(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("normalizeCountryIso", $$robo$$libcore_util_TimeZoneFinder$normalizeCountryIso(java.lang.String ), (String)string2);
    }

    public /* synthetic */ TimeZoneFinder() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZoneFinder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static interface ReaderSupplier {
        public Reader get() throws IOException;

        public static ReaderSupplier forFile(String fileName, Charset charSet) throws IOException {
            Path file = Paths.get(fileName, new String[0]);
            if (!Files.exists(file, new LinkOption[0])) {
                throw new FileNotFoundException(fileName + " does not exist");
            }
            if (!Files.isRegularFile(file, new LinkOption[0]) && Files.isReadable(file)) {
                throw new IOException(fileName + " must be a regular readable file.");
            }
            return () -> Files.newBufferedReader(file, charSet);
        }

        public static ReaderSupplier forString(String xml2) {
            return () -> new StringReader(xml2);
        }
    }

    private static class SelectiveCountryTimeZonesExtractor
    implements TimeZonesProcessor,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String countryCodeToMatch;
        private CountryTimeZones validatedCountryTimeZones;

        private void $$robo$$libcore_util_TimeZoneFinder_SelectiveCountryTimeZonesExtractor$__constructor__(String countryCodeToMatch) {
            this.countryCodeToMatch = TimeZoneFinder.normalizeCountryIso(countryCodeToMatch);
        }

        private final boolean $$robo$$libcore_util_TimeZoneFinder_SelectiveCountryTimeZonesExtractor$processCountryZones(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) {
            if (!this.countryCodeToMatch.equals(countryIso = TimeZoneFinder.normalizeCountryIso(countryIso))) {
                return true;
            }
            this.validatedCountryTimeZones = CountryTimeZones.createValidated(countryIso, defaultTimeZoneId, everUsesUtc, timeZoneMappings, debugInfo);
            return false;
        }

        private final CountryTimeZones $$robo$$libcore_util_TimeZoneFinder_SelectiveCountryTimeZonesExtractor$getValidatedCountryTimeZones() {
            return this.validatedCountryTimeZones;
        }

        private /* synthetic */ void $$robo$$libcore_util_TimeZoneFinder_SelectiveCountryTimeZonesExtractor$__constructor__(String x0, 1 x1) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$libcore_util_TimeZoneFinder_SelectiveCountryTimeZonesExtractor$__constructor__(string2);
        }

        public SelectiveCountryTimeZonesExtractor(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder_SelectiveCountryTimeZonesExtractor$__constructor__(java.lang.String ), this, string2);
        }

        @Override
        public boolean processCountryZones(String string2, String string3, boolean bl, List<CountryTimeZones.TimeZoneMapping> list, String string4) {
            return (boolean)InvokeDynamicSupport.bootstrap("processCountryZones", $$robo$$libcore_util_TimeZoneFinder_SelectiveCountryTimeZonesExtractor$processCountryZones(java.lang.String java.lang.String boolean java.util.List<libcore.util.CountryTimeZones$TimeZoneMapping> java.lang.String ), this, string2, string3, bl, list, string4);
        }

        CountryTimeZones getValidatedCountryTimeZones() {
            return InvokeDynamicSupport.bootstrap("getValidatedCountryTimeZones", $$robo$$libcore_util_TimeZoneFinder_SelectiveCountryTimeZonesExtractor$getValidatedCountryTimeZones(), this);
        }

        private /* synthetic */ void __constructor__(String string2, 1 var2_2) {
            this.$$robo$$libcore_util_TimeZoneFinder_SelectiveCountryTimeZonesExtractor$__constructor__(string2, var2_2);
        }

        public /* synthetic */ SelectiveCountryTimeZonesExtractor(String string2, 1 var2_2) {
            this(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder_SelectiveCountryTimeZonesExtractor$__constructor__(java.lang.String libcore.util.TimeZoneFinder$1 ), this, string2, var2_2);
        }

        public /* synthetic */ SelectiveCountryTimeZonesExtractor() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectiveCountryTimeZonesExtractor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class CountryZonesLookupExtractor
    implements TimeZonesProcessor,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private List<CountryTimeZones> countryTimeZonesList;

        private void $$robo$$libcore_util_TimeZoneFinder_CountryZonesLookupExtractor$__constructor__() {
            this.countryTimeZonesList = new ArrayList<CountryTimeZones>(250);
        }

        private final boolean $$robo$$libcore_util_TimeZoneFinder_CountryZonesLookupExtractor$processCountryZones(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) throws XmlPullParserException {
            CountryTimeZones countryTimeZones = CountryTimeZones.createValidated(countryIso, defaultTimeZoneId, everUsesUtc, timeZoneMappings, debugInfo);
            this.countryTimeZonesList.add(countryTimeZones);
            return true;
        }

        private final CountryZonesFinder $$robo$$libcore_util_TimeZoneFinder_CountryZonesLookupExtractor$getCountryZonesLookup() {
            return new CountryZonesFinder(this.countryTimeZonesList);
        }

        private /* synthetic */ void $$robo$$libcore_util_TimeZoneFinder_CountryZonesLookupExtractor$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$libcore_util_TimeZoneFinder_CountryZonesLookupExtractor$__constructor__();
        }

        public CountryZonesLookupExtractor() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder_CountryZonesLookupExtractor$__constructor__(), this);
        }

        @Override
        public boolean processCountryZones(String string2, String string3, boolean bl, List<CountryTimeZones.TimeZoneMapping> list, String string4) throws XmlPullParserException {
            return (boolean)InvokeDynamicSupport.bootstrap("processCountryZones", $$robo$$libcore_util_TimeZoneFinder_CountryZonesLookupExtractor$processCountryZones(java.lang.String java.lang.String boolean java.util.List<libcore.util.CountryTimeZones$TimeZoneMapping> java.lang.String ), this, string2, string3, bl, list, string4);
        }

        CountryZonesFinder getCountryZonesLookup() {
            return InvokeDynamicSupport.bootstrap("getCountryZonesLookup", $$robo$$libcore_util_TimeZoneFinder_CountryZonesLookupExtractor$getCountryZonesLookup(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$libcore_util_TimeZoneFinder_CountryZonesLookupExtractor$__constructor__(var1_1);
        }

        public /* synthetic */ CountryZonesLookupExtractor(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder_CountryZonesLookupExtractor$__constructor__(libcore.util.TimeZoneFinder$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CountryZonesLookupExtractor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class IanaVersionExtractor
    implements TimeZonesProcessor,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String ianaVersion;

        private void $$robo$$libcore_util_TimeZoneFinder_IanaVersionExtractor$__constructor__() {
        }

        private final boolean $$robo$$libcore_util_TimeZoneFinder_IanaVersionExtractor$processHeader(String ianaVersion) throws XmlPullParserException {
            this.ianaVersion = ianaVersion;
            return false;
        }

        private final String $$robo$$libcore_util_TimeZoneFinder_IanaVersionExtractor$getIanaVersion() {
            return this.ianaVersion;
        }

        private /* synthetic */ void $$robo$$libcore_util_TimeZoneFinder_IanaVersionExtractor$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$libcore_util_TimeZoneFinder_IanaVersionExtractor$__constructor__();
        }

        public IanaVersionExtractor() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder_IanaVersionExtractor$__constructor__(), this);
        }

        @Override
        public boolean processHeader(String string2) throws XmlPullParserException {
            return (boolean)InvokeDynamicSupport.bootstrap("processHeader", $$robo$$libcore_util_TimeZoneFinder_IanaVersionExtractor$processHeader(java.lang.String ), this, string2);
        }

        public String getIanaVersion() {
            return InvokeDynamicSupport.bootstrap("getIanaVersion", $$robo$$libcore_util_TimeZoneFinder_IanaVersionExtractor$getIanaVersion(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$libcore_util_TimeZoneFinder_IanaVersionExtractor$__constructor__(var1_1);
        }

        public /* synthetic */ IanaVersionExtractor(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder_IanaVersionExtractor$__constructor__(libcore.util.TimeZoneFinder$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IanaVersionExtractor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class TimeZonesValidator
    implements TimeZonesProcessor,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Set<String> knownCountryCodes;

        private void $$robo$$libcore_util_TimeZoneFinder_TimeZonesValidator$__constructor__() {
            this.knownCountryCodes = new HashSet<String>();
        }

        private final boolean $$robo$$libcore_util_TimeZoneFinder_TimeZonesValidator$processCountryZones(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) throws XmlPullParserException {
            if (!TimeZoneFinder.normalizeCountryIso(countryIso).equals(countryIso)) {
                throw new XmlPullParserException("Country code: " + countryIso + " is not normalized at " + debugInfo);
            }
            if (this.knownCountryCodes.contains(countryIso)) {
                throw new XmlPullParserException("Second entry for country code: " + countryIso + " at " + debugInfo);
            }
            if (timeZoneMappings.isEmpty()) {
                throw new XmlPullParserException("No time zone IDs for country code: " + countryIso + " at " + debugInfo);
            }
            if (!CountryTimeZones.TimeZoneMapping.containsTimeZoneId(timeZoneMappings, defaultTimeZoneId)) {
                throw new XmlPullParserException("defaultTimeZoneId for country code: " + countryIso + " is not one of the zones " + timeZoneMappings + " at " + debugInfo);
            }
            this.knownCountryCodes.add(countryIso);
            return true;
        }

        private /* synthetic */ void $$robo$$libcore_util_TimeZoneFinder_TimeZonesValidator$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$libcore_util_TimeZoneFinder_TimeZonesValidator$__constructor__();
        }

        public TimeZonesValidator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder_TimeZonesValidator$__constructor__(), this);
        }

        @Override
        public boolean processCountryZones(String string2, String string3, boolean bl, List<CountryTimeZones.TimeZoneMapping> list, String string4) throws XmlPullParserException {
            return (boolean)InvokeDynamicSupport.bootstrap("processCountryZones", $$robo$$libcore_util_TimeZoneFinder_TimeZonesValidator$processCountryZones(java.lang.String java.lang.String boolean java.util.List<libcore.util.CountryTimeZones$TimeZoneMapping> java.lang.String ), this, string2, string3, bl, list, string4);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$libcore_util_TimeZoneFinder_TimeZonesValidator$__constructor__(var1_1);
        }

        public /* synthetic */ TimeZonesValidator(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder_TimeZonesValidator$__constructor__(libcore.util.TimeZoneFinder$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZonesValidator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface TimeZonesProcessor {
        public static final boolean CONTINUE = true;
        public static final boolean HALT = false;

        default public boolean processHeader(String ianaVersion) throws XmlPullParserException {
            return true;
        }

        default public boolean processCountryZones(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) throws XmlPullParserException {
            return true;
        }
    }
}

