/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class HexEncoding
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static char[] HEX_DIGITS;

    private void $$robo$$libcore_util_HexEncoding$__constructor__() {
    }

    private static final char[] $$robo$$libcore_util_HexEncoding$encode(byte[] data) {
        return HexEncoding.encode(data, 0, data.length);
    }

    private static final char[] $$robo$$libcore_util_HexEncoding$encode(byte[] data, int offset, int len) {
        char[] result = new char[len * 2];
        for (int i = 0; i < len; ++i) {
            byte b = data[offset + i];
            int resultIndex = 2 * i;
            result[resultIndex] = HEX_DIGITS[b >>> 4 & 0xF];
            result[resultIndex + 1] = HEX_DIGITS[b & 0xF];
        }
        return result;
    }

    private static final String $$robo$$libcore_util_HexEncoding$encodeToString(byte[] data) {
        return new String(HexEncoding.encode(data));
    }

    private static final byte[] $$robo$$libcore_util_HexEncoding$decode(String encoded) throws IllegalArgumentException {
        return HexEncoding.decode(encoded.toCharArray());
    }

    private static final byte[] $$robo$$libcore_util_HexEncoding$decode(String encoded, boolean allowSingleChar) throws IllegalArgumentException {
        return HexEncoding.decode(encoded.toCharArray(), allowSingleChar);
    }

    private static final byte[] $$robo$$libcore_util_HexEncoding$decode(char[] encoded) throws IllegalArgumentException {
        return HexEncoding.decode(encoded, false);
    }

    private static final byte[] $$robo$$libcore_util_HexEncoding$decode(char[] encoded, boolean allowSingleChar) throws IllegalArgumentException {
        int resultLengthBytes = (encoded.length + 1) / 2;
        byte[] result = new byte[resultLengthBytes];
        int resultOffset = 0;
        int i = 0;
        if (allowSingleChar) {
            if (encoded.length % 2 != 0) {
                result[resultOffset++] = (byte)HexEncoding.toDigit(encoded, i);
                ++i;
            }
        } else if (encoded.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid input length: " + encoded.length);
        }
        int len = encoded.length;
        while (i < len) {
            result[resultOffset++] = (byte)(HexEncoding.toDigit(encoded, i) << 4 | HexEncoding.toDigit(encoded, i + 1));
            i += 2;
        }
        return result;
    }

    private static final int $$robo$$libcore_util_HexEncoding$toDigit(char[] str, int offset) throws IllegalArgumentException {
        char pseudoCodePoint = str[offset];
        if ('0' <= pseudoCodePoint && pseudoCodePoint <= '9') {
            return pseudoCodePoint - 48;
        }
        if ('a' <= pseudoCodePoint && pseudoCodePoint <= 'f') {
            return 10 + (pseudoCodePoint - 97);
        }
        if ('A' <= pseudoCodePoint && pseudoCodePoint <= 'F') {
            return 10 + (pseudoCodePoint - 65);
        }
        throw new IllegalArgumentException("Illegal char: " + str[offset] + " at offset " + offset);
    }

    static void __staticInitializer__() {
        HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    }

    private void __constructor__() {
        this.$$robo$$libcore_util_HexEncoding$__constructor__();
    }

    public HexEncoding() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_HexEncoding$__constructor__(), this);
    }

    public static char[] encode(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("encode", $$robo$$libcore_util_HexEncoding$encode(byte[] ), (byte[])byArray);
    }

    public static char[] encode(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("encode", $$robo$$libcore_util_HexEncoding$encode(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    public static String encodeToString(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("encodeToString", $$robo$$libcore_util_HexEncoding$encodeToString(byte[] ), (byte[])byArray);
    }

    public static byte[] decode(String string2) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$libcore_util_HexEncoding$decode(java.lang.String ), (String)string2);
    }

    public static byte[] decode(String string2, boolean bl) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$libcore_util_HexEncoding$decode(java.lang.String boolean ), (String)string2, (boolean)bl);
    }

    public static byte[] decode(char[] cArray) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$libcore_util_HexEncoding$decode(char[] ), (char[])cArray);
    }

    public static byte[] decode(char[] cArray, boolean bl) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$libcore_util_HexEncoding$decode(char[] boolean ), (char[])cArray, (boolean)bl);
    }

    private static int toDigit(char[] cArray, int n) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("toDigit", $$robo$$libcore_util_HexEncoding$toDigit(char[] int ), (char[])cArray, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(HexEncoding.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HexEncoding)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

