/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import android.system.OsConstants;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.nio.ByteOrder;
import libcore.io.BufferIterator;
import libcore.io.Libcore;
import libcore.io.NioBufferIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MemoryMappedFile
implements AutoCloseable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private boolean closed;
    private long address;
    private int size;

    private void $$robo$$libcore_io_MemoryMappedFile$__constructor__(long address, long size) {
        this.address = address;
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unsupported file size=" + size);
        }
        this.size = (int)size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MemoryMappedFile $$robo$$libcore_io_MemoryMappedFile$mmapRO(String path) throws ErrnoException {
        FileDescriptor fd = Libcore.os.open(path, OsConstants.O_RDONLY, 0);
        try {
            long size = Libcore.os.fstat((FileDescriptor)fd).st_size;
            long address = Libcore.os.mmap(0L, size, OsConstants.PROT_READ, OsConstants.MAP_SHARED, fd, 0L);
            MemoryMappedFile memoryMappedFile = new MemoryMappedFile(address, size);
            return memoryMappedFile;
        }
        finally {
            Libcore.os.close(fd);
        }
    }

    private final void $$robo$$libcore_io_MemoryMappedFile$close() throws ErrnoException {
        if (!this.closed) {
            this.closed = true;
            Libcore.os.munmap(this.address, this.size);
        }
    }

    private final boolean $$robo$$libcore_io_MemoryMappedFile$isClosed() {
        return this.closed;
    }

    private final BufferIterator $$robo$$libcore_io_MemoryMappedFile$bigEndianIterator() {
        return new NioBufferIterator(this, this.address, this.size, ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN);
    }

    private final BufferIterator $$robo$$libcore_io_MemoryMappedFile$littleEndianIterator() {
        return new NioBufferIterator(this, this.address, this.size, ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN);
    }

    private final void $$robo$$libcore_io_MemoryMappedFile$checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("MemoryMappedFile is closed");
        }
    }

    private final int $$robo$$libcore_io_MemoryMappedFile$size() {
        this.checkNotClosed();
        return this.size;
    }

    private void __constructor__(long l, long l2) {
        this.$$robo$$libcore_io_MemoryMappedFile$__constructor__(l, l2);
    }

    public MemoryMappedFile(long l, long l2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_MemoryMappedFile$__constructor__(long long ), this, l, l2);
    }

    public static MemoryMappedFile mmapRO(String string2) throws ErrnoException {
        return InvokeDynamicSupport.bootstrapStatic("mmapRO", $$robo$$libcore_io_MemoryMappedFile$mmapRO(java.lang.String ), (String)string2);
    }

    @Override
    public void close() throws ErrnoException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$libcore_io_MemoryMappedFile$close(), this);
    }

    public boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$libcore_io_MemoryMappedFile$isClosed(), this);
    }

    public BufferIterator bigEndianIterator() {
        return InvokeDynamicSupport.bootstrap("bigEndianIterator", $$robo$$libcore_io_MemoryMappedFile$bigEndianIterator(), this);
    }

    public BufferIterator littleEndianIterator() {
        return InvokeDynamicSupport.bootstrap("littleEndianIterator", $$robo$$libcore_io_MemoryMappedFile$littleEndianIterator(), this);
    }

    void checkNotClosed() {
        InvokeDynamicSupport.bootstrap("checkNotClosed", $$robo$$libcore_io_MemoryMappedFile$checkNotClosed(), this);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$libcore_io_MemoryMappedFile$size(), this);
    }

    public /* synthetic */ MemoryMappedFile() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryMappedFile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

