/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.os.Build;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.Trace;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.WindowManagerService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

class WindowTracing {
    private static final String TAG = "WindowTracing";
    private static final long MAGIC_NUMBER_VALUE = 4990904633914181975L;
    private final Object mLock = new Object();
    private final File mTraceFile;
    private final BlockingQueue<ProtoOutputStream> mWriteQueue = new ArrayBlockingQueue<ProtoOutputStream>(200);
    private boolean mEnabled;
    private volatile boolean mEnabledLockFree;

    WindowTracing(File file) {
        this.mTraceFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTrace(PrintWriter pw) throws IOException {
        if (Build.IS_USER) {
            this.logAndPrintln(pw, "Error: Tracing is not supported on user builds.");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.logAndPrintln(pw, "Start tracing to " + this.mTraceFile + ".");
            this.mWriteQueue.clear();
            this.mTraceFile.delete();
            try (FileOutputStream os = new FileOutputStream(this.mTraceFile);){
                this.mTraceFile.setReadable(true, false);
                ProtoOutputStream proto = new ProtoOutputStream(os);
                proto.write(0x10600000001L, 4990904633914181975L);
                proto.flush();
            }
            this.mEnabledLockFree = true;
            this.mEnabled = true;
        }
    }

    private void logAndPrintln(PrintWriter pw, String msg) {
        Log.i(TAG, msg);
        if (pw != null) {
            pw.println(msg);
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTrace(PrintWriter pw) {
        if (Build.IS_USER) {
            this.logAndPrintln(pw, "Error: Tracing is not supported on user builds.");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.logAndPrintln(pw, "Stop tracing to " + this.mTraceFile + ". Waiting for traces to flush.");
            this.mEnabledLockFree = false;
            this.mEnabled = false;
            while (!this.mWriteQueue.isEmpty()) {
                if (this.mEnabled) {
                    this.logAndPrintln(pw, "ERROR: tracing was re-enabled while waiting for flush.");
                    throw new IllegalStateException("tracing enabled while waiting for flush.");
                }
                try {
                    this.mLock.wait();
                    this.mLock.notify();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.logAndPrintln(pw, "Trace written to " + this.mTraceFile + ".");
        }
    }

    void appendTraceEntry(ProtoOutputStream proto) {
        if (!this.mEnabledLockFree) {
            return;
        }
        if (!this.mWriteQueue.offer(proto)) {
            Log.e(TAG, "Dropping window trace entry, queue full");
        }
    }

    void loop() {
        while (true) {
            this.loopOnce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void loopOnce() {
        ProtoOutputStream proto;
        try {
            proto = this.mWriteQueue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                Trace.traceBegin(32L, "writeToFile");
                try (FileOutputStream os = new FileOutputStream(this.mTraceFile, true);){
                    ((OutputStream)os).write(proto.getBytes());
                }
            }
            catch (IOException e) {
                Log.e(TAG, "Failed to write file " + this.mTraceFile, e);
            }
            finally {
                Trace.traceEnd(32L);
            }
            this.mLock.notify();
        }
    }

    boolean isEnabled() {
        return this.mEnabledLockFree;
    }

    static WindowTracing createDefaultAndStartLooper(Context context) {
        File file = new File("/data/misc/wmtrace/wm_trace.pb");
        WindowTracing windowTracing = new WindowTracing(file);
        if (!Build.IS_USER) {
            new Thread(windowTracing::loop, "window_tracing").start();
        }
        return windowTracing;
    }

    int onShellCommand(ShellCommand shell, String cmd) {
        PrintWriter pw = shell.getOutPrintWriter();
        try {
            switch (cmd) {
                case "start": {
                    this.startTrace(pw);
                    return 0;
                }
                case "stop": {
                    this.stopTrace(pw);
                    return 0;
                }
            }
            pw.println("Unknown command: " + cmd);
            return -1;
        }
        catch (IOException e) {
            this.logAndPrintln(pw, e.toString());
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traceStateLocked(String where, WindowManagerService service) {
        if (!this.isEnabled()) {
            return;
        }
        ProtoOutputStream os = new ProtoOutputStream();
        long tokenOuter = os.start(0x20B00000002L);
        os.write(0x10600000001L, SystemClock.elapsedRealtimeNanos());
        os.write(1138166333442L, where);
        Trace.traceBegin(32L, "writeToProtoLocked");
        try {
            long tokenInner = os.start(1146756268035L);
            service.writeToProtoLocked(os, true);
            os.end(tokenInner);
        }
        finally {
            Trace.traceEnd(32L);
        }
        os.end(tokenOuter);
        this.appendTraceEntry(os);
        Trace.traceEnd(32L);
    }
}

