/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.MergedConfiguration;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.Gravity;
import android.view.IApplicationToken;
import android.view.IWindow;
import android.view.IWindowFocusObserver;
import android.view.IWindowId;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.WindowInfo;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ToBooleanFunction;
import com.android.server.input.InputWindowHandle;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.wm.AccessibilityController;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.Dimmer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.ForcedSeamlessRotator;
import com.android.server.wm.LocalAnimationAdapter;
import com.android.server.wm.Session;
import com.android.server.wm.TapExcludeRegionHolder;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowAnimationSpec;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import com.android.server.wm.utils.CoordinateTransforms;
import com.android.server.wm.utils.WmDisplayCutout;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Predicate;

class WindowState
extends WindowContainer<WindowState>
implements WindowManagerPolicy.WindowState {
    static final String TAG = "WindowManager";
    static final int MINIMUM_VISIBLE_WIDTH_IN_DP = 48;
    static final int MINIMUM_VISIBLE_HEIGHT_IN_DP = 32;
    static final int RESIZE_HANDLE_WIDTH_IN_DP = 30;
    final WindowManagerPolicy mPolicy;
    final Context mContext;
    final Session mSession;
    final IWindow mClient;
    final int mAppOp;
    final int mOwnerUid;
    final boolean mOwnerCanAddInternalSystemWindow;
    final WindowId mWindowId;
    WindowToken mToken;
    AppWindowToken mAppToken;
    final WindowManager.LayoutParams mAttrs = new WindowManager.LayoutParams();
    final DeathRecipient mDeathRecipient;
    private boolean mIsChildWindow;
    final int mBaseLayer;
    final int mSubLayer;
    final boolean mLayoutAttached;
    final boolean mIsImWindow;
    final boolean mIsWallpaper;
    private final boolean mIsFloatingLayer;
    int mSeq;
    boolean mEnforceSizeCompat;
    int mViewVisibility;
    int mSystemUiVisibility;
    boolean mPolicyVisibility = true;
    boolean mPolicyVisibilityAfterAnim = true;
    private boolean mHiddenWhileSuspended;
    private boolean mAppOpVisibility = true;
    boolean mPermanentlyHidden;
    private boolean mForceHideNonSystemOverlayWindow;
    boolean mAppFreezing;
    boolean mHidden = true;
    boolean mWallpaperVisible;
    private boolean mDragResizing;
    private boolean mDragResizingChangeReported = true;
    private int mResizeMode;
    final boolean mForceSeamlesslyRotate;
    ForcedSeamlessRotator mPendingForcedSeamlessRotate;
    long mFinishForcedSeamlessRotateFrameNumber;
    private RemoteCallbackList<IWindowFocusObserver> mFocusCallbacks;
    int mRequestedWidth;
    int mRequestedHeight;
    private int mLastRequestedWidth;
    private int mLastRequestedHeight;
    int mLayer;
    boolean mHaveFrame;
    boolean mObscured;
    int mLayoutSeq = -1;
    private final MergedConfiguration mLastReportedConfiguration = new MergedConfiguration();
    final Rect mVisibleInsets = new Rect();
    private final Rect mLastVisibleInsets = new Rect();
    private boolean mVisibleInsetsChanged;
    final Rect mContentInsets = new Rect();
    final Rect mLastContentInsets = new Rect();
    final Rect mLastRelayoutContentInsets = new Rect();
    private boolean mContentInsetsChanged;
    final Rect mOverscanInsets = new Rect();
    private final Rect mLastOverscanInsets = new Rect();
    private boolean mOverscanInsetsChanged;
    final Rect mStableInsets = new Rect();
    private final Rect mLastStableInsets = new Rect();
    private boolean mStableInsetsChanged;
    final Rect mOutsets = new Rect();
    private final Rect mLastOutsets = new Rect();
    private boolean mOutsetsChanged = false;
    WmDisplayCutout mDisplayCutout = WmDisplayCutout.NO_CUTOUT;
    private WmDisplayCutout mLastDisplayCutout = WmDisplayCutout.NO_CUTOUT;
    private boolean mDisplayCutoutChanged;
    boolean mGivenInsetsPending;
    final Rect mGivenContentInsets = new Rect();
    final Rect mGivenVisibleInsets = new Rect();
    final Region mGivenTouchableRegion = new Region();
    int mTouchableInsets = 0;
    float mGlobalScale = 1.0f;
    float mInvGlobalScale = 1.0f;
    float mHScale = 1.0f;
    float mVScale = 1.0f;
    float mLastHScale = 1.0f;
    float mLastVScale = 1.0f;
    final Matrix mTmpMatrix = new Matrix();
    final Rect mFrame = new Rect();
    final Rect mLastFrame = new Rect();
    private boolean mFrameSizeChanged = false;
    final Rect mCompatFrame = new Rect();
    final Rect mContainingFrame = new Rect();
    final Rect mParentFrame = new Rect();
    private boolean mParentFrameWasClippedByDisplayCutout;
    final Rect mDisplayFrame = new Rect();
    private final Rect mOverscanFrame = new Rect();
    private final Rect mStableFrame = new Rect();
    final Rect mDecorFrame = new Rect();
    private final Rect mContentFrame = new Rect();
    final Rect mVisibleFrame = new Rect();
    private final Rect mOutsetFrame = new Rect();
    private final Rect mInsetFrame = new Rect();
    boolean mContentChanged;
    float mWallpaperX = -1.0f;
    float mWallpaperY = -1.0f;
    float mWallpaperXStep = -1.0f;
    float mWallpaperYStep = -1.0f;
    int mWallpaperDisplayOffsetX = Integer.MIN_VALUE;
    int mWallpaperDisplayOffsetY = Integer.MIN_VALUE;
    boolean mRelayoutCalled;
    boolean mInRelayout;
    boolean mLayoutNeeded;
    boolean mAnimatingExit;
    boolean mDestroying;
    boolean mRemoveOnExit;
    boolean mAppDied;
    private boolean mOrientationChanging;
    private boolean mOrientationChangeTimedOut;
    int mLastVisibleLayoutRotation = -1;
    boolean mReportOrientationChanged;
    int mLastFreezeDuration;
    boolean mRemoved;
    boolean mWindowRemovalAllowed;
    final InputWindowHandle mInputWindowHandle;
    InputChannel mInputChannel;
    private InputChannel mClientChannel;
    private String mStringNameCache;
    private CharSequence mLastTitle;
    private boolean mWasExiting;
    final WindowStateAnimator mWinAnimator;
    boolean mHasSurface = false;
    private boolean mShowToOwnerOnly;
    private boolean mWasVisibleBeforeClientHidden;
    boolean mWillReplaceWindow = false;
    private boolean mReplacingRemoveRequested = false;
    private boolean mAnimateReplacingWindow = false;
    private WindowState mReplacementWindow = null;
    boolean mSkipEnterAnimationForSeamlessReplacement = false;
    private boolean mMovedByResize;
    private PowerManager.WakeLock mDrawLock;
    private final Rect mTmpRect = new Rect();
    boolean mResizedWhileGone = false;
    boolean mSeamlesslyRotated = false;
    final Rect mLastSurfaceInsets = new Rect();
    private boolean mDrawnStateEvaluated;
    private final Point mSurfacePosition = new Point();
    private TapExcludeRegionHolder mTapExcludeRegionHolder;
    private PowerManagerWrapper mPowerManagerWrapper;
    private long mFrameNumber = -1L;
    private static final Comparator<WindowState> sWindowSubLayerComparator = new Comparator<WindowState>(){

        @Override
        public int compare(WindowState w1, WindowState w2) {
            int layer1 = w1.mSubLayer;
            int layer2 = w2.mSubLayer;
            if (layer1 < layer2 || layer1 == layer2 && layer2 < 0) {
                return -1;
            }
            return 1;
        }
    };
    private boolean mIsDimming = false;
    private static final float DEFAULT_DIM_AMOUNT_DEAD_WINDOW = 0.5f;
    private DeadWindowEventReceiver mDeadWindowEventReceiver;

    void forceSeamlesslyRotateIfAllowed(int oldRotation, int rotation) {
        if (this.mForceSeamlesslyRotate) {
            this.mPendingForcedSeamlessRotate = new ForcedSeamlessRotator(oldRotation, rotation, this.getDisplayInfo());
            this.mPendingForcedSeamlessRotate.unrotate(this.mToken);
        }
    }

    WindowState(final WindowManagerService service, Session s, IWindow c, WindowToken token, WindowState parentWindow, int appOp, int seq, WindowManager.LayoutParams a, int viewVisibility, int ownerId, boolean ownerCanAddInternalSystemWindow) {
        this(service, s, c, token, parentWindow, appOp, seq, a, viewVisibility, ownerId, ownerCanAddInternalSystemWindow, new PowerManagerWrapper(){

            @Override
            public void wakeUp(long time, String reason) {
                service.mPowerManager.wakeUp(time, reason);
            }

            @Override
            public boolean isInteractive() {
                return service.mPowerManager.isInteractive();
            }
        });
    }

    WindowState(WindowManagerService service, Session s, IWindow c, WindowToken token, WindowState parentWindow, int appOp, int seq, WindowManager.LayoutParams a, int viewVisibility, int ownerId, boolean ownerCanAddInternalSystemWindow, PowerManagerWrapper powerManagerWrapper) {
        super(service);
        this.mSession = s;
        this.mClient = c;
        this.mAppOp = appOp;
        this.mToken = token;
        this.mAppToken = this.mToken.asAppWindowToken();
        this.mOwnerUid = ownerId;
        this.mOwnerCanAddInternalSystemWindow = ownerCanAddInternalSystemWindow;
        this.mWindowId = new WindowId(this);
        this.mAttrs.copyFrom(a);
        this.mLastSurfaceInsets.set(this.mAttrs.surfaceInsets);
        this.mViewVisibility = viewVisibility;
        this.mPolicy = this.mService.mPolicy;
        this.mContext = this.mService.mContext;
        DeathRecipient deathRecipient = new DeathRecipient();
        this.mSeq = seq;
        this.mEnforceSizeCompat = (this.mAttrs.privateFlags & 0x80) != 0;
        this.mPowerManagerWrapper = powerManagerWrapper;
        this.mForceSeamlesslyRotate = token.mRoundedCornerOverlay;
        try {
            c.asBinder().linkToDeath(deathRecipient, 0);
        }
        catch (RemoteException e) {
            this.mDeathRecipient = null;
            this.mIsChildWindow = false;
            this.mLayoutAttached = false;
            this.mIsImWindow = false;
            this.mIsWallpaper = false;
            this.mIsFloatingLayer = false;
            this.mBaseLayer = 0;
            this.mSubLayer = 0;
            this.mInputWindowHandle = null;
            this.mWinAnimator = null;
            return;
        }
        this.mDeathRecipient = deathRecipient;
        if (this.mAttrs.type >= 1000 && this.mAttrs.type <= 1999) {
            this.mBaseLayer = this.mPolicy.getWindowLayerLw(parentWindow) * 10000 + 1000;
            this.mSubLayer = this.mPolicy.getSubWindowLayerFromTypeLw(a.type);
            this.mIsChildWindow = true;
            parentWindow.addChild(this, sWindowSubLayerComparator);
            this.mLayoutAttached = this.mAttrs.type != 1003;
            this.mIsImWindow = parentWindow.mAttrs.type == 2011 || parentWindow.mAttrs.type == 2012;
            this.mIsWallpaper = parentWindow.mAttrs.type == 2013;
        } else {
            this.mBaseLayer = this.mPolicy.getWindowLayerLw(this) * 10000 + 1000;
            this.mSubLayer = 0;
            this.mIsChildWindow = false;
            this.mLayoutAttached = false;
            this.mIsImWindow = this.mAttrs.type == 2011 || this.mAttrs.type == 2012;
            this.mIsWallpaper = this.mAttrs.type == 2013;
        }
        boolean bl = this.mIsFloatingLayer = this.mIsImWindow || this.mIsWallpaper;
        if (this.mAppToken != null && this.mAppToken.mShowForAllUsers) {
            this.mAttrs.flags |= 0x80000;
        }
        this.mWinAnimator = new WindowStateAnimator(this);
        this.mWinAnimator.mAlpha = a.alpha;
        this.mRequestedWidth = 0;
        this.mRequestedHeight = 0;
        this.mLastRequestedWidth = 0;
        this.mLastRequestedHeight = 0;
        this.mLayer = 0;
        this.mInputWindowHandle = new InputWindowHandle(this.mAppToken != null ? this.mAppToken.mInputApplicationHandle : null, this, c, this.getDisplayId());
    }

    void attach() {
        this.mSession.windowAddedLocked(this.mAttrs.packageName);
    }

    boolean getDrawnStateEvaluated() {
        return this.mDrawnStateEvaluated;
    }

    void setDrawnStateEvaluated(boolean evaluated) {
        this.mDrawnStateEvaluated = evaluated;
    }

    @Override
    void onParentSet() {
        super.onParentSet();
        this.setDrawnStateEvaluated(false);
        this.getDisplayContent().reapplyMagnificationSpec();
    }

    @Override
    public int getOwningUid() {
        return this.mOwnerUid;
    }

    @Override
    public String getOwningPackage() {
        return this.mAttrs.packageName;
    }

    @Override
    public boolean canAddInternalSystemWindow() {
        return this.mOwnerCanAddInternalSystemWindow;
    }

    @Override
    public boolean canAcquireSleepToken() {
        return this.mSession.mCanAcquireSleepToken;
    }

    private void subtractInsets(Rect frame, Rect layoutFrame, Rect insetFrame, Rect displayFrame) {
        int left = Math.max(0, insetFrame.left - Math.max(layoutFrame.left, displayFrame.left));
        int top = Math.max(0, insetFrame.top - Math.max(layoutFrame.top, displayFrame.top));
        int right = Math.max(0, Math.min(layoutFrame.right, displayFrame.right) - insetFrame.right);
        int bottom = Math.max(0, Math.min(layoutFrame.bottom, displayFrame.bottom) - insetFrame.bottom);
        frame.inset(left, top, right, bottom);
    }

    @Override
    public void computeFrameLw(Rect parentFrame, Rect displayFrame, Rect overscanFrame, Rect contentFrame, Rect visibleFrame, Rect decorFrame, Rect stableFrame, Rect outsetFrame, WmDisplayCutout displayCutout, boolean parentFrameWasClippedByDisplayCutout) {
        DisplayContent displayContent;
        boolean hasOutsets;
        int layoutYDiff;
        int layoutXDiff;
        Rect layoutContainingFrame;
        Rect layoutDisplayFrame;
        if (this.mWillReplaceWindow && (this.mAnimatingExit || !this.mReplacingRemoveRequested)) {
            return;
        }
        this.mHaveFrame = true;
        this.mParentFrameWasClippedByDisplayCutout = parentFrameWasClippedByDisplayCutout;
        Task task = this.getTask();
        boolean inFullscreenContainer = this.inFullscreenContainer();
        boolean windowsAreFloating = task != null && task.isFloating();
        DisplayContent dc = this.getDisplayContent();
        if (task != null && this.isInMultiWindowMode()) {
            task.getTempInsetBounds(this.mInsetFrame);
        } else {
            this.mInsetFrame.setEmpty();
        }
        if (inFullscreenContainer || this.layoutInParentFrame()) {
            this.mContainingFrame.set(parentFrame);
            this.mDisplayFrame.set(displayFrame);
            layoutDisplayFrame = displayFrame;
            layoutContainingFrame = parentFrame;
            layoutXDiff = 0;
            layoutYDiff = 0;
        } else {
            WindowState imeWin;
            this.getBounds(this.mContainingFrame);
            if (this.mAppToken != null && !this.mAppToken.mFrozenBounds.isEmpty()) {
                Rect frozen = this.mAppToken.mFrozenBounds.peek();
                this.mContainingFrame.right = this.mContainingFrame.left + frozen.width();
                this.mContainingFrame.bottom = this.mContainingFrame.top + frozen.height();
            }
            if ((imeWin = this.mService.mInputMethodWindow) != null && imeWin.isVisibleNow() && this.isInputMethodTarget()) {
                if (this.inFreeformWindowingMode() && this.mContainingFrame.bottom > contentFrame.bottom) {
                    this.mContainingFrame.top -= this.mContainingFrame.bottom - contentFrame.bottom;
                } else if (!this.inPinnedWindowingMode() && this.mContainingFrame.bottom > parentFrame.bottom) {
                    this.mContainingFrame.bottom = parentFrame.bottom;
                }
            }
            if (windowsAreFloating && this.mContainingFrame.isEmpty()) {
                this.mContainingFrame.set(contentFrame);
            }
            TaskStack stack = this.getStack();
            if (this.inPinnedWindowingMode() && stack != null && stack.lastAnimatingBoundsWasToFullscreen()) {
                this.mInsetFrame.intersectUnchecked(parentFrame);
                this.mContainingFrame.intersectUnchecked(parentFrame);
            }
            this.mDisplayFrame.set(this.mContainingFrame);
            layoutXDiff = !this.mInsetFrame.isEmpty() ? this.mInsetFrame.left - this.mContainingFrame.left : 0;
            layoutYDiff = !this.mInsetFrame.isEmpty() ? this.mInsetFrame.top - this.mContainingFrame.top : 0;
            layoutContainingFrame = !this.mInsetFrame.isEmpty() ? this.mInsetFrame : this.mContainingFrame;
            this.mTmpRect.set(0, 0, dc.getDisplayInfo().logicalWidth, dc.getDisplayInfo().logicalHeight);
            this.subtractInsets(this.mDisplayFrame, layoutContainingFrame, displayFrame, this.mTmpRect);
            if (!this.layoutInParentFrame()) {
                this.subtractInsets(this.mContainingFrame, layoutContainingFrame, parentFrame, this.mTmpRect);
                this.subtractInsets(this.mInsetFrame, layoutContainingFrame, parentFrame, this.mTmpRect);
            }
            layoutDisplayFrame = displayFrame;
            layoutDisplayFrame.intersect(layoutContainingFrame);
        }
        int pw = this.mContainingFrame.width();
        int ph = this.mContainingFrame.height();
        if (!this.mParentFrame.equals(parentFrame)) {
            this.mParentFrame.set(parentFrame);
            this.mContentChanged = true;
        }
        if (this.mRequestedWidth != this.mLastRequestedWidth || this.mRequestedHeight != this.mLastRequestedHeight) {
            this.mLastRequestedWidth = this.mRequestedWidth;
            this.mLastRequestedHeight = this.mRequestedHeight;
            this.mContentChanged = true;
        }
        this.mOverscanFrame.set(overscanFrame);
        this.mContentFrame.set(contentFrame);
        this.mVisibleFrame.set(visibleFrame);
        this.mDecorFrame.set(decorFrame);
        this.mStableFrame.set(stableFrame);
        boolean bl = hasOutsets = outsetFrame != null;
        if (hasOutsets) {
            this.mOutsetFrame.set(outsetFrame);
        }
        int fw = this.mFrame.width();
        int fh = this.mFrame.height();
        this.applyGravityAndUpdateFrame(layoutContainingFrame, layoutDisplayFrame);
        if (hasOutsets) {
            this.mOutsets.set(Math.max(this.mContentFrame.left - this.mOutsetFrame.left, 0), Math.max(this.mContentFrame.top - this.mOutsetFrame.top, 0), Math.max(this.mOutsetFrame.right - this.mContentFrame.right, 0), Math.max(this.mOutsetFrame.bottom - this.mContentFrame.bottom, 0));
        } else {
            this.mOutsets.set(0, 0, 0, 0);
        }
        if (windowsAreFloating && !this.mFrame.isEmpty()) {
            Rect limitFrame = task.inPinnedWindowingMode() ? this.mFrame : this.mContentFrame;
            int height = Math.min(this.mFrame.height(), limitFrame.height());
            int width = Math.min(limitFrame.width(), this.mFrame.width());
            DisplayMetrics displayMetrics = this.getDisplayContent().getDisplayMetrics();
            int minVisibleHeight = Math.min(height, WindowManagerService.dipToPixel(32, displayMetrics));
            int minVisibleWidth = Math.min(width, WindowManagerService.dipToPixel(48, displayMetrics));
            int top = Math.max(limitFrame.top, Math.min(this.mFrame.top, limitFrame.bottom - minVisibleHeight));
            int left = Math.max(limitFrame.left + minVisibleWidth - width, Math.min(this.mFrame.left, limitFrame.right - minVisibleWidth));
            this.mFrame.set(left, top, left + width, top + height);
            this.mContentFrame.set(this.mFrame);
            this.mVisibleFrame.set(this.mContentFrame);
            this.mStableFrame.set(this.mContentFrame);
        } else if (this.mAttrs.type == 2034) {
            dc.getDockedDividerController().positionDockedStackedDivider(this.mFrame);
            this.mContentFrame.set(this.mFrame);
            if (!this.mFrame.equals(this.mLastFrame)) {
                this.mMovedByResize = true;
            }
        } else {
            this.mContentFrame.set(Math.max(this.mContentFrame.left, this.mFrame.left), Math.max(this.mContentFrame.top, this.mFrame.top), Math.min(this.mContentFrame.right, this.mFrame.right), Math.min(this.mContentFrame.bottom, this.mFrame.bottom));
            this.mVisibleFrame.set(Math.max(this.mVisibleFrame.left, this.mFrame.left), Math.max(this.mVisibleFrame.top, this.mFrame.top), Math.min(this.mVisibleFrame.right, this.mFrame.right), Math.min(this.mVisibleFrame.bottom, this.mFrame.bottom));
            this.mStableFrame.set(Math.max(this.mStableFrame.left, this.mFrame.left), Math.max(this.mStableFrame.top, this.mFrame.top), Math.min(this.mStableFrame.right, this.mFrame.right), Math.min(this.mStableFrame.bottom, this.mFrame.bottom));
        }
        if (inFullscreenContainer && !windowsAreFloating) {
            this.mOverscanInsets.set(Math.max(this.mOverscanFrame.left - layoutContainingFrame.left, 0), Math.max(this.mOverscanFrame.top - layoutContainingFrame.top, 0), Math.max(layoutContainingFrame.right - this.mOverscanFrame.right, 0), Math.max(layoutContainingFrame.bottom - this.mOverscanFrame.bottom, 0));
        }
        if (this.mAttrs.type == 2034) {
            WmDisplayCutout c = displayCutout.calculateRelativeTo(this.mDisplayFrame);
            this.mTmpRect.set(this.mDisplayFrame);
            this.mTmpRect.inset(c.getDisplayCutout().getSafeInsets());
            this.mTmpRect.intersectUnchecked(this.mStableFrame);
            this.mStableInsets.set(Math.max(this.mTmpRect.left - this.mDisplayFrame.left, 0), Math.max(this.mTmpRect.top - this.mDisplayFrame.top, 0), Math.max(this.mDisplayFrame.right - this.mTmpRect.right, 0), Math.max(this.mDisplayFrame.bottom - this.mTmpRect.bottom, 0));
            this.mContentInsets.setEmpty();
            this.mVisibleInsets.setEmpty();
            displayCutout = WmDisplayCutout.NO_CUTOUT;
        } else {
            this.getDisplayContent().getBounds(this.mTmpRect);
            boolean overrideRightInset = !windowsAreFloating && !inFullscreenContainer && this.mFrame.right > this.mTmpRect.right;
            boolean overrideBottomInset = !windowsAreFloating && !inFullscreenContainer && this.mFrame.bottom > this.mTmpRect.bottom;
            this.mContentInsets.set(this.mContentFrame.left - this.mFrame.left, this.mContentFrame.top - this.mFrame.top, overrideRightInset ? this.mTmpRect.right - this.mContentFrame.right : this.mFrame.right - this.mContentFrame.right, overrideBottomInset ? this.mTmpRect.bottom - this.mContentFrame.bottom : this.mFrame.bottom - this.mContentFrame.bottom);
            this.mVisibleInsets.set(this.mVisibleFrame.left - this.mFrame.left, this.mVisibleFrame.top - this.mFrame.top, overrideRightInset ? this.mTmpRect.right - this.mVisibleFrame.right : this.mFrame.right - this.mVisibleFrame.right, overrideBottomInset ? this.mTmpRect.bottom - this.mVisibleFrame.bottom : this.mFrame.bottom - this.mVisibleFrame.bottom);
            this.mStableInsets.set(Math.max(this.mStableFrame.left - this.mFrame.left, 0), Math.max(this.mStableFrame.top - this.mFrame.top, 0), overrideRightInset ? Math.max(this.mTmpRect.right - this.mStableFrame.right, 0) : Math.max(this.mFrame.right - this.mStableFrame.right, 0), overrideBottomInset ? Math.max(this.mTmpRect.bottom - this.mStableFrame.bottom, 0) : Math.max(this.mFrame.bottom - this.mStableFrame.bottom, 0));
        }
        this.mDisplayCutout = displayCutout.calculateRelativeTo(this.mFrame);
        this.mFrame.offset(-layoutXDiff, -layoutYDiff);
        this.mCompatFrame.offset(-layoutXDiff, -layoutYDiff);
        this.mContentFrame.offset(-layoutXDiff, -layoutYDiff);
        this.mVisibleFrame.offset(-layoutXDiff, -layoutYDiff);
        this.mStableFrame.offset(-layoutXDiff, -layoutYDiff);
        this.mCompatFrame.set(this.mFrame);
        if (this.mEnforceSizeCompat) {
            this.mOverscanInsets.scale(this.mInvGlobalScale);
            this.mContentInsets.scale(this.mInvGlobalScale);
            this.mVisibleInsets.scale(this.mInvGlobalScale);
            this.mStableInsets.scale(this.mInvGlobalScale);
            this.mOutsets.scale(this.mInvGlobalScale);
            this.mCompatFrame.scale(this.mInvGlobalScale);
        }
        if (this.mIsWallpaper && (fw != this.mFrame.width() || fh != this.mFrame.height()) && (displayContent = this.getDisplayContent()) != null) {
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            this.getDisplayContent().mWallpaperController.updateWallpaperOffset(this, displayInfo.logicalWidth, displayInfo.logicalHeight, false);
        }
    }

    @Override
    public Rect getBounds() {
        if (this.isInMultiWindowMode()) {
            return this.getTask().getBounds();
        }
        if (this.mAppToken != null) {
            return this.mAppToken.getBounds();
        }
        return super.getBounds();
    }

    @Override
    public Rect getFrameLw() {
        return this.mFrame;
    }

    @Override
    public Rect getDisplayFrameLw() {
        return this.mDisplayFrame;
    }

    @Override
    public Rect getOverscanFrameLw() {
        return this.mOverscanFrame;
    }

    @Override
    public Rect getContentFrameLw() {
        return this.mContentFrame;
    }

    @Override
    public Rect getVisibleFrameLw() {
        return this.mVisibleFrame;
    }

    Rect getStableFrameLw() {
        return this.mStableFrame;
    }

    @Override
    public boolean getGivenInsetsPendingLw() {
        return this.mGivenInsetsPending;
    }

    @Override
    public Rect getGivenContentInsetsLw() {
        return this.mGivenContentInsets;
    }

    @Override
    public Rect getGivenVisibleInsetsLw() {
        return this.mGivenVisibleInsets;
    }

    @Override
    public WindowManager.LayoutParams getAttrs() {
        return this.mAttrs;
    }

    @Override
    public boolean getNeedsMenuLw(WindowManagerPolicy.WindowState bottom) {
        return this.getDisplayContent().getNeedsMenu(this, bottom);
    }

    @Override
    public int getSystemUiVisibility() {
        return this.mSystemUiVisibility;
    }

    @Override
    public int getSurfaceLayer() {
        return this.mLayer;
    }

    @Override
    public int getBaseType() {
        return this.getTopParentWindow().mAttrs.type;
    }

    @Override
    public IApplicationToken getAppToken() {
        return this.mAppToken != null ? this.mAppToken.appToken : null;
    }

    @Override
    public boolean isVoiceInteraction() {
        return this.mAppToken != null && this.mAppToken.mVoiceInteraction;
    }

    boolean setReportResizeHints() {
        this.mOverscanInsetsChanged |= !this.mLastOverscanInsets.equals(this.mOverscanInsets);
        this.mContentInsetsChanged |= !this.mLastContentInsets.equals(this.mContentInsets);
        this.mVisibleInsetsChanged |= !this.mLastVisibleInsets.equals(this.mVisibleInsets);
        this.mStableInsetsChanged |= !this.mLastStableInsets.equals(this.mStableInsets);
        this.mOutsetsChanged |= !this.mLastOutsets.equals(this.mOutsets);
        this.mFrameSizeChanged |= this.mLastFrame.width() != this.mFrame.width() || this.mLastFrame.height() != this.mFrame.height();
        this.mDisplayCutoutChanged |= !this.mLastDisplayCutout.equals(this.mDisplayCutout);
        return this.mOverscanInsetsChanged || this.mContentInsetsChanged || this.mVisibleInsetsChanged || this.mOutsetsChanged || this.mFrameSizeChanged || this.mDisplayCutoutChanged;
    }

    void updateResizingWindowIfNeeded() {
        WindowStateAnimator winAnimator = this.mWinAnimator;
        if (!this.mHasSurface || this.getDisplayContent().mLayoutSeq != this.mLayoutSeq || this.isGoneForLayoutLw()) {
            return;
        }
        Task task = this.getTask();
        if (task != null && task.mStack.isAnimatingBounds()) {
            return;
        }
        this.setReportResizeHints();
        boolean configChanged = this.isConfigChanged();
        boolean dragResizingChanged = this.isDragResizeChanged() && !this.isDragResizingChangeReported();
        this.mLastFrame.set(this.mFrame);
        if (this.mContentInsetsChanged || this.mVisibleInsetsChanged || this.mStableInsetsChanged || winAnimator.mSurfaceResized || this.mOutsetsChanged || this.mFrameSizeChanged || this.mDisplayCutoutChanged || configChanged || dragResizingChanged || this.mReportOrientationChanged) {
            if (this.mAppToken != null && this.mAppDied) {
                this.mAppToken.removeDeadWindows();
                return;
            }
            this.updateLastInsetValues();
            this.mService.makeWindowFreezingScreenIfNeededLocked(this);
            if (this.getOrientationChanging() || dragResizingChanged) {
                winAnimator.mDrawState = 1;
                if (this.mAppToken != null) {
                    this.mAppToken.clearAllDrawn();
                }
            }
            if (!this.mService.mResizingWindows.contains(this)) {
                this.mService.mResizingWindows.add(this);
            }
        } else if (this.getOrientationChanging() && this.isDrawnLw()) {
            this.setOrientationChanging(false);
            this.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mService.mDisplayFreezeTime);
        }
    }

    boolean getOrientationChanging() {
        return (this.mOrientationChanging || this.isVisible() && this.getConfiguration().orientation != this.getLastReportedConfiguration().orientation) && !this.mSeamlesslyRotated && !this.mOrientationChangeTimedOut;
    }

    void setOrientationChanging(boolean changing) {
        this.mOrientationChanging = changing;
        this.mOrientationChangeTimedOut = false;
    }

    void orientationChangeTimedOut() {
        this.mOrientationChangeTimedOut = true;
    }

    DisplayContent getDisplayContent() {
        return this.mToken.getDisplayContent();
    }

    @Override
    void onDisplayChanged(DisplayContent dc) {
        super.onDisplayChanged(dc);
        if (dc != null) {
            this.mLayoutSeq = dc.mLayoutSeq - 1;
            this.mInputWindowHandle.displayId = dc.getDisplayId();
        }
    }

    DisplayInfo getDisplayInfo() {
        DisplayContent displayContent = this.getDisplayContent();
        return displayContent != null ? displayContent.getDisplayInfo() : null;
    }

    @Override
    public int getDisplayId() {
        DisplayContent displayContent = this.getDisplayContent();
        if (displayContent == null) {
            return -1;
        }
        return displayContent.getDisplayId();
    }

    Task getTask() {
        return this.mAppToken != null ? this.mAppToken.getTask() : null;
    }

    TaskStack getStack() {
        Task task = this.getTask();
        if (task != null && task.mStack != null) {
            return task.mStack;
        }
        DisplayContent dc = this.getDisplayContent();
        return this.mAttrs.type >= 2000 && dc != null ? dc.getHomeStack() : null;
    }

    void getVisibleBounds(Rect bounds) {
        Task task = this.getTask();
        boolean intersectWithStackBounds = task != null && task.cropWindowsToStackBounds();
        bounds.setEmpty();
        this.mTmpRect.setEmpty();
        if (intersectWithStackBounds) {
            TaskStack stack = task.mStack;
            if (stack != null) {
                stack.getDimBounds(this.mTmpRect);
            } else {
                intersectWithStackBounds = false;
            }
        }
        bounds.set(this.mVisibleFrame);
        if (intersectWithStackBounds) {
            bounds.intersect(this.mTmpRect);
        }
        if (bounds.isEmpty()) {
            bounds.set(this.mFrame);
            if (intersectWithStackBounds) {
                bounds.intersect(this.mTmpRect);
            }
            return;
        }
    }

    public long getInputDispatchingTimeoutNanos() {
        return this.mAppToken != null ? this.mAppToken.mInputDispatchingTimeoutNanos : 5000000000L;
    }

    @Override
    public boolean hasAppShownWindows() {
        return this.mAppToken != null && (this.mAppToken.firstWindowDrawn || this.mAppToken.startingDisplayed);
    }

    boolean isIdentityMatrix(float dsdx, float dtdx, float dsdy, float dtdy) {
        if (dsdx < 0.99999f || dsdx > 1.00001f) {
            return false;
        }
        if (dtdy < 0.99999f || dtdy > 1.00001f) {
            return false;
        }
        if (dtdx < -1.0E-6f || dtdx > 1.0E-6f) {
            return false;
        }
        return !(dsdy < -1.0E-6f) && !(dsdy > 1.0E-6f);
    }

    void prelayout() {
        if (this.mEnforceSizeCompat) {
            this.mGlobalScale = this.getDisplayContent().mCompatibleScreenScale;
            this.mInvGlobalScale = 1.0f / this.mGlobalScale;
        } else {
            this.mInvGlobalScale = 1.0f;
            this.mGlobalScale = 1.0f;
        }
    }

    @Override
    boolean hasContentToDisplay() {
        if (!this.mAppFreezing && this.isDrawnLw() && (this.mViewVisibility == 0 || this.mWinAnimator.isAnimationSet() && !this.mService.mAppTransition.isTransitionSet())) {
            return true;
        }
        return super.hasContentToDisplay();
    }

    @Override
    boolean isVisible() {
        return this.wouldBeVisibleIfPolicyIgnored() && this.mPolicyVisibility;
    }

    boolean wouldBeVisibleIfPolicyIgnored() {
        return this.mHasSurface && !this.isParentWindowHidden() && !this.mAnimatingExit && !this.mDestroying && (!this.mIsWallpaper || this.mWallpaperVisible);
    }

    @Override
    public boolean isVisibleLw() {
        return this.isVisible();
    }

    boolean isWinVisibleLw() {
        return (this.mAppToken == null || !this.mAppToken.hiddenRequested || this.mAppToken.isSelfAnimating()) && this.isVisible();
    }

    boolean isVisibleNow() {
        return (!this.mToken.isHidden() || this.mAttrs.type == 3) && this.isVisible();
    }

    boolean isPotentialDragTarget() {
        return this.isVisibleNow() && !this.mRemoved && this.mInputChannel != null && this.mInputWindowHandle != null;
    }

    boolean isVisibleOrAdding() {
        AppWindowToken atoken = this.mAppToken;
        return (this.mHasSurface || !this.mRelayoutCalled && this.mViewVisibility == 0) && this.mPolicyVisibility && !this.isParentWindowHidden() && (atoken == null || !atoken.hiddenRequested) && !this.mAnimatingExit && !this.mDestroying;
    }

    boolean isOnScreen() {
        if (!this.mHasSurface || this.mDestroying || !this.mPolicyVisibility) {
            return false;
        }
        AppWindowToken atoken = this.mAppToken;
        if (atoken != null) {
            return !this.isParentWindowHidden() && !atoken.hiddenRequested || this.mWinAnimator.isAnimationSet();
        }
        return !this.isParentWindowHidden() || this.mWinAnimator.isAnimationSet();
    }

    boolean mightAffectAllDrawn() {
        boolean isAppType = this.mWinAnimator.mAttrType == 1 || this.mWinAnimator.mAttrType == 4;
        return (this.isOnScreen() || isAppType) && !this.mAnimatingExit && !this.mDestroying;
    }

    boolean isInteresting() {
        return this.mAppToken != null && !this.mAppDied && (!this.mAppToken.isFreezingScreen() || !this.mAppFreezing);
    }

    boolean isReadyForDisplay() {
        if (this.mToken.waitingToShow && this.mService.mAppTransition.isTransitionSet()) {
            return false;
        }
        return this.mHasSurface && this.mPolicyVisibility && !this.mDestroying && (!this.isParentWindowHidden() && this.mViewVisibility == 0 && !this.mToken.isHidden() || this.mWinAnimator.isAnimationSet());
    }

    @Override
    public boolean canAffectSystemUiFlags() {
        boolean translucent;
        boolean bl = translucent = this.mAttrs.alpha == 0.0f;
        if (translucent) {
            return false;
        }
        if (this.mAppToken == null) {
            boolean shown = this.mWinAnimator.getShown();
            boolean exiting = this.mAnimatingExit || this.mDestroying;
            return shown && !exiting;
        }
        Task task = this.getTask();
        boolean canFromTask = task != null && task.canAffectSystemUiFlags();
        return canFromTask && !this.mAppToken.isHidden();
    }

    @Override
    public boolean isDisplayedLw() {
        AppWindowToken atoken = this.mAppToken;
        return this.isDrawnLw() && this.mPolicyVisibility && (!this.isParentWindowHidden() && (atoken == null || !atoken.hiddenRequested) || this.mWinAnimator.isAnimationSet());
    }

    @Override
    public boolean isAnimatingLw() {
        return this.isAnimating();
    }

    @Override
    public boolean isGoneForLayoutLw() {
        AppWindowToken atoken = this.mAppToken;
        return this.mViewVisibility == 8 || !this.mRelayoutCalled || atoken == null && this.mToken.isHidden() || atoken != null && atoken.hiddenRequested || this.isParentWindowHidden() || this.mAnimatingExit && !this.isAnimatingLw() || this.mDestroying;
    }

    public boolean isDrawFinishedLw() {
        return this.mHasSurface && !this.mDestroying && (this.mWinAnimator.mDrawState == 2 || this.mWinAnimator.mDrawState == 3 || this.mWinAnimator.mDrawState == 4);
    }

    @Override
    public boolean isDrawnLw() {
        return this.mHasSurface && !this.mDestroying && (this.mWinAnimator.mDrawState == 3 || this.mWinAnimator.mDrawState == 4);
    }

    private boolean isOpaqueDrawn() {
        return (!this.mIsWallpaper && this.mAttrs.format == -1 || this.mIsWallpaper && this.mWallpaperVisible) && this.isDrawnLw() && !this.mWinAnimator.isAnimationSet();
    }

    @Override
    void onMovedByResize() {
        this.mMovedByResize = true;
        super.onMovedByResize();
    }

    boolean onAppVisibilityChanged(boolean visible, boolean runningAppAnimation) {
        boolean changed = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            changed |= c.onAppVisibilityChanged(visible, runningAppAnimation);
        }
        if (this.mAttrs.type == 3) {
            if (!visible && this.isVisibleNow() && this.mAppToken.isSelfAnimating()) {
                this.mAnimatingExit = true;
                this.mRemoveOnExit = true;
                this.mWindowRemovalAllowed = true;
            }
            return changed;
        }
        boolean isVisibleNow = this.isVisibleNow();
        if (visible != isVisibleNow) {
            if (!runningAppAnimation && isVisibleNow) {
                AccessibilityController accessibilityController = this.mService.mAccessibilityController;
                int winTransit = 2;
                this.mWinAnimator.applyAnimationLocked(2, false);
                if (accessibilityController != null && this.getDisplayId() == 0) {
                    accessibilityController.onWindowTransitionLocked(this, 2);
                }
            }
            changed = true;
            this.setDisplayLayoutNeeded();
        }
        return changed;
    }

    boolean onSetAppExiting() {
        DisplayContent displayContent = this.getDisplayContent();
        boolean changed = false;
        if (this.isVisibleNow()) {
            this.mWinAnimator.applyAnimationLocked(2, false);
            if (this.mService.mAccessibilityController != null && this.isDefaultDisplay()) {
                this.mService.mAccessibilityController.onWindowTransitionLocked(this, 2);
            }
            changed = true;
            if (displayContent != null) {
                displayContent.setLayoutNeeded();
            }
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            changed |= c.onSetAppExiting();
        }
        return changed;
    }

    @Override
    void onResize() {
        ArrayList<WindowState> resizingWindows = this.mService.mResizingWindows;
        if (this.mHasSurface && !this.isGoneForLayoutLw() && !resizingWindows.contains(this)) {
            resizingWindows.add(this);
        }
        if (this.isGoneForLayoutLw()) {
            this.mResizedWhileGone = true;
        }
        super.onResize();
    }

    void onUnfreezeBounds() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.onUnfreezeBounds();
        }
        if (!this.mHasSurface) {
            return;
        }
        this.mLayoutNeeded = true;
        this.setDisplayLayoutNeeded();
        if (!this.mService.mResizingWindows.contains(this)) {
            this.mService.mResizingWindows.add(this);
        }
    }

    void handleWindowMovedIfNeeded() {
        boolean adjustedForMinimizedDockOrIme;
        if (!this.hasMoved()) {
            return;
        }
        int left = this.mFrame.left;
        int top = this.mFrame.top;
        Task task = this.getTask();
        boolean bl = adjustedForMinimizedDockOrIme = task != null && (task.mStack.isAdjustedForMinimizedDockedStack() || task.mStack.isAdjustedForIme());
        if (this.mToken.okToAnimate() && (this.mAttrs.privateFlags & 0x40) == 0 && !this.isDragResizing() && !adjustedForMinimizedDockOrIme && this.getWindowConfiguration().hasMovementAnimations() && !this.mWinAnimator.mLastHidden && !this.mSeamlesslyRotated) {
            this.startMoveAnimation(left, top);
        }
        if (this.mService.mAccessibilityController != null && this.getDisplayContent().getDisplayId() == 0) {
            this.mService.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
        }
        try {
            this.mClient.moved(left, top);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mMovedByResize = false;
    }

    private boolean hasMoved() {
        return !(!this.mHasSurface || !this.mContentChanged && !this.mMovedByResize || this.mAnimatingExit || this.mFrame.top == this.mLastFrame.top && this.mFrame.left == this.mLastFrame.left || this.mIsChildWindow && this.getParentWindow().hasMoved());
    }

    boolean isObscuringDisplay() {
        Task task = this.getTask();
        if (task != null && task.mStack != null && !task.mStack.fillsParent()) {
            return false;
        }
        return this.isOpaqueDrawn() && this.fillsDisplay();
    }

    boolean fillsDisplay() {
        DisplayInfo displayInfo = this.getDisplayInfo();
        return this.mFrame.left <= 0 && this.mFrame.top <= 0 && this.mFrame.right >= displayInfo.appWidth && this.mFrame.bottom >= displayInfo.appHeight;
    }

    boolean isConfigChanged() {
        return !this.getLastReportedConfiguration().equals(this.getConfiguration());
    }

    void onWindowReplacementTimeout() {
        if (this.mWillReplaceWindow) {
            this.removeImmediately();
        } else {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                WindowState c = (WindowState)this.mChildren.get(i);
                c.onWindowReplacementTimeout();
            }
        }
    }

    @Override
    void forceWindowsScaleableInTransaction(boolean force) {
        if (this.mWinAnimator != null && this.mWinAnimator.hasSurface()) {
            this.mWinAnimator.mSurfaceController.forceScaleableInTransaction(force);
        }
        super.forceWindowsScaleableInTransaction(force);
    }

    @Override
    void removeImmediately() {
        int type;
        super.removeImmediately();
        if (this.mRemoved) {
            return;
        }
        this.mRemoved = true;
        this.mWillReplaceWindow = false;
        if (this.mReplacementWindow != null) {
            this.mReplacementWindow.mSkipEnterAnimationForSeamlessReplacement = false;
        }
        DisplayContent dc = this.getDisplayContent();
        if (this.isInputMethodTarget()) {
            dc.computeImeTarget(true);
        }
        if (WindowManagerService.excludeWindowTypeFromTapOutTask(type = this.mAttrs.type)) {
            dc.mTapExcludedWindows.remove(this);
        }
        if (this.mTapExcludeRegionHolder != null) {
            dc.mTapExcludeProvidingWindows.remove(this);
        }
        this.mPolicy.removeWindowLw(this);
        this.disposeInputChannel();
        this.mWinAnimator.destroyDeferredSurfaceLocked();
        this.mWinAnimator.destroySurfaceLocked();
        this.mSession.windowRemovedLocked();
        try {
            this.mClient.asBinder().unlinkToDeath(this.mDeathRecipient, 0);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.mService.postWindowRemoveCleanupLocked(this);
    }

    @Override
    void removeIfPossible() {
        super.removeIfPossible();
        this.removeIfPossible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIfPossible(boolean keepVisibleDeadWindow) {
        boolean startingWindow;
        this.mWindowRemovalAllowed = true;
        boolean bl = startingWindow = this.mAttrs.type == 3;
        if (startingWindow) {
            // empty if block
        }
        long origId = Binder.clearCallingIdentity();
        try {
            this.disposeInputChannel();
            boolean wasVisible = false;
            int displayId = this.getDisplayId();
            if (this.mHasSurface && this.mToken.okToAnimate()) {
                boolean lastWindowIsStartingWindow;
                if (this.mWillReplaceWindow) {
                    this.mAnimatingExit = true;
                    this.mReplacingRemoveRequested = true;
                    return;
                }
                wasVisible = this.isWinVisibleLw();
                if (keepVisibleDeadWindow) {
                    this.mAppDied = true;
                    this.setDisplayLayoutNeeded();
                    this.mService.mWindowPlacerLocked.performSurfacePlacement();
                    this.openInputChannel(null);
                    this.mService.mInputMonitor.updateInputWindowsLw(true);
                    return;
                }
                if (wasVisible) {
                    int transit;
                    int n = transit = !startingWindow ? 2 : 5;
                    if (this.mWinAnimator.applyAnimationLocked(transit, false)) {
                        this.mAnimatingExit = true;
                        this.setDisplayLayoutNeeded();
                        this.mService.requestTraversal();
                    }
                    if (this.mService.mAccessibilityController != null && displayId == 0) {
                        this.mService.mAccessibilityController.onWindowTransitionLocked(this, transit);
                    }
                }
                boolean isAnimating = this.mWinAnimator.isAnimationSet() && (this.mAppToken == null || !this.mAppToken.isWaitingForTransitionStart());
                boolean bl2 = lastWindowIsStartingWindow = startingWindow && this.mAppToken != null && this.mAppToken.isLastWindow(this);
                if (this.mWinAnimator.getShown() && this.mAnimatingExit && (!lastWindowIsStartingWindow || isAnimating)) {
                    this.setupWindowForRemoveOnExit();
                    if (this.mAppToken != null) {
                        this.mAppToken.updateReportedVisibilityLocked();
                    }
                    return;
                }
            }
            this.removeImmediately();
            if (wasVisible && this.mService.updateOrientationFromAppTokensLocked(displayId)) {
                this.mService.mH.obtainMessage(18, displayId).sendToTarget();
            }
            this.mService.updateFocusedWindowLocked(0, true);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    private void setupWindowForRemoveOnExit() {
        this.mRemoveOnExit = true;
        this.setDisplayLayoutNeeded();
        boolean focusChanged = this.mService.updateFocusedWindowLocked(3, false);
        this.mService.mWindowPlacerLocked.performSurfacePlacement();
        if (focusChanged) {
            this.mService.mInputMonitor.updateInputWindowsLw(false);
        }
    }

    void setHasSurface(boolean hasSurface) {
        this.mHasSurface = hasSurface;
    }

    boolean canBeImeTarget() {
        boolean windowsAreFocusable;
        if (this.mIsImWindow) {
            return false;
        }
        boolean bl = windowsAreFocusable = this.mAppToken == null || this.mAppToken.windowsAreFocusable();
        if (!windowsAreFocusable) {
            return false;
        }
        int fl = this.mAttrs.flags & 0x20008;
        int type = this.mAttrs.type;
        if (fl != 0 && fl != 131080 && type != 3) {
            return false;
        }
        return this.isVisibleOrAdding();
    }

    void openInputChannel(InputChannel outInputChannel) {
        if (this.mInputChannel != null) {
            throw new IllegalStateException("Window already has an input channel.");
        }
        String name = this.getName();
        InputChannel[] inputChannels = InputChannel.openInputChannelPair(name);
        this.mInputChannel = inputChannels[0];
        this.mClientChannel = inputChannels[1];
        this.mInputWindowHandle.inputChannel = inputChannels[0];
        if (outInputChannel != null) {
            this.mClientChannel.transferTo(outInputChannel);
            this.mClientChannel.dispose();
            this.mClientChannel = null;
        } else {
            this.mDeadWindowEventReceiver = new DeadWindowEventReceiver(this.mClientChannel);
        }
        this.mService.mInputManager.registerInputChannel(this.mInputChannel, this.mInputWindowHandle);
    }

    void disposeInputChannel() {
        if (this.mDeadWindowEventReceiver != null) {
            this.mDeadWindowEventReceiver.dispose();
            this.mDeadWindowEventReceiver = null;
        }
        if (this.mInputChannel != null) {
            this.mService.mInputManager.unregisterInputChannel(this.mInputChannel);
            this.mInputChannel.dispose();
            this.mInputChannel = null;
        }
        if (this.mClientChannel != null) {
            this.mClientChannel.dispose();
            this.mClientChannel = null;
        }
        this.mInputWindowHandle.inputChannel = null;
    }

    boolean removeReplacedWindowIfNeeded(WindowState replacement) {
        if (this.mWillReplaceWindow && this.mReplacementWindow == replacement && replacement.hasDrawnLw()) {
            replacement.mSkipEnterAnimationForSeamlessReplacement = false;
            this.removeReplacedWindow();
            return true;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            if (!c.removeReplacedWindowIfNeeded(replacement)) continue;
            return true;
        }
        return false;
    }

    private void removeReplacedWindow() {
        this.mWillReplaceWindow = false;
        this.mAnimateReplacingWindow = false;
        this.mReplacingRemoveRequested = false;
        this.mReplacementWindow = null;
        if (this.mAnimatingExit || !this.mAnimateReplacingWindow) {
            this.removeImmediately();
        }
    }

    boolean setReplacementWindowIfNeeded(WindowState replacementCandidate) {
        boolean replacementSet = false;
        if (this.mWillReplaceWindow && this.mReplacementWindow == null && this.getWindowTag().toString().equals(replacementCandidate.getWindowTag().toString())) {
            this.mReplacementWindow = replacementCandidate;
            replacementCandidate.mSkipEnterAnimationForSeamlessReplacement = !this.mAnimateReplacingWindow;
            replacementSet = true;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            replacementSet |= c.setReplacementWindowIfNeeded(replacementCandidate);
        }
        return replacementSet;
    }

    void setDisplayLayoutNeeded() {
        DisplayContent dc = this.getDisplayContent();
        if (dc != null) {
            dc.setLayoutNeeded();
        }
    }

    void applyAdjustForImeIfNeeded() {
        Task task = this.getTask();
        if (task != null && task.mStack != null && task.mStack.isAdjustedForIme()) {
            task.mStack.applyAdjustForImeIfNeeded(task);
        }
    }

    @Override
    void switchUser() {
        super.switchUser();
        if (this.isHiddenFromUserLocked()) {
            this.hideLw(false);
        }
    }

    int getTouchableRegion(Region region, int flags) {
        boolean modal;
        boolean bl = modal = (flags & 0x28) == 0;
        if (modal && this.mAppToken != null) {
            flags |= 0x20;
            Task task = this.getTask();
            if (task != null) {
                task.getDimBounds(this.mTmpRect);
            } else {
                this.getStack().getDimBounds(this.mTmpRect);
            }
            if (this.inFreeformWindowingMode()) {
                DisplayMetrics displayMetrics = this.getDisplayContent().getDisplayMetrics();
                int delta = WindowManagerService.dipToPixel(30, displayMetrics);
                this.mTmpRect.inset(-delta, -delta);
            }
            region.set(this.mTmpRect);
            this.cropRegionToStackBoundsIfNeeded(region);
        } else {
            this.getTouchableRegion(region);
        }
        return flags;
    }

    void checkPolicyVisibilityChange() {
        if (this.mPolicyVisibility != this.mPolicyVisibilityAfterAnim) {
            this.mPolicyVisibility = this.mPolicyVisibilityAfterAnim;
            if (!this.mPolicyVisibility) {
                this.mWinAnimator.hide("checkPolicyVisibilityChange");
                if (this.mService.mCurrentFocus == this) {
                    this.mService.mFocusMayChange = true;
                }
                this.setDisplayLayoutNeeded();
                this.mService.enableScreenIfNeededLocked();
            }
        }
    }

    void setRequestedSize(int requestedWidth, int requestedHeight) {
        if (this.mRequestedWidth != requestedWidth || this.mRequestedHeight != requestedHeight) {
            this.mLayoutNeeded = true;
            this.mRequestedWidth = requestedWidth;
            this.mRequestedHeight = requestedHeight;
        }
    }

    void prepareWindowToDisplayDuringRelayout(boolean wasVisible) {
        boolean canTurnScreenOn;
        boolean hasTurnScreenOnFlag = (this.mAttrs.flags & 0x200000) != 0;
        boolean allowTheaterMode = this.mService.mAllowTheaterModeWakeFromLayout || Settings.Global.getInt(this.mService.mContext.getContentResolver(), "theater_mode_on", 0) == 0;
        boolean bl = canTurnScreenOn = this.mAppToken == null || this.mAppToken.canTurnScreenOn();
        if (hasTurnScreenOnFlag) {
            if (allowTheaterMode && canTurnScreenOn && !this.mPowerManagerWrapper.isInteractive()) {
                this.mPowerManagerWrapper.wakeUp(SystemClock.uptimeMillis(), "android.server.wm:TURN_ON");
            }
            if (this.mAppToken != null) {
                this.mAppToken.setCanTurnScreenOn(false);
            }
        }
        if (wasVisible) {
            return;
        }
        if ((this.mAttrs.softInputMode & 0xF0) == 16) {
            this.mLayoutNeeded = true;
        }
        if (this.isDrawnLw() && this.mToken.okToAnimate()) {
            this.mWinAnimator.applyEnterAnimationLocked();
        }
    }

    void getMergedConfiguration(MergedConfiguration outConfiguration) {
        Configuration globalConfig = this.mService.mRoot.getConfiguration();
        Configuration overrideConfig = this.getMergedOverrideConfiguration();
        outConfiguration.setConfiguration(globalConfig, overrideConfig);
    }

    void setLastReportedMergedConfiguration(MergedConfiguration config) {
        this.mLastReportedConfiguration.setTo(config);
    }

    void getLastReportedMergedConfiguration(MergedConfiguration config) {
        config.setTo(this.mLastReportedConfiguration);
    }

    private Configuration getLastReportedConfiguration() {
        return this.mLastReportedConfiguration.getMergedConfiguration();
    }

    void adjustStartingWindowFlags() {
        if (this.mAttrs.type == 1 && this.mAppToken != null && this.mAppToken.startingWindow != null) {
            int mask = 4718593;
            WindowManager.LayoutParams sa = this.mAppToken.startingWindow.mAttrs;
            sa.flags = sa.flags & 0xFFB7FFFE | this.mAttrs.flags & 0x480001;
        }
    }

    void setWindowScale(int requestedWidth, int requestedHeight) {
        boolean scaledWindow;
        boolean bl = scaledWindow = (this.mAttrs.flags & 0x4000) != 0;
        if (scaledWindow) {
            this.mHScale = this.mAttrs.width != requestedWidth ? (float)this.mAttrs.width / (float)requestedWidth : 1.0f;
            this.mVScale = this.mAttrs.height != requestedHeight ? (float)this.mAttrs.height / (float)requestedHeight : 1.0f;
        } else {
            this.mVScale = 1.0f;
            this.mHScale = 1.0f;
        }
    }

    private boolean shouldKeepVisibleDeadAppWindow() {
        if (!this.isWinVisibleLw() || this.mAppToken == null || this.mAppToken.isClientHidden()) {
            return false;
        }
        if (this.mAttrs.token != this.mClient.asBinder()) {
            return false;
        }
        if (this.mAttrs.type == 3) {
            return false;
        }
        return this.getWindowConfiguration().keepVisibleDeadAppWindowOnScreen();
    }

    boolean canReceiveKeys() {
        return this.isVisibleOrAdding() && this.mViewVisibility == 0 && !this.mRemoveOnExit && (this.mAttrs.flags & 8) == 0 && (this.mAppToken == null || this.mAppToken.windowsAreFocusable()) && !this.canReceiveTouchInput();
    }

    boolean canReceiveTouchInput() {
        return this.mAppToken != null && this.mAppToken.getTask() != null && this.mAppToken.getTask().mStack.shouldIgnoreInput();
    }

    @Override
    public boolean hasDrawnLw() {
        return this.mWinAnimator.mDrawState == 4;
    }

    @Override
    public boolean showLw(boolean doAnimation) {
        return this.showLw(doAnimation, true);
    }

    boolean showLw(boolean doAnimation, boolean requestAnim) {
        if (this.isHiddenFromUserLocked()) {
            return false;
        }
        if (!this.mAppOpVisibility) {
            return false;
        }
        if (this.mPermanentlyHidden) {
            return false;
        }
        if (this.mHiddenWhileSuspended) {
            return false;
        }
        if (this.mForceHideNonSystemOverlayWindow) {
            return false;
        }
        if (this.mPolicyVisibility && this.mPolicyVisibilityAfterAnim) {
            return false;
        }
        if (doAnimation) {
            if (!this.mToken.okToAnimate()) {
                doAnimation = false;
            } else if (this.mPolicyVisibility && !this.mWinAnimator.isAnimationSet()) {
                doAnimation = false;
            }
        }
        this.mPolicyVisibility = true;
        this.mPolicyVisibilityAfterAnim = true;
        if (doAnimation) {
            this.mWinAnimator.applyAnimationLocked(1, true);
        }
        if (requestAnim) {
            this.mService.scheduleAnimationLocked();
        }
        if ((this.mAttrs.flags & 8) == 0) {
            this.mService.updateFocusedWindowLocked(0, false);
        }
        return true;
    }

    @Override
    public boolean hideLw(boolean doAnimation) {
        return this.hideLw(doAnimation, true);
    }

    boolean hideLw(boolean doAnimation, boolean requestAnim) {
        boolean current;
        if (doAnimation && !this.mToken.okToAnimate()) {
            doAnimation = false;
        }
        boolean bl = current = doAnimation ? this.mPolicyVisibilityAfterAnim : this.mPolicyVisibility;
        if (!current) {
            return false;
        }
        if (doAnimation) {
            this.mWinAnimator.applyAnimationLocked(2, false);
            if (!this.mWinAnimator.isAnimationSet()) {
                doAnimation = false;
            }
        }
        this.mPolicyVisibilityAfterAnim = false;
        if (!doAnimation) {
            this.mPolicyVisibility = false;
            this.mService.enableScreenIfNeededLocked();
            if (this.mService.mCurrentFocus == this) {
                this.mService.mFocusMayChange = true;
            }
        }
        if (requestAnim) {
            this.mService.scheduleAnimationLocked();
        }
        if (this.mService.mCurrentFocus == this) {
            this.mService.updateFocusedWindowLocked(0, false);
        }
        return true;
    }

    void setForceHideNonSystemOverlayWindowIfNeeded(boolean forceHide) {
        if (this.mOwnerCanAddInternalSystemWindow || !WindowManager.LayoutParams.isSystemAlertWindowType(this.mAttrs.type) && this.mAttrs.type != 2005) {
            return;
        }
        if (this.mForceHideNonSystemOverlayWindow == forceHide) {
            return;
        }
        this.mForceHideNonSystemOverlayWindow = forceHide;
        if (forceHide) {
            this.hideLw(true, true);
        } else {
            this.showLw(true, true);
        }
    }

    void setHiddenWhileSuspended(boolean hide) {
        if (this.mOwnerCanAddInternalSystemWindow || !WindowManager.LayoutParams.isSystemAlertWindowType(this.mAttrs.type) && this.mAttrs.type != 2005) {
            return;
        }
        if (this.mHiddenWhileSuspended == hide) {
            return;
        }
        this.mHiddenWhileSuspended = hide;
        if (hide) {
            this.hideLw(true, true);
        } else {
            this.showLw(true, true);
        }
    }

    private void setAppOpVisibilityLw(boolean state) {
        if (this.mAppOpVisibility != state) {
            this.mAppOpVisibility = state;
            if (state) {
                this.showLw(true, true);
            } else {
                this.hideLw(true, true);
            }
        }
    }

    void initAppOpsState() {
        if (this.mAppOp == -1 || !this.mAppOpVisibility) {
            return;
        }
        int mode = this.mService.mAppOps.startOpNoThrow(this.mAppOp, this.getOwningUid(), this.getOwningPackage(), true);
        if (mode != 0 && mode != 3) {
            this.setAppOpVisibilityLw(false);
        }
    }

    void resetAppOpsState() {
        if (this.mAppOp != -1 && this.mAppOpVisibility) {
            this.mService.mAppOps.finishOp(this.mAppOp, this.getOwningUid(), this.getOwningPackage());
        }
    }

    void updateAppOpsState() {
        if (this.mAppOp == -1) {
            return;
        }
        int uid = this.getOwningUid();
        String packageName = this.getOwningPackage();
        if (this.mAppOpVisibility) {
            int mode = this.mService.mAppOps.checkOpNoThrow(this.mAppOp, uid, packageName);
            if (mode != 0 && mode != 3) {
                this.mService.mAppOps.finishOp(this.mAppOp, uid, packageName);
                this.setAppOpVisibilityLw(false);
            }
        } else {
            int mode = this.mService.mAppOps.startOpNoThrow(this.mAppOp, uid, packageName, true);
            if (mode == 0 || mode == 3) {
                this.setAppOpVisibilityLw(true);
            }
        }
    }

    public void hidePermanentlyLw() {
        if (!this.mPermanentlyHidden) {
            this.mPermanentlyHidden = true;
            this.hideLw(true, true);
        }
    }

    public void pokeDrawLockLw(long timeout) {
        if (this.isVisibleOrAdding()) {
            if (this.mDrawLock == null) {
                CharSequence tag = this.getWindowTag();
                this.mDrawLock = this.mService.mPowerManager.newWakeLock(128, "Window:" + tag);
                this.mDrawLock.setReferenceCounted(false);
                this.mDrawLock.setWorkSource(new WorkSource(this.mOwnerUid, this.mAttrs.packageName));
            }
            this.mDrawLock.acquire(timeout);
        }
    }

    @Override
    public boolean isAlive() {
        return this.mClient.asBinder().isBinderAlive();
    }

    boolean isClosing() {
        return this.mAnimatingExit || this.mAppToken != null && this.mAppToken.isClosingOrEnteringPip();
    }

    void addWinAnimatorToList(ArrayList<WindowStateAnimator> animators) {
        animators.add(this.mWinAnimator);
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.addWinAnimatorToList(animators);
        }
    }

    @Override
    void sendAppVisibilityToClients() {
        super.sendAppVisibilityToClients();
        boolean clientHidden = this.mAppToken.isClientHidden();
        if (this.mAttrs.type == 3 && clientHidden) {
            return;
        }
        if (clientHidden) {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                WindowState c = (WindowState)this.mChildren.get(i);
                c.mWinAnimator.detachChildren();
            }
            this.mWinAnimator.detachChildren();
        }
        try {
            this.mClient.dispatchAppVisibility(!clientHidden);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void onStartFreezingScreen() {
        this.mAppFreezing = true;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.onStartFreezingScreen();
        }
    }

    boolean onStopFreezingScreen() {
        boolean unfrozeWindows = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            unfrozeWindows |= c.onStopFreezingScreen();
        }
        if (!this.mAppFreezing) {
            return unfrozeWindows;
        }
        this.mAppFreezing = false;
        if (this.mHasSurface && !this.getOrientationChanging() && this.mService.mWindowsFreezingScreen != 2) {
            this.setOrientationChanging(true);
            this.mService.mRoot.mOrientationChangeComplete = false;
        }
        this.mLastFreezeDuration = 0;
        this.setDisplayLayoutNeeded();
        return true;
    }

    boolean destroySurface(boolean cleanupOnResume, boolean appStopped) {
        boolean destroyedSomething = false;
        ArrayList childWindows = new ArrayList(this.mChildren);
        for (int i = childWindows.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)childWindows.get(i);
            destroyedSomething |= c.destroySurface(cleanupOnResume, appStopped);
        }
        if (!(appStopped || this.mWindowRemovalAllowed || cleanupOnResume)) {
            return destroyedSomething;
        }
        if (appStopped || this.mWindowRemovalAllowed) {
            this.mWinAnimator.destroyPreservedSurfaceLocked();
        }
        if (this.mDestroying) {
            if (!cleanupOnResume || this.mRemoveOnExit) {
                this.destroySurfaceUnchecked();
            }
            if (this.mRemoveOnExit) {
                this.removeImmediately();
            }
            if (cleanupOnResume) {
                this.requestUpdateWallpaperIfNeeded();
            }
            this.mDestroying = false;
            destroyedSomething = true;
        }
        return destroyedSomething;
    }

    void destroySurfaceUnchecked() {
        this.mWinAnimator.destroySurfaceLocked();
        this.mAnimatingExit = false;
    }

    @Override
    public boolean isDefaultDisplay() {
        DisplayContent displayContent = this.getDisplayContent();
        if (displayContent == null) {
            return false;
        }
        return displayContent.isDefaultDisplay;
    }

    void setShowToOwnerOnlyLocked(boolean showToOwnerOnly) {
        this.mShowToOwnerOnly = showToOwnerOnly;
    }

    private boolean isHiddenFromUserLocked() {
        WindowState win = this.getTopParentWindow();
        if (win.mAttrs.type < 2000 && win.mAppToken != null && win.mAppToken.mShowForAllUsers && win.mFrame.left <= win.mDisplayFrame.left && win.mFrame.top <= win.mDisplayFrame.top && win.mFrame.right >= win.mStableFrame.right && win.mFrame.bottom >= win.mStableFrame.bottom) {
            return false;
        }
        return win.mShowToOwnerOnly && !this.mService.isCurrentProfileLocked(UserHandle.getUserId(win.mOwnerUid));
    }

    private static void applyInsets(Region outRegion, Rect frame, Rect inset) {
        outRegion.set(frame.left + inset.left, frame.top + inset.top, frame.right - inset.right, frame.bottom - inset.bottom);
    }

    void getTouchableRegion(Region outRegion) {
        Rect frame = this.mFrame;
        switch (this.mTouchableInsets) {
            default: {
                outRegion.set(frame);
                break;
            }
            case 1: {
                WindowState.applyInsets(outRegion, frame, this.mGivenContentInsets);
                break;
            }
            case 2: {
                WindowState.applyInsets(outRegion, frame, this.mGivenVisibleInsets);
                break;
            }
            case 3: {
                outRegion.set(this.mGivenTouchableRegion);
                outRegion.translate(frame.left, frame.top);
            }
        }
        this.cropRegionToStackBoundsIfNeeded(outRegion);
    }

    private void cropRegionToStackBoundsIfNeeded(Region region) {
        Task task = this.getTask();
        if (task == null || !task.cropWindowsToStackBounds()) {
            return;
        }
        TaskStack stack = task.mStack;
        if (stack == null) {
            return;
        }
        stack.getDimBounds(this.mTmpRect);
        region.op(this.mTmpRect, Region.Op.INTERSECT);
    }

    void reportFocusChangedSerialized(boolean focused, boolean inTouchMode) {
        try {
            this.mClient.windowFocusChanged(focused, inTouchMode);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mFocusCallbacks != null) {
            int N = this.mFocusCallbacks.beginBroadcast();
            for (int i = 0; i < N; ++i) {
                IWindowFocusObserver obs = this.mFocusCallbacks.getBroadcastItem(i);
                try {
                    if (focused) {
                        obs.focusGained(this.mWindowId.asBinder());
                        continue;
                    }
                    obs.focusLost(this.mWindowId.asBinder());
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mFocusCallbacks.finishBroadcast();
        }
    }

    @Override
    public Configuration getConfiguration() {
        if (this.mAppToken != null && this.mAppToken.mFrozenMergedConfig.size() > 0) {
            return this.mAppToken.mFrozenMergedConfig.peek();
        }
        return super.getConfiguration();
    }

    void reportResized() {
        Trace.traceBegin(32L, "wm.reportResized_" + this.getWindowTag());
        try {
            final MergedConfiguration mergedConfiguration = new MergedConfiguration(this.mService.mRoot.getConfiguration(), this.getMergedOverrideConfiguration());
            this.setLastReportedMergedConfiguration(mergedConfiguration);
            final Rect frame = this.mFrame;
            final Rect overscanInsets = this.mLastOverscanInsets;
            final Rect contentInsets = this.mLastContentInsets;
            final Rect visibleInsets = this.mLastVisibleInsets;
            final Rect stableInsets = this.mLastStableInsets;
            final Rect outsets = this.mLastOutsets;
            final boolean reportDraw = this.mWinAnimator.mDrawState == 1;
            final boolean reportOrientation = this.mReportOrientationChanged;
            final int displayId = this.getDisplayId();
            final DisplayCutout displayCutout = this.mDisplayCutout.getDisplayCutout();
            if (this.mAttrs.type != 3 && this.mClient instanceof IWindow.Stub) {
                this.mService.mH.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            WindowState.this.dispatchResized(frame, overscanInsets, contentInsets, visibleInsets, stableInsets, outsets, reportDraw, mergedConfiguration, reportOrientation, displayId, displayCutout);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                });
            } else {
                this.dispatchResized(frame, overscanInsets, contentInsets, visibleInsets, stableInsets, outsets, reportDraw, mergedConfiguration, reportOrientation, displayId, displayCutout);
            }
            if (this.mService.mAccessibilityController != null && this.getDisplayId() == 0) {
                this.mService.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
            }
            this.mOverscanInsetsChanged = false;
            this.mContentInsetsChanged = false;
            this.mVisibleInsetsChanged = false;
            this.mStableInsetsChanged = false;
            this.mOutsetsChanged = false;
            this.mFrameSizeChanged = false;
            this.mDisplayCutoutChanged = false;
            this.mWinAnimator.mSurfaceResized = false;
            this.mReportOrientationChanged = false;
        }
        catch (RemoteException e) {
            this.setOrientationChanging(false);
            this.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mService.mDisplayFreezeTime);
            Slog.w(TAG, "Failed to report 'resized' to the client of " + this + ", removing this window.");
            this.mService.mPendingRemove.add(this);
            this.mService.mWindowPlacerLocked.requestTraversal();
        }
        Trace.traceEnd(32L);
    }

    Rect getBackdropFrame(Rect frame) {
        boolean resizing;
        boolean bl = resizing = this.isDragResizing() || this.isDragResizeChanged();
        if (this.getWindowConfiguration().useWindowFrameForBackdrop() || !resizing) {
            return frame;
        }
        DisplayInfo displayInfo = this.getDisplayInfo();
        this.mTmpRect.set(0, 0, displayInfo.logicalWidth, displayInfo.logicalHeight);
        return this.mTmpRect;
    }

    private int getStackId() {
        TaskStack stack = this.getStack();
        if (stack == null) {
            return -1;
        }
        return stack.mStackId;
    }

    private void dispatchResized(Rect frame, Rect overscanInsets, Rect contentInsets, Rect visibleInsets, Rect stableInsets, Rect outsets, boolean reportDraw, MergedConfiguration mergedConfiguration, boolean reportOrientation, int displayId, DisplayCutout displayCutout) throws RemoteException {
        boolean forceRelayout = this.isDragResizeChanged() || reportOrientation;
        this.mClient.resized(frame, overscanInsets, contentInsets, visibleInsets, stableInsets, outsets, reportDraw, mergedConfiguration, this.getBackdropFrame(frame), forceRelayout, this.mPolicy.isNavBarForcedShownLw(this), displayId, new DisplayCutout.ParcelableWrapper(displayCutout));
        this.mDragResizingChangeReported = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFocusObserver(IWindowFocusObserver observer) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mFocusCallbacks == null) {
                    this.mFocusCallbacks = new RemoteCallbackList();
                }
                this.mFocusCallbacks.register(observer);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFocusObserver(IWindowFocusObserver observer) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mFocusCallbacks != null) {
                    this.mFocusCallbacks.unregister(observer);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFocused() {
        boolean bl;
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                bl = this.mService.mCurrentFocus == this;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    @Override
    public boolean isInMultiWindowMode() {
        Task task = this.getTask();
        return task != null && !task.isFullscreen();
    }

    private boolean inFullscreenContainer() {
        return this.mAppToken == null || this.mAppToken.matchParentBounds() && !this.isInMultiWindowMode();
    }

    boolean isLetterboxedAppWindow() {
        return !this.isInMultiWindowMode() && this.mAppToken != null && !this.mAppToken.matchParentBounds() || this.isLetterboxedForDisplayCutoutLw();
    }

    @Override
    public boolean isLetterboxedForDisplayCutoutLw() {
        if (this.mAppToken == null) {
            return false;
        }
        if (!this.mParentFrameWasClippedByDisplayCutout) {
            return false;
        }
        if (this.mAttrs.layoutInDisplayCutoutMode == 1) {
            return false;
        }
        if (!this.mAttrs.isFullscreen()) {
            return false;
        }
        return !this.frameCoversEntireAppTokenBounds();
    }

    private boolean frameCoversEntireAppTokenBounds() {
        this.mTmpRect.set(this.mAppToken.getBounds());
        this.mTmpRect.intersectUnchecked(this.mFrame);
        return this.mAppToken.getBounds().equals(this.mTmpRect);
    }

    @Override
    public boolean isLetterboxedOverlappingWith(Rect rect) {
        return this.mAppToken != null && this.mAppToken.isLetterboxOverlappingWith(rect);
    }

    boolean isDragResizeChanged() {
        return this.mDragResizing != this.computeDragResizing();
    }

    @Override
    void setWaitingForDrawnIfResizingChanged() {
        if (this.isDragResizeChanged()) {
            this.mService.mWaitingForDrawn.add(this);
        }
        super.setWaitingForDrawnIfResizingChanged();
    }

    private boolean isDragResizingChangeReported() {
        return this.mDragResizingChangeReported;
    }

    @Override
    void resetDragResizingChangeReported() {
        this.mDragResizingChangeReported = false;
        super.resetDragResizingChangeReported();
    }

    int getResizeMode() {
        return this.mResizeMode;
    }

    private boolean computeDragResizing() {
        Task task = this.getTask();
        if (task == null) {
            return false;
        }
        if (!this.inSplitScreenWindowingMode() && !this.inFreeformWindowingMode()) {
            return false;
        }
        if (this.mAttrs.width != -1 || this.mAttrs.height != -1) {
            return false;
        }
        if (task.isDragResizing()) {
            return true;
        }
        return (this.getDisplayContent().mDividerControllerLocked.isResizing() || this.mAppToken != null && !this.mAppToken.mFrozenBounds.isEmpty()) && !task.inFreeformWindowingMode() && !this.isGoneForLayoutLw();
    }

    void setDragResizing() {
        boolean resizing = this.computeDragResizing();
        if (resizing == this.mDragResizing) {
            return;
        }
        this.mDragResizing = resizing;
        Task task = this.getTask();
        this.mResizeMode = task != null && task.isDragResizing() ? task.getDragResizeMode() : (this.mDragResizing && this.getDisplayContent().mDividerControllerLocked.isResizing() ? 1 : 0);
    }

    boolean isDragResizing() {
        return this.mDragResizing;
    }

    boolean isDockedResizing() {
        return this.mDragResizing && this.getResizeMode() == 1 || this.isChildWindow() && this.getParentWindow().isDockedResizing();
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, boolean trim) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, trim);
        this.writeIdentifierToProto(proto, 1146756268034L);
        proto.write(1120986464259L, this.getDisplayId());
        proto.write(1120986464260L, this.getStackId());
        this.mAttrs.writeToProto(proto, 1146756268037L);
        this.mGivenContentInsets.writeToProto(proto, 1146756268038L);
        this.mFrame.writeToProto(proto, 1146756268039L);
        this.mContainingFrame.writeToProto(proto, 1146756268040L);
        this.mParentFrame.writeToProto(proto, 1146756268041L);
        this.mContentFrame.writeToProto(proto, 1146756268042L);
        this.mContentInsets.writeToProto(proto, 0x10B0000000BL);
        this.mAttrs.surfaceInsets.writeToProto(proto, 1146756268044L);
        this.mSurfacePosition.writeToProto(proto, 0x10B00000010L);
        this.mWinAnimator.writeToProto(proto, 1146756268045L);
        proto.write(1133871366158L, this.mAnimatingExit);
        for (int i = 0; i < this.mChildren.size(); ++i) {
            ((WindowState)this.mChildren.get(i)).writeToProto(proto, 2246267895823L, trim);
        }
        proto.write(1120986464274L, this.mRequestedWidth);
        proto.write(1120986464275L, this.mRequestedHeight);
        proto.write(1120986464276L, this.mViewVisibility);
        proto.write(0x10500000015L, this.mSystemUiVisibility);
        proto.write(1133871366166L, this.mHasSurface);
        proto.write(1133871366167L, this.isReadyForDisplay());
        this.mDisplayFrame.writeToProto(proto, 1146756268056L);
        this.mOverscanFrame.writeToProto(proto, 1146756268057L);
        this.mVisibleFrame.writeToProto(proto, 1146756268058L);
        this.mDecorFrame.writeToProto(proto, 0x10B0000001BL);
        this.mOutsetFrame.writeToProto(proto, 1146756268060L);
        this.mOverscanInsets.writeToProto(proto, 1146756268061L);
        this.mVisibleInsets.writeToProto(proto, 1146756268062L);
        this.mStableInsets.writeToProto(proto, 1146756268063L);
        this.mOutsets.writeToProto(proto, 1146756268064L);
        this.mDisplayCutout.getDisplayCutout().writeToProto(proto, 1146756268065L);
        proto.write(1133871366178L, this.mRemoveOnExit);
        proto.write(1133871366179L, this.mDestroying);
        proto.write(1133871366180L, this.mRemoved);
        proto.write(1133871366181L, this.isOnScreen());
        proto.write(1133871366182L, this.isVisible());
        if (this.mForceSeamlesslyRotate) {
            proto.write(1133871366183L, this.mPendingForcedSeamlessRotate != null);
            proto.write(1112396529704L, this.mFinishForcedSeamlessRotateFrameNumber);
        }
        proto.end(token);
    }

    @Override
    public void writeIdentifierToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, System.identityHashCode(this));
        proto.write(1120986464258L, UserHandle.getUserId(this.mOwnerUid));
        CharSequence title = this.getWindowTag();
        if (title != null) {
            proto.write(1138166333443L, title.toString());
        }
        proto.end(token);
    }

    @Override
    void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        TaskStack stack = this.getStack();
        pw.print(prefix);
        pw.print("mDisplayId=");
        pw.print(this.getDisplayId());
        if (stack != null) {
            pw.print(" stackId=");
            pw.print(stack.mStackId);
        }
        pw.print(" mSession=");
        pw.print(this.mSession);
        pw.print(" mClient=");
        pw.println(this.mClient.asBinder());
        pw.print(prefix);
        pw.print("mOwnerUid=");
        pw.print(this.mOwnerUid);
        pw.print(" mShowToOwnerOnly=");
        pw.print(this.mShowToOwnerOnly);
        pw.print(" package=");
        pw.print(this.mAttrs.packageName);
        pw.print(" appop=");
        pw.println(AppOpsManager.opToName(this.mAppOp));
        pw.print(prefix);
        pw.print("mAttrs=");
        pw.println(this.mAttrs.toString(prefix));
        pw.print(prefix);
        pw.print("Requested w=");
        pw.print(this.mRequestedWidth);
        pw.print(" h=");
        pw.print(this.mRequestedHeight);
        pw.print(" mLayoutSeq=");
        pw.println(this.mLayoutSeq);
        if (this.mRequestedWidth != this.mLastRequestedWidth || this.mRequestedHeight != this.mLastRequestedHeight) {
            pw.print(prefix);
            pw.print("LastRequested w=");
            pw.print(this.mLastRequestedWidth);
            pw.print(" h=");
            pw.println(this.mLastRequestedHeight);
        }
        if (this.mIsChildWindow || this.mLayoutAttached) {
            pw.print(prefix);
            pw.print("mParentWindow=");
            pw.print(this.getParentWindow());
            pw.print(" mLayoutAttached=");
            pw.println(this.mLayoutAttached);
        }
        if (this.mIsImWindow || this.mIsWallpaper || this.mIsFloatingLayer) {
            pw.print(prefix);
            pw.print("mIsImWindow=");
            pw.print(this.mIsImWindow);
            pw.print(" mIsWallpaper=");
            pw.print(this.mIsWallpaper);
            pw.print(" mIsFloatingLayer=");
            pw.print(this.mIsFloatingLayer);
            pw.print(" mWallpaperVisible=");
            pw.println(this.mWallpaperVisible);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mBaseLayer=");
            pw.print(this.mBaseLayer);
            pw.print(" mSubLayer=");
            pw.print(this.mSubLayer);
            pw.print(" mAnimLayer=");
            pw.print(this.mLayer);
            pw.print("+");
            pw.print("=");
            pw.print(this.mWinAnimator.mAnimLayer);
            pw.print(" mLastLayer=");
            pw.println(this.mWinAnimator.mLastLayer);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mToken=");
            pw.println(this.mToken);
            if (this.mAppToken != null) {
                pw.print(prefix);
                pw.print("mAppToken=");
                pw.println(this.mAppToken);
                pw.print(prefix);
                pw.print(" isAnimatingWithSavedSurface()=");
                pw.print(" mAppDied=");
                pw.print(this.mAppDied);
                pw.print(prefix);
                pw.print("drawnStateEvaluated=");
                pw.print(this.getDrawnStateEvaluated());
                pw.print(prefix);
                pw.print("mightAffectAllDrawn=");
                pw.println(this.mightAffectAllDrawn());
            }
            pw.print(prefix);
            pw.print("mViewVisibility=0x");
            pw.print(Integer.toHexString(this.mViewVisibility));
            pw.print(" mHaveFrame=");
            pw.print(this.mHaveFrame);
            pw.print(" mObscured=");
            pw.println(this.mObscured);
            pw.print(prefix);
            pw.print("mSeq=");
            pw.print(this.mSeq);
            pw.print(" mSystemUiVisibility=0x");
            pw.println(Integer.toHexString(this.mSystemUiVisibility));
        }
        if (!this.mPolicyVisibility || !this.mPolicyVisibilityAfterAnim || !this.mAppOpVisibility || this.isParentWindowHidden() || this.mPermanentlyHidden || this.mForceHideNonSystemOverlayWindow || this.mHiddenWhileSuspended) {
            pw.print(prefix);
            pw.print("mPolicyVisibility=");
            pw.print(this.mPolicyVisibility);
            pw.print(" mPolicyVisibilityAfterAnim=");
            pw.print(this.mPolicyVisibilityAfterAnim);
            pw.print(" mAppOpVisibility=");
            pw.print(this.mAppOpVisibility);
            pw.print(" parentHidden=");
            pw.print(this.isParentWindowHidden());
            pw.print(" mPermanentlyHidden=");
            pw.print(this.mPermanentlyHidden);
            pw.print(" mHiddenWhileSuspended=");
            pw.print(this.mHiddenWhileSuspended);
            pw.print(" mForceHideNonSystemOverlayWindow=");
            pw.println(this.mForceHideNonSystemOverlayWindow);
        }
        if (!this.mRelayoutCalled || this.mLayoutNeeded) {
            pw.print(prefix);
            pw.print("mRelayoutCalled=");
            pw.print(this.mRelayoutCalled);
            pw.print(" mLayoutNeeded=");
            pw.println(this.mLayoutNeeded);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mGivenContentInsets=");
            this.mGivenContentInsets.printShortString(pw);
            pw.print(" mGivenVisibleInsets=");
            this.mGivenVisibleInsets.printShortString(pw);
            pw.println();
            if (this.mTouchableInsets != 0 || this.mGivenInsetsPending) {
                pw.print(prefix);
                pw.print("mTouchableInsets=");
                pw.print(this.mTouchableInsets);
                pw.print(" mGivenInsetsPending=");
                pw.println(this.mGivenInsetsPending);
                Region region = new Region();
                this.getTouchableRegion(region);
                pw.print(prefix);
                pw.print("touchable region=");
                pw.println(region);
            }
            pw.print(prefix);
            pw.print("mFullConfiguration=");
            pw.println(this.getConfiguration());
            pw.print(prefix);
            pw.print("mLastReportedConfiguration=");
            pw.println(this.getLastReportedConfiguration());
        }
        pw.print(prefix);
        pw.print("mHasSurface=");
        pw.print(this.mHasSurface);
        pw.print(" isReadyForDisplay()=");
        pw.print(this.isReadyForDisplay());
        pw.print(" mWindowRemovalAllowed=");
        pw.println(this.mWindowRemovalAllowed);
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mFrame=");
            this.mFrame.printShortString(pw);
            pw.print(" last=");
            this.mLastFrame.printShortString(pw);
            pw.println();
        }
        if (this.mEnforceSizeCompat) {
            pw.print(prefix);
            pw.print("mCompatFrame=");
            this.mCompatFrame.printShortString(pw);
            pw.println();
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("Frames: containing=");
            this.mContainingFrame.printShortString(pw);
            pw.print(" parent=");
            this.mParentFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("    display=");
            this.mDisplayFrame.printShortString(pw);
            pw.print(" overscan=");
            this.mOverscanFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("    content=");
            this.mContentFrame.printShortString(pw);
            pw.print(" visible=");
            this.mVisibleFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("    decor=");
            this.mDecorFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("    outset=");
            this.mOutsetFrame.printShortString(pw);
            pw.println();
            pw.print(prefix);
            pw.print("Cur insets: overscan=");
            this.mOverscanInsets.printShortString(pw);
            pw.print(" content=");
            this.mContentInsets.printShortString(pw);
            pw.print(" visible=");
            this.mVisibleInsets.printShortString(pw);
            pw.print(" stable=");
            this.mStableInsets.printShortString(pw);
            pw.print(" surface=");
            this.mAttrs.surfaceInsets.printShortString(pw);
            pw.print(" outsets=");
            this.mOutsets.printShortString(pw);
            pw.print(" cutout=" + this.mDisplayCutout.getDisplayCutout());
            pw.println();
            pw.print(prefix);
            pw.print("Lst insets: overscan=");
            this.mLastOverscanInsets.printShortString(pw);
            pw.print(" content=");
            this.mLastContentInsets.printShortString(pw);
            pw.print(" visible=");
            this.mLastVisibleInsets.printShortString(pw);
            pw.print(" stable=");
            this.mLastStableInsets.printShortString(pw);
            pw.print(" physical=");
            this.mLastOutsets.printShortString(pw);
            pw.print(" outset=");
            this.mLastOutsets.printShortString(pw);
            pw.print(" cutout=" + this.mLastDisplayCutout);
            pw.println();
        }
        super.dump(pw, prefix, dumpAll);
        pw.print(prefix);
        pw.print(this.mWinAnimator);
        pw.println(":");
        this.mWinAnimator.dump(pw, prefix + "  ", dumpAll);
        if (this.mAnimatingExit || this.mRemoveOnExit || this.mDestroying || this.mRemoved) {
            pw.print(prefix);
            pw.print("mAnimatingExit=");
            pw.print(this.mAnimatingExit);
            pw.print(" mRemoveOnExit=");
            pw.print(this.mRemoveOnExit);
            pw.print(" mDestroying=");
            pw.print(this.mDestroying);
            pw.print(" mRemoved=");
            pw.println(this.mRemoved);
        }
        if (this.getOrientationChanging() || this.mAppFreezing || this.mReportOrientationChanged) {
            pw.print(prefix);
            pw.print("mOrientationChanging=");
            pw.print(this.mOrientationChanging);
            pw.print(" configOrientationChanging=");
            pw.print(this.getLastReportedConfiguration().orientation != this.getConfiguration().orientation);
            pw.print(" mAppFreezing=");
            pw.print(this.mAppFreezing);
            pw.print(" mReportOrientationChanged=");
            pw.println(this.mReportOrientationChanged);
        }
        if (this.mLastFreezeDuration != 0) {
            pw.print(prefix);
            pw.print("mLastFreezeDuration=");
            TimeUtils.formatDuration((long)this.mLastFreezeDuration, pw);
            pw.println();
        }
        if (this.mForceSeamlesslyRotate) {
            pw.print(prefix);
            pw.print("forceSeamlesslyRotate: pending=");
            if (this.mPendingForcedSeamlessRotate != null) {
                this.mPendingForcedSeamlessRotate.dump(pw);
            } else {
                pw.print("null");
            }
            pw.print(" finishedFrameNumber=");
            pw.print(this.mFinishForcedSeamlessRotateFrameNumber);
            pw.println();
        }
        if (this.mHScale != 1.0f || this.mVScale != 1.0f) {
            pw.print(prefix);
            pw.print("mHScale=");
            pw.print(this.mHScale);
            pw.print(" mVScale=");
            pw.println(this.mVScale);
        }
        if (this.mWallpaperX != -1.0f || this.mWallpaperY != -1.0f) {
            pw.print(prefix);
            pw.print("mWallpaperX=");
            pw.print(this.mWallpaperX);
            pw.print(" mWallpaperY=");
            pw.println(this.mWallpaperY);
        }
        if (this.mWallpaperXStep != -1.0f || this.mWallpaperYStep != -1.0f) {
            pw.print(prefix);
            pw.print("mWallpaperXStep=");
            pw.print(this.mWallpaperXStep);
            pw.print(" mWallpaperYStep=");
            pw.println(this.mWallpaperYStep);
        }
        if (this.mWallpaperDisplayOffsetX != Integer.MIN_VALUE || this.mWallpaperDisplayOffsetY != Integer.MIN_VALUE) {
            pw.print(prefix);
            pw.print("mWallpaperDisplayOffsetX=");
            pw.print(this.mWallpaperDisplayOffsetX);
            pw.print(" mWallpaperDisplayOffsetY=");
            pw.println(this.mWallpaperDisplayOffsetY);
        }
        if (this.mDrawLock != null) {
            pw.print(prefix);
            pw.println("mDrawLock=" + this.mDrawLock);
        }
        if (this.isDragResizing()) {
            pw.print(prefix);
            pw.println("isDragResizing=" + this.isDragResizing());
        }
        if (this.computeDragResizing()) {
            pw.print(prefix);
            pw.println("computeDragResizing=" + this.computeDragResizing());
        }
        pw.print(prefix);
        pw.println("isOnScreen=" + this.isOnScreen());
        pw.print(prefix);
        pw.println("isVisible=" + this.isVisible());
    }

    @Override
    String getName() {
        return Integer.toHexString(System.identityHashCode(this)) + " " + this.getWindowTag();
    }

    CharSequence getWindowTag() {
        CharSequence tag = this.mAttrs.getTitle();
        if (tag == null || tag.length() <= 0) {
            tag = this.mAttrs.packageName;
        }
        return tag;
    }

    public String toString() {
        CharSequence title = this.getWindowTag();
        if (this.mStringNameCache == null || this.mLastTitle != title || this.mWasExiting != this.mAnimatingExit) {
            this.mLastTitle = title;
            this.mWasExiting = this.mAnimatingExit;
            this.mStringNameCache = "Window{" + Integer.toHexString(System.identityHashCode(this)) + " u" + UserHandle.getUserId(this.mOwnerUid) + " " + this.mLastTitle + (this.mAnimatingExit ? " EXITING}" : "}");
        }
        return this.mStringNameCache;
    }

    void transformClipRectFromScreenToSurfaceSpace(Rect clipRect) {
        if (this.mHScale >= 0.0f) {
            clipRect.left = (int)((float)clipRect.left / this.mHScale);
            clipRect.right = (int)Math.ceil((float)clipRect.right / this.mHScale);
        }
        if (this.mVScale >= 0.0f) {
            clipRect.top = (int)((float)clipRect.top / this.mVScale);
            clipRect.bottom = (int)Math.ceil((float)clipRect.bottom / this.mVScale);
        }
    }

    void applyGravityAndUpdateFrame(Rect containingFrame, Rect displayFrame) {
        float y;
        float x;
        int h;
        int w;
        boolean fitToDisplay;
        int pw = containingFrame.width();
        int ph = containingFrame.height();
        Task task = this.getTask();
        boolean inNonFullscreenContainer = !this.inFullscreenContainer();
        boolean noLimits = (this.mAttrs.flags & 0x200) != 0;
        boolean bl = fitToDisplay = task == null || !inNonFullscreenContainer || this.mAttrs.type != 1 && !noLimits;
        if ((this.mAttrs.flags & 0x4000) != 0) {
            w = this.mAttrs.width < 0 ? pw : (this.mEnforceSizeCompat ? (int)((float)this.mAttrs.width * this.mGlobalScale + 0.5f) : this.mAttrs.width);
            h = this.mAttrs.height < 0 ? ph : (this.mEnforceSizeCompat ? (int)((float)this.mAttrs.height * this.mGlobalScale + 0.5f) : this.mAttrs.height);
        } else {
            w = this.mAttrs.width == -1 ? pw : (this.mEnforceSizeCompat ? (int)((float)this.mRequestedWidth * this.mGlobalScale + 0.5f) : this.mRequestedWidth);
            h = this.mAttrs.height == -1 ? ph : (this.mEnforceSizeCompat ? (int)((float)this.mRequestedHeight * this.mGlobalScale + 0.5f) : this.mRequestedHeight);
        }
        if (this.mEnforceSizeCompat) {
            x = (float)this.mAttrs.x * this.mGlobalScale;
            y = (float)this.mAttrs.y * this.mGlobalScale;
        } else {
            x = this.mAttrs.x;
            y = this.mAttrs.y;
        }
        if (inNonFullscreenContainer && !this.layoutInParentFrame()) {
            w = Math.min(w, pw);
            h = Math.min(h, ph);
        }
        Gravity.apply(this.mAttrs.gravity, w, h, containingFrame, (int)(x + this.mAttrs.horizontalMargin * (float)pw), (int)(y + this.mAttrs.verticalMargin * (float)ph), this.mFrame);
        if (fitToDisplay) {
            Gravity.applyDisplay(this.mAttrs.gravity, displayFrame, this.mFrame);
        }
        this.mCompatFrame.set(this.mFrame);
        if (this.mEnforceSizeCompat) {
            this.mCompatFrame.scale(this.mInvGlobalScale);
        }
    }

    boolean isChildWindow() {
        return this.mIsChildWindow;
    }

    boolean layoutInParentFrame() {
        return this.mIsChildWindow && (this.mAttrs.privateFlags & 0x10000) != 0;
    }

    boolean hideNonSystemOverlayWindowsWhenVisible() {
        return (this.mAttrs.privateFlags & 0x80000) != 0 && this.mSession.mCanHideNonSystemOverlayWindows;
    }

    WindowState getParentWindow() {
        return this.mIsChildWindow ? (WindowState)super.getParent() : null;
    }

    WindowState getTopParentWindow() {
        WindowState current;
        WindowState topParent = current = this;
        while (current != null && current.mIsChildWindow) {
            if ((current = current.getParentWindow()) == null) continue;
            topParent = current;
        }
        return topParent;
    }

    boolean isParentWindowHidden() {
        WindowState parent = this.getParentWindow();
        return parent != null && parent.mHidden;
    }

    void setWillReplaceWindow(boolean animate) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.setWillReplaceWindow(animate);
        }
        if ((this.mAttrs.privateFlags & 0x8000) != 0 || this.mAttrs.type == 3) {
            return;
        }
        this.mWillReplaceWindow = true;
        this.mReplacementWindow = null;
        this.mAnimateReplacingWindow = animate;
    }

    void clearWillReplaceWindow() {
        this.mWillReplaceWindow = false;
        this.mReplacementWindow = null;
        this.mAnimateReplacingWindow = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.clearWillReplaceWindow();
        }
    }

    boolean waitingForReplacement() {
        if (this.mWillReplaceWindow) {
            return true;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            if (!c.waitingForReplacement()) continue;
            return true;
        }
        return false;
    }

    void requestUpdateWallpaperIfNeeded() {
        DisplayContent dc = this.getDisplayContent();
        if (dc != null && (this.mAttrs.flags & 0x100000) != 0) {
            dc.pendingLayoutChanges |= 4;
            dc.setLayoutNeeded();
            this.mService.mWindowPlacerLocked.requestTraversal();
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.requestUpdateWallpaperIfNeeded();
        }
    }

    float translateToWindowX(float x) {
        float winX = x - (float)this.mFrame.left;
        if (this.mEnforceSizeCompat) {
            winX *= this.mGlobalScale;
        }
        return winX;
    }

    float translateToWindowY(float y) {
        float winY = y - (float)this.mFrame.top;
        if (this.mEnforceSizeCompat) {
            winY *= this.mGlobalScale;
        }
        return winY;
    }

    boolean shouldBeReplacedWithChildren() {
        return this.mIsChildWindow || this.mAttrs.type == 2 || this.mAttrs.type == 4;
    }

    void setWillReplaceChildWindows() {
        if (this.shouldBeReplacedWithChildren()) {
            this.setWillReplaceWindow(false);
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.setWillReplaceChildWindows();
        }
    }

    WindowState getReplacingWindow() {
        if (this.mAnimatingExit && this.mWillReplaceWindow && this.mAnimateReplacingWindow) {
            return this;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            WindowState replacing = c.getReplacingWindow();
            if (replacing == null) continue;
            return replacing;
        }
        return null;
    }

    @Override
    public int getRotationAnimationHint() {
        if (this.mAppToken != null) {
            return this.mAppToken.mRotationAnimationHint;
        }
        return -1;
    }

    @Override
    public boolean isInputMethodWindow() {
        return this.mIsImWindow;
    }

    boolean performShowLocked() {
        if (this.isHiddenFromUserLocked()) {
            this.hideLw(false);
            return false;
        }
        this.logPerformShow("performShow on ");
        int drawState = this.mWinAnimator.mDrawState;
        if ((drawState == 4 || drawState == 3) && this.mAttrs.type != 3 && this.mAppToken != null) {
            this.mAppToken.onFirstWindowDrawn(this, this.mWinAnimator);
        }
        if (this.mWinAnimator.mDrawState != 3 || !this.isReadyForDisplay()) {
            return false;
        }
        this.logPerformShow("Showing ");
        this.mService.enableScreenIfNeededLocked();
        this.mWinAnimator.applyEnterAnimationLocked();
        this.mWinAnimator.mLastAlpha = -1.0f;
        this.mWinAnimator.mDrawState = 4;
        this.mService.scheduleAnimationLocked();
        if (this.mHidden) {
            this.mHidden = false;
            DisplayContent displayContent = this.getDisplayContent();
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                WindowState c = (WindowState)this.mChildren.get(i);
                if (c.mWinAnimator.mSurfaceController == null) continue;
                c.performShowLocked();
                if (displayContent == null) continue;
                displayContent.setLayoutNeeded();
            }
        }
        if (this.mAttrs.type == 2011) {
            this.getDisplayContent().mDividerControllerLocked.resetImeHideRequested();
        }
        return true;
    }

    private void logPerformShow(String prefix) {
    }

    WindowInfo getWindowInfo() {
        int childCount;
        boolean isAccessibilityOverlay;
        WindowInfo windowInfo = WindowInfo.obtain();
        windowInfo.type = this.mAttrs.type;
        windowInfo.layer = this.mLayer;
        windowInfo.token = this.mClient.asBinder();
        if (this.mAppToken != null) {
            windowInfo.activityToken = this.mAppToken.appToken.asBinder();
        }
        windowInfo.title = this.mAttrs.accessibilityTitle;
        boolean isPanelWindow = this.mAttrs.type >= 1000 && this.mAttrs.type <= 1999;
        boolean bl = isAccessibilityOverlay = windowInfo.type == 2032;
        if (TextUtils.isEmpty(windowInfo.title) && (isPanelWindow || isAccessibilityOverlay)) {
            windowInfo.title = this.mAttrs.getTitle();
        }
        windowInfo.accessibilityIdOfAnchor = this.mAttrs.accessibilityIdOfAnchor;
        windowInfo.focused = this.isFocused();
        Task task = this.getTask();
        boolean bl2 = windowInfo.inPictureInPicture = task != null && task.inPinnedWindowingMode();
        if (this.mIsChildWindow) {
            windowInfo.parentToken = this.getParentWindow().mClient.asBinder();
        }
        if ((childCount = this.mChildren.size()) > 0) {
            if (windowInfo.childTokens == null) {
                windowInfo.childTokens = new ArrayList<IBinder>(childCount);
            }
            for (int j = 0; j < childCount; ++j) {
                WindowState child = (WindowState)this.mChildren.get(j);
                windowInfo.childTokens.add(child.mClient.asBinder());
            }
        }
        return windowInfo;
    }

    int getHighestAnimLayer() {
        int highest = this.mWinAnimator.mAnimLayer;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            int childLayer = c.getHighestAnimLayer();
            if (childLayer <= highest) continue;
            highest = childLayer;
        }
        return highest;
    }

    @Override
    boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        if (this.mChildren.isEmpty()) {
            return this.applyInOrderWithImeWindows(callback, traverseTopToBottom);
        }
        if (traverseTopToBottom) {
            return this.forAllWindowTopToBottom(callback);
        }
        return this.forAllWindowBottomToTop(callback);
    }

    private boolean forAllWindowBottomToTop(ToBooleanFunction<WindowState> callback) {
        int i = 0;
        int count = this.mChildren.size();
        WindowState child = (WindowState)this.mChildren.get(i);
        while (i < count && child.mSubLayer < 0) {
            if (child.applyInOrderWithImeWindows(callback, false)) {
                return true;
            }
            if (++i >= count) break;
            child = (WindowState)this.mChildren.get(i);
        }
        if (this.applyInOrderWithImeWindows(callback, false)) {
            return true;
        }
        while (i < count) {
            if (child.applyInOrderWithImeWindows(callback, false)) {
                return true;
            }
            if (++i >= count) break;
            child = (WindowState)this.mChildren.get(i);
        }
        return false;
    }

    private boolean forAllWindowTopToBottom(ToBooleanFunction<WindowState> callback) {
        int i = this.mChildren.size() - 1;
        WindowState child = (WindowState)this.mChildren.get(i);
        while (i >= 0 && child.mSubLayer >= 0) {
            if (child.applyInOrderWithImeWindows(callback, true)) {
                return true;
            }
            if (--i < 0) break;
            child = (WindowState)this.mChildren.get(i);
        }
        if (this.applyInOrderWithImeWindows(callback, true)) {
            return true;
        }
        while (i >= 0) {
            if (child.applyInOrderWithImeWindows(callback, true)) {
                return true;
            }
            if (--i < 0) break;
            child = (WindowState)this.mChildren.get(i);
        }
        return false;
    }

    private boolean applyImeWindowsIfNeeded(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        return this.isInputMethodTarget() && !this.inSplitScreenWindowingMode() && this.getDisplayContent().forAllImeWindows(callback, traverseTopToBottom);
    }

    private boolean applyInOrderWithImeWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        return traverseTopToBottom ? this.applyImeWindowsIfNeeded(callback, traverseTopToBottom) || callback.apply(this) : callback.apply(this) || this.applyImeWindowsIfNeeded(callback, traverseTopToBottom);
    }

    @Override
    WindowState getWindow(Predicate<WindowState> callback) {
        if (this.mChildren.isEmpty()) {
            return callback.test(this) ? this : null;
        }
        int i = this.mChildren.size() - 1;
        WindowState child = (WindowState)this.mChildren.get(i);
        while (i >= 0 && child.mSubLayer >= 0) {
            if (callback.test(child)) {
                return child;
            }
            if (--i < 0) break;
            child = (WindowState)this.mChildren.get(i);
        }
        if (callback.test(this)) {
            return this;
        }
        while (i >= 0) {
            if (callback.test(child)) {
                return child;
            }
            if (--i < 0) break;
            child = (WindowState)this.mChildren.get(i);
        }
        return null;
    }

    @VisibleForTesting
    boolean isSelfOrAncestorWindowAnimatingExit() {
        WindowState window = this;
        do {
            if (!window.mAnimatingExit) continue;
            return true;
        } while ((window = window.getParentWindow()) != null);
        return false;
    }

    void onExitAnimationDone() {
        if (!this.mChildren.isEmpty()) {
            ArrayList childWindows = new ArrayList(this.mChildren);
            for (int i = childWindows.size() - 1; i >= 0; --i) {
                ((WindowState)childWindows.get(i)).onExitAnimationDone();
            }
        }
        if (this.mWinAnimator.mEnteringAnimation) {
            this.mWinAnimator.mEnteringAnimation = false;
            this.mService.requestTraversal();
            if (this.mAppToken == null) {
                try {
                    this.mClient.dispatchWindowShown();
                }
                catch (RemoteException childWindows) {
                    // empty catch block
                }
            }
        }
        if (this.isSelfAnimating()) {
            return;
        }
        if (this.mService.mAccessibilityController != null && this.getDisplayId() == 0) {
            this.mService.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
        }
        if (!this.isSelfOrAncestorWindowAnimatingExit()) {
            return;
        }
        this.mDestroying = true;
        boolean hasSurface = this.mWinAnimator.hasSurface();
        this.mWinAnimator.hide(this.getPendingTransaction(), "onExitAnimationDone");
        if (this.mAppToken != null) {
            this.mAppToken.destroySurfaces();
        } else {
            if (hasSurface) {
                this.mService.mDestroySurface.add(this);
            }
            if (this.mRemoveOnExit) {
                this.mService.mPendingRemove.add(this);
                this.mRemoveOnExit = false;
            }
        }
        this.mAnimatingExit = false;
        this.getDisplayContent().mWallpaperController.hideWallpapers(this);
    }

    boolean clearAnimatingFlags() {
        boolean didSomething = false;
        if (!this.mWillReplaceWindow && !this.mRemoveOnExit) {
            if (this.mAnimatingExit) {
                this.mAnimatingExit = false;
                didSomething = true;
            }
            if (this.mDestroying) {
                this.mDestroying = false;
                this.mService.mDestroySurface.remove(this);
                didSomething = true;
            }
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            didSomething |= ((WindowState)this.mChildren.get(i)).clearAnimatingFlags();
        }
        return didSomething;
    }

    public boolean isRtl() {
        return this.getConfiguration().getLayoutDirection() == 1;
    }

    void hideWallpaperWindow(boolean wasDeferred, String reason) {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowState c = (WindowState)this.mChildren.get(j);
            c.hideWallpaperWindow(wasDeferred, reason);
        }
        if (!this.mWinAnimator.mLastHidden || wasDeferred) {
            this.mWinAnimator.hide(reason);
            this.dispatchWallpaperVisibility(false);
            DisplayContent displayContent = this.getDisplayContent();
            if (displayContent != null) {
                displayContent.pendingLayoutChanges |= 4;
            }
        }
    }

    void dispatchWallpaperVisibility(boolean visible) {
        boolean hideAllowed;
        boolean bl = hideAllowed = this.getDisplayContent().mWallpaperController.mDeferredHideWallpaper == null;
        if (this.mWallpaperVisible != visible && (hideAllowed || visible)) {
            this.mWallpaperVisible = visible;
            try {
                this.mClient.dispatchAppVisibility(visible);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    boolean hasVisibleNotDrawnWallpaper() {
        if (this.mWallpaperVisible && !this.isDrawnLw()) {
            return true;
        }
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowState c = (WindowState)this.mChildren.get(j);
            if (!c.hasVisibleNotDrawnWallpaper()) continue;
            return true;
        }
        return false;
    }

    void updateReportedVisibility(UpdateReportedVisibilityResults results) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState c = (WindowState)this.mChildren.get(i);
            c.updateReportedVisibility(results);
        }
        if (this.mAppFreezing || this.mViewVisibility != 0 || this.mAttrs.type == 3 || this.mDestroying) {
            return;
        }
        ++results.numInteresting;
        if (this.isDrawnLw()) {
            ++results.numDrawn;
            if (!this.mWinAnimator.isAnimationSet()) {
                ++results.numVisible;
            }
            results.nowGone = false;
        } else if (this.mWinAnimator.isAnimationSet()) {
            results.nowGone = false;
        }
    }

    private boolean skipDecorCrop() {
        if (this.mDecorFrame.isEmpty()) {
            return true;
        }
        if (this.mAppToken != null) {
            return false;
        }
        return this.mToken.canLayerAboveSystemBars();
    }

    void calculatePolicyCrop(Rect policyCrop) {
        DisplayContent displayContent = this.getDisplayContent();
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        if (!this.isDefaultDisplay()) {
            policyCrop.set(0, 0, this.mCompatFrame.width(), this.mCompatFrame.height());
            policyCrop.intersect(-this.mCompatFrame.left, -this.mCompatFrame.top, displayInfo.logicalWidth - this.mCompatFrame.left, displayInfo.logicalHeight - this.mCompatFrame.top);
        } else if (this.skipDecorCrop()) {
            policyCrop.set(0, 0, this.mCompatFrame.width(), this.mCompatFrame.height());
        } else {
            this.calculateSystemDecorRect(policyCrop);
        }
    }

    private void calculateSystemDecorRect(Rect systemDecorRect) {
        boolean cropToDecor;
        Rect decorRect = this.mDecorFrame;
        int width = this.mFrame.width();
        int height = this.mFrame.height();
        int left = this.mFrame.left;
        int top = this.mFrame.top;
        if (this.isDockedResizing()) {
            DisplayInfo displayInfo = this.getDisplayContent().getDisplayInfo();
            systemDecorRect.set(0, 0, Math.max(width, displayInfo.logicalWidth), Math.max(height, displayInfo.logicalHeight));
        } else {
            systemDecorRect.set(0, 0, width, height);
        }
        boolean bl = cropToDecor = (!this.inFreeformWindowingMode() || !this.isAnimatingLw()) && !this.isDockedResizing();
        if (cropToDecor) {
            systemDecorRect.intersect(decorRect.left - left, decorRect.top - top, decorRect.right - left, decorRect.bottom - top);
        }
        if (this.mEnforceSizeCompat && this.mInvGlobalScale != 1.0f) {
            float scale = this.mInvGlobalScale;
            systemDecorRect.left = (int)((float)systemDecorRect.left * scale - 0.5f);
            systemDecorRect.top = (int)((float)systemDecorRect.top * scale - 0.5f);
            systemDecorRect.right = (int)((float)(systemDecorRect.right + 1) * scale - 0.5f);
            systemDecorRect.bottom = (int)((float)(systemDecorRect.bottom + 1) * scale - 0.5f);
        }
    }

    void expandForSurfaceInsets(Rect r) {
        r.inset(-this.mAttrs.surfaceInsets.left, -this.mAttrs.surfaceInsets.top, -this.mAttrs.surfaceInsets.right, -this.mAttrs.surfaceInsets.bottom);
    }

    boolean surfaceInsetsChanging() {
        return !this.mLastSurfaceInsets.equals(this.mAttrs.surfaceInsets);
    }

    int relayoutVisibleWindow(int result, int attrChanges, int oldVisibility) {
        boolean wasVisible = this.isVisibleLw();
        result |= !wasVisible || !this.isDrawnLw() ? 2 : 0;
        if (this.mAnimatingExit) {
            Slog.d(TAG, "relayoutVisibleWindow: " + this + " mAnimatingExit=true, mRemoveOnExit=" + this.mRemoveOnExit + ", mDestroying=" + this.mDestroying);
            this.mWinAnimator.cancelExitAnimationForNextAnimationLocked();
            this.mAnimatingExit = false;
        }
        if (this.mDestroying) {
            this.mDestroying = false;
            this.mService.mDestroySurface.remove(this);
        }
        if (oldVisibility == 8) {
            this.mWinAnimator.mEnterAnimationPending = true;
        }
        this.mLastVisibleLayoutRotation = this.getDisplayContent().getRotation();
        this.mWinAnimator.mEnteringAnimation = true;
        this.prepareWindowToDisplayDuringRelayout(wasVisible);
        if ((attrChanges & 8) != 0 && !this.mWinAnimator.tryChangeFormatInPlaceLocked()) {
            this.mWinAnimator.preserveSurfaceLocked();
            result |= 6;
        }
        if (this.isDragResizeChanged()) {
            this.setDragResizing();
            if (this.mHasSurface && !this.isChildWindow()) {
                this.mWinAnimator.preserveSurfaceLocked();
                result |= 6;
            }
        }
        boolean freeformResizing = this.isDragResizing() && this.getResizeMode() == 0;
        boolean dockedResizing = this.isDragResizing() && this.getResizeMode() == 1;
        result |= freeformResizing ? 16 : 0;
        return result |= dockedResizing ? 8 : 0;
    }

    boolean isLaidOut() {
        return this.mLayoutSeq != -1;
    }

    void updateLastInsetValues() {
        this.mLastOverscanInsets.set(this.mOverscanInsets);
        this.mLastContentInsets.set(this.mContentInsets);
        this.mLastVisibleInsets.set(this.mVisibleInsets);
        this.mLastStableInsets.set(this.mStableInsets);
        this.mLastOutsets.set(this.mOutsets);
        this.mLastDisplayCutout = this.mDisplayCutout;
    }

    void startAnimation(Animation anim2) {
        DisplayInfo displayInfo = this.getDisplayContent().getDisplayInfo();
        anim2.initialize(this.mFrame.width(), this.mFrame.height(), displayInfo.appWidth, displayInfo.appHeight);
        anim2.restrictDuration(10000L);
        anim2.scaleCurrentDuration(this.mService.getWindowAnimationScaleLocked());
        LocalAnimationAdapter adapter = new LocalAnimationAdapter(new WindowAnimationSpec(anim2, this.mSurfacePosition, false), this.mService.mSurfaceAnimationRunner);
        this.startAnimation(this.mPendingTransaction, adapter);
        this.commitPendingTransaction();
    }

    private void startMoveAnimation(int left, int top) {
        Point oldPosition = new Point();
        Point newPosition = new Point();
        this.transformFrameToSurfacePosition(this.mLastFrame.left, this.mLastFrame.top, oldPosition);
        this.transformFrameToSurfacePosition(left, top, newPosition);
        LocalAnimationAdapter adapter = new LocalAnimationAdapter(new MoveAnimationSpec(oldPosition.x, oldPosition.y, newPosition.x, newPosition.y), this.mService.mSurfaceAnimationRunner);
        this.startAnimation(this.getPendingTransaction(), adapter);
    }

    private void startAnimation(SurfaceControl.Transaction t, AnimationAdapter adapter) {
        this.startAnimation(t, adapter, this.mWinAnimator.mLastHidden);
    }

    @Override
    protected void onAnimationFinished() {
        this.mWinAnimator.onAnimationFinished();
    }

    void getTransformationMatrix(float[] float9, Matrix outMatrix) {
        float9[0] = this.mWinAnimator.mDsDx;
        float9[3] = this.mWinAnimator.mDtDx;
        float9[1] = this.mWinAnimator.mDtDy;
        float9[4] = this.mWinAnimator.mDsDy;
        int x = this.mSurfacePosition.x;
        int y = this.mSurfacePosition.y;
        WindowContainer parent = this.getParent();
        if (this.isChildWindow()) {
            WindowState parentWindow = this.getParentWindow();
            x += parentWindow.mFrame.left - parentWindow.mAttrs.surfaceInsets.left;
            y += parentWindow.mFrame.top - parentWindow.mAttrs.surfaceInsets.top;
        } else if (parent != null) {
            Rect parentBounds = parent.getBounds();
            x += parentBounds.left;
            y += parentBounds.top;
        }
        float9[2] = x;
        float9[5] = y;
        float9[6] = 0.0f;
        float9[7] = 0.0f;
        float9[8] = 1.0f;
        outMatrix.setValues(float9);
    }

    @Override
    boolean shouldMagnify() {
        return this.mAttrs.type != 2011 && this.mAttrs.type != 2012 && this.mAttrs.type != 2027 && this.mAttrs.type != 2019 && this.mAttrs.type != 2024;
    }

    @Override
    SurfaceSession getSession() {
        if (this.mSession.mSurfaceSession != null) {
            return this.mSession.mSurfaceSession;
        }
        return this.getParent().getSession();
    }

    @Override
    boolean needsZBoost() {
        AppWindowToken appToken;
        if (this.mIsImWindow && this.mService.mInputMethodTarget != null && (appToken = this.mService.mInputMethodTarget.mAppToken) != null) {
            return appToken.needsZBoost();
        }
        return this.mWillReplaceWindow;
    }

    private void applyDims(Dimmer dimmer) {
        if (!this.mAnimatingExit && this.mAppDied) {
            this.mIsDimming = true;
            dimmer.dimAbove(this.getPendingTransaction(), this, 0.5f);
        } else if ((this.mAttrs.flags & 2) != 0 && this.isVisibleNow() && !this.mHidden) {
            this.mIsDimming = true;
            dimmer.dimBelow(this.getPendingTransaction(), this, this.mAttrs.dimAmount);
        }
    }

    @Override
    void prepareSurfaces() {
        Dimmer dimmer = this.getDimmer();
        this.mIsDimming = false;
        if (dimmer != null) {
            this.applyDims(dimmer);
        }
        this.updateSurfacePosition();
        this.mWinAnimator.prepareSurfaceLocked(true);
        super.prepareSurfaces();
    }

    @Override
    public void onAnimationLeashCreated(SurfaceControl.Transaction t, SurfaceControl leash) {
        super.onAnimationLeashCreated(t, leash);
        t.setPosition(this.mSurfaceControl, 0.0f, 0.0f);
        this.mLastSurfacePosition.set(0, 0);
    }

    @Override
    public void onAnimationLeashDestroyed(SurfaceControl.Transaction t) {
        super.onAnimationLeashDestroyed(t);
        this.updateSurfacePosition(t);
    }

    @Override
    void updateSurfacePosition() {
        this.updateSurfacePosition(this.getPendingTransaction());
    }

    private void updateSurfacePosition(SurfaceControl.Transaction t) {
        if (this.mSurfaceControl == null) {
            return;
        }
        this.transformFrameToSurfacePosition(this.mFrame.left, this.mFrame.top, this.mSurfacePosition);
        if (!this.mSurfaceAnimator.hasLeash() && this.mPendingForcedSeamlessRotate == null && !this.mLastSurfacePosition.equals(this.mSurfacePosition)) {
            t.setPosition(this.mSurfaceControl, this.mSurfacePosition.x, this.mSurfacePosition.y);
            this.mLastSurfacePosition.set(this.mSurfacePosition.x, this.mSurfacePosition.y);
            if (this.surfaceInsetsChanging() && this.mWinAnimator.hasSurface()) {
                this.mLastSurfaceInsets.set(this.mAttrs.surfaceInsets);
                t.deferTransactionUntil(this.mSurfaceControl, this.mWinAnimator.mSurfaceController.mSurfaceControl.getHandle(), this.getFrameNumber());
            }
        }
    }

    private void transformFrameToSurfacePosition(int left, int top, Point outPoint) {
        outPoint.set(left, top);
        WindowContainer parentWindowContainer = this.getParent();
        if (this.isChildWindow()) {
            WindowState parent = this.getParentWindow();
            outPoint.offset(-parent.mFrame.left + parent.mAttrs.surfaceInsets.left, -parent.mFrame.top + parent.mAttrs.surfaceInsets.top);
        } else if (parentWindowContainer != null) {
            Rect parentBounds = parentWindowContainer.getBounds();
            outPoint.offset(-parentBounds.left, -parentBounds.top);
        }
        TaskStack stack = this.getStack();
        if (stack != null) {
            int outset = stack.getStackOutset();
            outPoint.offset(outset, outset);
        }
        outPoint.offset(-this.mAttrs.surfaceInsets.left, -this.mAttrs.surfaceInsets.top);
    }

    boolean needsRelativeLayeringToIme() {
        if (!this.inSplitScreenWindowingMode()) {
            return false;
        }
        if (this.isChildWindow()) {
            if (this.getParentWindow().isInputMethodTarget()) {
                return true;
            }
        } else if (this.mAppToken != null) {
            WindowState imeTarget = this.mService.mInputMethodTarget;
            boolean inTokenWithAndAboveImeTarget = imeTarget != null && imeTarget != this && imeTarget.mToken == this.mToken && imeTarget.compareTo(this) <= 0;
            return inTokenWithAndAboveImeTarget;
        }
        return false;
    }

    @Override
    void assignLayer(SurfaceControl.Transaction t, int layer) {
        if (this.needsRelativeLayeringToIme()) {
            this.getDisplayContent().assignRelativeLayerForImeTargetChild(t, this);
            return;
        }
        super.assignLayer(t, layer);
    }

    @Override
    public boolean isDimming() {
        return this.mIsDimming;
    }

    @Override
    public void assignChildLayers(SurfaceControl.Transaction t) {
        int layer = 1;
        for (int i = 0; i < this.mChildren.size(); ++i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            if (w.mAttrs.type == 1001) {
                w.assignLayer(t, -2);
            } else if (w.mAttrs.type == 1004) {
                w.assignLayer(t, -1);
            } else {
                w.assignLayer(t, layer);
            }
            w.assignChildLayers(t);
            ++layer;
        }
    }

    void updateTapExcludeRegion(int regionId, int left, int top, int width, int height) {
        DisplayContent currentDisplay = this.getDisplayContent();
        if (currentDisplay == null) {
            throw new IllegalStateException("Trying to update window not attached to any display.");
        }
        if (this.mTapExcludeRegionHolder == null) {
            this.mTapExcludeRegionHolder = new TapExcludeRegionHolder();
            currentDisplay.mTapExcludeProvidingWindows.add(this);
        }
        this.mTapExcludeRegionHolder.updateRegion(regionId, left, top, width, height);
        boolean isAppFocusedOnDisplay = this.mService.mFocusedApp != null && this.mService.mFocusedApp.getDisplayContent() == currentDisplay;
        currentDisplay.setTouchExcludeRegion(isAppFocusedOnDisplay ? this.mService.mFocusedApp.getTask() : null);
    }

    void amendTapExcludeRegion(Region region) {
        this.mTapExcludeRegionHolder.amendRegion(region, this.getBounds());
    }

    @Override
    public boolean isInputMethodTarget() {
        return this.mService.mInputMethodTarget == this;
    }

    long getFrameNumber() {
        return this.mFrameNumber;
    }

    void setFrameNumber(long frameNumber) {
        this.mFrameNumber = frameNumber;
    }

    @Override
    void seamlesslyRotate(SurfaceControl.Transaction t, int oldRotation, int newRotation) {
        if (!this.isVisibleNow() || this.mIsWallpaper || this.mForceSeamlesslyRotate) {
            return;
        }
        Matrix transform = this.mTmpMatrix;
        this.mService.markForSeamlessRotation(this, true);
        CoordinateTransforms.transformToRotation(oldRotation, newRotation, this.getDisplayInfo(), transform);
        CoordinateTransforms.transformRect(transform, this.mFrame, null);
        this.updateSurfacePosition(t);
        this.mWinAnimator.seamlesslyRotate(t, oldRotation, newRotation);
        super.seamlesslyRotate(t, oldRotation, newRotation);
    }

    private final class MoveAnimationSpec
    implements LocalAnimationAdapter.AnimationSpec {
        private final long mDuration;
        private Interpolator mInterpolator;
        private Point mFrom = new Point();
        private Point mTo = new Point();

        private MoveAnimationSpec(int fromX, int fromY, int toX, int toY) {
            Animation anim2 = AnimationUtils.loadAnimation(WindowState.this.mContext, 17432758);
            this.mDuration = (long)((float)anim2.computeDurationHint() * WindowState.this.mService.getWindowAnimationScaleLocked());
            this.mInterpolator = anim2.getInterpolator();
            this.mFrom.set(fromX, fromY);
            this.mTo.set(toX, toY);
        }

        @Override
        public long getDuration() {
            return this.mDuration;
        }

        @Override
        public void apply(SurfaceControl.Transaction t, SurfaceControl leash, long currentPlayTime) {
            float fraction2 = (float)currentPlayTime / (float)this.getDuration();
            float v = this.mInterpolator.getInterpolation(fraction2);
            t.setPosition(leash, (float)this.mFrom.x + (float)(this.mTo.x - this.mFrom.x) * v, (float)this.mFrom.y + (float)(this.mTo.y - this.mFrom.y) * v);
        }

        @Override
        public void dump(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.print("from=");
            pw.print(this.mFrom);
            pw.print(" to=");
            pw.print(this.mTo);
            pw.print(" duration=");
            pw.println(this.mDuration);
        }

        @Override
        public void writeToProtoInner(ProtoOutputStream proto) {
            long token = proto.start(1146756268034L);
            this.mFrom.writeToProto(proto, 0x10B00000001L);
            this.mTo.writeToProto(proto, 1146756268034L);
            proto.write(0x10300000003L, this.mDuration);
            proto.end(token);
        }
    }

    private static final class WindowId
    extends IWindowId.Stub {
        private final WeakReference<WindowState> mOuter;

        private WindowId(WindowState outer) {
            this.mOuter = new WeakReference<WindowState>(outer);
        }

        @Override
        public void registerFocusObserver(IWindowFocusObserver observer) {
            WindowState outer = (WindowState)this.mOuter.get();
            if (outer != null) {
                outer.registerFocusObserver(observer);
            }
        }

        @Override
        public void unregisterFocusObserver(IWindowFocusObserver observer) {
            WindowState outer = (WindowState)this.mOuter.get();
            if (outer != null) {
                outer.unregisterFocusObserver(observer);
            }
        }

        @Override
        public boolean isFocused() {
            WindowState outer = (WindowState)this.mOuter.get();
            return outer != null && outer.isFocused();
        }
    }

    static final class UpdateReportedVisibilityResults {
        int numInteresting;
        int numVisible;
        int numDrawn;
        boolean nowGone = true;

        UpdateReportedVisibilityResults() {
        }

        void reset() {
            this.numInteresting = 0;
            this.numVisible = 0;
            this.numDrawn = 0;
            this.nowGone = true;
        }
    }

    private class DeathRecipient
    implements IBinder.DeathRecipient {
        private DeathRecipient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            block13: {
                try {
                    boolean resetSplitScreenResizing = false;
                    WindowHashMap windowHashMap = WindowState.this.mService.mWindowMap;
                    synchronized (windowHashMap) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            WindowState win = WindowState.this.mService.windowForClientLocked(WindowState.this.mSession, WindowState.this.mClient, false);
                            Slog.i(WindowState.TAG, "WIN DEATH: " + win);
                            if (win != null) {
                                DisplayContent dc = WindowState.this.getDisplayContent();
                                if (win.mAppToken != null && win.mAppToken.findMainWindow() == win) {
                                    WindowState.this.mService.mTaskSnapshotController.onAppDied(win.mAppToken);
                                }
                                win.removeIfPossible(WindowState.this.shouldKeepVisibleDeadAppWindow());
                                if (win.mAttrs.type == 2034) {
                                    TaskStack stack = dc.getSplitScreenPrimaryStackIgnoringVisibility();
                                    if (stack != null) {
                                        stack.resetDockedStackToMiddle();
                                    }
                                    resetSplitScreenResizing = true;
                                }
                            } else if (WindowState.this.mHasSurface) {
                                Slog.e(WindowState.TAG, "!!! LEAK !!! Window removed but surface still valid.");
                                WindowState.this.removeIfPossible();
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[0, 3, 4] lbl29 : MonitorExitStatement: MONITOREXIT : var2_3
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    if (!resetSplitScreenResizing) break block13;
                    try {
                        WindowState.this.mService.mActivityManager.setSplitScreenResizing(false);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowAsRuntimeException();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private final class DeadWindowEventReceiver
    extends InputEventReceiver {
        DeadWindowEventReceiver(InputChannel inputChannel) {
            super(inputChannel, WindowState.this.mService.mH.getLooper());
        }

        @Override
        public void onInputEvent(InputEvent event, int displayId) {
            this.finishInputEvent(event, true);
        }
    }

    static interface PowerManagerWrapper {
        public void wakeUp(long var1, String var3);

        public boolean isInteractive();
    }
}

