/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.os.RemoteException;
import android.os.ShellCommand;
import android.view.IWindowManager;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowManagerShellCommand
extends ShellCommand {
    private final IWindowManager mInterface;
    private final WindowManagerService mInternal;

    public WindowManagerShellCommand(WindowManagerService service) {
        this.mInterface = service;
        this.mInternal = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        try {
            switch (cmd) {
                case "size": {
                    return this.runDisplaySize(pw);
                }
                case "density": {
                    return this.runDisplayDensity(pw);
                }
                case "overscan": {
                    return this.runDisplayOverscan(pw);
                }
                case "scaling": {
                    return this.runDisplayScaling(pw);
                }
                case "dismiss-keyguard": {
                    return this.runDismissKeyguard(pw);
                }
                case "tracing": {
                    return this.mInternal.mWindowTracing.onShellCommand(this, this.getNextArgRequired());
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    private int runDisplaySize(PrintWriter pw) throws RemoteException {
        int w;
        int h;
        String size = this.getNextArg();
        if (size == null) {
            Point initialSize = new Point();
            Point baseSize = new Point();
            try {
                this.mInterface.getInitialDisplaySize(0, initialSize);
                this.mInterface.getBaseDisplaySize(0, baseSize);
                pw.println("Physical size: " + initialSize.x + "x" + initialSize.y);
                if (!initialSize.equals(baseSize)) {
                    pw.println("Override size: " + baseSize.x + "x" + baseSize.y);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return 0;
        }
        if ("reset".equals(size)) {
            h = -1;
            w = -1;
        } else {
            int div = size.indexOf(120);
            if (div <= 0 || div >= size.length() - 1) {
                this.getErrPrintWriter().println("Error: bad size " + size);
                return -1;
            }
            String wstr = size.substring(0, div);
            String hstr = size.substring(div + 1);
            try {
                w = this.parseDimension(wstr);
                h = this.parseDimension(hstr);
            }
            catch (NumberFormatException e) {
                this.getErrPrintWriter().println("Error: bad number " + e);
                return -1;
            }
        }
        if (w >= 0 && h >= 0) {
            this.mInterface.setForcedDisplaySize(0, w, h);
        } else {
            this.mInterface.clearForcedDisplaySize(0);
        }
        return 0;
    }

    private int runDisplayDensity(PrintWriter pw) throws RemoteException {
        int density;
        String densityStr = this.getNextArg();
        if (densityStr == null) {
            try {
                int initialDensity = this.mInterface.getInitialDisplayDensity(0);
                int baseDensity = this.mInterface.getBaseDisplayDensity(0);
                pw.println("Physical density: " + initialDensity);
                if (initialDensity != baseDensity) {
                    pw.println("Override density: " + baseDensity);
                }
            }
            catch (RemoteException initialDensity) {
                // empty catch block
            }
            return 0;
        }
        if ("reset".equals(densityStr)) {
            density = -1;
        } else {
            try {
                density = Integer.parseInt(densityStr);
            }
            catch (NumberFormatException e) {
                this.getErrPrintWriter().println("Error: bad number " + e);
                return -1;
            }
            if (density < 72) {
                this.getErrPrintWriter().println("Error: density must be >= 72");
                return -1;
            }
        }
        if (density > 0) {
            this.mInterface.setForcedDisplayDensityForUser(0, density, -2);
        } else {
            this.mInterface.clearForcedDisplayDensityForUser(0, -2);
        }
        return 0;
    }

    private int runDisplayOverscan(PrintWriter pw) throws RemoteException {
        String overscanStr = this.getNextArgRequired();
        Rect rect = new Rect();
        if ("reset".equals(overscanStr)) {
            rect.set(0, 0, 0, 0);
        } else {
            Pattern FLATTENED_PATTERN = Pattern.compile("(-?\\d+),(-?\\d+),(-?\\d+),(-?\\d+)");
            Matcher matcher = FLATTENED_PATTERN.matcher(overscanStr);
            if (!matcher.matches()) {
                this.getErrPrintWriter().println("Error: bad rectangle arg: " + overscanStr);
                return -1;
            }
            rect.left = Integer.parseInt(matcher.group(1));
            rect.top = Integer.parseInt(matcher.group(2));
            rect.right = Integer.parseInt(matcher.group(3));
            rect.bottom = Integer.parseInt(matcher.group(4));
        }
        this.mInterface.setOverscan(0, rect.left, rect.top, rect.right, rect.bottom);
        return 0;
    }

    private int runDisplayScaling(PrintWriter pw) throws RemoteException {
        String scalingStr = this.getNextArgRequired();
        if ("auto".equals(scalingStr)) {
            this.mInterface.setForcedDisplayScalingMode(0, 0);
        } else if ("off".equals(scalingStr)) {
            this.mInterface.setForcedDisplayScalingMode(0, 1);
        } else {
            this.getErrPrintWriter().println("Error: scaling must be 'auto' or 'off'");
            return -1;
        }
        return 0;
    }

    private int runDismissKeyguard(PrintWriter pw) throws RemoteException {
        this.mInterface.dismissKeyguard(null, null);
        return 0;
    }

    private int parseDimension(String s) throws NumberFormatException {
        if (s.endsWith("px")) {
            return Integer.parseInt(s.substring(0, s.length() - 2));
        }
        if (s.endsWith("dp")) {
            int density;
            try {
                density = this.mInterface.getBaseDisplayDensity(0);
            }
            catch (RemoteException e) {
                density = 160;
            }
            return Integer.parseInt(s.substring(0, s.length() - 2)) * density / 160;
        }
        return Integer.parseInt(s);
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Window manager (window) commands:");
        pw.println("  help");
        pw.println("      Print this help text.");
        pw.println("  size [reset|WxH|WdpxHdp]");
        pw.println("    Return or override display size.");
        pw.println("    width and height in pixels unless suffixed with 'dp'.");
        pw.println("  density [reset|DENSITY]");
        pw.println("    Return or override display density.");
        pw.println("  overscan [reset|LEFT,TOP,RIGHT,BOTTOM]");
        pw.println("    Set overscan area for display.");
        pw.println("  scaling [off|auto]");
        pw.println("    Set display scaling mode.");
        pw.println("  dismiss-keyguard");
        pw.println("    Dismiss the keyguard, prompting user for auth if\u00a0necessary.");
        if (!Build.IS_USER) {
            pw.println("  tracing (start | stop)");
            pw.println("    Start or stop window tracing.");
        }
    }
}

