/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.util.ArrayMap;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.Task;
import com.android.server.wm.TaskSnapshotLoader;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;

class TaskSnapshotCache {
    private final WindowManagerService mService;
    private final TaskSnapshotLoader mLoader;
    private final ArrayMap<AppWindowToken, Integer> mAppTaskMap = new ArrayMap();
    private final ArrayMap<Integer, CacheEntry> mRunningCache = new ArrayMap();

    TaskSnapshotCache(WindowManagerService service, TaskSnapshotLoader loader) {
        this.mService = service;
        this.mLoader = loader;
    }

    void putSnapshot(Task task, ActivityManager.TaskSnapshot snapshot) {
        CacheEntry entry = this.mRunningCache.get(task.mTaskId);
        if (entry != null) {
            this.mAppTaskMap.remove(entry.topApp);
        }
        AppWindowToken top = (AppWindowToken)task.getTopChild();
        this.mAppTaskMap.put(top, task.mTaskId);
        this.mRunningCache.put(task.mTaskId, new CacheEntry(snapshot, (AppWindowToken)task.getTopChild()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ActivityManager.TaskSnapshot getSnapshot(int taskId, int userId, boolean restoreFromDisk, boolean reducedResolution) {
        block6: {
            ActivityManager.TaskSnapshot taskSnapshot;
            WindowHashMap windowHashMap = this.mService.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    CacheEntry entry = this.mRunningCache.get(taskId);
                    if (entry != null) {
                        taskSnapshot = entry.snapshot;
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[2, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var5_5
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return taskSnapshot;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        if (restoreFromDisk) {
            return this.tryRestoreFromDisk(taskId, userId, reducedResolution);
        }
        return null;
    }

    private ActivityManager.TaskSnapshot tryRestoreFromDisk(int taskId, int userId, boolean reducedResolution) {
        ActivityManager.TaskSnapshot snapshot = this.mLoader.loadTask(taskId, userId, reducedResolution);
        if (snapshot == null) {
            return null;
        }
        return snapshot;
    }

    void onAppRemoved(AppWindowToken wtoken) {
        Integer taskId = this.mAppTaskMap.get(wtoken);
        if (taskId != null) {
            this.removeRunningEntry(taskId);
        }
    }

    void onAppDied(AppWindowToken wtoken) {
        Integer taskId = this.mAppTaskMap.get(wtoken);
        if (taskId != null) {
            this.removeRunningEntry(taskId);
        }
    }

    void onTaskRemoved(int taskId) {
        this.removeRunningEntry(taskId);
    }

    private void removeRunningEntry(int taskId) {
        CacheEntry entry = this.mRunningCache.get(taskId);
        if (entry != null) {
            this.mAppTaskMap.remove(entry.topApp);
            this.mRunningCache.remove(taskId);
        }
    }

    void dump(PrintWriter pw, String prefix) {
        String doublePrefix = prefix + "  ";
        String triplePrefix = doublePrefix + "  ";
        pw.println(prefix + "SnapshotCache");
        for (int i = this.mRunningCache.size() - 1; i >= 0; --i) {
            CacheEntry entry = this.mRunningCache.valueAt(i);
            pw.println(doublePrefix + "Entry taskId=" + this.mRunningCache.keyAt(i));
            pw.println(triplePrefix + "topApp=" + entry.topApp);
            pw.println(triplePrefix + "snapshot=" + entry.snapshot);
        }
    }

    private static final class CacheEntry {
        final ActivityManager.TaskSnapshot snapshot;
        final AppWindowToken topApp;

        CacheEntry(ActivityManager.TaskSnapshot snapshot, AppWindowToken topApp) {
            this.snapshot = snapshot;
            this.topApp = topApp;
        }
    }
}

