/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.IActivityManager;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Slog;
import android.view.Display;
import android.view.IWindow;
import com.android.internal.annotations.GuardedBy;
import com.android.server.input.InputManagerService;
import com.android.server.input.InputWindowHandle;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.InputMonitor;
import com.android.server.wm.TaskPositioner;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;

class TaskPositioningController {
    private final WindowManagerService mService;
    private final InputManagerService mInputManager;
    private final InputMonitor mInputMonitor;
    private final IActivityManager mActivityManager;
    private final Handler mHandler;
    @GuardedBy(value="WindowManagerSerivce.mWindowMap")
    private TaskPositioner mTaskPositioner;

    boolean isPositioningLocked() {
        return this.mTaskPositioner != null;
    }

    InputWindowHandle getDragWindowHandleLocked() {
        return this.mTaskPositioner != null ? this.mTaskPositioner.mDragWindowHandle : null;
    }

    TaskPositioningController(WindowManagerService service, InputManagerService inputManager, InputMonitor inputMonitor, IActivityManager activityManager, Looper looper) {
        this.mService = service;
        this.mInputMonitor = inputMonitor;
        this.mInputManager = inputManager;
        this.mActivityManager = activityManager;
        this.mHandler = new Handler(looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean startMovingTask(IWindow window, float startX, float startY) {
        win = null;
        var5_5 = this.mService.mWindowMap;
        synchronized (var5_5) {
            WindowManagerService.boostPriorityForLockedSection();
            win = this.mService.windowForClientLocked(null, window, false);
            if (this.startPositioningLocked(win, false, false, startX, startY)) ** break block6
            v0 = false;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v0;
        {
            try {}
            catch (Throwable var6_7) {
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
                throw var6_7;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        try {
            this.mActivityManager.setFocusedTask(win.getTask().mTaskId);
        }
        catch (RemoteException var5_6) {
            // empty catch block
        }
        return true;
    }

    void handleTapOutsideTask(DisplayContent displayContent, int x, int y) {
        this.mHandler.post(() -> this.lambda$handleTapOutsideTask$0(displayContent, x, y));
    }

    private boolean startPositioningLocked(WindowState win, boolean resize, boolean preserveOrientation, float startX, float startY) {
        if (win == null || win.getAppToken() == null) {
            Slog.w("WindowManager", "startPositioningLocked: Bad window " + win);
            return false;
        }
        if (win.mInputChannel == null) {
            Slog.wtf("WindowManager", "startPositioningLocked: " + win + " has no input channel,  probably being removed");
            return false;
        }
        DisplayContent displayContent = win.getDisplayContent();
        if (displayContent == null) {
            Slog.w("WindowManager", "startPositioningLocked: Invalid display content " + win);
            return false;
        }
        Display display = displayContent.getDisplay();
        this.mTaskPositioner = TaskPositioner.create(this.mService);
        this.mTaskPositioner.register(displayContent);
        this.mInputMonitor.updateInputWindowsLw(true);
        WindowState transferFocusFromWin = win;
        if (this.mService.mCurrentFocus != null && this.mService.mCurrentFocus != win && this.mService.mCurrentFocus.mAppToken == win.mAppToken) {
            transferFocusFromWin = this.mService.mCurrentFocus;
        }
        if (!this.mInputManager.transferTouchFocus(transferFocusFromWin.mInputChannel, this.mTaskPositioner.mServerChannel)) {
            Slog.e("WindowManager", "startPositioningLocked: Unable to transfer touch focus");
            this.mTaskPositioner.unregister();
            this.mTaskPositioner = null;
            this.mInputMonitor.updateInputWindowsLw(true);
            return false;
        }
        this.mTaskPositioner.startDrag(win, resize, preserveOrientation, startX, startY);
        return true;
    }

    void finishTaskPositioning() {
        this.mHandler.post(() -> {
            WindowHashMap windowHashMap = this.mService.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (this.mTaskPositioner != null) {
                        this.mTaskPositioner.unregister();
                        this.mTaskPositioner = null;
                        this.mInputMonitor.updateInputWindowsLw(true);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$handleTapOutsideTask$0(DisplayContent displayContent, int x, int y) {
        block8: {
            taskId = -1;
            var5_5 = this.mService.mWindowMap;
            synchronized (var5_5) {
                WindowManagerService.boostPriorityForLockedSection();
                task = displayContent.findTaskForResizePoint(x, y);
                if (task == null) ** GOTO lbl15
                if (this.startPositioningLocked(task.getTopVisibleAppMainWindow(), true, task.preserveOrientationOnResize(), x, y)) ** break block7
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
            {
                try {
                    taskId = task.mTaskId;
                    break block8;
lbl15:
                    // 1 sources

                    taskId = displayContent.taskIdFromPoint(x, y);
                }
                catch (Throwable var7_8) {
                    // MONITOREXIT @DISABLED, blocks:[3, 4] lbl19 : MonitorExitStatement: MONITOREXIT : var5_5
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw var7_8;
                }
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        if (taskId >= 0) {
            try {
                this.mActivityManager.setFocusedTask(taskId);
            }
            catch (RemoteException var5_6) {
                // empty catch block
            }
        }
    }
}

