/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.server.wm.AppWindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;

class AnimatingAppWindowTokenRegistry {
    private ArraySet<AppWindowToken> mAnimatingTokens = new ArraySet();
    private ArrayMap<AppWindowToken, Runnable> mFinishedTokens = new ArrayMap();
    private ArrayList<Runnable> mTmpRunnableList = new ArrayList();
    private boolean mEndingDeferredFinish;

    AnimatingAppWindowTokenRegistry() {
    }

    void notifyStarting(AppWindowToken token) {
        this.mAnimatingTokens.add(token);
    }

    void notifyFinished(AppWindowToken token) {
        this.mAnimatingTokens.remove(token);
        this.mFinishedTokens.remove(token);
        if (this.mAnimatingTokens.isEmpty()) {
            this.endDeferringFinished();
        }
    }

    boolean notifyAboutToFinish(AppWindowToken token, Runnable endDeferFinishCallback) {
        boolean removed = this.mAnimatingTokens.remove(token);
        if (!removed) {
            return false;
        }
        if (this.mAnimatingTokens.isEmpty()) {
            this.endDeferringFinished();
            return false;
        }
        this.mFinishedTokens.put(token, endDeferFinishCallback);
        return true;
    }

    private void endDeferringFinished() {
        if (this.mEndingDeferredFinish) {
            return;
        }
        try {
            int i;
            this.mEndingDeferredFinish = true;
            for (i = this.mFinishedTokens.size() - 1; i >= 0; --i) {
                this.mTmpRunnableList.add(this.mFinishedTokens.valueAt(i));
            }
            this.mFinishedTokens.clear();
            for (i = this.mTmpRunnableList.size() - 1; i >= 0; --i) {
                this.mTmpRunnableList.get(i).run();
            }
            this.mTmpRunnableList.clear();
        }
        finally {
            this.mEndingDeferredFinish = false;
        }
    }

    void dump(PrintWriter pw, String header, String prefix) {
        if (!this.mAnimatingTokens.isEmpty() || !this.mFinishedTokens.isEmpty()) {
            pw.print(prefix);
            pw.println(header);
            prefix = prefix + "  ";
            pw.print(prefix);
            pw.print("mAnimatingTokens=");
            pw.println(this.mAnimatingTokens);
            pw.print(prefix);
            pw.print("mFinishedTokens=");
            pw.println(this.mFinishedTokens);
        }
    }
}

