/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.webkit;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Slog;
import android.webkit.UserPackage;
import android.webkit.WebViewFactory;
import android.webkit.WebViewProviderInfo;
import android.webkit.WebViewProviderResponse;
import com.android.server.webkit.SystemInterface;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

class WebViewUpdater {
    private static final String TAG = WebViewUpdater.class.getSimpleName();
    private static final int WAIT_TIMEOUT_MS = 1000;
    private static final int VALIDITY_OK = 0;
    private static final int VALIDITY_INCORRECT_SDK_VERSION = 1;
    private static final int VALIDITY_INCORRECT_VERSION_CODE = 2;
    private static final int VALIDITY_INCORRECT_SIGNATURE = 3;
    private static final int VALIDITY_NO_LIBRARY_FLAG = 4;
    private Context mContext;
    private SystemInterface mSystemInterface;
    private long mMinimumVersionCode = -1L;
    private int mNumRelroCreationsStarted = 0;
    private int mNumRelroCreationsFinished = 0;
    private boolean mWebViewPackageDirty = false;
    private boolean mAnyWebViewInstalled = false;
    private int NUMBER_OF_RELROS_UNKNOWN = Integer.MAX_VALUE;
    private PackageInfo mCurrentWebViewPackage = null;
    private final Object mLock = new Object();

    WebViewUpdater(Context context, SystemInterface systemInterface) {
        this.mContext = context;
        this.mSystemInterface = systemInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void packageStateChanged(String packageName, int changedState) {
        for (WebViewProviderInfo provider : this.mSystemInterface.getWebViewPackages()) {
            String webviewPackage = provider.packageName;
            if (!webviewPackage.equals(packageName)) continue;
            boolean updateWebView = false;
            boolean removedOrChangedOldPackage = false;
            String oldProviderName = null;
            PackageInfo newPackage = null;
            Object object = this.mLock;
            synchronized (object) {
                try {
                    newPackage = this.findPreferredWebViewPackage();
                    if (this.mCurrentWebViewPackage != null) {
                        oldProviderName = this.mCurrentWebViewPackage.packageName;
                        if (changedState == 0 && newPackage.packageName.equals(oldProviderName)) {
                            return;
                        }
                        if (newPackage.packageName.equals(oldProviderName) && newPackage.lastUpdateTime == this.mCurrentWebViewPackage.lastUpdateTime) {
                            return;
                        }
                    }
                    updateWebView = provider.packageName.equals(newPackage.packageName) || provider.packageName.equals(oldProviderName) || this.mCurrentWebViewPackage == null;
                    removedOrChangedOldPackage = provider.packageName.equals(oldProviderName);
                    if (updateWebView) {
                        this.onWebViewProviderChanged(newPackage);
                    }
                }
                catch (WebViewPackageMissingException e) {
                    this.mCurrentWebViewPackage = null;
                    Slog.e(TAG, "Could not find valid WebView package to create relro with " + e);
                }
            }
            if (updateWebView && !removedOrChangedOldPackage && oldProviderName != null) {
                this.mSystemInterface.killPackageDependents(oldProviderName);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareWebViewInSystemServer() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mCurrentWebViewPackage = this.findPreferredWebViewPackage();
                this.mSystemInterface.updateUserSetting(this.mContext, this.mCurrentWebViewPackage.packageName);
                this.onWebViewProviderChanged(this.mCurrentWebViewPackage);
            }
        }
        catch (Throwable t) {
            Slog.e(TAG, "error preparing webview provider from system server", t);
        }
    }

    String changeProviderAndSetting(String newProviderName) {
        PackageInfo newPackage = this.updateCurrentWebViewPackage(newProviderName);
        if (newPackage == null) {
            return "";
        }
        return newPackage.packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageInfo updateCurrentWebViewPackage(String newProviderName) {
        PackageInfo oldPackage = null;
        PackageInfo newPackage = null;
        boolean providerChanged = false;
        Object object = this.mLock;
        synchronized (object) {
            oldPackage = this.mCurrentWebViewPackage;
            if (newProviderName != null) {
                this.mSystemInterface.updateUserSetting(this.mContext, newProviderName);
            }
            try {
                newPackage = this.findPreferredWebViewPackage();
                providerChanged = oldPackage == null || !newPackage.packageName.equals(oldPackage.packageName);
            }
            catch (WebViewPackageMissingException e) {
                this.mCurrentWebViewPackage = null;
                Slog.e(TAG, "Couldn't find WebView package to use " + e);
                return null;
            }
            if (providerChanged) {
                this.onWebViewProviderChanged(newPackage);
            }
        }
        if (providerChanged && oldPackage != null) {
            this.mSystemInterface.killPackageDependents(oldPackage.packageName);
        }
        return newPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWebViewProviderChanged(PackageInfo newPackage) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAnyWebViewInstalled = true;
            if (this.mNumRelroCreationsStarted == this.mNumRelroCreationsFinished) {
                this.mCurrentWebViewPackage = newPackage;
                this.mNumRelroCreationsStarted = this.NUMBER_OF_RELROS_UNKNOWN;
                this.mNumRelroCreationsFinished = 0;
                this.mNumRelroCreationsStarted = this.mSystemInterface.onWebViewProviderChanged(newPackage);
                this.checkIfRelrosDoneLocked();
            } else {
                this.mWebViewPackageDirty = true;
            }
        }
    }

    WebViewProviderInfo[] getValidWebViewPackages() {
        ProviderAndPackageInfo[] providersAndPackageInfos = this.getValidWebViewPackagesAndInfos();
        WebViewProviderInfo[] providers = new WebViewProviderInfo[providersAndPackageInfos.length];
        for (int n = 0; n < providersAndPackageInfos.length; ++n) {
            providers[n] = providersAndPackageInfos[n].provider;
        }
        return providers;
    }

    private ProviderAndPackageInfo[] getValidWebViewPackagesAndInfos() {
        WebViewProviderInfo[] allProviders = this.mSystemInterface.getWebViewPackages();
        ArrayList<ProviderAndPackageInfo> providers = new ArrayList<ProviderAndPackageInfo>();
        for (int n = 0; n < allProviders.length; ++n) {
            try {
                PackageInfo packageInfo = this.mSystemInterface.getPackageInfoForProvider(allProviders[n]);
                if (!this.isValidProvider(allProviders[n], packageInfo)) continue;
                providers.add(new ProviderAndPackageInfo(allProviders[n], packageInfo));
                continue;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return providers.toArray(new ProviderAndPackageInfo[providers.size()]);
    }

    private PackageInfo findPreferredWebViewPackage() throws WebViewPackageMissingException {
        List<UserPackage> userPackages;
        ProviderAndPackageInfo[] providers = this.getValidWebViewPackagesAndInfos();
        String userChosenProvider = this.mSystemInterface.getUserChosenWebViewProvider(this.mContext);
        for (ProviderAndPackageInfo providerAndPackage : providers) {
            if (!providerAndPackage.provider.packageName.equals(userChosenProvider) || !WebViewUpdater.isInstalledAndEnabledForAllUsers(userPackages = this.mSystemInterface.getPackageInfoForProviderAllUsers(this.mContext, providerAndPackage.provider))) continue;
            return providerAndPackage.packageInfo;
        }
        for (ProviderAndPackageInfo providerAndPackage : providers) {
            if (!providerAndPackage.provider.availableByDefault || !WebViewUpdater.isInstalledAndEnabledForAllUsers(userPackages = this.mSystemInterface.getPackageInfoForProviderAllUsers(this.mContext, providerAndPackage.provider))) continue;
            return providerAndPackage.packageInfo;
        }
        this.mAnyWebViewInstalled = false;
        throw new WebViewPackageMissingException("Could not find a loadable WebView package");
    }

    static boolean isInstalledAndEnabledForAllUsers(List<UserPackage> userPackages) {
        for (UserPackage userPackage : userPackages) {
            if (userPackage.isInstalledPackage() && userPackage.isEnabledPackage()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRelroCreationCompleted() {
        Object object = this.mLock;
        synchronized (object) {
            ++this.mNumRelroCreationsFinished;
            this.checkIfRelrosDoneLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebViewProviderResponse waitForAndGetProvider() {
        PackageInfo webViewPackage = null;
        long NS_PER_MS = 1000000L;
        long timeoutTimeMs = System.nanoTime() / 1000000L + 1000L;
        boolean webViewReady = false;
        int webViewStatus = 0;
        Object object = this.mLock;
        synchronized (object) {
            long timeNowMs;
            webViewReady = this.webViewIsReadyLocked();
            while (!webViewReady && (timeNowMs = System.nanoTime() / 1000000L) < timeoutTimeMs) {
                try {
                    this.mLock.wait(timeoutTimeMs - timeNowMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                webViewReady = this.webViewIsReadyLocked();
            }
            webViewPackage = this.mCurrentWebViewPackage;
            if (!webViewReady) {
                if (!this.mAnyWebViewInstalled) {
                    webViewStatus = 4;
                } else {
                    webViewStatus = 3;
                    Slog.e(TAG, "Timed out waiting for relro creation, relros started " + this.mNumRelroCreationsStarted + " relros finished " + this.mNumRelroCreationsFinished + " package dirty? " + this.mWebViewPackageDirty);
                }
            }
        }
        if (!webViewReady) {
            Slog.w(TAG, "creating relro file timed out");
        }
        return new WebViewProviderResponse(webViewPackage, webViewStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageInfo getCurrentWebViewPackage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentWebViewPackage;
        }
    }

    private boolean webViewIsReadyLocked() {
        return !this.mWebViewPackageDirty && this.mNumRelroCreationsStarted == this.mNumRelroCreationsFinished && this.mAnyWebViewInstalled;
    }

    private void checkIfRelrosDoneLocked() {
        if (this.mNumRelroCreationsStarted == this.mNumRelroCreationsFinished) {
            if (this.mWebViewPackageDirty) {
                this.mWebViewPackageDirty = false;
                try {
                    PackageInfo newPackage = this.findPreferredWebViewPackage();
                    this.onWebViewProviderChanged(newPackage);
                }
                catch (WebViewPackageMissingException e) {
                    this.mCurrentWebViewPackage = null;
                }
            } else {
                this.mLock.notifyAll();
            }
        }
    }

    boolean isValidProvider(WebViewProviderInfo configInfo, PackageInfo packageInfo) {
        return 0 == this.validityResult(configInfo, packageInfo);
    }

    private int validityResult(WebViewProviderInfo configInfo, PackageInfo packageInfo) {
        if (!UserPackage.hasCorrectTargetSdkVersion(packageInfo)) {
            return 1;
        }
        if (!WebViewUpdater.versionCodeGE(packageInfo.getLongVersionCode(), this.getMinimumVersionCode()) && !this.mSystemInterface.systemIsDebuggable()) {
            return 2;
        }
        if (!WebViewUpdater.providerHasValidSignature(configInfo, packageInfo, this.mSystemInterface)) {
            return 3;
        }
        if (WebViewFactory.getWebViewLibrary(packageInfo.applicationInfo) == null) {
            return 4;
        }
        return 0;
    }

    private static boolean versionCodeGE(long versionCode1, long versionCode2) {
        long v1 = versionCode1 / 100000L;
        long v2 = versionCode2 / 100000L;
        return v1 >= v2;
    }

    private long getMinimumVersionCode() {
        if (this.mMinimumVersionCode > 0L) {
            return this.mMinimumVersionCode;
        }
        long minimumVersionCode = -1L;
        for (WebViewProviderInfo provider : this.mSystemInterface.getWebViewPackages()) {
            if (!provider.availableByDefault || provider.isFallback) continue;
            try {
                long versionCode = this.mSystemInterface.getFactoryPackageVersion(provider.packageName);
                if (minimumVersionCode >= 0L && versionCode >= minimumVersionCode) continue;
                minimumVersionCode = versionCode;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        this.mMinimumVersionCode = minimumVersionCode;
        return this.mMinimumVersionCode;
    }

    private static boolean providerHasValidSignature(WebViewProviderInfo provider, PackageInfo packageInfo, SystemInterface systemInterface) {
        if (systemInterface.systemIsDebuggable()) {
            return true;
        }
        if (provider.signatures == null || provider.signatures.length == 0) {
            return packageInfo.applicationInfo.isSystemApp();
        }
        if (packageInfo.signatures.length != 1) {
            return false;
        }
        for (Signature signature : provider.signatures) {
            if (!signature.equals(packageInfo.signatures[0])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpState(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentWebViewPackage == null) {
                pw.println("  Current WebView package is null");
            } else {
                pw.println(String.format("  Current WebView package (name, version): (%s, %s)", this.mCurrentWebViewPackage.packageName, this.mCurrentWebViewPackage.versionName));
            }
            pw.println(String.format("  Minimum WebView version code: %d", this.mMinimumVersionCode));
            pw.println(String.format("  Number of relros started: %d", this.mNumRelroCreationsStarted));
            pw.println(String.format("  Number of relros finished: %d", this.mNumRelroCreationsFinished));
            pw.println(String.format("  WebView package dirty: %b", this.mWebViewPackageDirty));
            pw.println(String.format("  Any WebView package installed: %b", this.mAnyWebViewInstalled));
            try {
                PackageInfo preferredWebViewPackage = this.findPreferredWebViewPackage();
                pw.println(String.format("  Preferred WebView package (name, version): (%s, %s)", preferredWebViewPackage.packageName, preferredWebViewPackage.versionName));
            }
            catch (WebViewPackageMissingException e) {
                pw.println(String.format("  Preferred WebView package: none", new Object[0]));
            }
            this.dumpAllPackageInformationLocked(pw);
        }
    }

    private void dumpAllPackageInformationLocked(PrintWriter pw) {
        WebViewProviderInfo[] allProviders = this.mSystemInterface.getWebViewPackages();
        pw.println("  WebView packages:");
        for (WebViewProviderInfo provider : allProviders) {
            List<UserPackage> userPackages = this.mSystemInterface.getPackageInfoForProviderAllUsers(this.mContext, provider);
            PackageInfo systemUserPackageInfo = userPackages.get(0).getPackageInfo();
            if (systemUserPackageInfo == null) {
                pw.println(String.format("    %s is NOT installed.", provider.packageName));
                continue;
            }
            int validity = this.validityResult(provider, systemUserPackageInfo);
            String packageDetails = String.format("versionName: %s, versionCode: %d, targetSdkVersion: %d", systemUserPackageInfo.versionName, systemUserPackageInfo.getLongVersionCode(), systemUserPackageInfo.applicationInfo.targetSdkVersion);
            if (validity == 0) {
                boolean installedForAllUsers = WebViewUpdater.isInstalledAndEnabledForAllUsers(this.mSystemInterface.getPackageInfoForProviderAllUsers(this.mContext, provider));
                pw.println(String.format("    Valid package %s (%s) is %s installed/enabled for all users", systemUserPackageInfo.packageName, packageDetails, installedForAllUsers ? "" : "NOT"));
                continue;
            }
            pw.println(String.format("    Invalid package %s (%s), reason: %s", systemUserPackageInfo.packageName, packageDetails, WebViewUpdater.getInvalidityReason(validity)));
        }
    }

    private static String getInvalidityReason(int invalidityReason) {
        switch (invalidityReason) {
            case 1: {
                return "SDK version too low";
            }
            case 2: {
                return "Version code too low";
            }
            case 3: {
                return "Incorrect signature";
            }
            case 4: {
                return "No WebView-library manifest flag";
            }
        }
        return "Unexcepted validity-reason";
    }

    private static class ProviderAndPackageInfo {
        public final WebViewProviderInfo provider;
        public final PackageInfo packageInfo;

        public ProviderAndPackageInfo(WebViewProviderInfo provider, PackageInfo packageInfo) {
            this.provider = provider;
            this.packageInfo = packageInfo;
        }
    }

    private static class WebViewPackageMissingException
    extends Exception {
        public WebViewPackageMissingException(String message) {
            super(message);
        }

        public WebViewPackageMissingException(Exception e) {
            super(e);
        }
    }
}

