/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.webkit;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.webkit.UserPackage;
import android.webkit.WebViewProviderInfo;
import android.webkit.WebViewProviderResponse;
import com.android.server.webkit.SystemInterface;
import com.android.server.webkit.WebViewUpdater;
import java.io.PrintWriter;
import java.util.List;

public class WebViewUpdateServiceImpl {
    private static final String TAG = WebViewUpdateServiceImpl.class.getSimpleName();
    private SystemInterface mSystemInterface;
    private WebViewUpdater mWebViewUpdater;
    private final Context mContext;
    private static final int MULTIPROCESS_SETTING_ON_VALUE = Integer.MAX_VALUE;
    private static final int MULTIPROCESS_SETTING_OFF_VALUE = Integer.MIN_VALUE;

    public WebViewUpdateServiceImpl(Context context, SystemInterface systemInterface) {
        this.mContext = context;
        this.mSystemInterface = systemInterface;
        this.mWebViewUpdater = new WebViewUpdater(this.mContext, this.mSystemInterface);
    }

    void packageStateChanged(String packageName, int changedState, int userId) {
        this.updateFallbackStateOnPackageChange(packageName, changedState);
        this.mWebViewUpdater.packageStateChanged(packageName, changedState);
    }

    void prepareWebViewInSystemServer() {
        this.updateFallbackStateOnBoot();
        this.mWebViewUpdater.prepareWebViewInSystemServer();
        this.mSystemInterface.notifyZygote(this.isMultiProcessEnabled());
    }

    private boolean existsValidNonFallbackProvider(WebViewProviderInfo[] providers) {
        for (WebViewProviderInfo provider : providers) {
            List<UserPackage> userPackages;
            if (!provider.availableByDefault || provider.isFallback || !WebViewUpdater.isInstalledAndEnabledForAllUsers(userPackages = this.mSystemInterface.getPackageInfoForProviderAllUsers(this.mContext, provider)) || !this.mWebViewUpdater.isValidProvider(provider, userPackages.get(0).getPackageInfo())) continue;
            return true;
        }
        return false;
    }

    void handleNewUser(int userId) {
        if (userId == 0) {
            return;
        }
        this.handleUserChange();
    }

    void handleUserRemoved(int userId) {
        this.handleUserChange();
    }

    private void handleUserChange() {
        if (this.mSystemInterface.isFallbackLogicEnabled()) {
            this.updateFallbackState(this.mSystemInterface.getWebViewPackages());
        }
        this.mWebViewUpdater.updateCurrentWebViewPackage(null);
    }

    void notifyRelroCreationCompleted() {
        this.mWebViewUpdater.notifyRelroCreationCompleted();
    }

    WebViewProviderResponse waitForAndGetProvider() {
        return this.mWebViewUpdater.waitForAndGetProvider();
    }

    String changeProviderAndSetting(String newProvider) {
        return this.mWebViewUpdater.changeProviderAndSetting(newProvider);
    }

    WebViewProviderInfo[] getValidWebViewPackages() {
        return this.mWebViewUpdater.getValidWebViewPackages();
    }

    WebViewProviderInfo[] getWebViewPackages() {
        return this.mSystemInterface.getWebViewPackages();
    }

    PackageInfo getCurrentWebViewPackage() {
        return this.mWebViewUpdater.getCurrentWebViewPackage();
    }

    void enableFallbackLogic(boolean enable) {
        this.mSystemInterface.enableFallbackLogic(enable);
    }

    private void updateFallbackStateOnBoot() {
        if (!this.mSystemInterface.isFallbackLogicEnabled()) {
            return;
        }
        WebViewProviderInfo[] webviewProviders = this.mSystemInterface.getWebViewPackages();
        this.updateFallbackState(webviewProviders);
    }

    private void updateFallbackStateOnPackageChange(String changedPackage, int changedState) {
        if (!this.mSystemInterface.isFallbackLogicEnabled()) {
            return;
        }
        WebViewProviderInfo[] webviewProviders = this.mSystemInterface.getWebViewPackages();
        boolean changedPackageAvailableByDefault = false;
        for (WebViewProviderInfo provider : webviewProviders) {
            if (!provider.packageName.equals(changedPackage)) continue;
            if (!provider.availableByDefault) break;
            changedPackageAvailableByDefault = true;
            break;
        }
        if (!changedPackageAvailableByDefault) {
            return;
        }
        this.updateFallbackState(webviewProviders);
    }

    private void updateFallbackState(WebViewProviderInfo[] webviewProviders) {
        WebViewProviderInfo fallbackProvider = WebViewUpdateServiceImpl.getFallbackProvider(webviewProviders);
        if (fallbackProvider == null) {
            return;
        }
        boolean existsValidNonFallbackProvider = this.existsValidNonFallbackProvider(webviewProviders);
        List<UserPackage> userPackages = this.mSystemInterface.getPackageInfoForProviderAllUsers(this.mContext, fallbackProvider);
        if (existsValidNonFallbackProvider && !WebViewUpdateServiceImpl.isDisabledForAllUsers(userPackages)) {
            this.mSystemInterface.uninstallAndDisablePackageForAllUsers(this.mContext, fallbackProvider.packageName);
        } else if (!existsValidNonFallbackProvider && !WebViewUpdater.isInstalledAndEnabledForAllUsers(userPackages)) {
            this.mSystemInterface.enablePackageForAllUsers(this.mContext, fallbackProvider.packageName, true);
        }
    }

    private static WebViewProviderInfo getFallbackProvider(WebViewProviderInfo[] webviewPackages) {
        for (WebViewProviderInfo provider : webviewPackages) {
            if (!provider.isFallback) continue;
            return provider;
        }
        return null;
    }

    boolean isFallbackPackage(String packageName) {
        if (packageName == null || !this.mSystemInterface.isFallbackLogicEnabled()) {
            return false;
        }
        WebViewProviderInfo[] webviewPackages = this.mSystemInterface.getWebViewPackages();
        WebViewProviderInfo fallbackProvider = WebViewUpdateServiceImpl.getFallbackProvider(webviewPackages);
        return fallbackProvider != null && packageName.equals(fallbackProvider.packageName);
    }

    boolean isMultiProcessEnabled() {
        int settingValue = this.mSystemInterface.getMultiProcessSetting(this.mContext);
        if (this.mSystemInterface.isMultiProcessDefaultEnabled()) {
            return settingValue > Integer.MIN_VALUE;
        }
        return settingValue >= Integer.MAX_VALUE;
    }

    void enableMultiProcess(boolean enable) {
        PackageInfo current = this.getCurrentWebViewPackage();
        this.mSystemInterface.setMultiProcessSetting(this.mContext, enable ? Integer.MAX_VALUE : Integer.MIN_VALUE);
        this.mSystemInterface.notifyZygote(enable);
        if (current != null) {
            this.mSystemInterface.killPackageDependents(current.packageName);
        }
    }

    private static boolean isDisabledForAllUsers(List<UserPackage> userPackages) {
        for (UserPackage userPackage : userPackages) {
            if (userPackage.getPackageInfo() == null || !userPackage.isEnabledPackage()) continue;
            return false;
        }
        return true;
    }

    void dumpState(PrintWriter pw) {
        pw.println("Current WebView Update Service state");
        pw.println(String.format("  Fallback logic enabled: %b", this.mSystemInterface.isFallbackLogicEnabled()));
        pw.println(String.format("  Multiprocess enabled: %b", this.isMultiProcessEnabled()));
        this.mWebViewUpdater.dumpState(pw);
    }
}

