/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.vr;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.util.ArraySet;
import java.util.Objects;
import java.util.Set;

public class SettingsObserver {
    private final String mSecureSettingName;
    private final BroadcastReceiver mSettingRestoreReceiver;
    private final ContentObserver mContentObserver;
    private final Set<SettingChangeListener> mSettingsListeners = new ArraySet<SettingChangeListener>();

    private SettingsObserver(Context context, Handler handler, final Uri settingUri, final String secureSettingName) {
        this.mSecureSettingName = secureSettingName;
        this.mSettingRestoreReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String element;
                if ("android.os.action.SETTING_RESTORED".equals(intent.getAction()) && Objects.equals(element = intent.getStringExtra("setting_name"), secureSettingName)) {
                    String prevValue = intent.getStringExtra("previous_value");
                    String newValue = intent.getStringExtra("new_value");
                    SettingsObserver.this.sendSettingRestored(prevValue, newValue, this.getSendingUserId());
                }
            }
        };
        this.mContentObserver = new ContentObserver(handler){

            @Override
            public void onChange(boolean selfChange, Uri uri) {
                if (uri == null || settingUri.equals(uri)) {
                    SettingsObserver.this.sendSettingChanged();
                }
            }
        };
        ContentResolver resolver = context.getContentResolver();
        resolver.registerContentObserver(settingUri, false, this.mContentObserver, -1);
    }

    public static SettingsObserver build(Context context, Handler handler, String settingName) {
        Uri settingUri = Settings.Secure.getUriFor(settingName);
        return new SettingsObserver(context, handler, settingUri, settingName);
    }

    public void addListener(SettingChangeListener listener) {
        this.mSettingsListeners.add(listener);
    }

    public void removeListener(SettingChangeListener listener) {
        this.mSettingsListeners.remove(listener);
    }

    private void sendSettingChanged() {
        for (SettingChangeListener l : this.mSettingsListeners) {
            l.onSettingChanged();
        }
    }

    private void sendSettingRestored(String prevValue, String newValue, int userId) {
        for (SettingChangeListener l : this.mSettingsListeners) {
            l.onSettingRestored(prevValue, newValue, userId);
        }
    }

    public static interface SettingChangeListener {
        public void onSettingChanged();

        public void onSettingRestored(String var1, String var2, int var3);
    }
}

