/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.voiceinteraction;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.assist.AssistContent;
import android.app.assist.AssistStructure;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.voice.IVoiceInteractionSession;
import android.service.voice.IVoiceInteractionSessionService;
import android.util.Slog;
import android.view.IWindowManager;
import com.android.internal.app.AssistUtils;
import com.android.internal.app.IVoiceInteractionSessionShowCallback;
import com.android.internal.app.IVoiceInteractor;
import com.android.server.LocalServices;
import com.android.server.am.AssistDataRequester;
import com.android.server.statusbar.StatusBarManagerInternal;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

final class VoiceInteractionSessionConnection
implements ServiceConnection,
AssistDataRequester.AssistDataRequesterCallbacks {
    static final String TAG = "VoiceInteractionServiceManager";
    final IBinder mToken = new Binder();
    final Object mLock;
    final ComponentName mSessionComponentName;
    final Intent mBindIntent;
    final int mUser;
    final Context mContext;
    final Callback mCallback;
    final int mCallingUid;
    final Handler mHandler;
    final IActivityManager mAm;
    final IWindowManager mIWindowManager;
    final AppOpsManager mAppOps;
    final IBinder mPermissionOwner;
    boolean mShown;
    Bundle mShowArgs;
    int mShowFlags;
    boolean mBound;
    boolean mFullyBound;
    boolean mCanceled;
    IVoiceInteractionSessionService mService;
    IVoiceInteractionSession mSession;
    IVoiceInteractor mInteractor;
    ArrayList<IVoiceInteractionSessionShowCallback> mPendingShowCallbacks = new ArrayList();
    AssistDataRequester mAssistDataRequester;
    IVoiceInteractionSessionShowCallback mShowCallback = new IVoiceInteractionSessionShowCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailed() throws RemoteException {
            Object object = VoiceInteractionSessionConnection.this.mLock;
            synchronized (object) {
                VoiceInteractionSessionConnection.this.notifyPendingShowCallbacksFailedLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onShown() throws RemoteException {
            Object object = VoiceInteractionSessionConnection.this.mLock;
            synchronized (object) {
                VoiceInteractionSessionConnection.this.notifyPendingShowCallbacksShownLocked();
            }
        }
    };
    final ServiceConnection mFullConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    };
    private Runnable mShowAssistDisclosureRunnable = new Runnable(){

        @Override
        public void run() {
            StatusBarManagerInternal statusBarInternal = LocalServices.getService(StatusBarManagerInternal.class);
            if (statusBarInternal != null) {
                statusBarInternal.showAssistDisclosure();
            }
        }
    };

    public VoiceInteractionSessionConnection(Object lock, ComponentName component, int user, Context context, Callback callback, int callingUid, Handler handler) {
        this.mLock = lock;
        this.mSessionComponentName = component;
        this.mUser = user;
        this.mContext = context;
        this.mCallback = callback;
        this.mCallingUid = callingUid;
        this.mHandler = handler;
        this.mAm = ActivityManager.getService();
        this.mIWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        this.mAssistDataRequester = new AssistDataRequester(this.mContext, this.mAm, this.mIWindowManager, (AppOpsManager)this.mContext.getSystemService("appops"), this, this.mLock, 49, 50);
        IBinder permOwner = null;
        try {
            permOwner = this.mAm.newUriPermissionOwner("voicesession:" + component.flattenToShortString());
        }
        catch (RemoteException e) {
            Slog.w("voicesession", "AM dead", e);
        }
        this.mPermissionOwner = permOwner;
        this.mBindIntent = new Intent("android.service.voice.VoiceInteractionService");
        this.mBindIntent.setComponent(this.mSessionComponentName);
        this.mBound = this.mContext.bindServiceAsUser(this.mBindIntent, this, 49, new UserHandle(this.mUser));
        if (this.mBound) {
            try {
                this.mIWindowManager.addWindowToken(this.mToken, 2031, 0);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed adding window token", e);
            }
        } else {
            Slog.w(TAG, "Failed binding to voice interaction session service " + this.mSessionComponentName);
        }
    }

    public int getUserDisabledShowContextLocked() {
        int flags = 0;
        if (Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "assist_structure_enabled", 1, this.mUser) == 0) {
            flags |= 1;
        }
        if (Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "assist_screenshot_enabled", 1, this.mUser) == 0) {
            flags |= 2;
        }
        return flags;
    }

    public boolean showLocked(Bundle args, int flags, int disabledContext, IVoiceInteractionSessionShowCallback showCallback, List<IBinder> topActivities) {
        if (this.mBound) {
            boolean needDisclosure;
            if (!this.mFullyBound) {
                this.mFullyBound = this.mContext.bindServiceAsUser(this.mBindIntent, this.mFullConnection, 0xC000001, new UserHandle(this.mUser));
            }
            this.mShown = true;
            this.mShowArgs = args;
            this.mShowFlags = flags;
            this.mAssistDataRequester.requestAssistData(topActivities, (flags & 1) != 0, (flags & 2) != 0, ((disabledContext |= this.getUserDisabledShowContextLocked()) & 1) == 0, (disabledContext & 2) == 0, this.mCallingUid, this.mSessionComponentName.getPackageName());
            boolean bl = needDisclosure = this.mAssistDataRequester.getPendingDataCount() > 0 || this.mAssistDataRequester.getPendingScreenshotCount() > 0;
            if (needDisclosure && AssistUtils.shouldDisclose(this.mContext, this.mSessionComponentName)) {
                this.mHandler.post(this.mShowAssistDisclosureRunnable);
            }
            if (this.mSession != null) {
                try {
                    this.mSession.show(this.mShowArgs, this.mShowFlags, showCallback);
                    this.mShowArgs = null;
                    this.mShowFlags = 0;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mAssistDataRequester.processPendingAssistData();
            } else if (showCallback != null) {
                this.mPendingShowCallbacks.add(showCallback);
            }
            this.mCallback.onSessionShown(this);
            return true;
        }
        if (showCallback != null) {
            try {
                showCallback.onFailed();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean canHandleReceivedAssistDataLocked() {
        return this.mSession != null;
    }

    @Override
    public void onAssistDataReceivedLocked(Bundle data, int activityIndex, int activityCount) {
        if (this.mSession == null) {
            return;
        }
        if (data == null) {
            try {
                this.mSession.handleAssist(null, null, null, 0, 0);
            }
            catch (RemoteException remoteException) {}
        } else {
            Bundle assistData = data.getBundle("data");
            AssistStructure structure = (AssistStructure)data.getParcelable("structure");
            AssistContent content = (AssistContent)data.getParcelable("content");
            int uid = data.getInt("android.intent.extra.ASSIST_UID", -1);
            if (uid >= 0 && content != null) {
                ClipData clipData;
                Intent intent = content.getIntent();
                if (intent != null && (clipData = intent.getClipData()) != null && Intent.isAccessUriMode(intent.getFlags())) {
                    this.grantClipDataPermissions(clipData, intent.getFlags(), uid, this.mCallingUid, this.mSessionComponentName.getPackageName());
                }
                if ((clipData = content.getClipData()) != null) {
                    this.grantClipDataPermissions(clipData, 1, uid, this.mCallingUid, this.mSessionComponentName.getPackageName());
                }
            }
            try {
                this.mSession.handleAssist(assistData, structure, content, activityIndex, activityCount);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onAssistScreenshotReceivedLocked(Bitmap screenshot) {
        if (this.mSession == null) {
            return;
        }
        try {
            this.mSession.handleScreenshot(screenshot);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grantUriPermission(Uri uri, int mode, int srcUid, int destUid, String destPkg) {
        if (!"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mAm.checkGrantUriPermission(srcUid, null, ContentProvider.getUriWithoutUserId(uri), mode, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(srcUid)));
            int sourceUserId = ContentProvider.getUserIdFromUri(uri, this.mUser);
            uri = ContentProvider.getUriWithoutUserId(uri);
            this.mAm.grantUriPermissionFromOwner(this.mPermissionOwner, srcUid, destPkg, uri, 1, sourceUserId, this.mUser);
        }
        catch (RemoteException sourceUserId) {
        }
        catch (SecurityException e) {
            Slog.w(TAG, "Can't propagate permission", e);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    void grantClipDataItemPermission(ClipData.Item item, int mode, int srcUid, int destUid, String destPkg) {
        Intent intent;
        if (item.getUri() != null) {
            this.grantUriPermission(item.getUri(), mode, srcUid, destUid, destPkg);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.grantUriPermission(intent.getData(), mode, srcUid, destUid, destPkg);
        }
    }

    void grantClipDataPermissions(ClipData data, int mode, int srcUid, int destUid, String destPkg) {
        int N = data.getItemCount();
        for (int i = 0; i < N; ++i) {
            this.grantClipDataItemPermission(data.getItemAt(i), mode, srcUid, destUid, destPkg);
        }
    }

    public boolean hideLocked() {
        if (this.mBound) {
            if (this.mShown) {
                this.mShown = false;
                this.mShowArgs = null;
                this.mShowFlags = 0;
                this.mAssistDataRequester.cancel();
                this.mPendingShowCallbacks.clear();
                if (this.mSession != null) {
                    try {
                        this.mSession.hide();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                try {
                    this.mAm.revokeUriPermissionFromOwner(this.mPermissionOwner, null, 3, this.mUser);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (this.mSession != null) {
                    try {
                        this.mAm.finishVoiceTask(this.mSession);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.mCallback.onSessionHidden(this);
            }
            if (this.mFullyBound) {
                this.mContext.unbindService(this.mFullConnection);
                this.mFullyBound = false;
            }
            return true;
        }
        return false;
    }

    public void cancelLocked(boolean finishTask) {
        this.hideLocked();
        this.mCanceled = true;
        if (this.mBound) {
            if (this.mSession != null) {
                try {
                    this.mSession.destroy();
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Voice interation session already dead");
                }
            }
            if (finishTask && this.mSession != null) {
                try {
                    this.mAm.finishVoiceTask(this.mSession);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            this.mContext.unbindService(this);
            try {
                this.mIWindowManager.removeWindowToken(this.mToken, 0);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed removing window token", e);
            }
            this.mBound = false;
            this.mService = null;
            this.mSession = null;
            this.mInteractor = null;
        }
        if (this.mFullyBound) {
            this.mContext.unbindService(this.mFullConnection);
            this.mFullyBound = false;
        }
    }

    public boolean deliverNewSessionLocked(IVoiceInteractionSession session, IVoiceInteractor interactor) {
        this.mSession = session;
        this.mInteractor = interactor;
        if (this.mShown) {
            try {
                session.show(this.mShowArgs, this.mShowFlags, this.mShowCallback);
                this.mShowArgs = null;
                this.mShowFlags = 0;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mAssistDataRequester.processPendingAssistData();
        }
        return true;
    }

    private void notifyPendingShowCallbacksShownLocked() {
        for (int i = 0; i < this.mPendingShowCallbacks.size(); ++i) {
            try {
                this.mPendingShowCallbacks.get(i).onShown();
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mPendingShowCallbacks.clear();
    }

    private void notifyPendingShowCallbacksFailedLocked() {
        for (int i = 0; i < this.mPendingShowCallbacks.size(); ++i) {
            try {
                this.mPendingShowCallbacks.get(i).onFailed();
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mPendingShowCallbacks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        Object object = this.mLock;
        synchronized (object) {
            this.mService = IVoiceInteractionSessionService.Stub.asInterface(service);
            if (!this.mCanceled) {
                try {
                    this.mService.newSession(this.mToken, this.mShowArgs, this.mShowFlags);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Failed adding window token", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDisconnected(ComponentName name) {
        this.mCallback.sessionConnectionGone(this);
        Object object = this.mLock;
        synchronized (object) {
            this.mService = null;
        }
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mToken=");
        pw.println(this.mToken);
        pw.print(prefix);
        pw.print("mShown=");
        pw.println(this.mShown);
        pw.print(prefix);
        pw.print("mShowArgs=");
        pw.println(this.mShowArgs);
        pw.print(prefix);
        pw.print("mShowFlags=0x");
        pw.println(Integer.toHexString(this.mShowFlags));
        pw.print(prefix);
        pw.print("mBound=");
        pw.println(this.mBound);
        if (this.mBound) {
            pw.print(prefix);
            pw.print("mService=");
            pw.println(this.mService);
            pw.print(prefix);
            pw.print("mSession=");
            pw.println(this.mSession);
            pw.print(prefix);
            pw.print("mInteractor=");
            pw.println(this.mInteractor);
        }
        this.mAssistDataRequester.dump(prefix, pw);
    }

    public static interface Callback {
        public void sessionConnectionGone(VoiceInteractionSessionConnection var1);

        public void onSessionShown(VoiceInteractionSessionConnection var1);

        public void onSessionHidden(VoiceInteractionSessionConnection var1);
    }
}

