/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors.report;

import com.android.server.usb.descriptors.UsbDescriptorParser;
import com.android.server.usb.descriptors.report.ReportCanvas;

public final class HTMLReportCanvas
extends ReportCanvas {
    private static final String TAG = "HTMLReportCanvas";
    private final StringBuilder mStringBuilder;

    public HTMLReportCanvas(UsbDescriptorParser parser, StringBuilder stringBuilder) {
        super(parser);
        this.mStringBuilder = stringBuilder;
    }

    @Override
    public void write(String text) {
        this.mStringBuilder.append(text);
    }

    @Override
    public void openHeader(int level) {
        this.mStringBuilder.append("<h").append(level).append('>');
    }

    @Override
    public void closeHeader(int level) {
        this.mStringBuilder.append("</h").append(level).append('>');
    }

    @Override
    public void openParagraph(boolean emphasis) {
        if (emphasis) {
            this.mStringBuilder.append("<p style=\"color:red\">");
        } else {
            this.mStringBuilder.append("<p>");
        }
    }

    @Override
    public void closeParagraph() {
        this.mStringBuilder.append("</p>");
    }

    @Override
    public void writeParagraph(String text, boolean inRed) {
        this.openParagraph(inRed);
        this.mStringBuilder.append(text);
        this.closeParagraph();
    }

    @Override
    public void openList() {
        this.mStringBuilder.append("<ul>");
    }

    @Override
    public void closeList() {
        this.mStringBuilder.append("</ul>");
    }

    @Override
    public void openListItem() {
        this.mStringBuilder.append("<li>");
    }

    @Override
    public void closeListItem() {
        this.mStringBuilder.append("</li>");
    }
}

