/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbInterface;
import android.os.Parcelable;
import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.UsbDescriptorParser;
import com.android.server.usb.descriptors.UsbInterfaceDescriptor;
import com.android.server.usb.descriptors.report.ReportCanvas;
import java.util.ArrayList;

public final class UsbConfigDescriptor
extends UsbDescriptor {
    private static final String TAG = "UsbConfigDescriptor";
    private static final boolean DEBUG = false;
    private int mTotalLength;
    private byte mNumInterfaces;
    private int mConfigValue;
    private byte mConfigIndex;
    private int mAttribs;
    private int mMaxPower;
    private ArrayList<UsbInterfaceDescriptor> mInterfaceDescriptors = new ArrayList();

    UsbConfigDescriptor(int length, byte type) {
        super(length, type);
        this.mHierarchyLevel = 2;
    }

    public int getTotalLength() {
        return this.mTotalLength;
    }

    public byte getNumInterfaces() {
        return this.mNumInterfaces;
    }

    public int getConfigValue() {
        return this.mConfigValue;
    }

    public byte getConfigIndex() {
        return this.mConfigIndex;
    }

    public int getAttribs() {
        return this.mAttribs;
    }

    public int getMaxPower() {
        return this.mMaxPower;
    }

    void addInterfaceDescriptor(UsbInterfaceDescriptor interfaceDesc) {
        this.mInterfaceDescriptors.add(interfaceDesc);
    }

    UsbConfiguration toAndroid(UsbDescriptorParser parser) {
        String name = parser.getDescriptorString(this.mConfigIndex);
        UsbConfiguration config = new UsbConfiguration(this.mConfigValue, name, this.mAttribs, this.mMaxPower);
        Parcelable[] interfaces = new UsbInterface[this.mInterfaceDescriptors.size()];
        for (int index = 0; index < this.mInterfaceDescriptors.size(); ++index) {
            interfaces[index] = this.mInterfaceDescriptors.get(index).toAndroid(parser);
        }
        config.setInterfaces(interfaces);
        return config;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mTotalLength = stream.unpackUsbShort();
        this.mNumInterfaces = stream.getByte();
        this.mConfigValue = stream.getUnsignedByte();
        this.mConfigIndex = stream.getByte();
        this.mAttribs = stream.getUnsignedByte();
        this.mMaxPower = stream.getUnsignedByte();
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.openList();
        canvas.writeListItem("Config # " + this.getConfigValue());
        canvas.writeListItem(this.getNumInterfaces() + " Interfaces.");
        canvas.writeListItem("Attributes: " + ReportCanvas.getHexString(this.getAttribs()));
        canvas.closeList();
    }
}

