/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.XmlResourceParser;
import android.hardware.usb.AccessoryFilter;
import android.hardware.usb.DeviceFilter;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.Immutable;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.server.usb.MtpNotificationManager;
import com.android.server.usb.UsbSettingsManager;
import com.android.server.usb.UsbUserSettingsManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class UsbProfileGroupSettingsManager {
    private static final String TAG = UsbProfileGroupSettingsManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final File sSingleUserSettingsFile = new File("/data/system/usb_device_manager.xml");
    private final UserHandle mParentUser;
    private final AtomicFile mSettingsFile;
    private final boolean mDisablePermissionDialogs;
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final UserManager mUserManager;
    private final UsbSettingsManager mSettingsManager;
    @GuardedBy(value="mLock")
    private final HashMap<DeviceFilter, UserPackage> mDevicePreferenceMap = new HashMap();
    @GuardedBy(value="mLock")
    private final HashMap<AccessoryFilter, UserPackage> mAccessoryPreferenceMap = new HashMap();
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private boolean mIsWriteSettingsScheduled;
    MyPackageMonitor mPackageMonitor = new MyPackageMonitor();
    private final MtpNotificationManager mMtpNotificationManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UsbProfileGroupSettingsManager(Context context, UserHandle user, UsbSettingsManager settingsManager) {
        Context parentUserContext;
        try {
            parentUserContext = context.createPackageContextAsUser("android", 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Missing android package");
        }
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mSettingsManager = settingsManager;
        this.mUserManager = (UserManager)context.getSystemService("user");
        this.mParentUser = user;
        this.mSettingsFile = new AtomicFile(new File(Environment.getUserSystemDirectory(user.getIdentifier()), "usb_device_manager.xml"), "usb-state");
        this.mDisablePermissionDialogs = context.getResources().getBoolean(17956932);
        Object object = this.mLock;
        synchronized (object) {
            if (UserHandle.SYSTEM.equals(user)) {
                this.upgradeSingleUserLocked();
            }
            this.readSettingsLocked();
        }
        this.mPackageMonitor.register(context, null, UserHandle.ALL, true);
        this.mMtpNotificationManager = new MtpNotificationManager(parentUserContext, device -> this.resolveActivity(UsbProfileGroupSettingsManager.createDeviceAttachedIntent(device), device, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllDefaultsForUser(UserHandle userToRemove) {
        Object object = this.mLock;
        synchronized (object) {
            boolean needToPersist = false;
            Iterator<Map.Entry<DeviceFilter, UserPackage>> devicePreferenceIt = this.mDevicePreferenceMap.entrySet().iterator();
            while (devicePreferenceIt.hasNext()) {
                Map.Entry<DeviceFilter, UserPackage> entry = devicePreferenceIt.next();
                if (!entry.getValue().user.equals(userToRemove)) continue;
                devicePreferenceIt.remove();
                needToPersist = true;
            }
            Iterator<Map.Entry<AccessoryFilter, UserPackage>> accessoryPreferenceIt = this.mAccessoryPreferenceMap.entrySet().iterator();
            while (accessoryPreferenceIt.hasNext()) {
                Map.Entry<AccessoryFilter, UserPackage> entry = accessoryPreferenceIt.next();
                if (!entry.getValue().user.equals(userToRemove)) continue;
                accessoryPreferenceIt.remove();
                needToPersist = true;
            }
            if (needToPersist) {
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    private void readPreference(XmlPullParser parser) throws XmlPullParserException, IOException {
        String packageName = null;
        UserHandle user = this.mParentUser;
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if ("package".equals(parser.getAttributeName(i))) {
                packageName = parser.getAttributeValue(i);
            }
            if (!"user".equals(parser.getAttributeName(i))) continue;
            user = this.mUserManager.getUserForSerialNumber(Integer.parseInt(parser.getAttributeValue(i)));
        }
        XmlUtils.nextElement(parser);
        if ("usb-device".equals(parser.getName())) {
            DeviceFilter filter = DeviceFilter.read(parser);
            if (user != null) {
                this.mDevicePreferenceMap.put(filter, new UserPackage(packageName, user));
            }
        } else if ("usb-accessory".equals(parser.getName())) {
            AccessoryFilter filter = AccessoryFilter.read(parser);
            if (user != null) {
                this.mAccessoryPreferenceMap.put(filter, new UserPackage(packageName, user));
            }
        }
        XmlUtils.nextElement(parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mLock")
    private void upgradeSingleUserLocked() {
        block6: {
            if (!sSingleUserSettingsFile.exists()) break block6;
            this.mDevicePreferenceMap.clear();
            this.mAccessoryPreferenceMap.clear();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(sSingleUserSettingsFile);
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(fis, StandardCharsets.UTF_8.name());
                XmlUtils.nextElement(parser);
                while (parser.getEventType() != 1) {
                    String tagName = parser.getName();
                    if ("preference".equals(tagName)) {
                        this.readPreference(parser);
                        continue;
                    }
                    XmlUtils.nextElement(parser);
                }
            }
            catch (IOException | XmlPullParserException e) {
                try {
                    Log.wtf(TAG, "Failed to read single-user settings", e);
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fis);
                    throw throwable;
                }
                IoUtils.closeQuietly(fis);
            }
            IoUtils.closeQuietly(fis);
            this.scheduleWriteSettingsLocked();
            sSingleUserSettingsFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mLock")
    private void readSettingsLocked() {
        this.mDevicePreferenceMap.clear();
        this.mAccessoryPreferenceMap.clear();
        FileInputStream stream = null;
        try {
            stream = this.mSettingsFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            XmlUtils.nextElement(parser);
            while (parser.getEventType() != 1) {
                String tagName = parser.getName();
                if ("preference".equals(tagName)) {
                    this.readPreference(parser);
                    continue;
                }
                XmlUtils.nextElement(parser);
            }
        }
        catch (FileNotFoundException parser) {
        }
        catch (Exception e) {
            Slog.e(TAG, "error reading settings file, deleting to start fresh", e);
            this.mSettingsFile.delete();
        }
        finally {
            IoUtils.closeQuietly(stream);
        }
    }

    @GuardedBy(value="mLock")
    private void scheduleWriteSettingsLocked() {
        if (this.mIsWriteSettingsScheduled) {
            return;
        }
        this.mIsWriteSettingsScheduled = true;
        AsyncTask.execute(() -> {
            Object object = this.mLock;
            synchronized (object) {
                block7: {
                    FileOutputStream fos = null;
                    try {
                        fos = this.mSettingsFile.startWrite();
                        FastXmlSerializer serializer = new FastXmlSerializer();
                        serializer.setOutput(fos, StandardCharsets.UTF_8.name());
                        serializer.startDocument(null, true);
                        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                        serializer.startTag(null, "settings");
                        for (DeviceFilter deviceFilter : this.mDevicePreferenceMap.keySet()) {
                            serializer.startTag(null, "preference");
                            serializer.attribute(null, "package", this.mDevicePreferenceMap.get((Object)deviceFilter).packageName);
                            serializer.attribute(null, "user", String.valueOf(this.getSerial(this.mDevicePreferenceMap.get((Object)deviceFilter).user)));
                            deviceFilter.write(serializer);
                            serializer.endTag(null, "preference");
                        }
                        for (AccessoryFilter accessoryFilter : this.mAccessoryPreferenceMap.keySet()) {
                            serializer.startTag(null, "preference");
                            serializer.attribute(null, "package", this.mAccessoryPreferenceMap.get((Object)accessoryFilter).packageName);
                            serializer.attribute(null, "user", String.valueOf(this.getSerial(this.mAccessoryPreferenceMap.get((Object)accessoryFilter).user)));
                            accessoryFilter.write(serializer);
                            serializer.endTag(null, "preference");
                        }
                        serializer.endTag(null, "settings");
                        serializer.endDocument();
                        this.mSettingsFile.finishWrite(fos);
                    }
                    catch (IOException e) {
                        Slog.e(TAG, "Failed to write settings", e);
                        if (fos == null) break block7;
                        this.mSettingsFile.failWrite(fos);
                    }
                }
                this.mIsWriteSettingsScheduled = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean packageMatchesLocked(ResolveInfo info, String metaDataName, UsbDevice device, UsbAccessory accessory) {
        if (this.isForwardMatch(info)) {
            return true;
        }
        ActivityInfo ai = info.activityInfo;
        try (XmlResourceParser parser = null;){
            parser = ai.loadXmlMetaData(this.mPackageManager, metaDataName);
            if (parser == null) {
                Slog.w(TAG, "no meta-data for " + info);
                boolean bl = false;
                return bl;
            }
            XmlUtils.nextElement(parser);
            while (parser.getEventType() != 1) {
                Object filter;
                String tagName = parser.getName();
                if (device != null && "usb-device".equals(tagName)) {
                    filter = DeviceFilter.read(parser);
                    if (((DeviceFilter)filter).matches(device)) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (accessory != null && "usb-accessory".equals(tagName) && ((AccessoryFilter)(filter = AccessoryFilter.read(parser))).matches(accessory)) {
                    boolean bl = true;
                    return bl;
                }
                XmlUtils.nextElement(parser);
            }
        }
        return false;
    }

    private ArrayList<ResolveInfo> queryIntentActivitiesForAllProfiles(Intent intent) {
        List<UserInfo> profiles = this.mUserManager.getEnabledProfiles(this.mParentUser.getIdentifier());
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        int numProfiles = profiles.size();
        for (int i = 0; i < numProfiles; ++i) {
            resolveInfos.addAll(this.mPackageManager.queryIntentActivitiesAsUser(intent, 128, profiles.get((int)i).id));
        }
        return resolveInfos;
    }

    private boolean isForwardMatch(ResolveInfo match) {
        return match.getComponentInfo().name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE);
    }

    private ArrayList<ResolveInfo> preferHighPriority(ArrayList<ResolveInfo> matches) {
        SparseArray highestPriorityMatchesByUserId = new SparseArray();
        SparseIntArray highestPriorityByUserId = new SparseIntArray();
        ArrayList<ResolveInfo> forwardMatches = new ArrayList<ResolveInfo>();
        int numMatches = matches.size();
        for (int matchNum = 0; matchNum < numMatches; ++matchNum) {
            ResolveInfo match = matches.get(matchNum);
            if (this.isForwardMatch(match)) {
                forwardMatches.add(match);
                continue;
            }
            if (highestPriorityByUserId.indexOfKey(match.targetUserId) < 0) {
                highestPriorityByUserId.put(match.targetUserId, Integer.MIN_VALUE);
                highestPriorityMatchesByUserId.put(match.targetUserId, new ArrayList());
            }
            int highestPriority = highestPriorityByUserId.get(match.targetUserId);
            ArrayList highestPriorityMatches = (ArrayList)highestPriorityMatchesByUserId.get(match.targetUserId);
            if (match.priority == highestPriority) {
                highestPriorityMatches.add(match);
                continue;
            }
            if (match.priority <= highestPriority) continue;
            highestPriorityByUserId.put(match.targetUserId, match.priority);
            highestPriorityMatches.clear();
            highestPriorityMatches.add(match);
        }
        ArrayList<ResolveInfo> combinedMatches = new ArrayList<ResolveInfo>(forwardMatches);
        int numMatchArrays = highestPriorityMatchesByUserId.size();
        for (int matchArrayNum = 0; matchArrayNum < numMatchArrays; ++matchArrayNum) {
            combinedMatches.addAll((Collection)highestPriorityMatchesByUserId.valueAt(matchArrayNum));
        }
        return combinedMatches;
    }

    private ArrayList<ResolveInfo> removeForwardIntentIfNotNeeded(ArrayList<ResolveInfo> rawMatches) {
        int numRawMatches = rawMatches.size();
        int numParentActivityMatches = 0;
        int numNonParentActivityMatches = 0;
        for (int i = 0; i < numRawMatches; ++i) {
            ResolveInfo rawMatch = rawMatches.get(i);
            if (this.isForwardMatch(rawMatch)) continue;
            if (UserHandle.getUserHandleForUid(rawMatch.activityInfo.applicationInfo.uid).equals(this.mParentUser)) {
                ++numParentActivityMatches;
                continue;
            }
            ++numNonParentActivityMatches;
        }
        if (numParentActivityMatches == 0 || numNonParentActivityMatches == 0) {
            ArrayList<ResolveInfo> matches = new ArrayList<ResolveInfo>(numParentActivityMatches + numNonParentActivityMatches);
            for (int i = 0; i < numRawMatches; ++i) {
                ResolveInfo rawMatch = rawMatches.get(i);
                if (this.isForwardMatch(rawMatch)) continue;
                matches.add(rawMatch);
            }
            return matches;
        }
        return rawMatches;
    }

    private ArrayList<ResolveInfo> getDeviceMatchesLocked(UsbDevice device, Intent intent) {
        ArrayList<ResolveInfo> matches = new ArrayList<ResolveInfo>();
        ArrayList<ResolveInfo> resolveInfos = this.queryIntentActivitiesForAllProfiles(intent);
        int count = resolveInfos.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(i);
            if (!this.packageMatchesLocked(resolveInfo, intent.getAction(), device, null)) continue;
            matches.add(resolveInfo);
        }
        return this.removeForwardIntentIfNotNeeded(this.preferHighPriority(matches));
    }

    private ArrayList<ResolveInfo> getAccessoryMatchesLocked(UsbAccessory accessory, Intent intent) {
        ArrayList<ResolveInfo> matches = new ArrayList<ResolveInfo>();
        ArrayList<ResolveInfo> resolveInfos = this.queryIntentActivitiesForAllProfiles(intent);
        int count = resolveInfos.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(i);
            if (!this.packageMatchesLocked(resolveInfo, intent.getAction(), null, accessory)) continue;
            matches.add(resolveInfo);
        }
        return this.removeForwardIntentIfNotNeeded(this.preferHighPriority(matches));
    }

    public void deviceAttached(UsbDevice device) {
        Intent intent = UsbProfileGroupSettingsManager.createDeviceAttachedIntent(device);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        this.resolveActivity(intent, device, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveActivity(Intent intent, UsbDevice device, boolean showMtpNotification) {
        ActivityInfo defaultActivity;
        ArrayList<ResolveInfo> matches;
        Object object = this.mLock;
        synchronized (object) {
            matches = this.getDeviceMatchesLocked(device, intent);
            defaultActivity = this.getDefaultActivityLocked(matches, this.mDevicePreferenceMap.get(new DeviceFilter(device)));
        }
        if (showMtpNotification && MtpNotificationManager.shouldShowNotification(this.mPackageManager, device) && defaultActivity == null) {
            this.mMtpNotificationManager.showNotification(device);
            return;
        }
        this.resolveActivity(intent, matches, defaultActivity, device, null);
    }

    public void deviceAttachedForFixedHandler(UsbDevice device, ComponentName component) {
        ApplicationInfo appInfo;
        Intent intent = UsbProfileGroupSettingsManager.createDeviceAttachedIntent(device);
        this.mContext.sendBroadcast(intent);
        try {
            appInfo = this.mPackageManager.getApplicationInfoAsUser(component.getPackageName(), 0, this.mParentUser.getIdentifier());
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Default USB handling package (" + component.getPackageName() + ") not found  for user " + this.mParentUser);
            return;
        }
        this.mSettingsManager.getSettingsForUser(UserHandle.getUserId(appInfo.uid)).grantDevicePermission(device, appInfo.uid);
        Intent activityIntent = new Intent(intent);
        activityIntent.setComponent(component);
        try {
            this.mContext.startActivityAsUser(activityIntent, this.mParentUser);
        }
        catch (ActivityNotFoundException e) {
            Slog.e(TAG, "unable to start activity " + activityIntent);
        }
    }

    void usbDeviceRemoved(UsbDevice device) {
        this.mMtpNotificationManager.hideNotification(device.getDeviceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessoryAttached(UsbAccessory accessory) {
        ActivityInfo defaultActivity;
        ArrayList<ResolveInfo> matches;
        Intent intent = new Intent("android.hardware.usb.action.USB_ACCESSORY_ATTACHED");
        intent.putExtra("accessory", accessory);
        intent.addFlags(0x11000000);
        Object object = this.mLock;
        synchronized (object) {
            matches = this.getAccessoryMatchesLocked(accessory, intent);
            defaultActivity = this.getDefaultActivityLocked(matches, this.mAccessoryPreferenceMap.get(new AccessoryFilter(accessory)));
        }
        this.resolveActivity(intent, matches, defaultActivity, null, accessory);
    }

    private void resolveActivity(Intent intent, ArrayList<ResolveInfo> matches, ActivityInfo defaultActivity, UsbDevice device, UsbAccessory accessory) {
        if (matches.size() == 0) {
            String uri;
            if (accessory != null && (uri = accessory.getUri()) != null && uri.length() > 0) {
                Intent dialogIntent = new Intent();
                dialogIntent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbAccessoryUriActivity");
                dialogIntent.addFlags(0x10000000);
                dialogIntent.putExtra("accessory", accessory);
                dialogIntent.putExtra("uri", uri);
                try {
                    this.mContext.startActivityAsUser(dialogIntent, this.mParentUser);
                }
                catch (ActivityNotFoundException e) {
                    Slog.e(TAG, "unable to start UsbAccessoryUriActivity");
                }
            }
            return;
        }
        if (defaultActivity != null) {
            UsbUserSettingsManager defaultRIUserSettings = this.mSettingsManager.getSettingsForUser(UserHandle.getUserId(defaultActivity.applicationInfo.uid));
            if (device != null) {
                defaultRIUserSettings.grantDevicePermission(device, defaultActivity.applicationInfo.uid);
            } else if (accessory != null) {
                defaultRIUserSettings.grantAccessoryPermission(accessory, defaultActivity.applicationInfo.uid);
            }
            try {
                intent.setComponent(new ComponentName(defaultActivity.packageName, defaultActivity.name));
                UserHandle user = UserHandle.getUserHandleForUid(defaultActivity.applicationInfo.uid);
                this.mContext.startActivityAsUser(intent, user);
            }
            catch (ActivityNotFoundException e) {
                Slog.e(TAG, "startActivity failed", e);
            }
        } else {
            UserHandle user;
            Intent resolverIntent = new Intent();
            resolverIntent.addFlags(0x10000000);
            if (matches.size() == 1) {
                ResolveInfo rInfo = matches.get(0);
                resolverIntent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbConfirmActivity");
                resolverIntent.putExtra("rinfo", rInfo);
                user = UserHandle.getUserHandleForUid(rInfo.activityInfo.applicationInfo.uid);
                if (device != null) {
                    resolverIntent.putExtra("device", device);
                } else {
                    resolverIntent.putExtra("accessory", accessory);
                }
            } else {
                user = this.mParentUser;
                resolverIntent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbResolverActivity");
                resolverIntent.putParcelableArrayListExtra("rlist", matches);
                resolverIntent.putExtra("android.intent.extra.INTENT", intent);
            }
            try {
                this.mContext.startActivityAsUser(resolverIntent, user);
            }
            catch (ActivityNotFoundException e) {
                Slog.e(TAG, "unable to start activity " + resolverIntent, e);
            }
        }
    }

    private ActivityInfo getDefaultActivityLocked(ArrayList<ResolveInfo> matches, UserPackage userPackage) {
        ActivityInfo activityInfo;
        if (userPackage != null) {
            for (ResolveInfo info : matches) {
                if (info.activityInfo == null || !userPackage.equals(new UserPackage(info.activityInfo.packageName, UserHandle.getUserHandleForUid(info.activityInfo.applicationInfo.uid)))) continue;
                return info.activityInfo;
            }
        }
        if (matches.size() == 1 && (activityInfo = matches.get((int)0).activityInfo) != null) {
            if (this.mDisablePermissionDialogs) {
                return activityInfo;
            }
            if (activityInfo.applicationInfo != null && (activityInfo.applicationInfo.flags & 1) != 0) {
                return activityInfo;
            }
        }
        return null;
    }

    @GuardedBy(value="mLock")
    private boolean clearCompatibleMatchesLocked(UserPackage userPackage, DeviceFilter filter) {
        ArrayList<DeviceFilter> keysToRemove = new ArrayList<DeviceFilter>();
        for (DeviceFilter device : this.mDevicePreferenceMap.keySet()) {
            UserPackage currentMatch;
            if (!filter.contains(device) || (currentMatch = this.mDevicePreferenceMap.get(device)).equals(userPackage)) continue;
            keysToRemove.add(device);
        }
        if (!keysToRemove.isEmpty()) {
            for (DeviceFilter keyToRemove : keysToRemove) {
                this.mDevicePreferenceMap.remove(keyToRemove);
            }
        }
        return !keysToRemove.isEmpty();
    }

    @GuardedBy(value="mLock")
    private boolean clearCompatibleMatchesLocked(UserPackage userPackage, AccessoryFilter filter) {
        ArrayList<AccessoryFilter> keysToRemove = new ArrayList<AccessoryFilter>();
        for (AccessoryFilter accessory : this.mAccessoryPreferenceMap.keySet()) {
            UserPackage currentMatch;
            if (!filter.contains(accessory) || (currentMatch = this.mAccessoryPreferenceMap.get(accessory)).equals(userPackage)) continue;
            keysToRemove.add(accessory);
        }
        if (!keysToRemove.isEmpty()) {
            for (AccessoryFilter keyToRemove : keysToRemove) {
                this.mAccessoryPreferenceMap.remove(keyToRemove);
            }
        }
        return !keysToRemove.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mLock")
    private boolean handlePackageAddedLocked(UserPackage userPackage, ActivityInfo aInfo, String metaDataName) {
        boolean changed = false;
        try (XmlResourceParser parser = null;){
            parser = aInfo.loadXmlMetaData(this.mPackageManager, metaDataName);
            if (parser == null) {
                boolean bl = false;
                return bl;
            }
            XmlUtils.nextElement(parser);
            while (parser.getEventType() != 1) {
                Object filter;
                String tagName = parser.getName();
                if ("usb-device".equals(tagName)) {
                    filter = DeviceFilter.read(parser);
                    if (this.clearCompatibleMatchesLocked(userPackage, (DeviceFilter)filter)) {
                        changed = true;
                    }
                } else if ("usb-accessory".equals(tagName) && this.clearCompatibleMatchesLocked(userPackage, (AccessoryFilter)(filter = AccessoryFilter.read(parser)))) {
                    changed = true;
                }
                XmlUtils.nextElement(parser);
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageAdded(UserPackage userPackage) {
        Object object = this.mLock;
        synchronized (object) {
            PackageInfo info;
            boolean changed = false;
            try {
                info = this.mPackageManager.getPackageInfoAsUser(userPackage.packageName, 129, userPackage.user.getIdentifier());
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.e(TAG, "handlePackageUpdate could not find package " + userPackage, e);
                return;
            }
            ActivityInfo[] activities = info.activities;
            if (activities == null) {
                return;
            }
            for (int i = 0; i < activities.length; ++i) {
                if (this.handlePackageAddedLocked(userPackage, activities[i], "android.hardware.usb.action.USB_DEVICE_ATTACHED")) {
                    changed = true;
                }
                if (!this.handlePackageAddedLocked(userPackage, activities[i], "android.hardware.usb.action.USB_ACCESSORY_ATTACHED")) continue;
                changed = true;
            }
            if (changed) {
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    private int getSerial(UserHandle user) {
        return this.mUserManager.getUserSerialNumber(user.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDevicePackage(UsbDevice device, String packageName, UserHandle user) {
        DeviceFilter filter = new DeviceFilter(device);
        Object object = this.mLock;
        synchronized (object) {
            boolean changed;
            if (packageName == null) {
                changed = this.mDevicePreferenceMap.remove(filter) != null;
            } else {
                UserPackage userPackage = new UserPackage(packageName, user);
                boolean bl = changed = !userPackage.equals(this.mDevicePreferenceMap.get(filter));
                if (changed) {
                    this.mDevicePreferenceMap.put(filter, userPackage);
                }
            }
            if (changed) {
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAccessoryPackage(UsbAccessory accessory, String packageName, UserHandle user) {
        AccessoryFilter filter = new AccessoryFilter(accessory);
        Object object = this.mLock;
        synchronized (object) {
            boolean changed;
            if (packageName == null) {
                changed = this.mAccessoryPreferenceMap.remove(filter) != null;
            } else {
                UserPackage userPackage = new UserPackage(packageName, user);
                boolean bl = changed = !userPackage.equals(this.mAccessoryPreferenceMap.get(filter));
                if (changed) {
                    this.mAccessoryPreferenceMap.put(filter, userPackage);
                }
            }
            if (changed) {
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasDefaults(String packageName, UserHandle user) {
        UserPackage userPackage = new UserPackage(packageName, user);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDevicePreferenceMap.values().contains(userPackage)) {
                return true;
            }
            return this.mAccessoryPreferenceMap.values().contains(userPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDefaults(String packageName, UserHandle user) {
        UserPackage userPackage = new UserPackage(packageName, user);
        Object object = this.mLock;
        synchronized (object) {
            if (this.clearPackageDefaultsLocked(userPackage)) {
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearPackageDefaultsLocked(UserPackage userPackage) {
        boolean cleared = false;
        Object object = this.mLock;
        synchronized (object) {
            Object key;
            int i;
            Object[] keys;
            if (this.mDevicePreferenceMap.containsValue(userPackage)) {
                keys = this.mDevicePreferenceMap.keySet().toArray(new DeviceFilter[0]);
                for (i = 0; i < keys.length; ++i) {
                    key = keys[i];
                    if (!userPackage.equals(this.mDevicePreferenceMap.get(key))) continue;
                    this.mDevicePreferenceMap.remove(key);
                    cleared = true;
                }
            }
            if (this.mAccessoryPreferenceMap.containsValue(userPackage)) {
                keys = this.mAccessoryPreferenceMap.keySet().toArray(new AccessoryFilter[0]);
                for (i = 0; i < keys.length; ++i) {
                    key = keys[i];
                    if (!userPackage.equals(this.mAccessoryPreferenceMap.get(key))) continue;
                    this.mAccessoryPreferenceMap.remove(key);
                    cleared = true;
                }
            }
            return cleared;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(DualDumpOutputStream dump, String idName, long id2) {
        long token = dump.start(idName, id2);
        Object object = this.mLock;
        synchronized (object) {
            dump.write("parent_user_id", 0x10500000001L, this.mParentUser.getIdentifier());
            for (DeviceFilter deviceFilter : this.mDevicePreferenceMap.keySet()) {
                long devicePrefToken = dump.start("device_preferences", 0x20B00000002L);
                deviceFilter.dump(dump, "filter", 0x10B00000001L);
                this.mDevicePreferenceMap.get(deviceFilter).dump(dump, "user_package", 1146756268034L);
                dump.end(devicePrefToken);
            }
            for (AccessoryFilter accessoryFilter : this.mAccessoryPreferenceMap.keySet()) {
                long accessoryPrefToken = dump.start("accessory_preferences", 2246267895811L);
                accessoryFilter.dump(dump, "filter", 0x10B00000001L);
                this.mAccessoryPreferenceMap.get(accessoryFilter).dump(dump, "user_package", 1146756268034L);
                dump.end(accessoryPrefToken);
            }
        }
        dump.end(token);
    }

    private static Intent createDeviceAttachedIntent(UsbDevice device) {
        Intent intent = new Intent("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intent.putExtra("device", device);
        intent.addFlags(0x11000000);
        return intent;
    }

    private class MyPackageMonitor
    extends PackageMonitor {
        private MyPackageMonitor() {
        }

        @Override
        public void onPackageAdded(String packageName, int uid) {
            if (!UsbProfileGroupSettingsManager.this.mUserManager.isSameProfileGroup(UsbProfileGroupSettingsManager.this.mParentUser.getIdentifier(), UserHandle.getUserId(uid))) {
                return;
            }
            UsbProfileGroupSettingsManager.this.handlePackageAdded(new UserPackage(packageName, UserHandle.getUserHandleForUid(uid)));
        }

        @Override
        public void onPackageRemoved(String packageName, int uid) {
            if (!UsbProfileGroupSettingsManager.this.mUserManager.isSameProfileGroup(UsbProfileGroupSettingsManager.this.mParentUser.getIdentifier(), UserHandle.getUserId(uid))) {
                return;
            }
            UsbProfileGroupSettingsManager.this.clearDefaults(packageName, UserHandle.getUserHandleForUid(uid));
        }
    }

    @Immutable
    private static class UserPackage {
        final UserHandle user;
        final String packageName;

        private UserPackage(String packageName, UserHandle user) {
            this.packageName = packageName;
            this.user = user;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UserPackage)) {
                return false;
            }
            UserPackage other = (UserPackage)obj;
            return this.user.equals(other.user) && this.packageName.equals(other.packageName);
        }

        public int hashCode() {
            int result = this.user.hashCode();
            result = 31 * result + this.packageName.hashCode();
            return result;
        }

        public String toString() {
            return this.user.getIdentifier() + "/" + this.packageName;
        }

        public void dump(DualDumpOutputStream dump, String idName, long id2) {
            long token = dump.start(idName, id2);
            dump.write("user_id", 0x10500000001L, this.user.getIdentifier());
            dump.write("package_name", 1138166333442L, this.packageName);
            dump.end(token);
        }
    }
}

