/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.Context;
import android.content.res.Resources;
import android.hardware.usb.UsbDevice;
import android.media.IAudioService;
import android.os.Bundle;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Slog;
import com.android.internal.alsa.AlsaCardsParser;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.server.usb.UsbAlsaDevice;
import com.android.server.usb.UsbMidiDevice;
import com.android.server.usb.descriptors.UsbDescriptorParser;
import java.util.ArrayList;
import java.util.HashMap;
import libcore.io.IoUtils;

public final class UsbAlsaManager {
    private static final String TAG = UsbAlsaManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String ALSA_DIRECTORY = "/dev/snd/";
    private final Context mContext;
    private IAudioService mAudioService;
    private final boolean mHasMidiFeature;
    private final AlsaCardsParser mCardsParser = new AlsaCardsParser();
    private final ArrayList<UsbAlsaDevice> mAlsaDevices = new ArrayList();
    private UsbAlsaDevice mSelectedDevice;
    private final HashMap<String, UsbMidiDevice> mMidiDevices = new HashMap();
    private UsbMidiDevice mPeripheralMidiDevice = null;

    UsbAlsaManager(Context context) {
        this.mContext = context;
        this.mHasMidiFeature = context.getPackageManager().hasSystemFeature("android.software.midi");
    }

    public void systemReady() {
        this.mAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
    }

    private synchronized void selectAlsaDevice(UsbAlsaDevice alsaDevice) {
        int isDisabled;
        if (this.mSelectedDevice != null) {
            this.deselectAlsaDevice();
        }
        if ((isDisabled = Settings.Secure.getInt(this.mContext.getContentResolver(), "usb_audio_automatic_routing_disabled", 0)) != 0) {
            return;
        }
        this.mSelectedDevice = alsaDevice;
        alsaDevice.start();
    }

    private synchronized void deselectAlsaDevice() {
        if (this.mSelectedDevice != null) {
            this.mSelectedDevice.stop();
            this.mSelectedDevice = null;
        }
    }

    private int getAlsaDeviceListIndexFor(String deviceAddress) {
        for (int index = 0; index < this.mAlsaDevices.size(); ++index) {
            if (!this.mAlsaDevices.get(index).getDeviceAddress().equals(deviceAddress)) continue;
            return index;
        }
        return -1;
    }

    private UsbAlsaDevice removeAlsaDeviceFromList(String deviceAddress) {
        int index = this.getAlsaDeviceListIndexFor(deviceAddress);
        if (index > -1) {
            return this.mAlsaDevices.remove(index);
        }
        return null;
    }

    UsbAlsaDevice selectDefaultDevice() {
        if (this.mAlsaDevices.size() > 0) {
            UsbAlsaDevice alsaDevice = this.mAlsaDevices.get(0);
            if (alsaDevice != null) {
                this.selectAlsaDevice(alsaDevice);
            }
            return alsaDevice;
        }
        return null;
    }

    void usbDeviceAdded(String deviceAddress, UsbDevice usbDevice, UsbDescriptorParser parser) {
        boolean hasMidi;
        this.mCardsParser.scan();
        AlsaCardsParser.AlsaCardRecord cardRec = this.mCardsParser.findCardNumFor(deviceAddress);
        if (cardRec == null) {
            return;
        }
        boolean hasInput = parser.hasInput();
        boolean hasOutput = parser.hasOutput();
        if (hasInput || hasOutput) {
            boolean isInputHeadset = parser.isInputHeadset();
            boolean isOutputHeadset = parser.isOutputHeadset();
            if (this.mAudioService == null) {
                Slog.e(TAG, "no AudioService");
                return;
            }
            UsbAlsaDevice alsaDevice = new UsbAlsaDevice(this.mAudioService, cardRec.getCardNum(), 0, deviceAddress, hasOutput, hasInput, isInputHeadset, isOutputHeadset);
            if (alsaDevice != null) {
                alsaDevice.setDeviceNameAndDescription(cardRec.getCardName(), cardRec.getCardDescription());
                this.mAlsaDevices.add(0, alsaDevice);
                this.selectAlsaDevice(alsaDevice);
            }
        }
        if ((hasMidi = parser.hasMIDIInterface()) && this.mHasMidiFeature) {
            boolean device = false;
            Bundle properties = new Bundle();
            String manufacturer = usbDevice.getManufacturerName();
            String product = usbDevice.getProductName();
            String version = usbDevice.getVersion();
            String name = manufacturer == null || manufacturer.isEmpty() ? product : (product == null || product.isEmpty() ? manufacturer : manufacturer + " " + product);
            properties.putString("name", name);
            properties.putString("manufacturer", manufacturer);
            properties.putString("product", product);
            properties.putString("version", version);
            properties.putString("serial_number", usbDevice.getSerialNumber());
            properties.putInt("alsa_card", cardRec.getCardNum());
            properties.putInt("alsa_device", 0);
            properties.putParcelable("usb_device", usbDevice);
            UsbMidiDevice usbMidiDevice = UsbMidiDevice.create(this.mContext, properties, cardRec.getCardNum(), 0);
            if (usbMidiDevice != null) {
                this.mMidiDevices.put(deviceAddress, usbMidiDevice);
            }
        }
    }

    synchronized void usbDeviceRemoved(String deviceAddress) {
        UsbMidiDevice usbMidiDevice;
        UsbAlsaDevice alsaDevice = this.removeAlsaDeviceFromList(deviceAddress);
        Slog.i(TAG, "USB Audio Device Removed: " + alsaDevice);
        if (alsaDevice != null && alsaDevice == this.mSelectedDevice) {
            this.deselectAlsaDevice();
            this.selectDefaultDevice();
        }
        if ((usbMidiDevice = this.mMidiDevices.remove(deviceAddress)) != null) {
            Slog.i(TAG, "USB MIDI Device Removed: " + usbMidiDevice);
            IoUtils.closeQuietly(usbMidiDevice);
        }
    }

    void setPeripheralMidiState(boolean enabled, int card, int device) {
        if (!this.mHasMidiFeature) {
            return;
        }
        if (enabled && this.mPeripheralMidiDevice == null) {
            Bundle properties = new Bundle();
            Resources r = this.mContext.getResources();
            properties.putString("name", r.getString(17041003));
            properties.putString("manufacturer", r.getString(17041002));
            properties.putString("product", r.getString(17041004));
            properties.putInt("alsa_card", card);
            properties.putInt("alsa_device", device);
            this.mPeripheralMidiDevice = UsbMidiDevice.create(this.mContext, properties, card, device);
        } else if (!enabled && this.mPeripheralMidiDevice != null) {
            IoUtils.closeQuietly(this.mPeripheralMidiDevice);
            this.mPeripheralMidiDevice = null;
        }
    }

    public void dump(DualDumpOutputStream dump, String idName, long id2) {
        long token = dump.start(idName, id2);
        dump.write("cards_parser", 0x10500000001L, this.mCardsParser.getScanStatus());
        for (UsbAlsaDevice usbAlsaDevice : this.mAlsaDevices) {
            usbAlsaDevice.dump(dump, "alsa_devices", 0x20B00000002L);
        }
        for (String deviceAddr : this.mMidiDevices.keySet()) {
            this.mMidiDevices.get(deviceAddr).dump(deviceAddr, dump, "midi_devices", 2246267895811L);
        }
        dump.end(token);
    }
}

