/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import com.android.server.usb.UsbAlsaDevice;

public final class UsbAlsaJackDetector
implements Runnable {
    private static final String TAG = "UsbAlsaJackDetector";
    private boolean mStopJackDetect = false;
    private UsbAlsaDevice mAlsaDevice;

    private static native boolean nativeHasJackDetect(int var0);

    private native boolean nativeJackDetect(int var1);

    private native boolean nativeOutputJackConnected(int var1);

    private native boolean nativeInputJackConnected(int var1);

    private UsbAlsaJackDetector(UsbAlsaDevice device) {
        this.mAlsaDevice = device;
    }

    public static UsbAlsaJackDetector startJackDetect(UsbAlsaDevice device) {
        if (!UsbAlsaJackDetector.nativeHasJackDetect(device.getCardNum())) {
            return null;
        }
        UsbAlsaJackDetector jackDetector = new UsbAlsaJackDetector(device);
        new Thread((Runnable)jackDetector, "USB jack detect thread").start();
        return jackDetector;
    }

    public boolean isInputJackConnected() {
        return this.nativeInputJackConnected(this.mAlsaDevice.getCardNum());
    }

    public boolean isOutputJackConnected() {
        return this.nativeOutputJackConnected(this.mAlsaDevice.getCardNum());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pleaseStop() {
        UsbAlsaJackDetector usbAlsaJackDetector = this;
        synchronized (usbAlsaJackDetector) {
            this.mStopJackDetect = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean jackDetectCallback() {
        UsbAlsaJackDetector usbAlsaJackDetector = this;
        synchronized (usbAlsaJackDetector) {
            if (this.mStopJackDetect) {
                return false;
            }
            this.mAlsaDevice.updateWiredDeviceConnectionState(true);
        }
        return true;
    }

    @Override
    public void run() {
        this.nativeJackDetect(this.mAlsaDevice.getCardNum());
    }
}

