/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.PendingIntent;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class AppTimeLimitController {
    private static final String TAG = "AppTimeLimitController";
    private static final boolean DEBUG = false;
    private final Lock mLock = new Lock();
    private final MyHandler mHandler;
    private OnLimitReachedListener mListener;
    private static final long MAX_OBSERVER_PER_UID = 1000L;
    private static final long ONE_MINUTE = 60000L;
    @GuardedBy(value="mLock")
    private final SparseArray<UserData> mUsers = new SparseArray();

    public AppTimeLimitController(OnLimitReachedListener listener, Looper looper) {
        this.mHandler = new MyHandler(looper);
        this.mListener = listener;
    }

    @VisibleForTesting
    protected long getUptimeMillis() {
        return SystemClock.uptimeMillis();
    }

    @VisibleForTesting
    protected long getObserverPerUidLimit() {
        return 1000L;
    }

    @VisibleForTesting
    protected long getMinTimeLimit() {
        return 60000L;
    }

    private UserData getOrCreateUserDataLocked(int userId) {
        UserData userData = this.mUsers.get(userId);
        if (userData == null) {
            userData = new UserData(userId);
            this.mUsers.put(userId, userData);
        }
        return userData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserRemoved(int userId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            this.mUsers.remove(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(int requestingUid, int observerId, String[] packages, long timeLimit, PendingIntent callbackIntent, int userId) {
        if (timeLimit < this.getMinTimeLimit()) {
            throw new IllegalArgumentException("Time limit must be >= " + this.getMinTimeLimit());
        }
        Lock lock = this.mLock;
        synchronized (lock) {
            UserData user = this.getOrCreateUserDataLocked(userId);
            this.removeObserverLocked(user, requestingUid, observerId, true);
            int observerIdCount = user.observerIdCounts.get(requestingUid, 0);
            if ((long)observerIdCount >= this.getObserverPerUidLimit()) {
                throw new IllegalStateException("Too many observers added by uid " + requestingUid);
            }
            user.observerIdCounts.put(requestingUid, observerIdCount + 1);
            TimeLimitGroup group = new TimeLimitGroup();
            group.observerId = observerId;
            group.callbackIntent = callbackIntent;
            group.packages = packages;
            group.timeRemaining = group.timeLimit = timeLimit;
            group.timeRequested = this.getUptimeMillis();
            group.requestingUid = requestingUid;
            group.timeCurrentPackageStarted = -1L;
            group.userId = userId;
            user.groups.append(observerId, group);
            this.addGroupToPackageMapLocked(user, packages, group);
            if (user.currentForegroundedPackage != null && AppTimeLimitController.inPackageList(group.packages, user.currentForegroundedPackage)) {
                group.timeCurrentPackageStarted = group.timeRequested;
                group.currentPackage = user.currentForegroundedPackage;
                if (group.timeRemaining > 0L) {
                    this.postCheckTimeoutLocked(group, group.timeRemaining);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(int requestingUid, int observerId, int userId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            UserData user = this.getOrCreateUserDataLocked(userId);
            this.removeObserverLocked(user, requestingUid, observerId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    TimeLimitGroup getObserverGroup(int observerId, int userId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            return (TimeLimitGroup)this.getOrCreateUserDataLocked(userId).groups.get(observerId);
        }
    }

    private static boolean inPackageList(String[] packages, String packageName) {
        return ArrayUtils.contains(packages, packageName);
    }

    @GuardedBy(value="mLock")
    private void removeObserverLocked(UserData user, int requestingUid, int observerId, boolean readding) {
        TimeLimitGroup group = (TimeLimitGroup)user.groups.get(observerId);
        if (group != null && group.requestingUid == requestingUid) {
            this.removeGroupFromPackageMapLocked(user, group);
            user.groups.remove(observerId);
            this.mHandler.removeMessages(1, group);
            int observerIdCount = user.observerIdCounts.get(requestingUid);
            if (observerIdCount <= 1 && !readding) {
                user.observerIdCounts.delete(requestingUid);
            } else {
                user.observerIdCounts.put(requestingUid, observerIdCount - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToForeground(String packageName, String className, int userId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            UserData user = this.getOrCreateUserDataLocked(userId);
            user.currentForegroundedPackage = packageName;
            user.currentForegroundedTime = this.getUptimeMillis();
            this.maybeWatchForPackageLocked(user, packageName, user.currentForegroundedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToBackground(String packageName, String className, int userId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            UserData user = this.getOrCreateUserDataLocked(userId);
            if (!TextUtils.equals(user.currentForegroundedPackage, packageName)) {
                Slog.w(TAG, "Eh? Last foregrounded package = " + user.currentForegroundedPackage + " and now backgrounded = " + packageName);
                return;
            }
            long stopTime = this.getUptimeMillis();
            ArrayList groups = (ArrayList)user.packageMap.get(packageName);
            if (groups != null) {
                int size = groups.size();
                for (int i = 0; i < size; ++i) {
                    TimeLimitGroup group = (TimeLimitGroup)groups.get(i);
                    if (group.timeRemaining <= 0L) continue;
                    long startTime = Math.max(user.currentForegroundedTime, group.timeRequested);
                    long diff = stopTime - startTime;
                    group.timeRemaining -= diff;
                    if (group.timeRemaining <= 0L) {
                        this.postInformListenerLocked(group);
                    }
                    group.currentPackage = null;
                    group.timeCurrentPackageStarted = -1L;
                    this.mHandler.removeMessages(1, group);
                }
            }
            user.currentForegroundedPackage = null;
        }
    }

    private void postInformListenerLocked(TimeLimitGroup group) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, group));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informListener(TimeLimitGroup group) {
        if (this.mListener != null) {
            this.mListener.onLimitReached(group.observerId, group.userId, group.timeLimit, group.timeLimit - group.timeRemaining, group.callbackIntent);
        }
        Lock lock = this.mLock;
        synchronized (lock) {
            UserData user = this.getOrCreateUserDataLocked(group.userId);
            this.removeObserverLocked(user, group.requestingUid, group.observerId, false);
        }
    }

    @GuardedBy(value="mLock")
    private void maybeWatchForPackageLocked(UserData user, String packageName, long uptimeMillis) {
        ArrayList groups = (ArrayList)user.packageMap.get(packageName);
        if (groups == null) {
            return;
        }
        int size = groups.size();
        for (int i = 0; i < size; ++i) {
            TimeLimitGroup group = (TimeLimitGroup)groups.get(i);
            if (group.timeRemaining <= 0L) continue;
            group.timeCurrentPackageStarted = uptimeMillis;
            group.currentPackage = packageName;
            this.postCheckTimeoutLocked(group, group.timeRemaining);
        }
    }

    private void addGroupToPackageMapLocked(UserData user, String[] packages, TimeLimitGroup group) {
        for (int i = 0; i < packages.length; ++i) {
            ArrayList<TimeLimitGroup> list = (ArrayList<TimeLimitGroup>)user.packageMap.get(packages[i]);
            if (list == null) {
                list = new ArrayList<TimeLimitGroup>();
                user.packageMap.put(packages[i], list);
            }
            list.add(group);
        }
    }

    private void removeGroupFromPackageMapLocked(UserData user, TimeLimitGroup group) {
        int mapSize = user.packageMap.size();
        for (int i = 0; i < mapSize; ++i) {
            ArrayList list = (ArrayList)user.packageMap.valueAt(i);
            list.remove(group);
        }
    }

    private void postCheckTimeoutLocked(TimeLimitGroup group, long timeout) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, group), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTimeout(TimeLimitGroup group) {
        Lock lock = this.mLock;
        synchronized (lock) {
            UserData user = this.getOrCreateUserDataLocked(group.userId);
            if (user.groups.get(group.observerId) != group) {
                return;
            }
            if (group.timeRemaining <= 0L) {
                return;
            }
            if (AppTimeLimitController.inPackageList(group.packages, user.currentForegroundedPackage)) {
                long timeInForeground;
                if (group.timeCurrentPackageStarted < 0L) {
                    Slog.w(TAG, "startTime was not set correctly for " + group);
                }
                if (group.timeRemaining <= (timeInForeground = this.getUptimeMillis() - group.timeCurrentPackageStarted)) {
                    group.timeRemaining -= timeInForeground;
                    this.postInformListenerLocked(group);
                    group.timeCurrentPackageStarted = -1L;
                    group.currentPackage = null;
                } else {
                    this.postCheckTimeoutLocked(group, group.timeRemaining - timeInForeground);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(PrintWriter pw) {
        Lock lock = this.mLock;
        synchronized (lock) {
            pw.println("\n  App Time Limits");
            int nUsers = this.mUsers.size();
            for (int i = 0; i < nUsers; ++i) {
                UserData user = this.mUsers.valueAt(i);
                pw.print("   User ");
                pw.println(user.userId);
                int nGroups = user.groups.size();
                for (int j = 0; j < nGroups; ++j) {
                    TimeLimitGroup group = (TimeLimitGroup)user.groups.valueAt(j);
                    pw.print("    Group id=");
                    pw.print(group.observerId);
                    pw.print(" timeLimit=");
                    pw.print(group.timeLimit);
                    pw.print(" remaining=");
                    pw.print(group.timeRemaining);
                    pw.print(" currentPackage=");
                    pw.print(group.currentPackage);
                    pw.print(" timeCurrentPkgStarted=");
                    pw.print(group.timeCurrentPackageStarted);
                    pw.print(" packages=");
                    pw.println(Arrays.toString(group.packages));
                }
                pw.println();
                pw.print("    currentForegroundedPackage=");
                pw.println(user.currentForegroundedPackage);
            }
        }
    }

    private class MyHandler
    extends Handler {
        static final int MSG_CHECK_TIMEOUT = 1;
        static final int MSG_INFORM_LISTENER = 2;

        MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AppTimeLimitController.this.checkTimeout((TimeLimitGroup)msg.obj);
                    break;
                }
                case 2: {
                    AppTimeLimitController.this.informListener((TimeLimitGroup)msg.obj);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    static class TimeLimitGroup {
        int requestingUid;
        int observerId;
        String[] packages;
        long timeLimit;
        long timeRequested;
        long timeRemaining;
        PendingIntent callbackIntent;
        String currentPackage;
        long timeCurrentPackageStarted;
        int userId;

        TimeLimitGroup() {
        }
    }

    public static interface OnLimitReachedListener {
        public void onLimitReached(int var1, int var2, long var3, long var5, PendingIntent var7);
    }

    private static class UserData {
        private int userId;
        private String currentForegroundedPackage;
        private long currentForegroundedTime;
        private ArrayMap<String, ArrayList<TimeLimitGroup>> packageMap = new ArrayMap();
        private SparseArray<TimeLimitGroup> groups = new SparseArray();
        private SparseIntArray observerIdCounts = new SparseIntArray();

        private UserData(int userId) {
            this.userId = userId;
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

