/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.timezone;

import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.timezone.CheckToken;
import com.android.server.timezone.PackageStatus;
import com.android.server.timezone.PackageVersions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

final class PackageStatusStorage {
    private static final String LOG_TAG = "timezone.PackageStatusStorage";
    private static final String TAG_PACKAGE_STATUS = "PackageStatus";
    private static final String ATTRIBUTE_OPTIMISTIC_LOCK_ID = "optimisticLockId";
    private static final String ATTRIBUTE_CHECK_STATUS = "checkStatus";
    private static final String ATTRIBUTE_UPDATE_APP_VERSION = "updateAppPackageVersion";
    private static final String ATTRIBUTE_DATA_APP_VERSION = "dataAppPackageVersion";
    private static final long UNKNOWN_PACKAGE_VERSION = -1L;
    private final AtomicFile mPackageStatusFile;

    PackageStatusStorage(File storageDir) {
        this.mPackageStatusFile = new AtomicFile(new File(storageDir, "package-status.xml"), "timezone-status");
    }

    void initialize() throws IOException {
        if (!this.mPackageStatusFile.getBaseFile().exists()) {
            this.insertInitialPackageStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFileForTests() {
        PackageStatusStorage packageStatusStorage = this;
        synchronized (packageStatusStorage) {
            this.mPackageStatusFile.delete();
        }
    }

    PackageStatus getPackageStatus() {
        PackageStatusStorage packageStatusStorage = this;
        synchronized (packageStatusStorage) {
            try {
                return this.getPackageStatusLocked();
            }
            catch (ParseException e) {
                Slog.e(LOG_TAG, "Package status invalid, resetting and retrying", e);
                this.recoverFromBadData(e);
                try {
                    return this.getPackageStatusLocked();
                }
                catch (ParseException e2) {
                    throw new IllegalStateException("Recovery from bad file failed", e2);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GuardedBy(value="this")
    private PackageStatus getPackageStatusLocked() throws ParseException {
        try (FileInputStream fis = this.mPackageStatusFile.openRead();){
            XmlPullParser parser = PackageStatusStorage.parseToPackageStatusTag(fis);
            Integer checkStatus = PackageStatusStorage.getNullableIntAttribute(parser, ATTRIBUTE_CHECK_STATUS);
            if (checkStatus == null) {
                PackageStatus packageStatus = null;
                return packageStatus;
            }
            int updateAppVersion = PackageStatusStorage.getIntAttribute(parser, ATTRIBUTE_UPDATE_APP_VERSION);
            int dataAppVersion = PackageStatusStorage.getIntAttribute(parser, ATTRIBUTE_DATA_APP_VERSION);
            PackageStatus packageStatus = new PackageStatus(checkStatus, new PackageVersions(updateAppVersion, dataAppVersion));
            return packageStatus;
        }
        catch (IOException e) {
            ParseException e2 = new ParseException("Error reading package status", 0);
            e2.initCause(e);
            throw e2;
        }
    }

    @GuardedBy(value="this")
    private int recoverFromBadData(Exception cause) {
        this.mPackageStatusFile.delete();
        try {
            return this.insertInitialPackageStatus();
        }
        catch (IOException e) {
            IllegalStateException fatal = new IllegalStateException(e);
            fatal.addSuppressed(cause);
            throw fatal;
        }
    }

    private int insertInitialPackageStatus() throws IOException {
        int initialOptimisticLockId = (int)System.currentTimeMillis();
        this.writePackageStatusLocked(null, initialOptimisticLockId, null);
        return initialOptimisticLockId;
    }

    CheckToken generateCheckToken(PackageVersions currentInstalledVersions) {
        if (currentInstalledVersions == null) {
            throw new NullPointerException("currentInstalledVersions == null");
        }
        PackageStatusStorage packageStatusStorage = this;
        synchronized (packageStatusStorage) {
            int optimisticLockId;
            try {
                optimisticLockId = this.getCurrentOptimisticLockId();
            }
            catch (ParseException e) {
                Slog.w(LOG_TAG, "Unable to find optimistic lock ID from package status");
                optimisticLockId = this.recoverFromBadData(e);
            }
            int newOptimisticLockId = optimisticLockId + 1;
            try {
                boolean statusUpdated = this.writePackageStatusWithOptimisticLockCheck(optimisticLockId, newOptimisticLockId, 1, currentInstalledVersions);
                if (!statusUpdated) {
                    throw new IllegalStateException("Unable to update status to CHECK_STARTED. synchronization failure?");
                }
                return new CheckToken(newOptimisticLockId, currentInstalledVersions);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetCheckState() {
        PackageStatusStorage packageStatusStorage = this;
        synchronized (packageStatusStorage) {
            int optimisticLockId;
            try {
                optimisticLockId = this.getCurrentOptimisticLockId();
            }
            catch (ParseException e) {
                Slog.w(LOG_TAG, "resetCheckState: Unable to find optimistic lock ID from package status");
                optimisticLockId = this.recoverFromBadData(e);
            }
            int newOptimisticLockId = optimisticLockId + 1;
            try {
                if (!this.writePackageStatusWithOptimisticLockCheck(optimisticLockId, newOptimisticLockId, null, null)) {
                    throw new IllegalStateException("resetCheckState: Unable to reset package status, newOptimisticLockId=" + newOptimisticLockId);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    boolean markChecked(CheckToken checkToken, boolean succeeded) {
        PackageStatusStorage packageStatusStorage = this;
        synchronized (packageStatusStorage) {
            int optimisticLockId = checkToken.mOptimisticLockId;
            int newOptimisticLockId = optimisticLockId + 1;
            int status = succeeded ? 2 : 3;
            try {
                return this.writePackageStatusWithOptimisticLockCheck(optimisticLockId, newOptimisticLockId, status, checkToken.mPackageVersions);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GuardedBy(value="this")
    private int getCurrentOptimisticLockId() throws ParseException {
        try (FileInputStream fis = this.mPackageStatusFile.openRead();){
            XmlPullParser parser = PackageStatusStorage.parseToPackageStatusTag(fis);
            int n = PackageStatusStorage.getIntAttribute(parser, ATTRIBUTE_OPTIMISTIC_LOCK_ID);
            return n;
        }
        catch (IOException e) {
            ParseException e2 = new ParseException("Unable to read file", 0);
            e2.initCause(e);
            throw e2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static XmlPullParser parseToPackageStatusTag(FileInputStream fis) throws ParseException {
        try {
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 1) {
                String tag = parser.getName();
                if (type == 2 && TAG_PACKAGE_STATUS.equals(tag)) {
                    return parser;
                }
            }
            throw new ParseException("Unable to find PackageStatus tag", 0);
        }
        catch (XmlPullParserException e) {
            throw new IllegalStateException("Unable to configure parser", e);
        }
        catch (IOException e) {
            ParseException e2 = new ParseException("Error reading XML", 0);
            e.initCause(e);
            throw e2;
        }
    }

    @GuardedBy(value="this")
    private boolean writePackageStatusWithOptimisticLockCheck(int optimisticLockId, int newOptimisticLockId, Integer status, PackageVersions packageVersions) throws IOException {
        try {
            int currentOptimisticLockId = this.getCurrentOptimisticLockId();
            if (currentOptimisticLockId != optimisticLockId) {
                return false;
            }
        }
        catch (ParseException e) {
            this.recoverFromBadData(e);
            return false;
        }
        this.writePackageStatusLocked(status, newOptimisticLockId, packageVersions);
        return true;
    }

    @GuardedBy(value="this")
    private void writePackageStatusLocked(Integer status, int optimisticLockId, PackageVersions packageVersions) throws IOException {
        if (status == null != (packageVersions == null)) {
            throw new IllegalArgumentException("Provide both status and packageVersions, or neither.");
        }
        FileOutputStream fos = null;
        try {
            fos = this.mPackageStatusFile.startWrite();
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(fos, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            String namespace = null;
            serializer.startTag(namespace, TAG_PACKAGE_STATUS);
            String statusAttributeValue = status == null ? "" : Integer.toString(status);
            serializer.attribute(namespace, ATTRIBUTE_CHECK_STATUS, statusAttributeValue);
            serializer.attribute(namespace, ATTRIBUTE_OPTIMISTIC_LOCK_ID, Integer.toString(optimisticLockId));
            long updateAppVersion = status == null ? -1L : packageVersions.mUpdateAppVersion;
            serializer.attribute(namespace, ATTRIBUTE_UPDATE_APP_VERSION, Long.toString(updateAppVersion));
            long dataAppVersion = status == null ? -1L : packageVersions.mDataAppVersion;
            serializer.attribute(namespace, ATTRIBUTE_DATA_APP_VERSION, Long.toString(dataAppVersion));
            serializer.endTag(namespace, TAG_PACKAGE_STATUS);
            serializer.endDocument();
            serializer.flush();
            this.mPackageStatusFile.finishWrite(fos);
        }
        catch (IOException e) {
            if (fos != null) {
                this.mPackageStatusFile.failWrite(fos);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceCheckStateForTests(int checkStatus, PackageVersions packageVersions) throws IOException {
        PackageStatusStorage packageStatusStorage = this;
        synchronized (packageStatusStorage) {
            try {
                int initialOptimisticLockId = (int)System.currentTimeMillis();
                this.writePackageStatusLocked(checkStatus, initialOptimisticLockId, packageVersions);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static Integer getNullableIntAttribute(XmlPullParser parser, String attributeName) throws ParseException {
        String attributeValue = parser.getAttributeValue(null, attributeName);
        try {
            if (attributeValue == null) {
                throw new ParseException("Attribute " + attributeName + " missing", 0);
            }
            if (attributeValue.isEmpty()) {
                return null;
            }
            return Integer.parseInt(attributeValue);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Bad integer for attributeName=" + attributeName + ": " + attributeValue, 0);
        }
    }

    private static int getIntAttribute(XmlPullParser parser, String attributeName) throws ParseException {
        Integer value = PackageStatusStorage.getNullableIntAttribute(parser, attributeName);
        if (value == null) {
            throw new ParseException("Missing attribute " + attributeName, 0);
        }
        return value;
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("Package status: " + this.getPackageStatus());
    }
}

