/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.timezone;

import com.android.server.timezone.PackageVersions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class CheckToken {
    final int mOptimisticLockId;
    final PackageVersions mPackageVersions;

    CheckToken(int optimisticLockId, PackageVersions packageVersions) {
        this.mOptimisticLockId = optimisticLockId;
        if (packageVersions == null) {
            throw new NullPointerException("packageVersions == null");
        }
        this.mPackageVersions = packageVersions;
    }

    byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(12);
        try (DataOutputStream dos = new DataOutputStream(baos);){
            dos.writeInt(this.mOptimisticLockId);
            dos.writeLong(this.mPackageVersions.mUpdateAppVersion);
            dos.writeLong(this.mPackageVersions.mDataAppVersion);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write into a ByteArrayOutputStream", e);
        }
        return baos.toByteArray();
    }

    static CheckToken fromByteArray(byte[] tokenBytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(tokenBytes);
        try (DataInputStream dis = new DataInputStream(bais);){
            int versionId = dis.readInt();
            long updateAppVersion = dis.readLong();
            long dataAppVersion = dis.readLong();
            CheckToken checkToken = new CheckToken(versionId, new PackageVersions(updateAppVersion, dataAppVersion));
            return checkToken;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckToken checkToken = (CheckToken)o;
        if (this.mOptimisticLockId != checkToken.mOptimisticLockId) {
            return false;
        }
        return this.mPackageVersions.equals(checkToken.mPackageVersions);
    }

    public int hashCode() {
        int result = this.mOptimisticLockId;
        result = 31 * result + this.mPackageVersions.hashCode();
        return result;
    }

    public String toString() {
        return "Token{mOptimisticLockId=" + this.mOptimisticLockId + ", mPackageVersions=" + this.mPackageVersions + '}';
    }
}

