/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power.batterysaver;

import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.IoThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FileUpdater {
    private static final String TAG = "BatterySaverController";
    private static final boolean DEBUG = false;
    private static final String PROP_SKIP_WRITE = "debug.batterysaver.no_write_files";
    private static final String TAG_DEFAULT_ROOT = "defaults";
    private final Object mLock = new Object();
    private final Context mContext;
    private final Handler mHandler;
    @GuardedBy(value="mLock")
    private final ArrayMap<String, String> mPendingWrites = new ArrayMap();
    @GuardedBy(value="mLock")
    private final ArrayMap<String, String> mDefaultValues = new ArrayMap();
    @GuardedBy(value="mLock")
    private int mRetries = 0;
    private final int MAX_RETRIES;
    private final long RETRY_INTERVAL_MS;
    private Runnable mHandleWriteOnHandlerRunnable = () -> this.handleWriteOnHandler();

    public FileUpdater(Context context) {
        this(context, IoThread.get().getLooper(), 10, 5000);
    }

    @VisibleForTesting
    FileUpdater(Context context, Looper looper, int maxRetries, int retryIntervalMs) {
        this.mContext = context;
        this.mHandler = new Handler(looper);
        this.MAX_RETRIES = maxRetries;
        this.RETRY_INTERVAL_MS = retryIntervalMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(boolean runtimeRestarted) {
        Object object = this.mLock;
        synchronized (object) {
            if (runtimeRestarted) {
                if (this.loadDefaultValuesLocked()) {
                    Slog.d(TAG, "Default values loaded after runtime restart; writing them...");
                    this.restoreDefault();
                }
            } else {
                this.injectDefaultValuesFilename().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFiles(ArrayMap<String, String> fileValues) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = fileValues.size() - 1; i >= 0; --i) {
                String file = fileValues.keyAt(i);
                String value = fileValues.valueAt(i);
                this.mPendingWrites.put(file, value);
            }
            this.mRetries = 0;
            this.mHandler.removeCallbacks(this.mHandleWriteOnHandlerRunnable);
            this.mHandler.post(this.mHandleWriteOnHandlerRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreDefault() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingWrites.clear();
            this.writeFiles(this.mDefaultValues);
        }
    }

    private String getKeysString(Map<String, String> source) {
        return new ArrayList<String>(source.keySet()).toString();
    }

    private ArrayMap<String, String> cloneMap(ArrayMap<String, String> source) {
        return new ArrayMap<String, String>(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWriteOnHandler() {
        ArrayMap<String, String> writes;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingWrites.size() == 0) {
                return;
            }
            writes = this.cloneMap(this.mPendingWrites);
        }
        boolean needRetry = false;
        int size = writes.size();
        for (int i = 0; i < size; ++i) {
            String file = writes.keyAt(i);
            String value = writes.valueAt(i);
            if (!this.ensureDefaultLoaded(file)) continue;
            try {
                this.injectWriteToFile(file, value);
                this.removePendingWrite(file);
                continue;
            }
            catch (IOException e) {
                needRetry = true;
            }
        }
        if (needRetry) {
            this.scheduleRetry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingWrite(String file) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingWrites.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRetry() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingWrites.size() == 0) {
                return;
            }
            ++this.mRetries;
            if (this.mRetries > this.MAX_RETRIES) {
                this.doWtf("Gave up writing files: " + this.getKeysString(this.mPendingWrites));
                return;
            }
            this.mHandler.removeCallbacks(this.mHandleWriteOnHandlerRunnable);
            this.mHandler.postDelayed(this.mHandleWriteOnHandlerRunnable, this.RETRY_INTERVAL_MS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureDefaultLoaded(String file) {
        String originalValue;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDefaultValues.containsKey(file)) {
                return true;
            }
        }
        try {
            originalValue = this.injectReadFromFileTrimmed(file);
        }
        catch (IOException e) {
            this.injectWtf("Unable to read from file", e);
            this.removePendingWrite(file);
            return false;
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            this.mDefaultValues.put(file, originalValue);
            this.saveDefaultValuesLocked();
        }
        return true;
    }

    @VisibleForTesting
    String injectReadFromFileTrimmed(String file) throws IOException {
        return IoUtils.readFileAsString(file).trim();
    }

    @VisibleForTesting
    void injectWriteToFile(String file, String value) throws IOException {
        if (this.injectShouldSkipWrite()) {
            Slog.i(TAG, "Skipped writing to '" + file + "'");
            return;
        }
        try (FileWriter out = new FileWriter(file);){
            out.write(value);
        }
        catch (IOException | RuntimeException e) {
            Slog.w(TAG, "Failed writing '" + value + "' to '" + file + "': " + e.getMessage());
            throw e;
        }
    }

    @GuardedBy(value="mLock")
    private void saveDefaultValuesLocked() {
        AtomicFile file = new AtomicFile(this.injectDefaultValuesFilename());
        FileOutputStream outs = null;
        try {
            file.getBaseFile().getParentFile().mkdirs();
            outs = file.startWrite();
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(outs, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.startTag(null, TAG_DEFAULT_ROOT);
            XmlUtils.writeMapXml(this.mDefaultValues, out, null);
            out.endTag(null, TAG_DEFAULT_ROOT);
            out.endDocument();
            file.finishWrite(outs);
        }
        catch (IOException | RuntimeException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to write to file " + file.getBaseFile(), e);
            file.failWrite(outs);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GuardedBy(value="mLock")
    @VisibleForTesting
    boolean loadDefaultValuesLocked() {
        AtomicFile file = new AtomicFile(this.injectDefaultValuesFilename());
        ArrayMap<String, ?> read = null;
        try (FileInputStream in = file.openRead();){
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(in, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                int depth = parser.getDepth();
                String tag = parser.getName();
                if (depth == 1) {
                    if (TAG_DEFAULT_ROOT.equals(tag)) continue;
                    Slog.e(TAG, "Invalid root tag: " + tag);
                    boolean bl = false;
                    return bl;
                }
                String[] tagName = new String[1];
                read = XmlUtils.readThisArrayMapXml(parser, TAG_DEFAULT_ROOT, tagName, null);
            }
        }
        catch (FileNotFoundException e) {
            read = null;
        }
        catch (IOException | RuntimeException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to read file " + file.getBaseFile(), e);
        }
        if (read == null) return false;
        this.mDefaultValues.clear();
        this.mDefaultValues.putAll((Map<String, String>)read);
        return true;
    }

    private void doWtf(String message) {
        this.injectWtf(message, null);
    }

    @VisibleForTesting
    void injectWtf(String message, Throwable e) {
        Slog.wtf(TAG, message, e);
    }

    File injectDefaultValuesFilename() {
        File dir = new File(Environment.getDataSystemDirectory(), "battery-saver");
        dir.mkdirs();
        return new File(dir, "default-values.xml");
    }

    @VisibleForTesting
    boolean injectShouldSkipWrite() {
        return SystemProperties.getBoolean(PROP_SKIP_WRITE, false);
    }

    @VisibleForTesting
    ArrayMap<String, String> getDefaultValuesForTest() {
        return this.mDefaultValues;
    }
}

