/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power.batterysaver;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.os.Handler;
import android.provider.Settings;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.server.EventLogTags;
import com.android.server.power.batterysaver.BatterySaverController;
import java.io.PrintWriter;

public class BatterySaverStateMachine {
    private static final String TAG = "BatterySaverStateMachine";
    private final Object mLock;
    private static final boolean DEBUG = false;
    private final Context mContext;
    private final BatterySaverController mBatterySaverController;
    @GuardedBy(value="mLock")
    private boolean mBootCompleted;
    @GuardedBy(value="mLock")
    private boolean mSettingsLoaded;
    @GuardedBy(value="mLock")
    private boolean mBatteryStatusSet;
    @GuardedBy(value="mLock")
    private boolean mIsPowered;
    @GuardedBy(value="mLock")
    private int mBatteryLevel;
    @GuardedBy(value="mLock")
    private boolean mIsBatteryLevelLow;
    @GuardedBy(value="mLock")
    private boolean mSettingBatterySaverEnabled;
    @GuardedBy(value="mLock")
    private boolean mSettingBatterySaverEnabledSticky;
    @GuardedBy(value="mLock")
    private int mSettingBatterySaverTriggerThreshold;
    @GuardedBy(value="mLock")
    private boolean mBatterySaverSnoozing;
    @GuardedBy(value="mLock")
    private int mLastChangedIntReason;
    @GuardedBy(value="mLock")
    private String mLastChangedStrReason;
    private final ContentObserver mSettingsObserver = new ContentObserver(null){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange) {
            Object object = BatterySaverStateMachine.this.mLock;
            synchronized (object) {
                BatterySaverStateMachine.this.refreshSettingsLocked();
            }
        }
    };
    private final Runnable mThresholdChangeLogger = () -> EventLogTags.writeBatterySaverSetting(this.mSettingBatterySaverTriggerThreshold);

    public BatterySaverStateMachine(Object lock, Context context, BatterySaverController batterySaverController) {
        this.mLock = lock;
        this.mContext = context;
        this.mBatterySaverController = batterySaverController;
    }

    private boolean isBatterySaverEnabled() {
        return this.mBatterySaverController.isEnabled();
    }

    private boolean isAutoBatterySaverConfigured() {
        return this.mSettingBatterySaverTriggerThreshold > 0;
    }

    public void onBootCompleted() {
        this.putGlobalSetting("low_power", 0);
        this.runOnBgThread(() -> {
            ContentResolver cr = this.mContext.getContentResolver();
            cr.registerContentObserver(Settings.Global.getUriFor("low_power"), false, this.mSettingsObserver, 0);
            cr.registerContentObserver(Settings.Global.getUriFor("low_power_sticky"), false, this.mSettingsObserver, 0);
            cr.registerContentObserver(Settings.Global.getUriFor("low_power_trigger_level"), false, this.mSettingsObserver, 0);
            Object object = this.mLock;
            synchronized (object) {
                this.mBootCompleted = true;
                this.refreshSettingsLocked();
                this.doAutoBatterySaverLocked();
            }
        });
    }

    @VisibleForTesting
    void runOnBgThread(Runnable r) {
        BackgroundThread.getHandler().post(r);
    }

    @VisibleForTesting
    void runOnBgThreadLazy(Runnable r, int delayMillis) {
        Handler h = BackgroundThread.getHandler();
        h.removeCallbacks(r);
        h.postDelayed(r, delayMillis);
    }

    void refreshSettingsLocked() {
        boolean lowPowerModeEnabled = this.getGlobalSetting("low_power", 0) != 0;
        boolean lowPowerModeEnabledSticky = this.getGlobalSetting("low_power_sticky", 0) != 0;
        int lowPowerModeTriggerLevel = this.getGlobalSetting("low_power_trigger_level", 0);
        this.setSettingsLocked(lowPowerModeEnabled, lowPowerModeEnabledSticky, lowPowerModeTriggerLevel);
    }

    @VisibleForTesting
    void setSettingsLocked(boolean batterySaverEnabled, boolean batterySaverEnabledSticky, int batterySaverTriggerThreshold) {
        boolean thresholdChanged;
        this.mSettingsLoaded = true;
        boolean enabledChanged = this.mSettingBatterySaverEnabled != batterySaverEnabled;
        boolean stickyChanged = this.mSettingBatterySaverEnabledSticky != batterySaverEnabledSticky;
        boolean bl = thresholdChanged = this.mSettingBatterySaverTriggerThreshold != batterySaverTriggerThreshold;
        if (!(enabledChanged || stickyChanged || thresholdChanged)) {
            return;
        }
        this.mSettingBatterySaverEnabled = batterySaverEnabled;
        this.mSettingBatterySaverEnabledSticky = batterySaverEnabledSticky;
        this.mSettingBatterySaverTriggerThreshold = batterySaverTriggerThreshold;
        if (thresholdChanged) {
            this.runOnBgThreadLazy(this.mThresholdChangeLogger, 2000);
        }
        if (enabledChanged) {
            String reason = batterySaverEnabled ? "Global.low_power changed to 1" : "Global.low_power changed to 0";
            this.enableBatterySaverLocked(batterySaverEnabled, true, 8, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBatteryStatus(boolean newPowered, int newLevel, boolean newBatteryLevelLow) {
        Object object = this.mLock;
        synchronized (object) {
            boolean lowChanged;
            this.mBatteryStatusSet = true;
            boolean poweredChanged = this.mIsPowered != newPowered;
            boolean levelChanged = this.mBatteryLevel != newLevel;
            boolean bl = lowChanged = this.mIsBatteryLevelLow != newBatteryLevelLow;
            if (!(poweredChanged || levelChanged || lowChanged)) {
                return;
            }
            this.mIsPowered = newPowered;
            this.mBatteryLevel = newLevel;
            this.mIsBatteryLevelLow = newBatteryLevelLow;
            this.doAutoBatterySaverLocked();
        }
    }

    private void doAutoBatterySaverLocked() {
        if (!(this.mBootCompleted && this.mSettingsLoaded && this.mBatteryStatusSet)) {
            return;
        }
        if (!this.mIsBatteryLevelLow) {
            this.updateSnoozingLocked(false, "Battery not low");
        }
        if (this.mIsPowered) {
            this.updateSnoozingLocked(false, "Plugged in");
            this.enableBatterySaverLocked(false, false, 7, "Plugged in");
        } else if (this.mSettingBatterySaverEnabledSticky) {
            this.enableBatterySaverLocked(true, true, 4, "Sticky restore");
        } else if (this.mIsBatteryLevelLow) {
            if (!this.mBatterySaverSnoozing && this.isAutoBatterySaverConfigured()) {
                this.enableBatterySaverLocked(true, false, 0, "Auto ON");
            }
        } else {
            this.enableBatterySaverLocked(false, false, 1, "Auto OFF");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBatterySaverEnabledManually(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            this.enableBatterySaverLocked(enabled, true, enabled ? 2 : 3, enabled ? "Manual ON" : "Manual OFF");
        }
    }

    private void enableBatterySaverLocked(boolean enable, boolean manual, int intReason, String strReason) {
        boolean wasEnabled = this.mBatterySaverController.isEnabled();
        if (wasEnabled == enable) {
            return;
        }
        if (enable && this.mIsPowered) {
            return;
        }
        this.mLastChangedIntReason = intReason;
        this.mLastChangedStrReason = strReason;
        if (manual) {
            if (enable) {
                this.updateSnoozingLocked(false, "Manual snooze OFF");
            } else if (this.isBatterySaverEnabled() && this.mIsBatteryLevelLow) {
                this.updateSnoozingLocked(true, "Manual snooze");
            }
        }
        this.mSettingBatterySaverEnabled = enable;
        this.putGlobalSetting("low_power", enable ? 1 : 0);
        if (manual) {
            this.mSettingBatterySaverEnabledSticky = enable;
            this.putGlobalSetting("low_power_sticky", enable ? 1 : 0);
        }
        this.mBatterySaverController.enableBatterySaver(enable, intReason);
    }

    private void updateSnoozingLocked(boolean snoozing, String reason) {
        if (this.mBatterySaverSnoozing == snoozing) {
            return;
        }
        this.mBatterySaverSnoozing = snoozing;
    }

    @VisibleForTesting
    protected void putGlobalSetting(String key, int value) {
        Settings.Global.putInt(this.mContext.getContentResolver(), key, value);
    }

    @VisibleForTesting
    protected int getGlobalSetting(String key, int defValue) {
        return Settings.Global.getInt(this.mContext.getContentResolver(), key, defValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println();
            pw.println("Battery saver state machine:");
            pw.print("  Enabled=");
            pw.println(this.mBatterySaverController.isEnabled());
            pw.print("  mLastChangedIntReason=");
            pw.println(this.mLastChangedIntReason);
            pw.print("  mLastChangedStrReason=");
            pw.println(this.mLastChangedStrReason);
            pw.print("  mBootCompleted=");
            pw.println(this.mBootCompleted);
            pw.print("  mSettingsLoaded=");
            pw.println(this.mSettingsLoaded);
            pw.print("  mBatteryStatusSet=");
            pw.println(this.mBatteryStatusSet);
            pw.print("  mBatterySaverSnoozing=");
            pw.println(this.mBatterySaverSnoozing);
            pw.print("  mIsPowered=");
            pw.println(this.mIsPowered);
            pw.print("  mBatteryLevel=");
            pw.println(this.mBatteryLevel);
            pw.print("  mIsBatteryLevelLow=");
            pw.println(this.mIsBatteryLevelLow);
            pw.print("  mSettingBatterySaverEnabled=");
            pw.println(this.mSettingBatterySaverEnabled);
            pw.print("  mSettingBatterySaverEnabledSticky=");
            pw.println(this.mSettingBatterySaverEnabledSticky);
            pw.print("  mSettingBatterySaverTriggerThreshold=");
            pw.println(this.mSettingBatterySaverTriggerThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpProto(ProtoOutputStream proto, long tag) {
        Object object = this.mLock;
        synchronized (object) {
            long token = proto.start(tag);
            proto.write(0x10800000001L, this.mBatterySaverController.isEnabled());
            proto.write(1133871366146L, this.mBootCompleted);
            proto.write(1133871366147L, this.mSettingsLoaded);
            proto.write(1133871366148L, this.mBatteryStatusSet);
            proto.write(1133871366149L, this.mBatterySaverSnoozing);
            proto.write(1133871366150L, this.mIsPowered);
            proto.write(1120986464263L, this.mBatteryLevel);
            proto.write(0x10800000008L, this.mIsBatteryLevelLow);
            proto.write(1133871366153L, this.mSettingBatterySaverEnabled);
            proto.write(1133871366154L, this.mSettingBatterySaverEnabledSticky);
            proto.write(1120986464267L, this.mSettingBatterySaverTriggerThreshold);
            proto.end(token);
        }
    }
}

