/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.PowerSaveState;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.KeyValueListParser;
import android.util.Slog;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.ConcurrentUtils;
import com.android.server.power.batterysaver.BatterySavingStats;
import com.android.server.power.batterysaver.CpuFrequencies;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class BatterySaverPolicy
extends ContentObserver {
    private static final String TAG = "BatterySaverPolicy";
    public static final boolean DEBUG = false;
    public static final String SECURE_KEY_GPS_MODE = "batterySaverGpsMode";
    private static final String KEY_GPS_MODE = "gps_mode";
    private static final String KEY_VIBRATION_DISABLED = "vibration_disabled";
    private static final String KEY_ANIMATION_DISABLED = "animation_disabled";
    private static final String KEY_SOUNDTRIGGER_DISABLED = "soundtrigger_disabled";
    private static final String KEY_FIREWALL_DISABLED = "firewall_disabled";
    private static final String KEY_ADJUST_BRIGHTNESS_DISABLED = "adjust_brightness_disabled";
    private static final String KEY_DATASAVER_DISABLED = "datasaver_disabled";
    private static final String KEY_LAUNCH_BOOST_DISABLED = "launch_boost_disabled";
    private static final String KEY_ADJUST_BRIGHTNESS_FACTOR = "adjust_brightness_factor";
    private static final String KEY_FULLBACKUP_DEFERRED = "fullbackup_deferred";
    private static final String KEY_KEYVALUE_DEFERRED = "keyvaluebackup_deferred";
    private static final String KEY_FORCE_ALL_APPS_STANDBY = "force_all_apps_standby";
    private static final String KEY_FORCE_BACKGROUND_CHECK = "force_background_check";
    private static final String KEY_OPTIONAL_SENSORS_DISABLED = "optional_sensors_disabled";
    private static final String KEY_AOD_DISABLED = "aod_disabled";
    private static final String KEY_SEND_TRON_LOG = "send_tron_log";
    private static final String KEY_CPU_FREQ_INTERACTIVE = "cpufreq-i";
    private static final String KEY_CPU_FREQ_NONINTERACTIVE = "cpufreq-n";
    private final Object mLock;
    private final Handler mHandler;
    @GuardedBy(value="mLock")
    private String mSettings;
    @GuardedBy(value="mLock")
    private String mDeviceSpecificSettings;
    @GuardedBy(value="mLock")
    private String mDeviceSpecificSettingsSource;
    @GuardedBy(value="mLock")
    private String mEventLogKeys;
    @GuardedBy(value="mLock")
    private boolean mVibrationDisabledConfig;
    @GuardedBy(value="mLock")
    private boolean mVibrationDisabledEffective;
    @GuardedBy(value="mLock")
    private boolean mAnimationDisabled;
    @GuardedBy(value="mLock")
    private boolean mSoundTriggerDisabled;
    @GuardedBy(value="mLock")
    private boolean mFullBackupDeferred;
    @GuardedBy(value="mLock")
    private boolean mKeyValueBackupDeferred;
    @GuardedBy(value="mLock")
    private boolean mFireWallDisabled;
    @GuardedBy(value="mLock")
    private boolean mAdjustBrightnessDisabled;
    @GuardedBy(value="mLock")
    private boolean mDataSaverDisabled;
    @GuardedBy(value="mLock")
    private boolean mLaunchBoostDisabled;
    @GuardedBy(value="mLock")
    private int mGpsMode;
    @GuardedBy(value="mLock")
    private float mAdjustBrightnessFactor;
    @GuardedBy(value="mLock")
    private boolean mForceAllAppsStandby;
    @GuardedBy(value="mLock")
    private boolean mForceBackgroundCheck;
    @GuardedBy(value="mLock")
    private boolean mOptionalSensorsDisabled;
    @GuardedBy(value="mLock")
    private boolean mAodDisabled;
    @GuardedBy(value="mLock")
    private boolean mSendTronLog;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final BatterySavingStats mBatterySavingStats;
    @GuardedBy(value="mLock")
    private final List<BatterySaverPolicyListener> mListeners = new ArrayList<BatterySaverPolicyListener>();
    @GuardedBy(value="mLock")
    private ArrayMap<String, String> mFilesForInteractive;
    @GuardedBy(value="mLock")
    private ArrayMap<String, String> mFilesForNoninteractive;
    @GuardedBy(value="mLock")
    private boolean mAccessibilityEnabled;

    public BatterySaverPolicy(Object lock, Context context, BatterySavingStats batterySavingStats) {
        super(BackgroundThread.getHandler());
        this.mLock = lock;
        this.mHandler = BackgroundThread.getHandler();
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mBatterySavingStats = batterySavingStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        ConcurrentUtils.wtfIfLockHeld(TAG, this.mLock);
        this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("battery_saver_constants"), false, this);
        this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("battery_saver_device_specific_constants"), false, this);
        AccessibilityManager acm = this.mContext.getSystemService(AccessibilityManager.class);
        acm.addAccessibilityStateChangeListener(enabled -> {
            Object object = this.mLock;
            synchronized (object) {
                this.mAccessibilityEnabled = enabled;
            }
            this.refreshSettings();
        });
        boolean enabled2 = acm.isEnabled();
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityEnabled = enabled2;
        }
        this.onChange(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(BatterySaverPolicyListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListeners.add(listener);
        }
    }

    @VisibleForTesting
    String getGlobalSetting(String key) {
        return Settings.Global.getString(this.mContentResolver, key);
    }

    @VisibleForTesting
    int getDeviceSpecificConfigResId() {
        return 0x1040114;
    }

    @Override
    public void onChange(boolean selfChange, Uri uri) {
        this.refreshSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSettings() {
        BatterySaverPolicyListener[] listeners;
        Object object = this.mLock;
        synchronized (object) {
            String setting = this.getGlobalSetting("battery_saver_constants");
            String deviceSpecificSetting = this.getGlobalSetting("battery_saver_device_specific_constants");
            this.mDeviceSpecificSettingsSource = "battery_saver_device_specific_constants";
            if (TextUtils.isEmpty(deviceSpecificSetting) || "null".equals(deviceSpecificSetting)) {
                deviceSpecificSetting = this.mContext.getString(this.getDeviceSpecificConfigResId());
                this.mDeviceSpecificSettingsSource = "(overlay)";
            }
            this.updateConstantsLocked(setting, deviceSpecificSetting);
            listeners = this.mListeners.toArray(new BatterySaverPolicyListener[this.mListeners.size()]);
        }
        this.mHandler.post(() -> {
            for (BatterySaverPolicyListener listener : listeners) {
                listener.onBatterySaverPolicyChanged(this);
            }
        });
    }

    @GuardedBy(value="mLock")
    @VisibleForTesting
    void updateConstantsLocked(String setting, String deviceSpecificSetting) {
        this.mSettings = setting;
        this.mDeviceSpecificSettings = deviceSpecificSetting;
        KeyValueListParser parser = new KeyValueListParser(',');
        try {
            parser.setString(setting);
        }
        catch (IllegalArgumentException e) {
            Slog.wtf(TAG, "Bad battery saver constants: " + setting);
        }
        this.mVibrationDisabledConfig = parser.getBoolean(KEY_VIBRATION_DISABLED, true);
        this.mAnimationDisabled = parser.getBoolean(KEY_ANIMATION_DISABLED, false);
        this.mSoundTriggerDisabled = parser.getBoolean(KEY_SOUNDTRIGGER_DISABLED, true);
        this.mFullBackupDeferred = parser.getBoolean(KEY_FULLBACKUP_DEFERRED, true);
        this.mKeyValueBackupDeferred = parser.getBoolean(KEY_KEYVALUE_DEFERRED, true);
        this.mFireWallDisabled = parser.getBoolean(KEY_FIREWALL_DISABLED, false);
        this.mAdjustBrightnessDisabled = parser.getBoolean(KEY_ADJUST_BRIGHTNESS_DISABLED, true);
        this.mAdjustBrightnessFactor = parser.getFloat(KEY_ADJUST_BRIGHTNESS_FACTOR, 0.5f);
        this.mDataSaverDisabled = parser.getBoolean(KEY_DATASAVER_DISABLED, true);
        this.mLaunchBoostDisabled = parser.getBoolean(KEY_LAUNCH_BOOST_DISABLED, true);
        this.mForceAllAppsStandby = parser.getBoolean(KEY_FORCE_ALL_APPS_STANDBY, true);
        this.mForceBackgroundCheck = parser.getBoolean(KEY_FORCE_BACKGROUND_CHECK, true);
        this.mOptionalSensorsDisabled = parser.getBoolean(KEY_OPTIONAL_SENSORS_DISABLED, true);
        this.mAodDisabled = parser.getBoolean(KEY_AOD_DISABLED, true);
        this.mSendTronLog = parser.getBoolean(KEY_SEND_TRON_LOG, false);
        int defaultGpsMode = Settings.Secure.getInt(this.mContentResolver, SECURE_KEY_GPS_MODE, 2);
        this.mGpsMode = parser.getInt(KEY_GPS_MODE, defaultGpsMode);
        try {
            parser.setString(deviceSpecificSetting);
        }
        catch (IllegalArgumentException e) {
            Slog.wtf(TAG, "Bad device specific battery saver constants: " + deviceSpecificSetting);
        }
        this.mFilesForInteractive = new CpuFrequencies().parseString(parser.getString(KEY_CPU_FREQ_INTERACTIVE, "")).toSysFileMap();
        this.mFilesForNoninteractive = new CpuFrequencies().parseString(parser.getString(KEY_CPU_FREQ_NONINTERACTIVE, "")).toSysFileMap();
        this.mVibrationDisabledEffective = this.mVibrationDisabledConfig && !this.mAccessibilityEnabled;
        StringBuilder sb = new StringBuilder();
        if (this.mForceAllAppsStandby) {
            sb.append("A");
        }
        if (this.mForceBackgroundCheck) {
            sb.append("B");
        }
        if (this.mVibrationDisabledEffective) {
            sb.append("v");
        }
        if (this.mAnimationDisabled) {
            sb.append("a");
        }
        if (this.mSoundTriggerDisabled) {
            sb.append("s");
        }
        if (this.mFullBackupDeferred) {
            sb.append("F");
        }
        if (this.mKeyValueBackupDeferred) {
            sb.append("K");
        }
        if (!this.mFireWallDisabled) {
            sb.append("f");
        }
        if (!this.mDataSaverDisabled) {
            sb.append("d");
        }
        if (!this.mAdjustBrightnessDisabled) {
            sb.append("b");
        }
        if (this.mLaunchBoostDisabled) {
            sb.append("l");
        }
        if (this.mOptionalSensorsDisabled) {
            sb.append("S");
        }
        if (this.mAodDisabled) {
            sb.append("o");
        }
        if (this.mSendTronLog) {
            sb.append("t");
        }
        sb.append(this.mGpsMode);
        this.mEventLogKeys = sb.toString();
        this.mBatterySavingStats.setSendTronLog(this.mSendTronLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerSaveState getBatterySaverPolicy(int type, boolean realMode) {
        Object object = this.mLock;
        synchronized (object) {
            PowerSaveState.Builder builder = new PowerSaveState.Builder().setGlobalBatterySaverEnabled(realMode);
            if (!realMode) {
                return builder.setBatterySaverEnabled(realMode).build();
            }
            switch (type) {
                case 1: {
                    return builder.setBatterySaverEnabled(realMode).setGpsMode(this.mGpsMode).build();
                }
                case 3: {
                    return builder.setBatterySaverEnabled(this.mAnimationDisabled).build();
                }
                case 4: {
                    return builder.setBatterySaverEnabled(this.mFullBackupDeferred).build();
                }
                case 5: {
                    return builder.setBatterySaverEnabled(this.mKeyValueBackupDeferred).build();
                }
                case 6: {
                    return builder.setBatterySaverEnabled(!this.mFireWallDisabled).build();
                }
                case 7: {
                    return builder.setBatterySaverEnabled(!this.mAdjustBrightnessDisabled).setBrightnessFactor(this.mAdjustBrightnessFactor).build();
                }
                case 10: {
                    return builder.setBatterySaverEnabled(!this.mDataSaverDisabled).build();
                }
                case 8: {
                    return builder.setBatterySaverEnabled(this.mSoundTriggerDisabled).build();
                }
                case 2: {
                    return builder.setBatterySaverEnabled(this.mVibrationDisabledEffective).build();
                }
                case 11: {
                    return builder.setBatterySaverEnabled(this.mForceAllAppsStandby).build();
                }
                case 12: {
                    return builder.setBatterySaverEnabled(this.mForceBackgroundCheck).build();
                }
                case 13: {
                    return builder.setBatterySaverEnabled(this.mOptionalSensorsDisabled).build();
                }
                case 14: {
                    return builder.setBatterySaverEnabled(this.mAodDisabled).build();
                }
            }
            return builder.setBatterySaverEnabled(realMode).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGpsMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mGpsMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayMap<String, String> getFileValues(boolean interactive) {
        Object object = this.mLock;
        synchronized (object) {
            return interactive ? this.mFilesForInteractive : this.mFilesForNoninteractive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLaunchBoostDisabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLaunchBoostDisabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toEventLogString() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEventLogKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println();
            this.mBatterySavingStats.dump(pw, "");
            pw.println();
            pw.println("Battery saver policy (*NOTE* they only apply when battery saver is ON):");
            pw.println("  Settings: battery_saver_constants");
            pw.println("    value: " + this.mSettings);
            pw.println("  Settings: " + this.mDeviceSpecificSettingsSource);
            pw.println("    value: " + this.mDeviceSpecificSettings);
            pw.println();
            pw.println("  mAccessibilityEnabled=" + this.mAccessibilityEnabled);
            pw.println("  vibration_disabled:config=" + this.mVibrationDisabledConfig);
            pw.println("  vibration_disabled:effective=" + this.mVibrationDisabledEffective);
            pw.println("  animation_disabled=" + this.mAnimationDisabled);
            pw.println("  fullbackup_deferred=" + this.mFullBackupDeferred);
            pw.println("  keyvaluebackup_deferred=" + this.mKeyValueBackupDeferred);
            pw.println("  firewall_disabled=" + this.mFireWallDisabled);
            pw.println("  datasaver_disabled=" + this.mDataSaverDisabled);
            pw.println("  launch_boost_disabled=" + this.mLaunchBoostDisabled);
            pw.println("  adjust_brightness_disabled=" + this.mAdjustBrightnessDisabled);
            pw.println("  adjust_brightness_factor=" + this.mAdjustBrightnessFactor);
            pw.println("  gps_mode=" + this.mGpsMode);
            pw.println("  force_all_apps_standby=" + this.mForceAllAppsStandby);
            pw.println("  force_background_check=" + this.mForceBackgroundCheck);
            pw.println("  optional_sensors_disabled=" + this.mOptionalSensorsDisabled);
            pw.println("  aod_disabled=" + this.mAodDisabled);
            pw.println("  send_tron_log=" + this.mSendTronLog);
            pw.println();
            pw.print("  Interactive File values:\n");
            this.dumpMap(pw, "    ", this.mFilesForInteractive);
            pw.println();
            pw.print("  Noninteractive File values:\n");
            this.dumpMap(pw, "    ", this.mFilesForNoninteractive);
        }
    }

    private void dumpMap(PrintWriter pw, String prefix, ArrayMap<String, String> map) {
        if (map == null) {
            return;
        }
        int size = map.size();
        for (int i = 0; i < size; ++i) {
            pw.print(prefix);
            pw.print(map.keyAt(i));
            pw.print(": '");
            pw.print(map.valueAt(i));
            pw.println("'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void setAccessibilityEnabledForTest(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityEnabled = enabled;
        }
    }

    public static interface BatterySaverPolicyListener {
        public void onBatterySaverPolicyChanged(BatterySaverPolicy var1);
    }
}

