/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.view.animation.Interpolator;

public class LogDecelerateInterpolator
implements Interpolator {
    private int mBase;
    private int mDrift;
    private final float mLogScale;

    public LogDecelerateInterpolator(int base, int drift) {
        this.mBase = base;
        this.mDrift = drift;
        this.mLogScale = 1.0f / LogDecelerateInterpolator.computeLog(1.0f, this.mBase, this.mDrift);
    }

    private static float computeLog(float t, int base, int drift) {
        return (float)(-Math.pow(base, -t)) + 1.0f + (float)drift * t;
    }

    @Override
    public float getInterpolation(float t) {
        return LogDecelerateInterpolator.computeLog(t, this.mBase, this.mDrift) * this.mLogScale;
    }
}

