/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.IUidObserver;
import android.app.usage.UsageStatsManagerInternal;
import android.appwidget.AppWidgetProviderInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.IShortcutService;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutServiceInternal;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.LocaleList;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.EventLog;
import android.util.KeyValueListParser;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.util.TypedValue;
import android.util.Xml;
import android.view.IWindowManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Preconditions;
import com.android.internal.util.StatLogger;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.pm.ShortcutBitmapSaver;
import com.android.server.pm.ShortcutDumpFiles;
import com.android.server.pm.ShortcutLauncher;
import com.android.server.pm.ShortcutNonPersistentUser;
import com.android.server.pm.ShortcutPackage;
import com.android.server.pm.ShortcutPackageItem;
import com.android.server.pm.ShortcutRequestPinProcessor;
import com.android.server.pm.ShortcutUser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import libcore.io.IoUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ShortcutService
extends IShortcutService.Stub {
    static final String TAG = "ShortcutService";
    static final boolean DEBUG = false;
    static final boolean DEBUG_LOAD = false;
    static final boolean DEBUG_PROCSTATE = false;
    @VisibleForTesting
    static final long DEFAULT_RESET_INTERVAL_SEC = 86400L;
    @VisibleForTesting
    static final int DEFAULT_MAX_UPDATES_PER_INTERVAL = 10;
    @VisibleForTesting
    static final int DEFAULT_MAX_SHORTCUTS_PER_APP = 5;
    @VisibleForTesting
    static final int DEFAULT_MAX_ICON_DIMENSION_DP = 96;
    @VisibleForTesting
    static final int DEFAULT_MAX_ICON_DIMENSION_LOWRAM_DP = 48;
    @VisibleForTesting
    static final String DEFAULT_ICON_PERSIST_FORMAT = Bitmap.CompressFormat.PNG.name();
    @VisibleForTesting
    static final int DEFAULT_ICON_PERSIST_QUALITY = 100;
    @VisibleForTesting
    static final int DEFAULT_SAVE_DELAY_MS = 3000;
    @VisibleForTesting
    static final String FILENAME_BASE_STATE = "shortcut_service.xml";
    @VisibleForTesting
    static final String DIRECTORY_PER_USER = "shortcut_service";
    @VisibleForTesting
    static final String DIRECTORY_DUMP = "shortcut_dump";
    @VisibleForTesting
    static final String FILENAME_USER_PACKAGES = "shortcuts.xml";
    static final String DIRECTORY_BITMAPS = "bitmaps";
    private static final String TAG_ROOT = "root";
    private static final String TAG_LAST_RESET_TIME = "last_reset_time";
    private static final String ATTR_VALUE = "value";
    private static final String LAUNCHER_INTENT_CATEGORY = "android.intent.category.LAUNCHER";
    private static final String KEY_SHORTCUT = "shortcut";
    private static final String KEY_LOW_RAM = "lowRam";
    private static final String KEY_ICON_SIZE = "iconSize";
    private static final String DUMMY_MAIN_ACTIVITY = "android.__dummy__";
    final Context mContext;
    private final Object mLock = new Object();
    private static List<ResolveInfo> EMPTY_RESOLVE_INFO = new ArrayList<ResolveInfo>(0);
    private static Predicate<ResolveInfo> ACTIVITY_NOT_EXPORTED = new Predicate<ResolveInfo>(){

        @Override
        public boolean test(ResolveInfo ri) {
            return !ri.activityInfo.exported;
        }
    };
    private static Predicate<PackageInfo> PACKAGE_NOT_INSTALLED = new Predicate<PackageInfo>(){

        @Override
        public boolean test(PackageInfo pi) {
            return !ShortcutService.isInstalled(pi);
        }
    };
    private final Handler mHandler;
    @GuardedBy(value="mLock")
    private final ArrayList<ShortcutServiceInternal.ShortcutChangeListener> mListeners = new ArrayList(1);
    @GuardedBy(value="mLock")
    private long mRawLastResetTime;
    @GuardedBy(value="mLock")
    private final SparseArray<ShortcutUser> mUsers = new SparseArray();
    @GuardedBy(value="mLock")
    private final SparseArray<ShortcutNonPersistentUser> mShortcutNonPersistentUsers = new SparseArray();
    private int mMaxShortcuts;
    int mMaxUpdatesPerInterval;
    private long mResetInterval;
    private int mMaxIconDimension;
    private Bitmap.CompressFormat mIconPersistFormat;
    private int mIconPersistQuality;
    private int mSaveDelayMillis;
    private final IPackageManager mIPackageManager;
    private final PackageManagerInternal mPackageManagerInternal;
    private final UserManagerInternal mUserManagerInternal;
    private final UsageStatsManagerInternal mUsageStatsManagerInternal;
    private final ActivityManagerInternal mActivityManagerInternal;
    private final ShortcutRequestPinProcessor mShortcutRequestPinProcessor;
    private final ShortcutBitmapSaver mShortcutBitmapSaver;
    private final ShortcutDumpFiles mShortcutDumpFiles;
    @GuardedBy(value="mLock")
    final SparseIntArray mUidState = new SparseIntArray();
    @GuardedBy(value="mLock")
    final SparseLongArray mUidLastForegroundElapsedTime = new SparseLongArray();
    @GuardedBy(value="mLock")
    private List<Integer> mDirtyUserIds = new ArrayList<Integer>();
    private final AtomicBoolean mBootCompleted = new AtomicBoolean();
    private static final int PACKAGE_MATCH_FLAGS = 794624;
    @GuardedBy(value="mUnlockedUsers")
    final SparseBooleanArray mUnlockedUsers = new SparseBooleanArray();
    private final StatLogger mStatLogger = new StatLogger(new String[]{"getHomeActivities()", "Launcher permission check", "getPackageInfo()", "getPackageInfo(SIG)", "getApplicationInfo", "cleanupDanglingBitmaps", "getActivity+metadata", "getInstalledPackages", "checkPackageChanges", "getApplicationResources", "resourceNameLookup", "getLauncherActivity", "checkLauncherActivity", "isActivityEnabled", "packageUpdateCheck", "asyncPreloadUserDelay", "getDefaultLauncher()"});
    private static final int PROCESS_STATE_FOREGROUND_THRESHOLD = 4;
    static final int OPERATION_SET = 0;
    static final int OPERATION_ADD = 1;
    static final int OPERATION_UPDATE = 2;
    @GuardedBy(value="mLock")
    private int mWtfCount = 0;
    @GuardedBy(value="mLock")
    private Exception mLastWtfStacktrace;
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        @Override
        public void onUidStateChanged(int uid, int procState, long procStateSeq) {
            ShortcutService.this.injectPostToHandler(() -> ShortcutService.this.handleOnUidStateChanged(uid, procState));
        }

        @Override
        public void onUidGone(int uid, boolean disabled) {
            ShortcutService.this.injectPostToHandler(() -> ShortcutService.this.handleOnUidStateChanged(uid, 19));
        }

        @Override
        public void onUidActive(int uid) {
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) {
        }

        @Override
        public void onUidCachedChanged(int uid, boolean cached) {
        }
    };
    private final Runnable mSaveDirtyInfoRunner = this::saveDirtyInfo;
    final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (!ShortcutService.this.mBootCompleted.get()) {
                return;
            }
            try {
                if ("android.intent.action.LOCALE_CHANGED".equals(intent.getAction())) {
                    ShortcutService.this.handleLocaleChanged();
                }
            }
            catch (Exception e) {
                ShortcutService.this.wtf("Exception in mReceiver.onReceive", e);
            }
        }
    };
    @VisibleForTesting
    final BroadcastReceiver mPackageMonitor = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                Slog.w(ShortcutService.TAG, "Intent broadcast does not contain user handle: " + intent);
                return;
            }
            String action = intent.getAction();
            long token = ShortcutService.this.injectClearCallingIdentity();
            try {
                String packageName;
                Object object = ShortcutService.this.mLock;
                // MONITORENTER : object
                if (!ShortcutService.this.isUserUnlockedL(userId)) {
                    // MONITOREXIT : object
                    return;
                }
                ShortcutUser user = ShortcutService.this.getUserShortcutsLocked(userId);
                user.clearLauncher();
                // MONITOREXIT : object
                if ("android.intent.action.ACTION_PREFERRED_ACTIVITY_CHANGED".equals(action)) {
                    return;
                }
                Uri intentUri = intent.getData();
                String string2 = packageName = intentUri != null ? intentUri.getSchemeSpecificPart() : null;
                if (packageName == null) {
                    Slog.w(ShortcutService.TAG, "Intent broadcast does not contain package name: " + intent);
                    return;
                }
                boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                switch (action) {
                    case "android.intent.action.PACKAGE_ADDED": {
                        if (replacing) {
                            ShortcutService.this.handlePackageUpdateFinished(packageName, userId);
                            return;
                        }
                        ShortcutService.this.handlePackageAdded(packageName, userId);
                        return;
                    }
                    case "android.intent.action.PACKAGE_REMOVED": {
                        if (replacing) return;
                        ShortcutService.this.handlePackageRemoved(packageName, userId);
                        return;
                    }
                    case "android.intent.action.PACKAGE_CHANGED": {
                        ShortcutService.this.handlePackageChanged(packageName, userId);
                        return;
                    }
                    case "android.intent.action.PACKAGE_DATA_CLEARED": {
                        ShortcutService.this.handlePackageDataCleared(packageName, userId);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                ShortcutService.this.wtf("Exception in mPackageMonitor.onReceive", e);
                return;
            }
            finally {
                ShortcutService.this.injectRestoreCallingIdentity(token);
            }
        }
    };

    public ShortcutService(Context context) {
        this(context, BackgroundThread.get().getLooper(), false);
    }

    @VisibleForTesting
    ShortcutService(Context context, Looper looper, boolean onlyForPackageManagerApis) {
        this.mContext = Preconditions.checkNotNull(context);
        LocalServices.addService(ShortcutServiceInternal.class, new LocalService());
        this.mHandler = new Handler(looper);
        this.mIPackageManager = AppGlobals.getPackageManager();
        this.mPackageManagerInternal = Preconditions.checkNotNull(LocalServices.getService(PackageManagerInternal.class));
        this.mUserManagerInternal = Preconditions.checkNotNull(LocalServices.getService(UserManagerInternal.class));
        this.mUsageStatsManagerInternal = Preconditions.checkNotNull(LocalServices.getService(UsageStatsManagerInternal.class));
        this.mActivityManagerInternal = Preconditions.checkNotNull(LocalServices.getService(ActivityManagerInternal.class));
        this.mShortcutRequestPinProcessor = new ShortcutRequestPinProcessor(this, this.mLock);
        this.mShortcutBitmapSaver = new ShortcutBitmapSaver(this);
        this.mShortcutDumpFiles = new ShortcutDumpFiles(this);
        if (onlyForPackageManagerApis) {
            return;
        }
        IntentFilter packageFilter = new IntentFilter();
        packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        packageFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        packageFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        packageFilter.addAction("android.intent.action.PACKAGE_DATA_CLEARED");
        packageFilter.addDataScheme("package");
        packageFilter.setPriority(1000);
        this.mContext.registerReceiverAsUser(this.mPackageMonitor, UserHandle.ALL, packageFilter, null, this.mHandler);
        IntentFilter preferedActivityFilter = new IntentFilter();
        preferedActivityFilter.addAction("android.intent.action.ACTION_PREFERRED_ACTIVITY_CHANGED");
        preferedActivityFilter.setPriority(1000);
        this.mContext.registerReceiverAsUser(this.mPackageMonitor, UserHandle.ALL, preferedActivityFilter, null, this.mHandler);
        IntentFilter localeFilter = new IntentFilter();
        localeFilter.addAction("android.intent.action.LOCALE_CHANGED");
        localeFilter.setPriority(1000);
        this.mContext.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, localeFilter, null, this.mHandler);
        this.injectRegisterUidObserver(this.mUidObserver, 3);
    }

    long getStatStartTime() {
        return this.mStatLogger.getTime();
    }

    void logDurationStat(int statId, long start) {
        this.mStatLogger.logDurationStat(statId, start);
    }

    public String injectGetLocaleTagsForUser(int userId) {
        return LocaleList.getDefault().toLanguageTags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOnUidStateChanged(int uid, int procState) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUidState.put(uid, procState);
            if (this.isProcessStateForeground(procState)) {
                this.mUidLastForegroundElapsedTime.put(uid, this.injectElapsedRealtime());
            }
        }
    }

    private boolean isProcessStateForeground(int processState) {
        return processState <= 4;
    }

    @GuardedBy(value="mLock")
    boolean isUidForegroundLocked(int uid) {
        if (uid == 1000) {
            return true;
        }
        if (this.isProcessStateForeground(this.mUidState.get(uid, 19))) {
            return true;
        }
        return this.isProcessStateForeground(this.mActivityManagerInternal.getUidProcessState(uid));
    }

    @GuardedBy(value="mLock")
    long getUidLastForegroundElapsedTimeLocked(int uid) {
        return this.mUidLastForegroundElapsedTime.get(uid);
    }

    void onBootPhase(int phase) {
        switch (phase) {
            case 480: {
                this.initialize();
                break;
            }
            case 1000: {
                this.mBootCompleted.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnlockUser(int userId) {
        SparseBooleanArray sparseBooleanArray = this.mUnlockedUsers;
        synchronized (sparseBooleanArray) {
            this.mUnlockedUsers.put(userId, true);
        }
        long start = this.getStatStartTime();
        this.injectRunOnNewThread(() -> {
            Object object = this.mLock;
            synchronized (object) {
                this.logDurationStat(15, start);
                this.getUserShortcutsLocked(userId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleStopUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.unloadUserLocked(userId);
            SparseBooleanArray sparseBooleanArray = this.mUnlockedUsers;
            synchronized (sparseBooleanArray) {
                this.mUnlockedUsers.put(userId, false);
            }
        }
    }

    @GuardedBy(value="mLock")
    private void unloadUserLocked(int userId) {
        this.saveDirtyInfo();
        this.mUsers.delete(userId);
    }

    private AtomicFile getBaseStateFile() {
        File path = new File(this.injectSystemDataPath(), FILENAME_BASE_STATE);
        path.mkdirs();
        return new AtomicFile(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.mLock;
        synchronized (object) {
            this.loadConfigurationLocked();
            this.loadBaseStateLocked();
        }
    }

    private void loadConfigurationLocked() {
        this.updateConfigurationLocked(this.injectShortcutManagerConstants());
    }

    @VisibleForTesting
    boolean updateConfigurationLocked(String config) {
        boolean result = true;
        KeyValueListParser parser = new KeyValueListParser(',');
        try {
            parser.setString(config);
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "Bad shortcut manager settings", e);
            result = false;
        }
        this.mSaveDelayMillis = Math.max(0, (int)parser.getLong("save_delay_ms", 3000L));
        this.mResetInterval = Math.max(1L, parser.getLong("reset_interval_sec", 86400L) * 1000L);
        this.mMaxUpdatesPerInterval = Math.max(0, (int)parser.getLong("max_updates_per_interval", 10L));
        this.mMaxShortcuts = Math.max(0, (int)parser.getLong("max_shortcuts", 5L));
        int iconDimensionDp = Math.max(1, this.injectIsLowRamDevice() ? (int)parser.getLong("max_icon_dimension_dp_lowram", 48L) : (int)parser.getLong("max_icon_dimension_dp", 96L));
        this.mMaxIconDimension = this.injectDipToPixel(iconDimensionDp);
        this.mIconPersistFormat = Bitmap.CompressFormat.valueOf(parser.getString("icon_format", DEFAULT_ICON_PERSIST_FORMAT));
        this.mIconPersistQuality = (int)parser.getLong("icon_quality", 100L);
        return result;
    }

    @VisibleForTesting
    String injectShortcutManagerConstants() {
        return Settings.Global.getString(this.mContext.getContentResolver(), "shortcut_manager_constants");
    }

    @VisibleForTesting
    int injectDipToPixel(int dip) {
        return (int)TypedValue.applyDimension(1, dip, this.mContext.getResources().getDisplayMetrics());
    }

    static String parseStringAttribute(XmlPullParser parser, String attribute) {
        return parser.getAttributeValue(null, attribute);
    }

    static boolean parseBooleanAttribute(XmlPullParser parser, String attribute) {
        return ShortcutService.parseLongAttribute(parser, attribute) == 1L;
    }

    static boolean parseBooleanAttribute(XmlPullParser parser, String attribute, boolean def) {
        return ShortcutService.parseLongAttribute(parser, attribute, def ? 1 : 0) == 1L;
    }

    static int parseIntAttribute(XmlPullParser parser, String attribute) {
        return (int)ShortcutService.parseLongAttribute(parser, attribute);
    }

    static int parseIntAttribute(XmlPullParser parser, String attribute, int def) {
        return (int)ShortcutService.parseLongAttribute(parser, attribute, def);
    }

    static long parseLongAttribute(XmlPullParser parser, String attribute) {
        return ShortcutService.parseLongAttribute(parser, attribute, 0L);
    }

    static long parseLongAttribute(XmlPullParser parser, String attribute, long def) {
        String value = ShortcutService.parseStringAttribute(parser, attribute);
        if (TextUtils.isEmpty(value)) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Slog.e(TAG, "Error parsing long " + value);
            return def;
        }
    }

    static ComponentName parseComponentNameAttribute(XmlPullParser parser, String attribute) {
        String value = ShortcutService.parseStringAttribute(parser, attribute);
        if (TextUtils.isEmpty(value)) {
            return null;
        }
        return ComponentName.unflattenFromString(value);
    }

    static Intent parseIntentAttributeNoDefault(XmlPullParser parser, String attribute) {
        String value = ShortcutService.parseStringAttribute(parser, attribute);
        Intent parsed = null;
        if (!TextUtils.isEmpty(value)) {
            try {
                parsed = Intent.parseUri(value, 0);
            }
            catch (URISyntaxException e) {
                Slog.e(TAG, "Error parsing intent", e);
            }
        }
        return parsed;
    }

    static Intent parseIntentAttribute(XmlPullParser parser, String attribute) {
        Intent parsed = ShortcutService.parseIntentAttributeNoDefault(parser, attribute);
        if (parsed == null) {
            parsed = new Intent("android.intent.action.VIEW");
        }
        return parsed;
    }

    static void writeTagValue(XmlSerializer out, String tag, String value) throws IOException {
        if (TextUtils.isEmpty(value)) {
            return;
        }
        out.startTag(null, tag);
        out.attribute(null, ATTR_VALUE, value);
        out.endTag(null, tag);
    }

    static void writeTagValue(XmlSerializer out, String tag, long value) throws IOException {
        ShortcutService.writeTagValue(out, tag, Long.toString(value));
    }

    static void writeTagValue(XmlSerializer out, String tag, ComponentName name) throws IOException {
        if (name == null) {
            return;
        }
        ShortcutService.writeTagValue(out, tag, name.flattenToString());
    }

    static void writeTagExtra(XmlSerializer out, String tag, PersistableBundle bundle) throws IOException, XmlPullParserException {
        if (bundle == null) {
            return;
        }
        out.startTag(null, tag);
        bundle.saveToXml(out);
        out.endTag(null, tag);
    }

    static void writeAttr(XmlSerializer out, String name, CharSequence value) throws IOException {
        if (TextUtils.isEmpty(value)) {
            return;
        }
        out.attribute(null, name, value.toString());
    }

    static void writeAttr(XmlSerializer out, String name, long value) throws IOException {
        ShortcutService.writeAttr(out, name, String.valueOf(value));
    }

    static void writeAttr(XmlSerializer out, String name, boolean value) throws IOException {
        if (value) {
            ShortcutService.writeAttr(out, name, "1");
        } else {
            ShortcutService.writeAttr(out, name, "0");
        }
    }

    static void writeAttr(XmlSerializer out, String name, ComponentName comp) throws IOException {
        if (comp == null) {
            return;
        }
        ShortcutService.writeAttr(out, name, comp.flattenToString());
    }

    static void writeAttr(XmlSerializer out, String name, Intent intent) throws IOException {
        if (intent == null) {
            return;
        }
        ShortcutService.writeAttr(out, name, intent.toUri(0));
    }

    @GuardedBy(value="mLock")
    @VisibleForTesting
    void saveBaseStateLocked() {
        AtomicFile file = this.getBaseStateFile();
        FileOutputStream outs = null;
        try {
            outs = file.startWrite();
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(outs, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.startTag(null, TAG_ROOT);
            ShortcutService.writeTagValue((XmlSerializer)out, TAG_LAST_RESET_TIME, this.mRawLastResetTime);
            out.endTag(null, TAG_ROOT);
            out.endDocument();
            file.finishWrite(outs);
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to write to file " + file.getBaseFile(), e);
            file.failWrite(outs);
        }
    }

    @GuardedBy(value="mLock")
    private void loadBaseStateLocked() {
        this.mRawLastResetTime = 0L;
        AtomicFile file = this.getBaseStateFile();
        try (FileInputStream in2 = file.openRead();){
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(in2, StandardCharsets.UTF_8.name());
            block21: while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                int depth = parser.getDepth();
                String tag = parser.getName();
                if (depth == 1) {
                    if (TAG_ROOT.equals(tag)) continue;
                    Slog.e(TAG, "Invalid root tag: " + tag);
                    return;
                }
                switch (tag) {
                    case "last_reset_time": {
                        this.mRawLastResetTime = ShortcutService.parseLongAttribute(parser, ATTR_VALUE);
                        continue block21;
                    }
                }
                Slog.e(TAG, "Invalid tag: " + tag);
            }
        }
        catch (FileNotFoundException in2) {
        }
        catch (IOException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to read file " + file.getBaseFile(), e);
            this.mRawLastResetTime = 0L;
        }
        this.getLastResetTimeLocked();
    }

    @VisibleForTesting
    final File getUserFile(int userId) {
        return new File(this.injectUserDataPath(userId), FILENAME_USER_PACKAGES);
    }

    @GuardedBy(value="mLock")
    private void saveUserLocked(int userId) {
        File path = this.getUserFile(userId);
        this.mShortcutBitmapSaver.waitForAllSavesLocked();
        path.getParentFile().mkdirs();
        AtomicFile file = new AtomicFile(path);
        FileOutputStream os = null;
        try {
            os = file.startWrite();
            this.saveUserInternalLocked(userId, os, false);
            file.finishWrite(os);
            this.cleanupDanglingBitmapDirectoriesLocked(userId);
        }
        catch (IOException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to write to file " + file.getBaseFile(), e);
            file.failWrite(os);
        }
    }

    @GuardedBy(value="mLock")
    private void saveUserInternalLocked(int userId, OutputStream os, boolean forBackup) throws IOException, XmlPullParserException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        FastXmlSerializer out = new FastXmlSerializer();
        out.setOutput(bos, StandardCharsets.UTF_8.name());
        out.startDocument(null, true);
        this.getUserShortcutsLocked(userId).saveToXml(out, forBackup);
        out.endDocument();
        bos.flush();
        os.flush();
    }

    static IOException throwForInvalidTag(int depth, String tag) throws IOException {
        throw new IOException(String.format("Invalid tag '%s' found at depth %d", tag, depth));
    }

    static void warnForInvalidTag(int depth, String tag) throws IOException {
        Slog.w(TAG, String.format("Invalid tag '%s' found at depth %d", tag, depth));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShortcutUser loadUserLocked(int userId) {
        FileInputStream in;
        File path = this.getUserFile(userId);
        AtomicFile file = new AtomicFile(path);
        try {
            in = file.openRead();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            ShortcutUser ret;
            ShortcutUser shortcutUser = ret = this.loadUserInternal(userId, in, false);
            return shortcutUser;
        }
        catch (InvalidFileFormatException | IOException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to read file " + file.getBaseFile(), e);
            ShortcutUser shortcutUser = null;
            return shortcutUser;
        }
        finally {
            IoUtils.closeQuietly(in);
        }
    }

    private ShortcutUser loadUserInternal(int userId, InputStream is, boolean fromBackup) throws XmlPullParserException, IOException, InvalidFileFormatException {
        int type;
        BufferedInputStream bis = new BufferedInputStream(is);
        ShortcutUser ret = null;
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(bis, StandardCharsets.UTF_8.name());
        while ((type = parser.next()) != 1) {
            if (type != 2) continue;
            int depth = parser.getDepth();
            String tag = parser.getName();
            if (depth == 1 && "user".equals(tag)) {
                ret = ShortcutUser.loadFromXml(this, parser, userId, fromBackup);
                continue;
            }
            ShortcutService.throwForInvalidTag(depth, tag);
        }
        return ret;
    }

    private void scheduleSaveBaseState() {
        this.scheduleSaveInner(-10000);
    }

    void scheduleSaveUser(int userId) {
        this.scheduleSaveInner(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSaveInner(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mDirtyUserIds.contains(userId)) {
                this.mDirtyUserIds.add(userId);
            }
        }
        this.mHandler.removeCallbacks(this.mSaveDirtyInfoRunner);
        this.mHandler.postDelayed(this.mSaveDirtyInfoRunner, this.mSaveDelayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void saveDirtyInfo() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                for (int i = this.mDirtyUserIds.size() - 1; i >= 0; --i) {
                    int userId = this.mDirtyUserIds.get(i);
                    if (userId == -10000) {
                        this.saveBaseStateLocked();
                        continue;
                    }
                    this.saveUserLocked(userId);
                }
                this.mDirtyUserIds.clear();
            }
        }
        catch (Exception e) {
            this.wtf("Exception in saveDirtyInfo", e);
        }
    }

    @GuardedBy(value="mLock")
    long getLastResetTimeLocked() {
        this.updateTimesLocked();
        return this.mRawLastResetTime;
    }

    @GuardedBy(value="mLock")
    long getNextResetTimeLocked() {
        this.updateTimesLocked();
        return this.mRawLastResetTime + this.mResetInterval;
    }

    static boolean isClockValid(long time) {
        return time >= 1420070400L;
    }

    @GuardedBy(value="mLock")
    private void updateTimesLocked() {
        long now = this.injectCurrentTimeMillis();
        long prevLastResetTime = this.mRawLastResetTime;
        if (this.mRawLastResetTime == 0L) {
            this.mRawLastResetTime = now;
        } else if (now < this.mRawLastResetTime) {
            if (ShortcutService.isClockValid(now)) {
                Slog.w(TAG, "Clock rewound");
                this.mRawLastResetTime = now;
            }
        } else if (this.mRawLastResetTime + this.mResetInterval <= now) {
            long offset = this.mRawLastResetTime % this.mResetInterval;
            this.mRawLastResetTime = now / this.mResetInterval * this.mResetInterval + offset;
        }
        if (prevLastResetTime != this.mRawLastResetTime) {
            this.scheduleSaveBaseState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUserUnlockedL(int userId) {
        SparseBooleanArray sparseBooleanArray = this.mUnlockedUsers;
        synchronized (sparseBooleanArray) {
            if (this.mUnlockedUsers.get(userId)) {
                return true;
            }
            return this.mUserManagerInternal.isUserUnlockingOrUnlocked(userId);
        }
    }

    void throwIfUserLockedL(int userId) {
        if (!this.isUserUnlockedL(userId)) {
            throw new IllegalStateException("User " + userId + " is locked or not running");
        }
    }

    @GuardedBy(value="mLock")
    private boolean isUserLoadedLocked(int userId) {
        return this.mUsers.get(userId) != null;
    }

    @GuardedBy(value="mLock")
    ShortcutUser getUserShortcutsLocked(int userId) {
        ShortcutUser userPackages;
        if (!this.isUserUnlockedL(userId)) {
            this.wtf("User still locked");
        }
        if ((userPackages = this.mUsers.get(userId)) == null) {
            userPackages = this.loadUserLocked(userId);
            if (userPackages == null) {
                userPackages = new ShortcutUser(this, userId);
            }
            this.mUsers.put(userId, userPackages);
            this.checkPackageChanges(userId);
        }
        return userPackages;
    }

    @GuardedBy(value="mLock")
    ShortcutNonPersistentUser getNonPersistentUserLocked(int userId) {
        ShortcutNonPersistentUser ret = this.mShortcutNonPersistentUsers.get(userId);
        if (ret == null) {
            ret = new ShortcutNonPersistentUser(this, userId);
            this.mShortcutNonPersistentUsers.put(userId, ret);
        }
        return ret;
    }

    @GuardedBy(value="mLock")
    void forEachLoadedUserLocked(Consumer<ShortcutUser> c) {
        for (int i = this.mUsers.size() - 1; i >= 0; --i) {
            c.accept(this.mUsers.valueAt(i));
        }
    }

    @GuardedBy(value="mLock")
    ShortcutPackage getPackageShortcutsLocked(String packageName, int userId) {
        return this.getUserShortcutsLocked(userId).getPackageShortcuts(packageName);
    }

    @GuardedBy(value="mLock")
    ShortcutPackage getPackageShortcutsForPublisherLocked(String packageName, int userId) {
        ShortcutPackage ret = this.getUserShortcutsLocked(userId).getPackageShortcuts(packageName);
        ret.getUser().onCalledByPublisher(packageName);
        return ret;
    }

    @GuardedBy(value="mLock")
    ShortcutLauncher getLauncherShortcutsLocked(String packageName, int ownerUserId, int launcherUserId) {
        return this.getUserShortcutsLocked(ownerUserId).getLauncherShortcuts(packageName, launcherUserId);
    }

    void removeIconLocked(ShortcutInfo shortcut) {
        this.mShortcutBitmapSaver.removeIcon(shortcut);
    }

    public void cleanupBitmapsForPackage(int userId, String packageName) {
        File packagePath = new File(this.getUserBitmapFilePath(userId), packageName);
        if (!packagePath.isDirectory()) {
            return;
        }
        if (!FileUtils.deleteContents(packagePath) || !packagePath.delete()) {
            Slog.w(TAG, "Unable to remove directory " + packagePath);
        }
    }

    @GuardedBy(value="mLock")
    private void cleanupDanglingBitmapDirectoriesLocked(int userId) {
        long start = this.getStatStartTime();
        ShortcutUser user = this.getUserShortcutsLocked(userId);
        File bitmapDir = this.getUserBitmapFilePath(userId);
        File[] children = bitmapDir.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (!child.isDirectory()) continue;
            String packageName = child.getName();
            if (!user.hasPackage(packageName)) {
                this.cleanupBitmapsForPackage(userId, packageName);
                continue;
            }
            this.cleanupDanglingBitmapFilesLocked(userId, user, packageName, child);
        }
        this.logDurationStat(5, start);
    }

    private void cleanupDanglingBitmapFilesLocked(int userId, ShortcutUser user, String packageName, File path) {
        ArraySet<String> usedFiles = user.getPackageShortcuts(packageName).getUsedBitmapFiles();
        for (File child : path.listFiles()) {
            String name;
            if (!child.isFile() || usedFiles.contains(name = child.getName())) continue;
            child.delete();
        }
    }

    FileOutputStreamWithPath openIconFileForWrite(int userId, ShortcutInfo shortcut) throws IOException {
        File packagePath = new File(this.getUserBitmapFilePath(userId), shortcut.getPackage());
        if (!packagePath.isDirectory()) {
            packagePath.mkdirs();
            if (!packagePath.isDirectory()) {
                throw new IOException("Unable to create directory " + packagePath);
            }
            SELinux.restorecon(packagePath);
        }
        String baseName = String.valueOf(this.injectCurrentTimeMillis());
        int suffix = 0;
        String filename;
        File file;
        while ((file = new File(packagePath, filename = (suffix == 0 ? baseName : baseName + "_" + suffix) + ".png")).exists()) {
            ++suffix;
        }
        return new FileOutputStreamWithPath(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveIconAndFixUpShortcutLocked(ShortcutInfo shortcut) {
        if (shortcut.hasIconFile() || shortcut.hasIconResource()) {
            return;
        }
        long token = this.injectClearCallingIdentity();
        try {
            this.removeIconLocked(shortcut);
            Icon icon = shortcut.getIcon();
            if (icon == null) {
                return;
            }
            int maxIconDimension = this.mMaxIconDimension;
            try {
                switch (icon.getType()) {
                    case 2: {
                        this.injectValidateIconResPackage(shortcut, icon);
                        shortcut.setIconResourceId(icon.getResId());
                        shortcut.addFlags(4);
                        return;
                    }
                    case 1: {
                        Bitmap bitmap = icon.getBitmap();
                        break;
                    }
                    case 5: {
                        Bitmap bitmap = icon.getBitmap();
                        maxIconDimension = (int)((float)maxIconDimension * (1.0f + 2.0f * AdaptiveIconDrawable.getExtraInsetFraction()));
                        break;
                    }
                    default: {
                        throw ShortcutInfo.getInvalidIconException();
                    }
                }
                this.mShortcutBitmapSaver.saveBitmapLocked(shortcut, maxIconDimension, this.mIconPersistFormat, this.mIconPersistQuality);
            }
            finally {
                shortcut.clearIcon();
            }
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    void injectValidateIconResPackage(ShortcutInfo shortcut, Icon icon) {
        if (!shortcut.getPackage().equals(icon.getResPackage())) {
            throw new IllegalArgumentException("Icon resource must reside in shortcut owner package");
        }
    }

    static Bitmap shrinkBitmap(Bitmap in, int maxSize) {
        int ow = in.getWidth();
        int oh = in.getHeight();
        if (ow <= maxSize && oh <= maxSize) {
            return in;
        }
        int longerDimension = Math.max(ow, oh);
        int nw = ow * maxSize / longerDimension;
        int nh = oh * maxSize / longerDimension;
        Bitmap scaledBitmap = Bitmap.createBitmap(nw, nh, Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(scaledBitmap);
        RectF dst = new RectF(0.0f, 0.0f, nw, nh);
        c.drawBitmap(in, null, dst, null);
        return scaledBitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixUpShortcutResourceNamesAndValues(ShortcutInfo si) {
        Resources publisherRes = this.injectGetResourcesForApplicationAsUser(si.getPackage(), si.getUserId());
        if (publisherRes != null) {
            long start = this.getStatStartTime();
            try {
                si.lookupAndFillInResourceNames(publisherRes);
            }
            finally {
                this.logDurationStat(10, start);
            }
            si.resolveResourceStrings(publisherRes);
        }
    }

    private boolean isCallerSystem() {
        int callingUid = this.injectBinderCallingUid();
        return UserHandle.isSameApp(callingUid, 1000);
    }

    private boolean isCallerShell() {
        int callingUid = this.injectBinderCallingUid();
        return callingUid == 2000 || callingUid == 0;
    }

    private void enforceSystemOrShell() {
        if (!this.isCallerSystem() && !this.isCallerShell()) {
            throw new SecurityException("Caller must be system or shell");
        }
    }

    private void enforceShell() {
        if (!this.isCallerShell()) {
            throw new SecurityException("Caller must be shell");
        }
    }

    private void enforceSystem() {
        if (!this.isCallerSystem()) {
            throw new SecurityException("Caller must be system");
        }
    }

    private void enforceResetThrottlingPermission() {
        if (this.isCallerSystem()) {
            return;
        }
        this.enforceCallingOrSelfPermission("android.permission.RESET_SHORTCUT_MANAGER_THROTTLING", null);
    }

    private void enforceCallingOrSelfPermission(String permission2, String message) {
        if (this.isCallerSystem()) {
            return;
        }
        this.injectEnforceCallingPermission(permission2, message);
    }

    @VisibleForTesting
    void injectEnforceCallingPermission(String permission2, String message) {
        this.mContext.enforceCallingPermission(permission2, message);
    }

    private void verifyCaller(String packageName, int userId) {
        Preconditions.checkStringNotEmpty(packageName, "packageName");
        if (this.isCallerSystem()) {
            return;
        }
        int callingUid = this.injectBinderCallingUid();
        if (UserHandle.getUserId(callingUid) != userId) {
            throw new SecurityException("Invalid user-ID");
        }
        if (this.injectGetPackageUid(packageName, userId) != callingUid) {
            throw new SecurityException("Calling package name mismatch");
        }
        Preconditions.checkState(!this.isEphemeralApp(packageName, userId), "Ephemeral apps can't use ShortcutManager");
    }

    private void verifyShortcutInfoPackage(String callerPackage, ShortcutInfo si) {
        if (si == null) {
            return;
        }
        if (!Objects.equals(callerPackage, si.getPackage())) {
            EventLog.writeEvent(1397638484, "109824443", -1, "");
            throw new SecurityException("Shortcut package name mismatch");
        }
    }

    private void verifyShortcutInfoPackages(String callerPackage, List<ShortcutInfo> list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.verifyShortcutInfoPackage(callerPackage, list.get(i));
        }
    }

    void injectPostToHandler(Runnable r) {
        this.mHandler.post(r);
    }

    void injectRunOnNewThread(Runnable r) {
        new Thread(r).start();
    }

    void enforceMaxActivityShortcuts(int numShortcuts) {
        if (numShortcuts > this.mMaxShortcuts) {
            throw new IllegalArgumentException("Max number of dynamic shortcuts exceeded");
        }
    }

    int getMaxActivityShortcuts() {
        return this.mMaxShortcuts;
    }

    void packageShortcutsChanged(String packageName, int userId) {
        this.notifyListeners(packageName, userId);
        this.scheduleSaveUser(userId);
    }

    private void notifyListeners(String packageName, int userId) {
        this.injectPostToHandler(() -> {
            try {
                ArrayList<ShortcutServiceInternal.ShortcutChangeListener> copy;
                Object object = this.mLock;
                synchronized (object) {
                    if (!this.isUserUnlockedL(userId)) {
                        return;
                    }
                    copy = new ArrayList<ShortcutServiceInternal.ShortcutChangeListener>(this.mListeners);
                }
                for (int i = copy.size() - 1; i >= 0; --i) {
                    copy.get(i).onShortcutChanged(packageName, userId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void fixUpIncomingShortcutInfo(ShortcutInfo shortcut, boolean forUpdate, boolean forPinRequest) {
        if (shortcut.isReturnedByServer()) {
            Log.w(TAG, "Re-publishing ShortcutInfo returned by server is not supported. Some information such as icon may lost from shortcut.");
        }
        Preconditions.checkNotNull(shortcut, "Null shortcut detected");
        if (shortcut.getActivity() != null) {
            Preconditions.checkState(shortcut.getPackage().equals(shortcut.getActivity().getPackageName()), "Cannot publish shortcut: activity " + shortcut.getActivity() + " does not belong to package " + shortcut.getPackage());
            Preconditions.checkState(this.injectIsMainActivity(shortcut.getActivity(), shortcut.getUserId()), "Cannot publish shortcut: activity " + shortcut.getActivity() + " is not main activity");
        }
        if (!forUpdate) {
            shortcut.enforceMandatoryFields(forPinRequest);
            if (!forPinRequest) {
                Preconditions.checkState(shortcut.getActivity() != null, "Cannot publish shortcut: target activity is not set");
            }
        }
        if (shortcut.getIcon() != null) {
            ShortcutInfo.validateIcon(shortcut.getIcon());
        }
        shortcut.replaceFlags(0);
    }

    private void fixUpIncomingShortcutInfo(ShortcutInfo shortcut, boolean forUpdate) {
        this.fixUpIncomingShortcutInfo(shortcut, forUpdate, false);
    }

    public void validateShortcutForPinRequest(ShortcutInfo shortcut) {
        this.fixUpIncomingShortcutInfo(shortcut, false, true);
    }

    private void fillInDefaultActivity(List<ShortcutInfo> shortcuts) {
        ComponentName defaultActivity = null;
        for (int i = shortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = shortcuts.get(i);
            if (si.getActivity() != null) continue;
            if (defaultActivity == null) {
                defaultActivity = this.injectGetDefaultMainActivity(si.getPackage(), si.getUserId());
                Preconditions.checkState(defaultActivity != null, "Launcher activity not found for package " + si.getPackage());
            }
            si.setActivity(defaultActivity);
        }
    }

    private void assignImplicitRanks(List<ShortcutInfo> shortcuts) {
        for (int i = shortcuts.size() - 1; i >= 0; --i) {
            shortcuts.get(i).setImplicitRank(i);
        }
    }

    private List<ShortcutInfo> setReturnedByServer(List<ShortcutInfo> shortcuts) {
        for (int i = shortcuts.size() - 1; i >= 0; --i) {
            shortcuts.get(i).setReturnedByServer();
        }
        return shortcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDynamicShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) {
        this.verifyCaller(packageName, userId);
        List newShortcuts = shortcutInfoList.getList();
        this.verifyShortcutInfoPackages(packageName, newShortcuts);
        int size = newShortcuts.size();
        boolean unlimited = this.injectHasUnlimitedShortcutsApiCallsPermission(this.injectBinderCallingPid(), this.injectBinderCallingUid());
        Object object = this.mLock;
        synchronized (object) {
            int i;
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncluded(newShortcuts, true);
            this.fillInDefaultActivity(newShortcuts);
            ps.enforceShortcutCountsBeforeOperation(newShortcuts, 0);
            if (!ps.tryApiCall(unlimited)) {
                return false;
            }
            ps.clearAllImplicitRanks();
            this.assignImplicitRanks(newShortcuts);
            for (i = 0; i < size; ++i) {
                this.fixUpIncomingShortcutInfo((ShortcutInfo)newShortcuts.get(i), false);
            }
            ps.deleteAllDynamicShortcuts(true);
            for (i = 0; i < size; ++i) {
                ShortcutInfo newShortcut = (ShortcutInfo)newShortcuts.get(i);
                ps.addOrReplaceDynamicShortcut(newShortcut);
            }
            ps.adjustRanks();
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) {
        this.verifyCaller(packageName, userId);
        List newShortcuts = shortcutInfoList.getList();
        this.verifyShortcutInfoPackages(packageName, newShortcuts);
        int size = newShortcuts.size();
        boolean unlimited = this.injectHasUnlimitedShortcutsApiCallsPermission(this.injectBinderCallingPid(), this.injectBinderCallingUid());
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncluded(newShortcuts, true);
            ps.enforceShortcutCountsBeforeOperation(newShortcuts, 2);
            if (!ps.tryApiCall(unlimited)) {
                return false;
            }
            ps.clearAllImplicitRanks();
            this.assignImplicitRanks(newShortcuts);
            for (int i = 0; i < size; ++i) {
                boolean replacingIcon;
                ShortcutInfo source = (ShortcutInfo)newShortcuts.get(i);
                this.fixUpIncomingShortcutInfo(source, true);
                ShortcutInfo target = ps.findShortcutById(source.getId());
                if (target == null || !target.isVisibleToPublisher()) continue;
                if (target.isEnabled() != source.isEnabled()) {
                    Slog.w(TAG, "ShortcutInfo.enabled cannot be changed with updateShortcuts()");
                }
                if (source.hasRank()) {
                    target.setRankChanged();
                    target.setImplicitRank(source.getImplicitRank());
                }
                boolean bl = replacingIcon = source.getIcon() != null;
                if (replacingIcon) {
                    this.removeIconLocked(target);
                }
                target.copyNonNullFieldsFrom(source);
                target.setTimestamp(this.injectCurrentTimeMillis());
                if (replacingIcon) {
                    this.saveIconAndFixUpShortcutLocked(target);
                }
                if (!replacingIcon && !source.hasStringResources()) continue;
                this.fixUpShortcutResourceNamesAndValues(target);
            }
            ps.adjustRanks();
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addDynamicShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) {
        this.verifyCaller(packageName, userId);
        List newShortcuts = shortcutInfoList.getList();
        this.verifyShortcutInfoPackages(packageName, newShortcuts);
        int size = newShortcuts.size();
        boolean unlimited = this.injectHasUnlimitedShortcutsApiCallsPermission(this.injectBinderCallingPid(), this.injectBinderCallingUid());
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncluded(newShortcuts, true);
            this.fillInDefaultActivity(newShortcuts);
            ps.enforceShortcutCountsBeforeOperation(newShortcuts, 1);
            ps.clearAllImplicitRanks();
            this.assignImplicitRanks(newShortcuts);
            if (!ps.tryApiCall(unlimited)) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                ShortcutInfo newShortcut = (ShortcutInfo)newShortcuts.get(i);
                this.fixUpIncomingShortcutInfo(newShortcut, false);
                newShortcut.setRankChanged();
                ps.addOrReplaceDynamicShortcut(newShortcut);
            }
            ps.adjustRanks();
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
        return true;
    }

    @Override
    public boolean requestPinShortcut(String packageName, ShortcutInfo shortcut, IntentSender resultIntent, int userId) {
        Preconditions.checkNotNull(shortcut);
        Preconditions.checkArgument(shortcut.isEnabled(), "Shortcut must be enabled");
        return this.requestPinItem(packageName, userId, shortcut, null, null, resultIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Intent createShortcutResultIntent(String packageName, ShortcutInfo shortcut, int userId) throws RemoteException {
        Intent ret;
        Preconditions.checkNotNull(shortcut);
        Preconditions.checkArgument(shortcut.isEnabled(), "Shortcut must be enabled");
        this.verifyCaller(packageName, userId);
        this.verifyShortcutInfoPackage(packageName, shortcut);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ret = this.mShortcutRequestPinProcessor.createShortcutResultIntent(shortcut, userId);
        }
        this.verifyStates();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestPinItem(String packageName, int userId, ShortcutInfo shortcut, AppWidgetProviderInfo appWidget, Bundle extras, IntentSender resultIntent) {
        boolean ret;
        this.verifyCaller(packageName, userId);
        this.verifyShortcutInfoPackage(packageName, shortcut);
        Object object = this.mLock;
        synchronized (object) {
            String id2;
            ShortcutPackage ps;
            this.throwIfUserLockedL(userId);
            Preconditions.checkState(this.isUidForegroundLocked(this.injectBinderCallingUid()), "Calling application must have a foreground activity or a foreground service");
            if (shortcut != null && (ps = this.getPackageShortcutsForPublisherLocked(packageName, userId)).isShortcutExistsAndInvisibleToPublisher(id2 = shortcut.getId())) {
                ps.updateInvisibleShortcutForPinRequestWith(shortcut);
                this.packageShortcutsChanged(packageName, userId);
            }
            ret = this.mShortcutRequestPinProcessor.requestPinItemLocked(shortcut, appWidget, extras, userId, resultIntent);
        }
        this.verifyStates();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableShortcuts(String packageName, List shortcutIds, CharSequence disabledMessage, int disabledMessageResId, int userId) {
        this.verifyCaller(packageName, userId);
        Preconditions.checkNotNull(shortcutIds, "shortcutIds must be provided");
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncludedWithIds(shortcutIds, true);
            String disabledMessageString = disabledMessage == null ? null : disabledMessage.toString();
            for (int i = shortcutIds.size() - 1; i >= 0; --i) {
                String id2 = Preconditions.checkStringNotEmpty((String)shortcutIds.get(i));
                if (!ps.isShortcutExistsAndVisibleToPublisher(id2)) continue;
                ps.disableWithId(id2, disabledMessageString, disabledMessageResId, false, true, 1);
            }
            ps.adjustRanks();
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableShortcuts(String packageName, List shortcutIds, int userId) {
        this.verifyCaller(packageName, userId);
        Preconditions.checkNotNull(shortcutIds, "shortcutIds must be provided");
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncludedWithIds(shortcutIds, true);
            for (int i = shortcutIds.size() - 1; i >= 0; --i) {
                String id2 = Preconditions.checkStringNotEmpty((String)shortcutIds.get(i));
                if (!ps.isShortcutExistsAndVisibleToPublisher(id2)) continue;
                ps.enableWithId(id2);
            }
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDynamicShortcuts(String packageName, List shortcutIds, int userId) {
        this.verifyCaller(packageName, userId);
        Preconditions.checkNotNull(shortcutIds, "shortcutIds must be provided");
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncludedWithIds(shortcutIds, true);
            for (int i = shortcutIds.size() - 1; i >= 0; --i) {
                String id2 = Preconditions.checkStringNotEmpty((String)shortcutIds.get(i));
                if (!ps.isShortcutExistsAndVisibleToPublisher(id2)) continue;
                ps.deleteDynamicWithId(id2, true);
            }
            ps.adjustRanks();
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllDynamicShortcuts(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.deleteAllDynamicShortcuts(true);
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ShortcutInfo> getDynamicShortcuts(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            return this.getShortcutsWithQueryLocked(packageName, userId, 9, ShortcutInfo::isDynamicVisible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ShortcutInfo> getManifestShortcuts(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            return this.getShortcutsWithQueryLocked(packageName, userId, 9, ShortcutInfo::isManifestVisible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ShortcutInfo> getPinnedShortcuts(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            return this.getShortcutsWithQueryLocked(packageName, userId, 9, ShortcutInfo::isPinnedVisible);
        }
    }

    @GuardedBy(value="mLock")
    private ParceledListSlice<ShortcutInfo> getShortcutsWithQueryLocked(String packageName, int userId, int cloneFlags, Predicate<ShortcutInfo> query) {
        ArrayList<ShortcutInfo> ret = new ArrayList<ShortcutInfo>();
        ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
        ps.findAll(ret, query, cloneFlags);
        return new ParceledListSlice<ShortcutInfo>(this.setReturnedByServer(ret));
    }

    @Override
    public int getMaxShortcutCountPerActivity(String packageName, int userId) throws RemoteException {
        this.verifyCaller(packageName, userId);
        return this.mMaxShortcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRemainingCallCount(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        boolean unlimited = this.injectHasUnlimitedShortcutsApiCallsPermission(this.injectBinderCallingPid(), this.injectBinderCallingUid());
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            return this.mMaxUpdatesPerInterval - ps.getApiCallCount(unlimited);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRateLimitResetTime(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            return this.getNextResetTimeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIconMaxDimensions(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            return this.mMaxIconDimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportShortcutUsed(String packageName, String shortcutId, int userId) {
        long token;
        this.verifyCaller(packageName, userId);
        Preconditions.checkNotNull(shortcutId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            if (ps.findShortcutById(shortcutId) == null) {
                Log.w(TAG, String.format("reportShortcutUsed: package %s doesn't have shortcut %s", packageName, shortcutId));
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl15 : MonitorExitStatement: MONITOREXIT : var4_4
            token = this.injectClearCallingIdentity();
        }
        try {
            this.mUsageStatsManagerInternal.reportShortcutUsage(packageName, shortcutId, userId);
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRequestPinItemSupported(int callingUserId, int requestType) {
        long token = this.injectClearCallingIdentity();
        try {
            boolean bl = this.mShortcutRequestPinProcessor.isRequestPinItemSupported(callingUserId, requestType);
            return bl;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    @Override
    public void resetThrottling() {
        this.enforceSystemOrShell();
        this.resetThrottlingInner(this.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetThrottlingInner(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isUserUnlockedL(userId)) {
                Log.w(TAG, "User " + userId + " is locked or not running");
                return;
            }
            this.getUserShortcutsLocked(userId).resetThrottling();
        }
        this.scheduleSaveUser(userId);
        Slog.i(TAG, "ShortcutManager: throttling counter reset for user " + userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAllThrottlingInner() {
        Object object = this.mLock;
        synchronized (object) {
            this.mRawLastResetTime = this.injectCurrentTimeMillis();
        }
        this.scheduleSaveBaseState();
        Slog.i(TAG, "ShortcutManager: throttling counter reset for all users");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onApplicationActive(String packageName, int userId) {
        this.enforceResetThrottlingPermission();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isUserUnlockedL(userId)) {
                return;
            }
            this.getPackageShortcutsLocked(packageName, userId).resetRateLimitingForCommandLineNoSaving();
            this.saveUserLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasShortcutHostPermission(String callingPackage, int userId, int callingPid, int callingUid) {
        if (this.canSeeAnyPinnedShortcut(callingPackage, userId, callingPid, callingUid)) {
            return true;
        }
        long start = this.getStatStartTime();
        try {
            boolean bl = this.hasShortcutHostPermissionInner(callingPackage, userId);
            return bl;
        }
        finally {
            this.logDurationStat(4, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canSeeAnyPinnedShortcut(String callingPackage, int userId, int callingPid, int callingUid) {
        if (this.injectHasAccessShortcutsPermission(callingPid, callingUid)) {
            return true;
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.getNonPersistentUserLocked(userId).hasHostPackage(callingPackage);
        }
    }

    @VisibleForTesting
    boolean injectHasAccessShortcutsPermission(int callingPid, int callingUid) {
        return this.mContext.checkPermission("android.permission.ACCESS_SHORTCUTS", callingPid, callingUid) == 0;
    }

    @VisibleForTesting
    boolean injectHasUnlimitedShortcutsApiCallsPermission(int callingPid, int callingUid) {
        return this.mContext.checkPermission("android.permission.UNLIMITED_SHORTCUTS_API_CALLS", callingPid, callingUid) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean hasShortcutHostPermissionInner(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutUser user = this.getUserShortcutsLocked(userId);
            ComponentName cached = user.getCachedLauncher();
            if (cached != null && cached.getPackageName().equals(packageName)) {
                return true;
            }
            ComponentName detected = this.getDefaultLauncher(userId);
            user.setLauncher(detected);
            if (detected != null) {
                return detected.getPackageName().equals(packageName);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName getDefaultLauncher(int userId) {
        long start = this.getStatStartTime();
        long token = this.injectClearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.throwIfUserLockedL(userId);
                ShortcutUser user = this.getUserShortcutsLocked(userId);
                ArrayList<ResolveInfo> allHomeCandidates = new ArrayList<ResolveInfo>();
                long startGetHomeActivitiesAsUser = this.getStatStartTime();
                ComponentName defaultLauncher = this.mPackageManagerInternal.getHomeActivitiesAsUser(allHomeCandidates, userId);
                this.logDurationStat(0, startGetHomeActivitiesAsUser);
                ComponentName detected = null;
                if (defaultLauncher != null) {
                    detected = defaultLauncher;
                } else {
                    detected = user.getLastKnownLauncher();
                    if (detected != null && !this.injectIsActivityEnabledAndExported(detected, userId)) {
                        Slog.w(TAG, "Cached launcher " + detected + " no longer exists");
                        detected = null;
                        user.clearLauncher();
                    }
                }
                if (detected == null) {
                    int size = allHomeCandidates.size();
                    int lastPriority = Integer.MIN_VALUE;
                    for (int i = 0; i < size; ++i) {
                        ResolveInfo ri = (ResolveInfo)allHomeCandidates.get(i);
                        if (!ri.activityInfo.applicationInfo.isSystemApp() || ri.priority < lastPriority) continue;
                        detected = ri.activityInfo.getComponentName();
                        lastPriority = ri.priority;
                    }
                }
                ComponentName componentName = detected;
                return componentName;
            }
        }
        finally {
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(16, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShortcutHostPackage(String type, String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.getNonPersistentUserLocked(userId).setShortcutHostPackage(type, packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpPackageForAllLoadedUsers(String packageName, int packageUserId, boolean appStillExists) {
        Object object = this.mLock;
        synchronized (object) {
            this.forEachLoadedUserLocked(user -> this.cleanUpPackageLocked(packageName, user.getUserId(), packageUserId, appStillExists));
        }
    }

    @GuardedBy(value="mLock")
    @VisibleForTesting
    void cleanUpPackageLocked(String packageName, int owningUserId, int packageUserId, boolean appStillExists) {
        boolean wasUserLoaded = this.isUserLoadedLocked(owningUserId);
        ShortcutUser user = this.getUserShortcutsLocked(owningUserId);
        boolean doNotify = false;
        if (packageUserId == owningUserId && user.removePackage(packageName) != null) {
            doNotify = true;
        }
        user.removeLauncher(packageUserId, packageName);
        user.forAllLaunchers(l -> l.cleanUpPackage(packageName, packageUserId));
        user.forAllPackages(p -> p.refreshPinnedFlags());
        this.scheduleSaveUser(owningUserId);
        if (doNotify) {
            this.notifyListeners(packageName, owningUserId);
        }
        if (appStillExists && packageUserId == owningUserId) {
            user.rescanPackageIfNeeded(packageName, true);
        }
        if (!wasUserLoaded) {
            this.unloadUserLocked(owningUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleLocaleChanged() {
        this.scheduleSaveBaseState();
        Object object = this.mLock;
        synchronized (object) {
            long token = this.injectClearCallingIdentity();
            try {
                this.forEachLoadedUserLocked(user -> user.detectLocaleChange());
            }
            finally {
                this.injectRestoreCallingIdentity(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void checkPackageChanges(int ownerUserId) {
        if (this.injectIsSafeModeEnabled()) {
            Slog.i(TAG, "Safe mode, skipping checkPackageChanges()");
            return;
        }
        long start = this.getStatStartTime();
        try {
            ArrayList gonePackages = new ArrayList();
            Object object = this.mLock;
            synchronized (object) {
                ShortcutUser user = this.getUserShortcutsLocked(ownerUserId);
                user.forAllPackageItems(spi -> {
                    if (spi.getPackageInfo().isShadow()) {
                        return;
                    }
                    if (!this.isPackageInstalled(spi.getPackageName(), spi.getPackageUserId())) {
                        gonePackages.add(ShortcutUser.PackageWithUser.of(spi));
                    }
                });
                if (gonePackages.size() > 0) {
                    for (int i = gonePackages.size() - 1; i >= 0; --i) {
                        ShortcutUser.PackageWithUser pu = (ShortcutUser.PackageWithUser)gonePackages.get(i);
                        this.cleanUpPackageLocked(pu.packageName, ownerUserId, pu.userId, false);
                    }
                }
                this.rescanUpdatedPackagesLocked(ownerUserId, user.getLastAppScanTime());
            }
        }
        finally {
            this.logDurationStat(8, start);
        }
        this.verifyStates();
    }

    @GuardedBy(value="mLock")
    private void rescanUpdatedPackagesLocked(int userId, long lastScanTime) {
        ShortcutUser user = this.getUserShortcutsLocked(userId);
        long now = this.injectCurrentTimeMillis();
        boolean afterOta = !this.injectBuildFingerprint().equals(user.getLastAppScanOsFingerprint());
        this.forUpdatedPackages(userId, lastScanTime, afterOta, ai -> {
            user.attemptToRestoreIfNeededAndSave(this, ai.packageName, userId);
            user.rescanPackageIfNeeded(ai.packageName, true);
        });
        user.setLastAppScanTime(now);
        user.setLastAppScanOsFingerprint(this.injectBuildFingerprint());
        this.scheduleSaveUser(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageAdded(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.getUserShortcutsLocked(userId);
            user.attemptToRestoreIfNeededAndSave(this, packageName, userId);
            user.rescanPackageIfNeeded(packageName, true);
        }
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageUpdateFinished(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.getUserShortcutsLocked(userId);
            user.attemptToRestoreIfNeededAndSave(this, packageName, userId);
            if (this.isPackageInstalled(packageName, userId)) {
                user.rescanPackageIfNeeded(packageName, true);
            }
        }
        this.verifyStates();
    }

    private void handlePackageRemoved(String packageName, int packageUserId) {
        this.cleanUpPackageForAllLoadedUsers(packageName, packageUserId, false);
        this.verifyStates();
    }

    private void handlePackageDataCleared(String packageName, int packageUserId) {
        this.cleanUpPackageForAllLoadedUsers(packageName, packageUserId, true);
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageChanged(String packageName, int packageUserId) {
        if (!this.isPackageInstalled(packageName, packageUserId)) {
            this.handlePackageRemoved(packageName, packageUserId);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.getUserShortcutsLocked(packageUserId);
            user.rescanPackageIfNeeded(packageName, true);
        }
        this.verifyStates();
    }

    final PackageInfo getPackageInfoWithSignatures(String packageName, int userId) {
        return this.getPackageInfo(packageName, userId, true);
    }

    final PackageInfo getPackageInfo(String packageName, int userId) {
        return this.getPackageInfo(packageName, userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int injectGetPackageUid(String packageName, int userId) {
        long token = this.injectClearCallingIdentity();
        try {
            int n = this.mIPackageManager.getPackageUid(packageName, 794624, userId);
            return n;
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "RemoteException", e);
            int n = -1;
            return n;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    @VisibleForTesting
    final PackageInfo getPackageInfo(String packageName, int userId, boolean getSignatures) {
        return ShortcutService.isInstalledOrNull(this.injectPackageInfoWithUninstalled(packageName, userId, getSignatures));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    PackageInfo injectPackageInfoWithUninstalled(String packageName, int userId, boolean getSignatures) {
        long start = this.getStatStartTime();
        long token = this.injectClearCallingIdentity();
        try {
            PackageInfo packageInfo = this.mIPackageManager.getPackageInfo(packageName, 0xC2000 | (getSignatures ? 0x8000000 : 0), userId);
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(getSignatures ? 2 : 1, start);
            return packageInfo;
        }
        catch (RemoteException e) {
            try {
                Slog.wtf(TAG, "RemoteException", e);
                PackageInfo packageInfo = null;
                this.injectRestoreCallingIdentity(token);
                this.logDurationStat(getSignatures ? 2 : 1, start);
                return packageInfo;
            }
            catch (Throwable throwable) {
                this.injectRestoreCallingIdentity(token);
                this.logDurationStat(getSignatures ? 2 : 1, start);
                throw throwable;
            }
        }
    }

    @VisibleForTesting
    final ApplicationInfo getApplicationInfo(String packageName, int userId) {
        return ShortcutService.isInstalledOrNull(this.injectApplicationInfoWithUninstalled(packageName, userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ApplicationInfo injectApplicationInfoWithUninstalled(String packageName, int userId) {
        long start = this.getStatStartTime();
        long token = this.injectClearCallingIdentity();
        try {
            ApplicationInfo applicationInfo = this.mIPackageManager.getApplicationInfo(packageName, 794624, userId);
            return applicationInfo;
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "RemoteException", e);
            ApplicationInfo applicationInfo = null;
            return applicationInfo;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(3, start);
        }
    }

    final ActivityInfo getActivityInfoWithMetadata(ComponentName activity, int userId) {
        return ShortcutService.isInstalledOrNull(this.injectGetActivityInfoWithMetadataWithUninstalled(activity, userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ActivityInfo injectGetActivityInfoWithMetadataWithUninstalled(ComponentName activity, int userId) {
        long start = this.getStatStartTime();
        long token = this.injectClearCallingIdentity();
        try {
            ActivityInfo activityInfo = this.mIPackageManager.getActivityInfo(activity, 794752, userId);
            return activityInfo;
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "RemoteException", e);
            ActivityInfo activityInfo = null;
            return activityInfo;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(6, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final List<PackageInfo> getInstalledPackages(int userId) {
        long start = this.getStatStartTime();
        long token = this.injectClearCallingIdentity();
        try {
            List<PackageInfo> all = this.injectGetPackagesWithUninstalled(userId);
            all.removeIf(PACKAGE_NOT_INSTALLED);
            List<PackageInfo> list = all;
            return list;
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "RemoteException", e);
            List<PackageInfo> list = null;
            return list;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(7, start);
        }
    }

    @VisibleForTesting
    List<PackageInfo> injectGetPackagesWithUninstalled(int userId) throws RemoteException {
        ParceledListSlice parceledList = this.mIPackageManager.getInstalledPackages(794624, userId);
        if (parceledList == null) {
            return Collections.emptyList();
        }
        return parceledList.getList();
    }

    private void forUpdatedPackages(int userId, long lastScanTime, boolean afterOta, Consumer<ApplicationInfo> callback) {
        List<PackageInfo> list = this.getInstalledPackages(userId);
        for (int i = list.size() - 1; i >= 0; --i) {
            PackageInfo pi = list.get(i);
            if (!afterOta && pi.lastUpdateTime < lastScanTime) continue;
            callback.accept(pi.applicationInfo);
        }
    }

    private boolean isApplicationFlagSet(String packageName, int userId, int flags) {
        ApplicationInfo ai = this.injectApplicationInfoWithUninstalled(packageName, userId);
        return ai != null && (ai.flags & flags) == flags;
    }

    private static boolean isInstalled(ApplicationInfo ai) {
        return ai != null && ai.enabled && (ai.flags & 0x800000) != 0;
    }

    private static boolean isEphemeralApp(ApplicationInfo ai) {
        return ai != null && ai.isInstantApp();
    }

    private static boolean isInstalled(PackageInfo pi) {
        return pi != null && ShortcutService.isInstalled(pi.applicationInfo);
    }

    private static boolean isInstalled(ActivityInfo ai) {
        return ai != null && ShortcutService.isInstalled(ai.applicationInfo);
    }

    private static ApplicationInfo isInstalledOrNull(ApplicationInfo ai) {
        return ShortcutService.isInstalled(ai) ? ai : null;
    }

    private static PackageInfo isInstalledOrNull(PackageInfo pi) {
        return ShortcutService.isInstalled(pi) ? pi : null;
    }

    private static ActivityInfo isInstalledOrNull(ActivityInfo ai) {
        return ShortcutService.isInstalled(ai) ? ai : null;
    }

    boolean isPackageInstalled(String packageName, int userId) {
        return this.getApplicationInfo(packageName, userId) != null;
    }

    boolean isEphemeralApp(String packageName, int userId) {
        return ShortcutService.isEphemeralApp(this.getApplicationInfo(packageName, userId));
    }

    XmlResourceParser injectXmlMetaData(ActivityInfo activityInfo, String key) {
        return activityInfo.loadXmlMetaData(this.mContext.getPackageManager(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Resources injectGetResourcesForApplicationAsUser(String packageName, int userId) {
        long start = this.getStatStartTime();
        long token = this.injectClearCallingIdentity();
        try {
            Resources resources = this.mContext.getPackageManager().getResourcesForApplicationAsUser(packageName, userId);
            return resources;
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Resources for package " + packageName + " not found");
            Resources resources = null;
            return resources;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(9, start);
        }
    }

    private Intent getMainActivityIntent() {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory(LAUNCHER_INTENT_CATEGORY);
        return intent;
    }

    @VisibleForTesting
    List<ResolveInfo> queryActivities(Intent baseIntent, String packageName, ComponentName activity, int userId) {
        baseIntent.setPackage(Preconditions.checkNotNull(packageName));
        if (activity != null) {
            baseIntent.setComponent(activity);
        }
        return this.queryActivities(baseIntent, userId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> queryActivities(Intent intent, int userId, boolean exportedOnly) {
        List<ResolveInfo> resolved;
        long token = this.injectClearCallingIdentity();
        try {
            resolved = this.mContext.getPackageManager().queryIntentActivitiesAsUser(intent, 794624, userId);
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
        if (resolved == null || resolved.size() == 0) {
            return EMPTY_RESOLVE_INFO;
        }
        if (!ShortcutService.isInstalled(resolved.get((int)0).activityInfo)) {
            return EMPTY_RESOLVE_INFO;
        }
        if (exportedOnly) {
            resolved.removeIf(ACTIVITY_NOT_EXPORTED);
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName injectGetDefaultMainActivity(String packageName, int userId) {
        long start = this.getStatStartTime();
        try {
            List<ResolveInfo> resolved = this.queryActivities(this.getMainActivityIntent(), packageName, null, userId);
            ComponentName componentName = resolved.size() == 0 ? null : resolved.get((int)0).activityInfo.getComponentName();
            return componentName;
        }
        finally {
            this.logDurationStat(11, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean injectIsMainActivity(ComponentName activity, int userId) {
        long start = this.getStatStartTime();
        try {
            if (activity == null) {
                this.wtf("null activity detected");
                boolean bl = false;
                return bl;
            }
            if (DUMMY_MAIN_ACTIVITY.equals(activity.getClassName())) {
                boolean bl = true;
                return bl;
            }
            List<ResolveInfo> resolved = this.queryActivities(this.getMainActivityIntent(), activity.getPackageName(), activity, userId);
            boolean bl = resolved.size() > 0;
            return bl;
        }
        finally {
            this.logDurationStat(12, start);
        }
    }

    ComponentName getDummyMainActivity(String packageName) {
        return new ComponentName(packageName, DUMMY_MAIN_ACTIVITY);
    }

    boolean isDummyMainActivity(ComponentName name) {
        return name != null && DUMMY_MAIN_ACTIVITY.equals(name.getClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> injectGetMainActivities(String packageName, int userId) {
        long start = this.getStatStartTime();
        try {
            List<ResolveInfo> list = this.queryActivities(this.getMainActivityIntent(), packageName, null, userId);
            return list;
        }
        finally {
            this.logDurationStat(12, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean injectIsActivityEnabledAndExported(ComponentName activity, int userId) {
        long start = this.getStatStartTime();
        try {
            boolean bl = this.queryActivities(new Intent(), activity.getPackageName(), activity, userId).size() > 0;
            return bl;
        }
        finally {
            this.logDurationStat(13, start);
        }
    }

    ComponentName injectGetPinConfirmationActivity(String launcherPackageName, int launcherUserId, int requestType) {
        Preconditions.checkNotNull(launcherPackageName);
        String action = requestType == 1 ? "android.content.pm.action.CONFIRM_PIN_SHORTCUT" : "android.content.pm.action.CONFIRM_PIN_APPWIDGET";
        Intent confirmIntent = new Intent(action).setPackage(launcherPackageName);
        List<ResolveInfo> candidates = this.queryActivities(confirmIntent, launcherUserId, false);
        Iterator<ResolveInfo> iterator = candidates.iterator();
        if (iterator.hasNext()) {
            ResolveInfo ri = iterator.next();
            return ri.activityInfo.getComponentName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean injectIsSafeModeEnabled() {
        long token = this.injectClearCallingIdentity();
        try {
            boolean bl = IWindowManager.Stub.asInterface(ServiceManager.getService("window")).isSafeModeEnabled();
            return bl;
        }
        catch (RemoteException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    int getParentOrSelfUserId(int userId) {
        return this.mUserManagerInternal.getProfileParentId(userId);
    }

    void injectSendIntentSender(IntentSender intentSender, Intent extras) {
        if (intentSender == null) {
            return;
        }
        try {
            intentSender.sendIntent(this.mContext, 0, extras, null, null);
        }
        catch (IntentSender.SendIntentException e) {
            Slog.w(TAG, "sendIntent failed().", e);
        }
    }

    boolean shouldBackupApp(String packageName, int userId) {
        return this.isApplicationFlagSet(packageName, userId, 32768);
    }

    static boolean shouldBackupApp(PackageInfo pi) {
        return (pi.applicationInfo.flags & 0x8000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBackupPayload(int userId) {
        this.enforceSystem();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isUserUnlockedL(userId)) {
                this.wtf("Can't backup: user " + userId + " is locked or not running");
                return null;
            }
            ShortcutUser user = this.getUserShortcutsLocked(userId);
            if (user == null) {
                this.wtf("Can't backup: user not found: id=" + userId);
                return null;
            }
            user.forAllPackageItems(spi -> spi.refreshPackageSignatureAndSave());
            user.forAllPackages(pkg -> pkg.rescanPackageIfNeeded(false, true));
            user.forAllLaunchers(launcher -> launcher.ensurePackageInfo());
            this.scheduleSaveUser(userId);
            this.saveDirtyInfo();
            ByteArrayOutputStream os = new ByteArrayOutputStream(32768);
            try {
                this.saveUserInternalLocked(userId, os, true);
            }
            catch (IOException | XmlPullParserException e) {
                Slog.w(TAG, "Backup failed.", e);
                return null;
            }
            byte[] payload = os.toByteArray();
            this.mShortcutDumpFiles.save("backup-1-payload.txt", payload);
            return payload;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyRestore(byte[] payload, int userId) {
        this.enforceSystem();
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser restored;
            if (!this.isUserUnlockedL(userId)) {
                this.wtf("Can't restore: user " + userId + " is locked or not running");
                return;
            }
            this.mShortcutDumpFiles.save("restore-0-start.txt", pw -> {
                pw.print("Start time: ");
                this.dumpCurrentTime((PrintWriter)pw);
                pw.println();
            });
            this.mShortcutDumpFiles.save("restore-1-payload.xml", payload);
            ByteArrayInputStream is = new ByteArrayInputStream(payload);
            try {
                restored = this.loadUserInternal(userId, is, true);
            }
            catch (InvalidFileFormatException | IOException | XmlPullParserException e) {
                Slog.w(TAG, "Restoration failed.", e);
                return;
            }
            this.mShortcutDumpFiles.save("restore-2.txt", this::dumpInner);
            this.getUserShortcutsLocked(userId).mergeRestoredFile(restored);
            this.mShortcutDumpFiles.save("restore-3.txt", this::dumpInner);
            this.rescanUpdatedPackagesLocked(userId, 0L);
            this.mShortcutDumpFiles.save("restore-4.txt", this::dumpInner);
            this.mShortcutDumpFiles.save("restore-5-finish.txt", pw -> {
                pw.print("Finish time: ");
                this.dumpCurrentTime((PrintWriter)pw);
                pw.println();
            });
            this.saveUserLocked(userId);
        }
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, pw)) {
            return;
        }
        this.dumpNoCheck(fd, pw, args);
    }

    @VisibleForTesting
    void dumpNoCheck(FileDescriptor fd, PrintWriter pw, String[] args) {
        DumpFilter filter = ShortcutService.parseDumpArgs(args);
        if (filter.shouldDumpCheckIn()) {
            this.dumpCheckin(pw, filter.shouldCheckInClear());
        } else {
            if (filter.shouldDumpMain()) {
                this.dumpInner(pw, filter);
                pw.println();
            }
            if (filter.shouldDumpUid()) {
                this.dumpUid(pw);
                pw.println();
            }
            if (filter.shouldDumpFiles()) {
                this.dumpDumpFiles(pw);
                pw.println();
            }
        }
    }

    private static DumpFilter parseDumpArgs(String[] args) {
        DumpFilter filter = new DumpFilter();
        if (args == null) {
            return filter;
        }
        int argIndex = 0;
        while (argIndex < args.length) {
            String arg;
            if ("-c".equals(arg = args[argIndex++])) {
                filter.setDumpCheckIn(true);
                continue;
            }
            if ("--checkin".equals(arg)) {
                filter.setDumpCheckIn(true);
                filter.setCheckInClear(true);
                continue;
            }
            if ("-a".equals(arg) || "--all".equals(arg)) {
                filter.setDumpUid(true);
                filter.setDumpFiles(true);
                continue;
            }
            if ("-u".equals(arg) || "--uid".equals(arg)) {
                filter.setDumpUid(true);
                continue;
            }
            if ("-f".equals(arg) || "--files".equals(arg)) {
                filter.setDumpFiles(true);
                continue;
            }
            if ("-n".equals(arg) || "--no-main".equals(arg)) {
                filter.setDumpMain(false);
                continue;
            }
            if ("--user".equals(arg)) {
                if (argIndex >= args.length) {
                    throw new IllegalArgumentException("Missing user ID for --user");
                }
                try {
                    filter.addUser(Integer.parseInt(args[argIndex++]));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid user ID", e);
                }
            }
            if ("-p".equals(arg) || "--package".equals(arg)) {
                if (argIndex >= args.length) {
                    throw new IllegalArgumentException("Missing package name for --package");
                }
                filter.addPackageRegex(args[argIndex++]);
                filter.setDumpDetails(false);
                continue;
            }
            if (!arg.startsWith("-")) break;
            throw new IllegalArgumentException("Unknown option " + arg);
        }
        while (argIndex < args.length) {
            filter.addPackage(args[argIndex++]);
        }
        return filter;
    }

    private void dumpInner(PrintWriter pw) {
        this.dumpInner(pw, new DumpFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInner(PrintWriter pw, DumpFilter filter) {
        Object object = this.mLock;
        synchronized (object) {
            Object user;
            int i;
            if (filter.shouldDumpDetails()) {
                long now = this.injectCurrentTimeMillis();
                pw.print("Now: [");
                pw.print(now);
                pw.print("] ");
                pw.print(ShortcutService.formatTime(now));
                pw.print("  Raw last reset: [");
                pw.print(this.mRawLastResetTime);
                pw.print("] ");
                pw.print(ShortcutService.formatTime(this.mRawLastResetTime));
                long last = this.getLastResetTimeLocked();
                pw.print("  Last reset: [");
                pw.print(last);
                pw.print("] ");
                pw.print(ShortcutService.formatTime(last));
                long next = this.getNextResetTimeLocked();
                pw.print("  Next reset: [");
                pw.print(next);
                pw.print("] ");
                pw.print(ShortcutService.formatTime(next));
                pw.println();
                pw.println();
                pw.print("  Config:");
                pw.print("    Max icon dim: ");
                pw.println(this.mMaxIconDimension);
                pw.print("    Icon format: ");
                pw.println((Object)this.mIconPersistFormat);
                pw.print("    Icon quality: ");
                pw.println(this.mIconPersistQuality);
                pw.print("    saveDelayMillis: ");
                pw.println(this.mSaveDelayMillis);
                pw.print("    resetInterval: ");
                pw.println(this.mResetInterval);
                pw.print("    maxUpdatesPerInterval: ");
                pw.println(this.mMaxUpdatesPerInterval);
                pw.print("    maxShortcutsPerActivity: ");
                pw.println(this.mMaxShortcuts);
                pw.println();
                this.mStatLogger.dump(pw, "  ");
                pw.println();
                pw.print("  #Failures: ");
                pw.println(this.mWtfCount);
                if (this.mLastWtfStacktrace != null) {
                    pw.print("  Last failure stack trace: ");
                    pw.println(Log.getStackTraceString(this.mLastWtfStacktrace));
                }
                pw.println();
                this.mShortcutBitmapSaver.dumpLocked(pw, "  ");
                pw.println();
            }
            for (i = 0; i < this.mUsers.size(); ++i) {
                user = this.mUsers.valueAt(i);
                if (!filter.isUserMatch(((ShortcutUser)user).getUserId())) continue;
                ((ShortcutUser)user).dump(pw, "  ", filter);
                pw.println();
            }
            for (i = 0; i < this.mShortcutNonPersistentUsers.size(); ++i) {
                user = this.mShortcutNonPersistentUsers.valueAt(i);
                if (!filter.isUserMatch(((ShortcutNonPersistentUser)user).getUserId())) continue;
                ((ShortcutNonPersistentUser)user).dump(pw, "  ", filter);
                pw.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpUid(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("** SHORTCUT MANAGER UID STATES (dumpsys shortcut -n -u)");
            for (int i = 0; i < this.mUidState.size(); ++i) {
                int uid = this.mUidState.keyAt(i);
                int state = this.mUidState.valueAt(i);
                pw.print("    UID=");
                pw.print(uid);
                pw.print(" state=");
                pw.print(state);
                if (this.isProcessStateForeground(state)) {
                    pw.print("  [FG]");
                }
                pw.print("  last FG=");
                pw.print(this.mUidLastForegroundElapsedTime.get(uid));
                pw.println();
            }
        }
    }

    static String formatTime(long time) {
        Time tobj = new Time();
        tobj.set(time);
        return tobj.format("%Y-%m-%d %H:%M:%S");
    }

    private void dumpCurrentTime(PrintWriter pw) {
        pw.print(ShortcutService.formatTime(this.injectCurrentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpCheckin(PrintWriter pw, boolean clear) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                JSONArray users = new JSONArray();
                for (int i = 0; i < this.mUsers.size(); ++i) {
                    users.put(this.mUsers.valueAt(i).dumpCheckin(clear));
                }
                JSONObject result = new JSONObject();
                result.put(KEY_SHORTCUT, users);
                result.put(KEY_LOW_RAM, this.injectIsLowRamDevice());
                result.put(KEY_ICON_SIZE, this.mMaxIconDimension);
                pw.println(result.toString(1));
            }
            catch (JSONException e) {
                Slog.e(TAG, "Unable to write in json", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpDumpFiles(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("** SHORTCUT MANAGER FILES (dumpsys shortcut -n -f)");
            this.mShortcutDumpFiles.dumpAll(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        this.enforceShell();
        long token = this.injectClearCallingIdentity();
        try {
            int status = new MyShellCommand().exec(this, in, out, err, args, callback, resultReceiver);
            resultReceiver.send(status, null);
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    @VisibleForTesting
    long injectCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    long injectElapsedRealtime() {
        return SystemClock.elapsedRealtime();
    }

    @VisibleForTesting
    long injectUptimeMillis() {
        return SystemClock.uptimeMillis();
    }

    @VisibleForTesting
    int injectBinderCallingUid() {
        return ShortcutService.getCallingUid();
    }

    @VisibleForTesting
    int injectBinderCallingPid() {
        return ShortcutService.getCallingPid();
    }

    private int getCallingUserId() {
        return UserHandle.getUserId(this.injectBinderCallingUid());
    }

    @VisibleForTesting
    long injectClearCallingIdentity() {
        return Binder.clearCallingIdentity();
    }

    @VisibleForTesting
    void injectRestoreCallingIdentity(long token) {
        Binder.restoreCallingIdentity(token);
    }

    String injectBuildFingerprint() {
        return Build.FINGERPRINT;
    }

    final void wtf(String message) {
        this.wtf(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wtf(String message, Throwable e) {
        if (e == null) {
            e = new RuntimeException("Stacktrace");
        }
        Object object = this.mLock;
        synchronized (object) {
            ++this.mWtfCount;
            this.mLastWtfStacktrace = new Exception("Last failure was logged here:");
        }
        Slog.wtf(TAG, message, e);
    }

    @VisibleForTesting
    File injectSystemDataPath() {
        return Environment.getDataSystemDirectory();
    }

    @VisibleForTesting
    File injectUserDataPath(int userId) {
        return new File(Environment.getDataSystemCeDirectory(userId), DIRECTORY_PER_USER);
    }

    public File getDumpPath() {
        return new File(this.injectUserDataPath(0), DIRECTORY_DUMP);
    }

    @VisibleForTesting
    boolean injectIsLowRamDevice() {
        return ActivityManager.isLowRamDeviceStatic();
    }

    @VisibleForTesting
    void injectRegisterUidObserver(IUidObserver observer, int which) {
        try {
            ActivityManager.getService().registerUidObserver(observer, which, -1, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    File getUserBitmapFilePath(int userId) {
        return new File(this.injectUserDataPath(userId), DIRECTORY_BITMAPS);
    }

    @VisibleForTesting
    SparseArray<ShortcutUser> getShortcutsForTest() {
        return this.mUsers;
    }

    @VisibleForTesting
    int getMaxShortcutsForTest() {
        return this.mMaxShortcuts;
    }

    @VisibleForTesting
    int getMaxUpdatesPerIntervalForTest() {
        return this.mMaxUpdatesPerInterval;
    }

    @VisibleForTesting
    long getResetIntervalForTest() {
        return this.mResetInterval;
    }

    @VisibleForTesting
    int getMaxIconDimensionForTest() {
        return this.mMaxIconDimension;
    }

    @VisibleForTesting
    Bitmap.CompressFormat getIconPersistFormatForTest() {
        return this.mIconPersistFormat;
    }

    @VisibleForTesting
    int getIconPersistQualityForTest() {
        return this.mIconPersistQuality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ShortcutPackage getPackageShortcutForTest(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.mUsers.get(userId);
            if (user == null) {
                return null;
            }
            return user.getAllPackagesForTest().get(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ShortcutInfo getPackageShortcutForTest(String packageName, String shortcutId, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutPackage pkg = this.getPackageShortcutForTest(packageName, userId);
            if (pkg == null) {
                return null;
            }
            return pkg.findShortcutById(shortcutId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ShortcutLauncher getLauncherShortcutForTest(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.mUsers.get(userId);
            if (user == null) {
                return null;
            }
            return user.getAllLaunchersForTest().get(ShortcutUser.PackageWithUser.of(userId, packageName));
        }
    }

    @VisibleForTesting
    ShortcutRequestPinProcessor getShortcutRequestPinProcessorForTest() {
        return this.mShortcutRequestPinProcessor;
    }

    @VisibleForTesting
    boolean injectShouldPerformVerification() {
        return false;
    }

    final void verifyStates() {
        if (this.injectShouldPerformVerification()) {
            this.verifyStatesInner();
        }
    }

    private final void verifyStatesForce() {
        this.verifyStatesInner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyStatesInner() {
        Object object = this.mLock;
        synchronized (object) {
            this.forEachLoadedUserLocked(u -> u.forAllPackageItems(ShortcutPackageItem::verifyStates));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void waitForBitmapSavesForTest() {
        Object object = this.mLock;
        synchronized (object) {
            this.mShortcutBitmapSaver.waitForAllSavesLocked();
        }
    }

    private class MyShellCommand
    extends ShellCommand {
        private int mUserId = 0;

        private MyShellCommand() {
        }

        private void parseOptionsLocked(boolean takeUser) throws CommandException {
            String opt;
            block6: while ((opt = this.getNextOption()) != null) {
                switch (opt) {
                    case "--user": {
                        if (!takeUser) break;
                        this.mUserId = UserHandle.parseUserArg(this.getNextArgRequired());
                        if (ShortcutService.this.isUserUnlockedL(this.mUserId)) continue block6;
                        throw new CommandException("User " + this.mUserId + " is not running or locked");
                    }
                }
                throw new CommandException("Unknown option: " + opt);
            }
        }

        @Override
        public int onCommand(String cmd) {
            if (cmd == null) {
                return this.handleDefaultCommands(cmd);
            }
            PrintWriter pw = this.getOutPrintWriter();
            try {
                switch (cmd) {
                    case "reset-throttling": {
                        this.handleResetThrottling();
                        break;
                    }
                    case "reset-all-throttling": {
                        this.handleResetAllThrottling();
                        break;
                    }
                    case "override-config": {
                        this.handleOverrideConfig();
                        break;
                    }
                    case "reset-config": {
                        this.handleResetConfig();
                        break;
                    }
                    case "clear-default-launcher": {
                        this.handleClearDefaultLauncher();
                        break;
                    }
                    case "get-default-launcher": {
                        this.handleGetDefaultLauncher();
                        break;
                    }
                    case "unload-user": {
                        this.handleUnloadUser();
                        break;
                    }
                    case "clear-shortcuts": {
                        this.handleClearShortcuts();
                        break;
                    }
                    case "verify-states": {
                        this.handleVerifyStates();
                        break;
                    }
                    default: {
                        return this.handleDefaultCommands(cmd);
                    }
                }
            }
            catch (CommandException e) {
                pw.println("Error: " + e.getMessage());
                return 1;
            }
            pw.println("Success");
            return 0;
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            pw.println("Usage: cmd shortcut COMMAND [options ...]");
            pw.println();
            pw.println("cmd shortcut reset-throttling [--user USER_ID]");
            pw.println("    Reset throttling for all packages and users");
            pw.println();
            pw.println("cmd shortcut reset-all-throttling");
            pw.println("    Reset the throttling state for all users");
            pw.println();
            pw.println("cmd shortcut override-config CONFIG");
            pw.println("    Override the configuration for testing (will last until reboot)");
            pw.println();
            pw.println("cmd shortcut reset-config");
            pw.println("    Reset the configuration set with \"update-config\"");
            pw.println();
            pw.println("cmd shortcut clear-default-launcher [--user USER_ID]");
            pw.println("    Clear the cached default launcher");
            pw.println();
            pw.println("cmd shortcut get-default-launcher [--user USER_ID]");
            pw.println("    Show the default launcher");
            pw.println();
            pw.println("cmd shortcut unload-user [--user USER_ID]");
            pw.println("    Unload a user from the memory");
            pw.println("    (This should not affect any observable behavior)");
            pw.println();
            pw.println("cmd shortcut clear-shortcuts [--user USER_ID] PACKAGE");
            pw.println("    Remove all shortcuts from a package, including pinned shortcuts");
            pw.println();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResetThrottling() throws CommandException {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                this.parseOptionsLocked(true);
                Slog.i(ShortcutService.TAG, "cmd: handleResetThrottling: user=" + this.mUserId);
                ShortcutService.this.resetThrottlingInner(this.mUserId);
            }
        }

        private void handleResetAllThrottling() {
            Slog.i(ShortcutService.TAG, "cmd: handleResetAllThrottling");
            ShortcutService.this.resetAllThrottlingInner();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleOverrideConfig() throws CommandException {
            String config = this.getNextArgRequired();
            Slog.i(ShortcutService.TAG, "cmd: handleOverrideConfig: " + config);
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                if (!ShortcutService.this.updateConfigurationLocked(config)) {
                    throw new CommandException("override-config failed.  See logcat for details.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResetConfig() {
            Slog.i(ShortcutService.TAG, "cmd: handleResetConfig");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.loadConfigurationLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearLauncher() {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.getUserShortcutsLocked(this.mUserId).forceClearLauncher();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void showLauncher() {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.hasShortcutHostPermissionInner("-", this.mUserId);
                this.getOutPrintWriter().println("Launcher: " + ShortcutService.this.getUserShortcutsLocked(this.mUserId).getLastKnownLauncher());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleClearDefaultLauncher() throws CommandException {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                this.parseOptionsLocked(true);
                this.clearLauncher();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleGetDefaultLauncher() throws CommandException {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                this.parseOptionsLocked(true);
                this.clearLauncher();
                this.showLauncher();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleUnloadUser() throws CommandException {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                this.parseOptionsLocked(true);
                Slog.i(ShortcutService.TAG, "cmd: handleUnloadUser: user=" + this.mUserId);
                ShortcutService.this.handleStopUser(this.mUserId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleClearShortcuts() throws CommandException {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                this.parseOptionsLocked(true);
                String packageName = this.getNextArgRequired();
                Slog.i(ShortcutService.TAG, "cmd: handleClearShortcuts: user" + this.mUserId + ", " + packageName);
                ShortcutService.this.cleanUpPackageForAllLoadedUsers(packageName, this.mUserId, true);
            }
        }

        private void handleVerifyStates() throws CommandException {
            try {
                ShortcutService.this.verifyStatesForce();
            }
            catch (Throwable th) {
                throw new CommandException(th.getMessage() + "\n" + Log.getStackTraceString(th));
            }
        }
    }

    static class CommandException
    extends Exception {
        public CommandException(String message) {
            super(message);
        }
    }

    static class DumpFilter {
        private boolean mDumpCheckIn = false;
        private boolean mCheckInClear = false;
        private boolean mDumpMain = true;
        private boolean mDumpUid = false;
        private boolean mDumpFiles = false;
        private boolean mDumpDetails = true;
        private List<Pattern> mPackagePatterns = new ArrayList<Pattern>();
        private List<Integer> mUsers = new ArrayList<Integer>();

        DumpFilter() {
        }

        void addPackageRegex(String regex) {
            this.mPackagePatterns.add(Pattern.compile(regex));
        }

        public void addPackage(String packageName) {
            this.addPackageRegex(Pattern.quote(packageName));
        }

        void addUser(int userId) {
            this.mUsers.add(userId);
        }

        boolean isPackageMatch(String packageName) {
            if (this.mPackagePatterns.size() == 0) {
                return true;
            }
            for (int i = 0; i < this.mPackagePatterns.size(); ++i) {
                if (!this.mPackagePatterns.get(i).matcher(packageName).find()) continue;
                return true;
            }
            return false;
        }

        boolean isUserMatch(int userId) {
            if (this.mUsers.size() == 0) {
                return true;
            }
            for (int i = 0; i < this.mUsers.size(); ++i) {
                if (this.mUsers.get(i) != userId) continue;
                return true;
            }
            return false;
        }

        public boolean shouldDumpCheckIn() {
            return this.mDumpCheckIn;
        }

        public void setDumpCheckIn(boolean dumpCheckIn) {
            this.mDumpCheckIn = dumpCheckIn;
        }

        public boolean shouldCheckInClear() {
            return this.mCheckInClear;
        }

        public void setCheckInClear(boolean checkInClear) {
            this.mCheckInClear = checkInClear;
        }

        public boolean shouldDumpMain() {
            return this.mDumpMain;
        }

        public void setDumpMain(boolean dumpMain) {
            this.mDumpMain = dumpMain;
        }

        public boolean shouldDumpUid() {
            return this.mDumpUid;
        }

        public void setDumpUid(boolean dumpUid) {
            this.mDumpUid = dumpUid;
        }

        public boolean shouldDumpFiles() {
            return this.mDumpFiles;
        }

        public void setDumpFiles(boolean dumpFiles) {
            this.mDumpFiles = dumpFiles;
        }

        public boolean shouldDumpDetails() {
            return this.mDumpDetails;
        }

        public void setDumpDetails(boolean dumpDetails) {
            this.mDumpDetails = dumpDetails;
        }
    }

    private class LocalService
    extends ShortcutServiceInternal {
        private LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ShortcutInfo> getShortcuts(int launcherUserId, String callingPackage, long changedSince, String packageName, List<String> shortcutIds, ComponentName componentName, int queryFlags, int userId, int callingPid, int callingUid) {
            int cloneFlag;
            ArrayList<ShortcutInfo> ret = new ArrayList<ShortcutInfo>();
            boolean cloneKeyFieldOnly = (queryFlags & 4) != 0;
            int n = cloneFlag = cloneKeyFieldOnly ? 4 : 11;
            if (packageName == null) {
                shortcutIds = null;
            }
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave();
                if (packageName != null) {
                    this.getShortcutsInnerLocked(launcherUserId, callingPackage, packageName, shortcutIds, changedSince, componentName, queryFlags, userId, ret, cloneFlag, callingPid, callingUid);
                } else {
                    List<String> shortcutIdsF = shortcutIds;
                    ShortcutService.this.getUserShortcutsLocked(userId).forAllPackages(p -> this.getShortcutsInnerLocked(launcherUserId, callingPackage, p.getPackageName(), shortcutIdsF, changedSince, componentName, queryFlags, userId, ret, cloneFlag, callingPid, callingUid));
                }
            }
            return ShortcutService.this.setReturnedByServer(ret);
        }

        @GuardedBy(value="ShortcutService.this.mLock")
        private void getShortcutsInnerLocked(int launcherUserId, String callingPackage, String packageName, List<String> shortcutIds, long changedSince, ComponentName componentName, int queryFlags, int userId, ArrayList<ShortcutInfo> ret, int cloneFlag, int callingPid, int callingUid) {
            ArraySet<String> ids = shortcutIds == null ? null : new ArraySet<String>(shortcutIds);
            ShortcutUser user = ShortcutService.this.getUserShortcutsLocked(userId);
            ShortcutPackage p = user.getPackageShortcutsIfExists(packageName);
            if (p == null) {
                return;
            }
            boolean matchDynamic = (queryFlags & 1) != 0;
            boolean matchPinned = (queryFlags & 2) != 0;
            boolean matchManifest = (queryFlags & 8) != 0;
            boolean canAccessAllShortcuts = ShortcutService.this.canSeeAnyPinnedShortcut(callingPackage, launcherUserId, callingPid, callingUid);
            boolean getPinnedByAnyLauncher = canAccessAllShortcuts && (queryFlags & 0x400) != 0;
            p.findAll(ret, si -> {
                if (si.getLastChangedTimestamp() < changedSince) {
                    return false;
                }
                if (ids != null && !ids.contains(si.getId())) {
                    return false;
                }
                if (componentName != null && si.getActivity() != null && !si.getActivity().equals(componentName)) {
                    return false;
                }
                if (matchDynamic && si.isDynamic()) {
                    return true;
                }
                if ((matchPinned || getPinnedByAnyLauncher) && si.isPinned()) {
                    return true;
                }
                return matchManifest && si.isDeclaredInManifest();
            }, cloneFlag, callingPackage, launcherUserId, getPinnedByAnyLauncher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPinnedByCaller(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkStringNotEmpty(packageName, "packageName");
            Preconditions.checkStringNotEmpty(shortcutId, "shortcutId");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave();
                ShortcutInfo si = this.getShortcutInfoLocked(launcherUserId, callingPackage, packageName, shortcutId, userId, false);
                return si != null && si.isPinned();
            }
        }

        @GuardedBy(value="ShortcutService.this.mLock")
        private ShortcutInfo getShortcutInfoLocked(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId, boolean getPinnedByAnyLauncher) {
            Preconditions.checkStringNotEmpty(packageName, "packageName");
            Preconditions.checkStringNotEmpty(shortcutId, "shortcutId");
            ShortcutService.this.throwIfUserLockedL(userId);
            ShortcutService.this.throwIfUserLockedL(launcherUserId);
            ShortcutPackage p = ShortcutService.this.getUserShortcutsLocked(userId).getPackageShortcutsIfExists(packageName);
            if (p == null) {
                return null;
            }
            ArrayList<ShortcutInfo> list = new ArrayList<ShortcutInfo>(1);
            p.findAll(list, si -> shortcutId.equals(si.getId()), 0, callingPackage, launcherUserId, getPinnedByAnyLauncher);
            return list.size() == 0 ? null : list.get(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pinShortcuts(int launcherUserId, String callingPackage, String packageName, List<String> shortcutIds, int userId) {
            Preconditions.checkStringNotEmpty(packageName, "packageName");
            Preconditions.checkNotNull(shortcutIds, "shortcutIds");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutLauncher launcher = ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId);
                launcher.attemptToRestoreIfNeededAndSave();
                launcher.pinShortcuts(userId, packageName, shortcutIds, false);
            }
            ShortcutService.this.packageShortcutsChanged(packageName, userId);
            ShortcutService.this.verifyStates();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Intent[] createShortcutIntents(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId, int callingPid, int callingUid) {
            Preconditions.checkStringNotEmpty(packageName, "packageName can't be empty");
            Preconditions.checkStringNotEmpty(shortcutId, "shortcutId can't be empty");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave();
                boolean getPinnedByAnyLauncher = ShortcutService.this.canSeeAnyPinnedShortcut(callingPackage, launcherUserId, callingPid, callingUid);
                ShortcutInfo si = this.getShortcutInfoLocked(launcherUserId, callingPackage, packageName, shortcutId, userId, getPinnedByAnyLauncher);
                if (si == null || !si.isEnabled() || !si.isAlive() && !getPinnedByAnyLauncher) {
                    Log.e(ShortcutService.TAG, "Shortcut " + shortcutId + " does not exist or disabled");
                    return null;
                }
                return si.getIntents();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(ShortcutServiceInternal.ShortcutChangeListener listener) {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.mListeners.add(Preconditions.checkNotNull(listener));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getShortcutIconResId(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkNotNull(callingPackage, "callingPackage");
            Preconditions.checkNotNull(packageName, "packageName");
            Preconditions.checkNotNull(shortcutId, "shortcutId");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave();
                ShortcutPackage p = ShortcutService.this.getUserShortcutsLocked(userId).getPackageShortcutsIfExists(packageName);
                if (p == null) {
                    return 0;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl17 : MonitorExitStatement: MONITOREXIT : var6_6
                ShortcutInfo shortcutInfo = p.findShortcutById(shortcutId);
                return shortcutInfo != null && shortcutInfo.hasIconResource() ? shortcutInfo.getIconResourceId() : 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParcelFileDescriptor getShortcutIconFd(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkNotNull(callingPackage, "callingPackage");
            Preconditions.checkNotNull(packageName, "packageName");
            Preconditions.checkNotNull(shortcutId, "shortcutId");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave();
                ShortcutPackage p = ShortcutService.this.getUserShortcutsLocked(userId).getPackageShortcutsIfExists(packageName);
                if (p == null) {
                    return null;
                }
                ShortcutInfo shortcutInfo = p.findShortcutById(shortcutId);
                if (shortcutInfo == null || !shortcutInfo.hasIconFile()) {
                    return null;
                }
                String path = ShortcutService.this.mShortcutBitmapSaver.getBitmapPathMayWaitLocked(shortcutInfo);
                if (path == null) {
                    Slog.w(ShortcutService.TAG, "null bitmap detected in getShortcutIconFd()");
                    return null;
                }
                try {
                    return ParcelFileDescriptor.open(new File(path), 0x10000000);
                }
                catch (FileNotFoundException e) {
                    Slog.e(ShortcutService.TAG, "Icon file not found: " + path);
                    return null;
                }
            }
        }

        @Override
        public boolean hasShortcutHostPermission(int launcherUserId, String callingPackage, int callingPid, int callingUid) {
            return ShortcutService.this.hasShortcutHostPermission(callingPackage, launcherUserId, callingPid, callingUid);
        }

        @Override
        public void setShortcutHostPackage(String type, String packageName, int userId) {
            ShortcutService.this.setShortcutHostPackage(type, packageName, userId);
        }

        @Override
        public boolean requestPinAppWidget(String callingPackage, AppWidgetProviderInfo appWidget, Bundle extras, IntentSender resultIntent, int userId) {
            Preconditions.checkNotNull(appWidget);
            return ShortcutService.this.requestPinItem(callingPackage, userId, null, appWidget, extras, resultIntent);
        }

        @Override
        public boolean isRequestPinItemSupported(int callingUserId, int requestType) {
            return ShortcutService.this.isRequestPinItemSupported(callingUserId, requestType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isForegroundDefaultLauncher(String callingPackage, int callingUid) {
            Preconditions.checkNotNull(callingPackage);
            int userId = UserHandle.getUserId(callingUid);
            ComponentName defaultLauncher = ShortcutService.this.getDefaultLauncher(userId);
            if (defaultLauncher == null) {
                return false;
            }
            if (!callingPackage.equals(defaultLauncher.getPackageName())) {
                return false;
            }
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                if (!ShortcutService.this.isUidForegroundLocked(callingUid)) {
                    return false;
                }
                return true;
            }
        }
    }

    @VisibleForTesting
    static class FileOutputStreamWithPath
    extends FileOutputStream {
        private final File mFile;

        public FileOutputStreamWithPath(File file) throws FileNotFoundException {
            super(file);
            this.mFile = file;
        }

        public File getFile() {
            return this.mFile;
        }
    }

    public static final class Lifecycle
    extends SystemService {
        final ShortcutService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new ShortcutService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService(ShortcutService.KEY_SHORTCUT, this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            this.mService.onBootPhase(phase);
        }

        @Override
        public void onStopUser(int userHandle) {
            this.mService.handleStopUser(userHandle);
        }

        @Override
        public void onUnlockUser(int userId) {
            this.mService.handleUnlockUser(userId);
        }
    }

    static class InvalidFileFormatException
    extends Exception {
        public InvalidFileFormatException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ShortcutOperation {
    }

    @VisibleForTesting
    static interface Stats {
        public static final int GET_DEFAULT_HOME = 0;
        public static final int GET_PACKAGE_INFO = 1;
        public static final int GET_PACKAGE_INFO_WITH_SIG = 2;
        public static final int GET_APPLICATION_INFO = 3;
        public static final int LAUNCHER_PERMISSION_CHECK = 4;
        public static final int CLEANUP_DANGLING_BITMAPS = 5;
        public static final int GET_ACTIVITY_WITH_METADATA = 6;
        public static final int GET_INSTALLED_PACKAGES = 7;
        public static final int CHECK_PACKAGE_CHANGES = 8;
        public static final int GET_APPLICATION_RESOURCES = 9;
        public static final int RESOURCE_NAME_LOOKUP = 10;
        public static final int GET_LAUNCHER_ACTIVITY = 11;
        public static final int CHECK_LAUNCHER_ACTIVITY = 12;
        public static final int IS_ACTIVITY_ENABLED = 13;
        public static final int PACKAGE_UPDATE_CHECK = 14;
        public static final int ASYNC_PRELOAD_USER_DELAY = 15;
        public static final int GET_DEFAULT_LAUNCHER = 16;
        public static final int COUNT = 17;
    }

    @VisibleForTesting
    static interface ConfigConstants {
        public static final String KEY_SAVE_DELAY_MILLIS = "save_delay_ms";
        public static final String KEY_RESET_INTERVAL_SEC = "reset_interval_sec";
        public static final String KEY_MAX_UPDATES_PER_INTERVAL = "max_updates_per_interval";
        public static final String KEY_MAX_ICON_DIMENSION_DP = "max_icon_dimension_dp";
        public static final String KEY_MAX_ICON_DIMENSION_DP_LOWRAM = "max_icon_dimension_dp_lowram";
        public static final String KEY_MAX_SHORTCUTS = "max_shortcuts";
        public static final String KEY_ICON_QUALITY = "icon_quality";
        public static final String KEY_ICON_FORMAT = "icon_format";
    }
}

