/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.appwidget.AppWidgetProviderInfo;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.IPinItemRequest;
import android.content.pm.LauncherApps;
import android.content.pm.ShortcutInfo;
import android.os.Bundle;
import android.os.UserHandle;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.server.pm.ShortcutLauncher;
import com.android.server.pm.ShortcutPackage;
import com.android.server.pm.ShortcutService;

class ShortcutRequestPinProcessor {
    private static final String TAG = "ShortcutService";
    private static final boolean DEBUG = false;
    private final ShortcutService mService;
    private final Object mLock;

    public ShortcutRequestPinProcessor(ShortcutService service, Object lock) {
        this.mService = service;
        this.mLock = lock;
    }

    public boolean isRequestPinItemSupported(int callingUserId, int requestType) {
        return this.getRequestPinConfirmationActivity(callingUserId, requestType) != null;
    }

    public boolean requestPinItemLocked(ShortcutInfo inShortcut, AppWidgetProviderInfo inAppWidget, Bundle extras, int userId, IntentSender resultIntent) {
        LauncherApps.PinItemRequest request;
        int requestType = inShortcut != null ? 1 : 2;
        Pair<ComponentName, Integer> confirmActivity = this.getRequestPinConfirmationActivity(userId, requestType);
        if (confirmActivity == null) {
            Log.w(TAG, "Launcher doesn't support requestPinnedShortcut(). Shortcut not created.");
            return false;
        }
        int launcherUserId = (Integer)confirmActivity.second;
        this.mService.throwIfUserLockedL(launcherUserId);
        if (inShortcut != null) {
            request = this.requestPinShortcutLocked(inShortcut, resultIntent, confirmActivity);
        } else {
            int launcherUid = this.mService.injectGetPackageUid(((ComponentName)confirmActivity.first).getPackageName(), launcherUserId);
            request = new LauncherApps.PinItemRequest(new PinAppWidgetRequestInner(this, resultIntent, launcherUid, inAppWidget, extras), 2);
        }
        return this.startRequestConfirmActivity((ComponentName)confirmActivity.first, launcherUserId, request, requestType);
    }

    public Intent createShortcutResultIntent(ShortcutInfo inShortcut, int userId) {
        int launcherUserId = this.mService.getParentOrSelfUserId(userId);
        ComponentName defaultLauncher = this.mService.getDefaultLauncher(launcherUserId);
        if (defaultLauncher == null) {
            Log.e(TAG, "Default launcher not found.");
            return null;
        }
        this.mService.throwIfUserLockedL(launcherUserId);
        LauncherApps.PinItemRequest request = this.requestPinShortcutLocked(inShortcut, null, Pair.create(defaultLauncher, launcherUserId));
        return new Intent().putExtra("android.content.pm.extra.PIN_ITEM_REQUEST", request);
    }

    private LauncherApps.PinItemRequest requestPinShortcutLocked(ShortcutInfo inShortcut, IntentSender resultIntentOriginal, Pair<ComponentName, Integer> confirmActivity) {
        ShortcutInfo shortcutForLauncher;
        ShortcutPackage ps = this.mService.getPackageShortcutsForPublisherLocked(inShortcut.getPackage(), inShortcut.getUserId());
        ShortcutInfo existing = ps.findShortcutById(inShortcut.getId());
        boolean existsAlready = existing != null;
        boolean existingIsVisible = existsAlready && existing.isVisibleToPublisher();
        String launcherPackage = ((ComponentName)confirmActivity.first).getPackageName();
        int launcherUserId = (Integer)confirmActivity.second;
        IntentSender resultIntentToSend = resultIntentOriginal;
        if (existsAlready) {
            this.validateExistingShortcut(existing);
            boolean isAlreadyPinned = this.mService.getLauncherShortcutsLocked(launcherPackage, existing.getUserId(), launcherUserId).hasPinned(existing);
            if (isAlreadyPinned) {
                this.sendResultIntent(resultIntentOriginal, null);
                resultIntentToSend = null;
            }
            shortcutForLauncher = existing.clone(11);
            if (!isAlreadyPinned) {
                shortcutForLauncher.clearFlags(2);
            }
        } else {
            if (inShortcut.getActivity() == null) {
                inShortcut.setActivity(this.mService.injectGetDefaultMainActivity(inShortcut.getPackage(), inShortcut.getUserId()));
            }
            this.mService.validateShortcutForPinRequest(inShortcut);
            inShortcut.resolveResourceStrings(this.mService.injectGetResourcesForApplicationAsUser(inShortcut.getPackage(), inShortcut.getUserId()));
            shortcutForLauncher = inShortcut.clone(10);
        }
        PinShortcutRequestInner inner = new PinShortcutRequestInner(this, inShortcut, shortcutForLauncher, resultIntentToSend, launcherPackage, launcherUserId, this.mService.injectGetPackageUid(launcherPackage, launcherUserId), existsAlready);
        return new LauncherApps.PinItemRequest(inner, 1);
    }

    private void validateExistingShortcut(ShortcutInfo shortcutInfo) {
        Preconditions.checkArgument(shortcutInfo.isEnabled(), "Shortcut ID=" + shortcutInfo + " already exists but disabled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startRequestConfirmActivity(ComponentName activity, int launcherUserId, LauncherApps.PinItemRequest request, int requestType) {
        String action = requestType == 1 ? "android.content.pm.action.CONFIRM_PIN_SHORTCUT" : "android.content.pm.action.CONFIRM_PIN_APPWIDGET";
        Intent confirmIntent = new Intent(action);
        confirmIntent.setComponent(activity);
        confirmIntent.putExtra("android.content.pm.extra.PIN_ITEM_REQUEST", request);
        confirmIntent.addFlags(0x10008000);
        long token = this.mService.injectClearCallingIdentity();
        try {
            this.mService.mContext.startActivityAsUser(confirmIntent, UserHandle.of(launcherUserId));
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Unable to start activity " + activity, e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mService.injectRestoreCallingIdentity(token);
        }
        return true;
    }

    @VisibleForTesting
    Pair<ComponentName, Integer> getRequestPinConfirmationActivity(int callingUserId, int requestType) {
        int launcherUserId = this.mService.getParentOrSelfUserId(callingUserId);
        ComponentName defaultLauncher = this.mService.getDefaultLauncher(launcherUserId);
        if (defaultLauncher == null) {
            Log.e(TAG, "Default launcher not found.");
            return null;
        }
        ComponentName activity = this.mService.injectGetPinConfirmationActivity(defaultLauncher.getPackageName(), launcherUserId, requestType);
        return activity == null ? null : Pair.create(activity, launcherUserId);
    }

    public void sendResultIntent(IntentSender intent, Intent extras) {
        this.mService.injectSendIntentSender(intent, extras);
    }

    public boolean isCallerUid(int uid) {
        return uid == this.mService.injectBinderCallingUid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean directPinShortcut(PinShortcutRequestInner request) {
        ShortcutInfo original = request.shortcutOriginal;
        int appUserId = original.getUserId();
        String appPackageName = original.getPackage();
        int launcherUserId = request.launcherUserId;
        String launcherPackage = request.launcherPackage;
        String shortcutId = original.getId();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mService.isUserUnlockedL(appUserId) || !this.mService.isUserUnlockedL(request.launcherUserId)) {
                Log.w(TAG, "User is locked now.");
                return false;
            }
            ShortcutLauncher launcher = this.mService.getLauncherShortcutsLocked(launcherPackage, appUserId, launcherUserId);
            launcher.attemptToRestoreIfNeededAndSave();
            if (launcher.hasPinned(original)) {
                return true;
            }
            ShortcutPackage ps = this.mService.getPackageShortcutsForPublisherLocked(appPackageName, appUserId);
            ShortcutInfo current = ps.findShortcutById(shortcutId);
            try {
                if (current == null) {
                    this.mService.validateShortcutForPinRequest(original);
                } else {
                    this.validateExistingShortcut(current);
                }
            }
            catch (RuntimeException e) {
                Log.w(TAG, "Unable to pin shortcut: " + e.getMessage());
                return false;
            }
            if (current == null) {
                if (original.getActivity() == null) {
                    original.setActivity(this.mService.getDummyMainActivity(appPackageName));
                }
                ps.addOrReplaceDynamicShortcut(original);
            }
            launcher.addPinnedShortcut(appPackageName, appUserId, shortcutId, true);
            if (current == null) {
                ps.deleteDynamicWithId(shortcutId, false);
            }
            ps.adjustRanks();
        }
        this.mService.verifyStates();
        this.mService.packageShortcutsChanged(appPackageName, appUserId);
        return true;
    }

    private static class PinShortcutRequestInner
    extends PinItemRequestInner {
        public final ShortcutInfo shortcutOriginal;
        public final ShortcutInfo shortcutForLauncher;
        public final String launcherPackage;
        public final int launcherUserId;
        public final boolean preExisting;

        private PinShortcutRequestInner(ShortcutRequestPinProcessor processor, ShortcutInfo shortcutOriginal, ShortcutInfo shortcutForLauncher, IntentSender resultIntent, String launcherPackage, int launcherUserId, int launcherUid, boolean preExisting) {
            super(processor, resultIntent, launcherUid);
            this.shortcutOriginal = shortcutOriginal;
            this.shortcutForLauncher = shortcutForLauncher;
            this.launcherPackage = launcherPackage;
            this.launcherUserId = launcherUserId;
            this.preExisting = preExisting;
        }

        @Override
        public ShortcutInfo getShortcutInfo() {
            return this.shortcutForLauncher;
        }

        @Override
        protected boolean tryAccept() {
            return this.mProcessor.directPinShortcut(this);
        }
    }

    private static class PinAppWidgetRequestInner
    extends PinItemRequestInner {
        final AppWidgetProviderInfo mAppWidgetProviderInfo;
        final Bundle mExtras;

        private PinAppWidgetRequestInner(ShortcutRequestPinProcessor processor, IntentSender resultIntent, int launcherUid, AppWidgetProviderInfo appWidgetProviderInfo, Bundle extras) {
            super(processor, resultIntent, launcherUid);
            this.mAppWidgetProviderInfo = appWidgetProviderInfo;
            this.mExtras = extras;
        }

        @Override
        public AppWidgetProviderInfo getAppWidgetProviderInfo() {
            return this.mAppWidgetProviderInfo;
        }

        @Override
        public Bundle getExtras() {
            return this.mExtras;
        }
    }

    private static abstract class PinItemRequestInner
    extends IPinItemRequest.Stub {
        protected final ShortcutRequestPinProcessor mProcessor;
        private final IntentSender mResultIntent;
        private final int mLauncherUid;
        @GuardedBy(value="this")
        private boolean mAccepted;

        private PinItemRequestInner(ShortcutRequestPinProcessor processor, IntentSender resultIntent, int launcherUid) {
            this.mProcessor = processor;
            this.mResultIntent = resultIntent;
            this.mLauncherUid = launcherUid;
        }

        @Override
        public ShortcutInfo getShortcutInfo() {
            return null;
        }

        @Override
        public AppWidgetProviderInfo getAppWidgetProviderInfo() {
            return null;
        }

        @Override
        public Bundle getExtras() {
            return null;
        }

        private boolean isCallerValid() {
            return this.mProcessor.isCallerUid(this.mLauncherUid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isValid() {
            if (!this.isCallerValid()) {
                return false;
            }
            PinItemRequestInner pinItemRequestInner = this;
            synchronized (pinItemRequestInner) {
                return !this.mAccepted;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean accept(Bundle options) {
            if (!this.isCallerValid()) {
                throw new SecurityException("Calling uid mismatch");
            }
            Intent extras = null;
            if (options != null) {
                try {
                    options.size();
                    extras = new Intent().putExtras(options);
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException("options cannot be unparceled", e);
                }
            }
            PinItemRequestInner pinItemRequestInner = this;
            synchronized (pinItemRequestInner) {
                if (this.mAccepted) {
                    throw new IllegalStateException("accept() called already");
                }
                this.mAccepted = true;
            }
            if (this.tryAccept()) {
                this.mProcessor.sendResultIntent(this.mResultIntent, extras);
                return true;
            }
            return false;
        }

        protected boolean tryAccept() {
            return true;
        }
    }
}

