/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.pm.ShortcutService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class ShortcutParser {
    private static final String TAG = "ShortcutService";
    private static final boolean DEBUG = false;
    @VisibleForTesting
    static final String METADATA_KEY = "android.app.shortcuts";
    private static final String TAG_SHORTCUTS = "shortcuts";
    private static final String TAG_SHORTCUT = "shortcut";
    private static final String TAG_INTENT = "intent";
    private static final String TAG_CATEGORIES = "categories";

    public static List<ShortcutInfo> parseShortcuts(ShortcutService service, String packageName, int userId) throws IOException, XmlPullParserException {
        List<ResolveInfo> activities = service.injectGetMainActivities(packageName, userId);
        if (activities == null || activities.size() == 0) {
            return null;
        }
        List<ShortcutInfo> result = null;
        try {
            int size = activities.size();
            for (int i = 0; i < size; ++i) {
                ActivityInfo activityInfoWithMetadata;
                ActivityInfo activityInfoNoMetadata = activities.get((int)i).activityInfo;
                if (activityInfoNoMetadata == null || (activityInfoWithMetadata = service.getActivityInfoWithMetadata(activityInfoNoMetadata.getComponentName(), userId)) == null) continue;
                result = ShortcutParser.parseShortcutsOneFile(service, activityInfoWithMetadata, packageName, userId, result);
            }
        }
        catch (RuntimeException e) {
            service.wtf("Exception caught while parsing shortcut XML for package=" + packageName, e);
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ShortcutInfo> parseShortcutsOneFile(ShortcutService service, ActivityInfo activityInfo, String packageName, int userId, List<ShortcutInfo> result) throws IOException, XmlPullParserException {
        try (XmlResourceParser parser = null;){
            int type;
            parser = service.injectXmlMetaData(activityInfo, METADATA_KEY);
            if (parser == null) {
                List<ShortcutInfo> list = result;
                return list;
            }
            ComponentName activity = new ComponentName(packageName, activityInfo.name);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            int rank = 0;
            int maxShortcuts = service.getMaxActivityShortcuts();
            int numShortcuts = 0;
            ShortcutInfo currentShortcut = null;
            ArraySet<String> categories = null;
            ArrayList<Intent> intents = new ArrayList<Intent>();
            block7: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > 0)) {
                ShortcutInfo si;
                int depth = parser.getDepth();
                String tag = parser.getName();
                if (type == 3 && depth == 2 && TAG_SHORTCUT.equals(tag)) {
                    if (currentShortcut == null) continue;
                    si = currentShortcut;
                    currentShortcut = null;
                    if (si.isEnabled()) {
                        if (intents.size() == 0) {
                            Log.e(TAG, "Shortcut " + si.getId() + " has no intent. Skipping it.");
                            continue;
                        }
                    } else {
                        intents.clear();
                        intents.add(new Intent("android.intent.action.VIEW"));
                    }
                    if (numShortcuts >= maxShortcuts) {
                        Log.e(TAG, "More than " + maxShortcuts + " shortcuts found for " + activityInfo.getComponentName() + ". Skipping the rest.");
                        List<ShortcutInfo> list = result;
                        return list;
                    }
                    ((Intent)intents.get(0)).addFlags(0x1000C000);
                    try {
                        si.setIntents(intents.toArray(new Intent[intents.size()]));
                    }
                    catch (RuntimeException e) {
                        Log.e(TAG, "Shortcut's extras contain un-persistable values. Skipping it.");
                        continue;
                    }
                    intents.clear();
                    if (categories != null) {
                        si.setCategories(categories);
                        categories = null;
                    }
                    if (result == null) {
                        result = new ArrayList<ShortcutInfo>();
                    }
                    result.add(si);
                    ++numShortcuts;
                    ++rank;
                    continue;
                }
                if (type != 2 || depth == 1 && TAG_SHORTCUTS.equals(tag)) continue;
                if (depth == 2 && TAG_SHORTCUT.equals(tag)) {
                    si = ShortcutParser.parseShortcutAttributes(service, attrs, packageName, activity, userId, rank);
                    if (si == null) continue;
                    if (result != null) {
                        for (int i = result.size() - 1; i >= 0; --i) {
                            if (!si.getId().equals(result.get(i).getId())) continue;
                            Log.e(TAG, "Duplicate shortcut ID detected. Skipping it.");
                            continue block7;
                        }
                    }
                    currentShortcut = si;
                    categories = null;
                    continue;
                }
                if (depth == 3 && TAG_INTENT.equals(tag)) {
                    if (currentShortcut == null || !currentShortcut.isEnabled()) {
                        Log.e(TAG, "Ignoring excessive intent tag.");
                        continue;
                    }
                    Intent intent = Intent.parseIntent(service.mContext.getResources(), parser, attrs);
                    if (TextUtils.isEmpty(intent.getAction())) {
                        Log.e(TAG, "Shortcut intent action must be provided. activity=" + activity);
                        currentShortcut = null;
                        continue;
                    }
                    intents.add(intent);
                    continue;
                }
                if (depth == 3 && TAG_CATEGORIES.equals(tag)) {
                    if (currentShortcut == null || currentShortcut.getCategories() != null) continue;
                    String name = ShortcutParser.parseCategories(service, attrs);
                    if (TextUtils.isEmpty(name)) {
                        Log.e(TAG, "Empty category found. activity=" + activity);
                        continue;
                    }
                    if (categories == null) {
                        categories = new ArraySet<String>();
                    }
                    categories.add(name);
                    continue;
                }
                Log.w(TAG, String.format("Invalid tag '%s' found at depth %d", tag, depth));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseCategories(ShortcutService service, AttributeSet attrs) {
        TypedArray sa = service.mContext.getResources().obtainAttributes(attrs, R.styleable.ShortcutCategories);
        try {
            if (sa.getType(0) == 3) {
                String string2 = sa.getNonResourceString(0);
                return string2;
            }
            Log.w(TAG, "android:name for shortcut category must be string literal.");
            String string3 = null;
            return string3;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ShortcutInfo parseShortcutAttributes(ShortcutService service, AttributeSet attrs, String packageName, ComponentName activity, int userId, int rank) {
        TypedArray sa = service.mContext.getResources().obtainAttributes(attrs, R.styleable.Shortcut);
        try {
            if (sa.getType(2) != 3) {
                Log.w(TAG, "android:shortcutId must be string literal. activity=" + activity);
                ShortcutInfo shortcutInfo = null;
                return shortcutInfo;
            }
            String id2 = sa.getNonResourceString(2);
            boolean enabled = sa.getBoolean(1, true);
            int iconResId = sa.getResourceId(0, 0);
            int titleResId = sa.getResourceId(3, 0);
            int textResId = sa.getResourceId(4, 0);
            int disabledMessageResId = sa.getResourceId(5, 0);
            if (TextUtils.isEmpty(id2)) {
                Log.w(TAG, "android:shortcutId must be provided. activity=" + activity);
                ShortcutInfo shortcutInfo = null;
                return shortcutInfo;
            }
            if (titleResId == 0) {
                Log.w(TAG, "android:shortcutShortLabel must be provided. activity=" + activity);
                ShortcutInfo shortcutInfo = null;
                return shortcutInfo;
            }
            ShortcutInfo shortcutInfo = ShortcutParser.createShortcutFromManifest(service, userId, id2, packageName, activity, titleResId, textResId, disabledMessageResId, rank, iconResId, enabled);
            return shortcutInfo;
        }
        finally {
            sa.recycle();
        }
    }

    private static ShortcutInfo createShortcutFromManifest(ShortcutService service, int userId, String id2, String packageName, ComponentName activityComponent, int titleResId, int textResId, int disabledMessageResId, int rank, int iconResId, boolean enabled) {
        int flags = (enabled ? 32 : 64) | 0x100 | (iconResId != 0 ? 4 : 0);
        int disabledReason = enabled ? 0 : 1;
        return new ShortcutInfo(userId, id2, packageName, activityComponent, null, null, titleResId, null, null, textResId, null, null, disabledMessageResId, null, null, null, rank, null, service.injectCurrentTimeMillis(), flags, iconResId, null, null, disabledReason);
    }
}

