/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import com.android.server.pm.permission.PermissionsState;

abstract class SettingBase {
    int pkgFlags;
    int pkgPrivateFlags;
    protected final PermissionsState mPermissionsState;

    SettingBase(int pkgFlags, int pkgPrivateFlags) {
        this.setFlags(pkgFlags);
        this.setPrivateFlags(pkgPrivateFlags);
        this.mPermissionsState = new PermissionsState();
    }

    SettingBase(SettingBase orig) {
        this.mPermissionsState = new PermissionsState();
        this.doCopy(orig);
    }

    public void copyFrom(SettingBase orig) {
        this.doCopy(orig);
    }

    private void doCopy(SettingBase orig) {
        this.pkgFlags = orig.pkgFlags;
        this.pkgPrivateFlags = orig.pkgPrivateFlags;
        this.mPermissionsState.copyFrom(orig.mPermissionsState);
    }

    public PermissionsState getPermissionsState() {
        return this.mPermissionsState;
    }

    void setFlags(int pkgFlags) {
        this.pkgFlags = pkgFlags & 0x40001;
    }

    void setPrivateFlags(int pkgPrivateFlags) {
        this.pkgPrivateFlags = pkgPrivateFlags & 0xE020C;
    }
}

