/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.os.Environment;
import android.util.Slog;
import android.util.Xml;
import com.android.server.pm.Policy;
import com.android.server.pm.PolicyComparator;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class SELinuxMMAC {
    static final String TAG = "SELinuxMMAC";
    private static final boolean DEBUG_POLICY = false;
    private static final boolean DEBUG_POLICY_INSTALL = false;
    private static final boolean DEBUG_POLICY_ORDER = false;
    private static List<Policy> sPolicies = new ArrayList<Policy>();
    private static boolean sPolicyRead;
    private static List<File> sMacPermissions;
    private static final String DEFAULT_SEINFO = "default";
    private static final String PRIVILEGED_APP_STR = ":privapp";
    private static final String SANDBOX_V2_STR = ":v2";
    private static final String TARGETSDKVERSION_STR = ":targetSdkVersion=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean readInstallPolicy() {
        FileReader policyFile;
        ArrayList<Policy> policies;
        List<Policy> list = sPolicies;
        synchronized (list) {
            if (sPolicyRead) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var0
            policies = new ArrayList<Policy>();
            policyFile = null;
        }
        XmlPullParser parser = Xml.newPullParser();
        int count = sMacPermissions.size();
        for (int i = 0; i < count; ++i) {
            File macPermission = sMacPermissions.get(i);
            try {
                policyFile = new FileReader(macPermission);
                Slog.d(TAG, "Using policy file " + macPermission);
                parser.setInput(policyFile);
                parser.nextTag();
                parser.require(2, null, "policy");
                block20: while (parser.next() != 3) {
                    if (parser.getEventType() != 2) continue;
                    switch (parser.getName()) {
                        case "signer": {
                            policies.add(SELinuxMMAC.readSignerOrThrow(parser));
                            continue block20;
                        }
                    }
                    SELinuxMMAC.skip(parser);
                }
            }
            catch (IllegalArgumentException | IllegalStateException | XmlPullParserException ex) {
                StringBuilder sb = new StringBuilder("Exception @");
                sb.append(parser.getPositionDescription());
                sb.append(" while parsing ");
                sb.append(macPermission);
                sb.append(":");
                sb.append(ex);
                Slog.w(TAG, sb.toString());
                boolean bl = false;
                IoUtils.closeQuietly(policyFile);
                return bl;
            }
            catch (IOException ioe) {
                Slog.w(TAG, "Exception parsing " + macPermission, ioe);
                int n = 0;
                {
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(policyFile);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(policyFile);
                return n != 0;
            }
            IoUtils.closeQuietly(policyFile);
        }
        PolicyComparator policySort = new PolicyComparator();
        Collections.sort(policies, policySort);
        if (policySort.foundDuplicate()) {
            Slog.w(TAG, "ERROR! Duplicate entries found parsing mac_permissions.xml files");
            return false;
        }
        List<Policy> list2 = sPolicies;
        synchronized (list2) {
            sPolicies.clear();
            sPolicies.addAll(policies);
            sPolicyRead = true;
        }
        return true;
    }

    private static Policy readSignerOrThrow(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "signer");
        Policy.PolicyBuilder pb = new Policy.PolicyBuilder();
        String cert = parser.getAttributeValue(null, "signature");
        if (cert != null) {
            pb.addSignature(cert);
        }
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                String seinfo = parser.getAttributeValue(null, "value");
                pb.setGlobalSeinfoOrThrow(seinfo);
                SELinuxMMAC.readSeinfo(parser);
                continue;
            }
            if ("package".equals(tagName)) {
                SELinuxMMAC.readPackageOrThrow(parser, pb);
                continue;
            }
            if ("cert".equals(tagName)) {
                String sig = parser.getAttributeValue(null, "signature");
                pb.addSignature(sig);
                SELinuxMMAC.readCert(parser);
                continue;
            }
            SELinuxMMAC.skip(parser);
        }
        return pb.build();
    }

    private static void readPackageOrThrow(XmlPullParser parser, Policy.PolicyBuilder pb) throws IOException, XmlPullParserException {
        parser.require(2, null, "package");
        String pkgName = parser.getAttributeValue(null, "name");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                String seinfo = parser.getAttributeValue(null, "value");
                pb.addInnerPackageMapOrThrow(pkgName, seinfo);
                SELinuxMMAC.readSeinfo(parser);
                continue;
            }
            SELinuxMMAC.skip(parser);
        }
    }

    private static void readCert(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "cert");
        parser.nextTag();
    }

    private static void readSeinfo(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "seinfo");
        parser.nextTag();
    }

    private static void skip(XmlPullParser p) throws IOException, XmlPullParserException {
        if (p.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (p.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSeInfo(PackageParser.Package pkg, boolean isPrivileged, int targetSandboxVersion, int targetSdkVersion) {
        String seInfo = null;
        List<Policy> list = sPolicies;
        synchronized (list) {
            if (sPolicyRead) {
                Policy policy;
                Iterator<Policy> iterator = sPolicies.iterator();
                while (iterator.hasNext() && (seInfo = (policy = iterator.next()).getMatchedSeInfo(pkg)) == null) {
                }
            }
        }
        if (seInfo == null) {
            seInfo = DEFAULT_SEINFO;
        }
        if (targetSandboxVersion == 2) {
            seInfo = seInfo + SANDBOX_V2_STR;
        }
        if (isPrivileged) {
            seInfo = seInfo + PRIVILEGED_APP_STR;
        }
        seInfo = seInfo + TARGETSDKVERSION_STR + targetSdkVersion;
        return seInfo;
    }

    static {
        sMacPermissions = new ArrayList<File>();
        sMacPermissions.add(new File(Environment.getRootDirectory(), "/etc/selinux/plat_mac_permissions.xml"));
        File vendorMacPermission = new File(Environment.getVendorDirectory(), "/etc/selinux/vendor_mac_permissions.xml");
        if (vendorMacPermission.exists()) {
            sMacPermissions.add(vendorMacPermission);
        } else {
            sMacPermissions.add(new File(Environment.getVendorDirectory(), "/etc/selinux/nonplat_mac_permissions.xml"));
        }
        File odmMacPermission = new File(Environment.getOdmDirectory(), "/etc/selinux/odm_mac_permissions.xml");
        if (odmMacPermission.exists()) {
            sMacPermissions.add(odmMacPermission);
        }
    }
}

