/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.content.pm.UserInfo;
import android.util.proto.ProtoOutputStream;
import com.android.server.pm.PackageSettingBase;
import com.android.server.pm.SharedUserSetting;
import com.android.server.pm.permission.PermissionsState;
import java.io.File;
import java.util.List;

public final class PackageSetting
extends PackageSettingBase {
    int appId;
    PackageParser.Package pkg;
    SharedUserSetting sharedUser;
    private int sharedUserId;

    PackageSetting(String name, String realName, File codePath, File resourcePath, String legacyNativeLibraryPathString, String primaryCpuAbiString, String secondaryCpuAbiString, String cpuAbiOverrideString, long pVersionCode, int pkgFlags, int privateFlags, String parentPackageName, List<String> childPackageNames, int sharedUserId, String[] usesStaticLibraries, long[] usesStaticLibrariesVersions) {
        super(name, realName, codePath, resourcePath, legacyNativeLibraryPathString, primaryCpuAbiString, secondaryCpuAbiString, cpuAbiOverrideString, pVersionCode, pkgFlags, privateFlags, parentPackageName, childPackageNames, usesStaticLibraries, usesStaticLibrariesVersions);
        this.sharedUserId = sharedUserId;
    }

    PackageSetting(PackageSetting orig) {
        super(orig, orig.realName);
        this.doCopy(orig);
    }

    PackageSetting(PackageSetting orig, String realPkgName) {
        super(orig, realPkgName);
        this.doCopy(orig);
    }

    public int getSharedUserId() {
        if (this.sharedUser != null) {
            return this.sharedUser.userId;
        }
        return this.sharedUserId;
    }

    public SharedUserSetting getSharedUser() {
        return this.sharedUser;
    }

    public String toString() {
        return "PackageSetting{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "/" + this.appId + "}";
    }

    public void copyFrom(PackageSetting orig) {
        super.copyFrom(orig);
        this.doCopy(orig);
    }

    private void doCopy(PackageSetting orig) {
        this.appId = orig.appId;
        this.pkg = orig.pkg;
        this.sharedUser = orig.sharedUser;
        this.sharedUserId = orig.sharedUserId;
    }

    @Override
    public PermissionsState getPermissionsState() {
        return this.sharedUser != null ? this.sharedUser.getPermissionsState() : super.getPermissionsState();
    }

    public PackageParser.Package getPackage() {
        return this.pkg;
    }

    public int getAppId() {
        return this.appId;
    }

    public void setInstallPermissionsFixed(boolean fixed) {
        this.installPermissionsFixed = fixed;
    }

    public boolean areInstallPermissionsFixed() {
        return this.installPermissionsFixed;
    }

    public boolean isPrivileged() {
        return (this.pkgPrivateFlags & 8) != 0;
    }

    public boolean isOem() {
        return (this.pkgPrivateFlags & 0x20000) != 0;
    }

    public boolean isVendor() {
        return (this.pkgPrivateFlags & 0x40000) != 0;
    }

    public boolean isProduct() {
        return (this.pkgPrivateFlags & 0x80000) != 0;
    }

    public boolean isForwardLocked() {
        return (this.pkgPrivateFlags & 4) != 0;
    }

    public boolean isSystem() {
        return (this.pkgFlags & 1) != 0;
    }

    public boolean isUpdatedSystem() {
        return (this.pkgFlags & 0x80) != 0;
    }

    @Override
    public boolean isSharedUser() {
        return this.sharedUser != null;
    }

    public boolean isMatch(int flags) {
        if ((flags & 0x100000) != 0) {
            return this.isSystem();
        }
        return true;
    }

    public boolean hasChildPackages() {
        return this.childPackageNames != null && !this.childPackageNames.isEmpty();
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId, List<UserInfo> users) {
        long packageToken = proto.start(fieldId);
        proto.write(0x10900000001L, this.realName != null ? this.realName : this.name);
        proto.write(1120986464258L, this.appId);
        proto.write(1120986464259L, this.versionCode);
        proto.write(1138166333444L, this.pkg.mVersionName);
        proto.write(1112396529669L, this.firstInstallTime);
        proto.write(1112396529670L, this.lastUpdateTime);
        proto.write(1138166333447L, this.installerPackageName);
        if (this.pkg != null) {
            long splitToken = proto.start(2246267895816L);
            proto.write(0x10900000001L, "base");
            proto.write(1120986464258L, this.pkg.baseRevisionCode);
            proto.end(splitToken);
            if (this.pkg.splitNames != null) {
                for (int i = 0; i < this.pkg.splitNames.length; ++i) {
                    splitToken = proto.start(2246267895816L);
                    proto.write(0x10900000001L, this.pkg.splitNames[i]);
                    proto.write(1120986464258L, this.pkg.splitRevisionCodes[i]);
                    proto.end(splitToken);
                }
            }
        }
        this.writeUsersInfoToProto(proto, 2246267895817L);
        proto.end(packageToken);
    }
}

