/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.AppGlobals;
import android.content.Intent;
import android.content.pm.PackageParser;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Debug;
import android.os.Environment;
import android.os.FileUtils;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.util.ArraySet;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.FastPrintWriter;
import com.android.server.EventLogTags;
import com.android.server.pm.PackageManagerException;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageSignatures;
import com.android.server.pm.dex.DexManager;
import com.android.server.pm.dex.PackageDexUsage;
import dalvik.system.VMRuntime;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;

public class PackageManagerServiceUtils {
    private static final long SEVEN_DAYS_IN_MILLISECONDS = 604800000L;

    private static ArraySet<String> getPackageNamesForIntent(Intent intent, int userId) {
        List ris = null;
        try {
            ris = AppGlobals.getPackageManager().queryIntentReceivers(intent, null, 0, userId).getList();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        ArraySet<String> pkgNames = new ArraySet<String>();
        if (ris != null) {
            for (ResolveInfo ri : ris) {
                pkgNames.add(ri.activityInfo.packageName);
            }
        }
        return pkgNames;
    }

    public static void sortPackagesByUsageDate(List<PackageParser.Package> pkgs, PackageManagerService packageManagerService) {
        if (!packageManagerService.isHistoricalPackageUsageAvailable()) {
            return;
        }
        Collections.sort(pkgs, (pkg1, pkg2) -> Long.compare(pkg2.getLatestForegroundPackageUseTimeInMills(), pkg1.getLatestForegroundPackageUseTimeInMills()));
    }

    private static void applyPackageFilter(Predicate<PackageParser.Package> filter, Collection<PackageParser.Package> result, Collection<PackageParser.Package> packages, List<PackageParser.Package> sortTemp, PackageManagerService packageManagerService) {
        for (PackageParser.Package pkg : packages) {
            if (!filter.test(pkg)) continue;
            sortTemp.add(pkg);
        }
        PackageManagerServiceUtils.sortPackagesByUsageDate(sortTemp, packageManagerService);
        packages.removeAll(sortTemp);
        for (PackageParser.Package pkg : sortTemp) {
            result.add(pkg);
            List<PackageParser.Package> deps = packageManagerService.findSharedNonSystemLibraries(pkg);
            if (deps.isEmpty()) continue;
            deps.removeAll(result);
            result.addAll(deps);
            packages.removeAll(deps);
        }
        sortTemp.clear();
    }

    public static List<PackageParser.Package> getPackagesForDexopt(Collection<PackageParser.Package> packages, PackageManagerService packageManagerService) {
        Predicate<PackageParser.Package> remainingPredicate;
        ArrayList<PackageParser.Package> remainingPkgs = new ArrayList<PackageParser.Package>(packages);
        LinkedList<PackageParser.Package> result = new LinkedList<PackageParser.Package>();
        ArrayList<PackageParser.Package> sortTemp = new ArrayList<PackageParser.Package>(remainingPkgs.size());
        PackageManagerServiceUtils.applyPackageFilter(pkg -> pkg.coreApp, result, remainingPkgs, sortTemp, packageManagerService);
        Intent intent = new Intent("android.intent.action.PRE_BOOT_COMPLETED");
        ArraySet<String> pkgNames = PackageManagerServiceUtils.getPackageNamesForIntent(intent, 0);
        PackageManagerServiceUtils.applyPackageFilter(pkg -> pkgNames.contains(pkg.packageName), result, remainingPkgs, sortTemp, packageManagerService);
        DexManager dexManager = packageManagerService.getDexManager();
        PackageManagerServiceUtils.applyPackageFilter(pkg -> dexManager.getPackageUseInfoOrDefault(pkg.packageName).isAnyCodePathUsedByOtherApps(), result, remainingPkgs, sortTemp, packageManagerService);
        if (!remainingPkgs.isEmpty() && packageManagerService.isHistoricalPackageUsageAvailable()) {
            PackageParser.Package lastUsed = Collections.max(remainingPkgs, (pkg1, pkg2) -> Long.compare(pkg1.getLatestForegroundPackageUseTimeInMills(), pkg2.getLatestForegroundPackageUseTimeInMills()));
            long estimatedPreviousSystemUseTime = lastUsed.getLatestForegroundPackageUseTimeInMills();
            if (estimatedPreviousSystemUseTime != 0L) {
                long cutoffTime = estimatedPreviousSystemUseTime - 604800000L;
                remainingPredicate = pkg -> pkg.getLatestForegroundPackageUseTimeInMills() >= cutoffTime;
            } else {
                remainingPredicate = pkg -> true;
            }
            PackageManagerServiceUtils.sortPackagesByUsageDate(remainingPkgs, packageManagerService);
        } else {
            remainingPredicate = pkg -> true;
        }
        PackageManagerServiceUtils.applyPackageFilter(remainingPredicate, result, remainingPkgs, sortTemp, packageManagerService);
        return result;
    }

    public static boolean isUnusedSinceTimeInMillis(long firstInstallTime, long currentTimeInMillis, long thresholdTimeinMillis, PackageDexUsage.PackageUseInfo packageUseInfo, long latestPackageUseTimeInMillis, long latestForegroundPackageUseTimeInMillis) {
        boolean isActiveInForeground;
        if (currentTimeInMillis - firstInstallTime < thresholdTimeinMillis) {
            return false;
        }
        boolean bl = isActiveInForeground = currentTimeInMillis - latestForegroundPackageUseTimeInMillis < thresholdTimeinMillis;
        if (isActiveInForeground) {
            return false;
        }
        boolean isActiveInBackgroundAndUsedByOtherPackages = currentTimeInMillis - latestPackageUseTimeInMillis < thresholdTimeinMillis && packageUseInfo.isAnyCodePathUsedByOtherApps();
        return !isActiveInBackgroundAndUsedByOtherPackages;
    }

    public static String realpath(File path) throws IOException {
        try {
            return Os.realpath(path.getAbsolutePath());
        }
        catch (ErrnoException ee) {
            throw ee.rethrowAsIOException();
        }
    }

    public static String packagesToString(Collection<PackageParser.Package> c) {
        StringBuilder sb = new StringBuilder();
        for (PackageParser.Package pkg : c) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(pkg.packageName);
        }
        return sb.toString();
    }

    public static boolean checkISA(String isa) {
        for (String abi : Build.SUPPORTED_ABIS) {
            if (!VMRuntime.getInstructionSet(abi).equals(isa)) continue;
            return true;
        }
        return false;
    }

    public static long getLastModifiedTime(PackageParser.Package pkg) {
        File srcFile = new File(pkg.codePath);
        if (!srcFile.isDirectory()) {
            return srcFile.lastModified();
        }
        File baseFile = new File(pkg.baseCodePath);
        long maxModifiedTime = baseFile.lastModified();
        if (pkg.splitCodePaths != null) {
            for (int i = pkg.splitCodePaths.length - 1; i >= 0; --i) {
                File splitFile = new File(pkg.splitCodePaths[i]);
                maxModifiedTime = Math.max(maxModifiedTime, splitFile.lastModified());
            }
        }
        return maxModifiedTime;
    }

    private static File getSettingsProblemFile() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File fname = new File(systemDir, "uiderrors.txt");
        return fname;
    }

    public static void dumpCriticalInfo(ProtoOutputStream proto) {
        try (BufferedReader in = new BufferedReader(new FileReader(PackageManagerServiceUtils.getSettingsProblemFile()));){
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.contains("ignored: updated version")) continue;
                proto.write(2237677961223L, line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void dumpCriticalInfo(PrintWriter pw, String msg) {
        try (BufferedReader in = new BufferedReader(new FileReader(PackageManagerServiceUtils.getSettingsProblemFile()));){
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.contains("ignored: updated version")) continue;
                if (msg != null) {
                    pw.print(msg);
                }
                pw.println(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void logCriticalInfo(int priority, String msg) {
        Slog.println(priority, "PackageManager", msg);
        EventLogTags.writePmCriticalInfo(msg);
        try {
            File fname = PackageManagerServiceUtils.getSettingsProblemFile();
            FileOutputStream out = new FileOutputStream(fname, true);
            FastPrintWriter pw = new FastPrintWriter(out);
            SimpleDateFormat formatter = new SimpleDateFormat();
            String dateString = formatter.format(new Date(System.currentTimeMillis()));
            pw.println(dateString + ": " + msg);
            ((PrintWriter)pw).close();
            FileUtils.setPermissions(fname.toString(), 508, -1, -1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void enforceShellRestriction(String restriction, int callingUid, int userHandle) {
        if (callingUid == 2000) {
            if (userHandle >= 0 && PackageManagerService.sUserManager.hasUserRestriction(restriction, userHandle)) {
                throw new SecurityException("Shell does not have permission to access user " + userHandle);
            }
            if (userHandle < 0) {
                Slog.e("PackageManager", "Unable to check shell permission for user " + userHandle + "\n\t" + Debug.getCallers(3));
            }
        }
    }

    public static String deriveAbiOverride(String abiOverride, PackageSetting settings) {
        String cpuAbiOverride = null;
        if ("-".equals(abiOverride)) {
            cpuAbiOverride = null;
        } else if (abiOverride != null) {
            cpuAbiOverride = abiOverride;
        } else if (settings != null) {
            cpuAbiOverride = settings.cpuAbiOverrideString;
        }
        return cpuAbiOverride;
    }

    public static int compareSignatures(Signature[] s1, Signature[] s2) {
        if (s1 == null) {
            return s2 == null ? 1 : -1;
        }
        if (s2 == null) {
            return -2;
        }
        if (s1.length != s2.length) {
            return -3;
        }
        if (s1.length == 1) {
            return s1[0].equals(s2[0]) ? 0 : -3;
        }
        ArraySet<Signature> set1 = new ArraySet<Signature>();
        for (Signature sig : s1) {
            set1.add(sig);
        }
        ArraySet<Signature> set2 = new ArraySet<Signature>();
        for (Signature sig : s2) {
            set2.add(sig);
        }
        if (set1.equals(set2)) {
            return 0;
        }
        return -3;
    }

    private static boolean matchSignaturesCompat(String packageName, PackageSignatures packageSignatures, PackageParser.SigningDetails parsedSignatures) {
        ArraySet<Signature> existingSet = new ArraySet<Signature>();
        for (Signature sig : packageSignatures.mSigningDetails.signatures) {
            existingSet.add(sig);
        }
        ArraySet<Signature> scannedCompatSet = new ArraySet<Signature>();
        for (Signature sig : parsedSignatures.signatures) {
            try {
                Signature[] chainSignatures;
                for (Signature chainSig : chainSignatures = sig.getChainSignatures()) {
                    scannedCompatSet.add(chainSig);
                }
            }
            catch (CertificateEncodingException e) {
                scannedCompatSet.add(sig);
            }
        }
        if (scannedCompatSet.equals(existingSet)) {
            packageSignatures.mSigningDetails = parsedSignatures;
            return true;
        }
        if (parsedSignatures.hasPastSigningCertificates()) {
            PackageManagerServiceUtils.logCriticalInfo(4, "Existing package " + packageName + " has flattened signing certificate chain. Unable to install newer version with rotated signing certificate.");
        }
        return false;
    }

    private static boolean matchSignaturesRecover(String packageName, PackageParser.SigningDetails existingSignatures, PackageParser.SigningDetails parsedSignatures, @PackageParser.SigningDetails.CertCapabilities int flags) {
        String msg = null;
        try {
            if (parsedSignatures.checkCapabilityRecover(existingSignatures, flags)) {
                PackageManagerServiceUtils.logCriticalInfo(4, "Recovered effectively matching certificates for " + packageName);
                return true;
            }
        }
        catch (CertificateException e) {
            msg = e.getMessage();
        }
        PackageManagerServiceUtils.logCriticalInfo(4, "Failed to recover certificates for " + packageName + ": " + msg);
        return false;
    }

    private static boolean matchSignatureInSystem(PackageSetting pkgSetting, PackageSetting disabledPkgSetting) {
        try {
            PackageParser.collectCertificates(disabledPkgSetting.pkg, true);
            if (pkgSetting.signatures.mSigningDetails.checkCapability(disabledPkgSetting.signatures.mSigningDetails, 1) || disabledPkgSetting.signatures.mSigningDetails.checkCapability(pkgSetting.signatures.mSigningDetails, 8)) {
                return true;
            }
            PackageManagerServiceUtils.logCriticalInfo(6, "Updated system app mismatches cert on /system: " + pkgSetting.name);
            return false;
        }
        catch (PackageParser.PackageParserException e) {
            PackageManagerServiceUtils.logCriticalInfo(6, "Failed to collect cert for " + pkgSetting.name + ": " + e.getMessage());
            return false;
        }
    }

    static boolean isApkVerityEnabled() {
        return SystemProperties.getInt("ro.apk_verity.mode", 0) != 0;
    }

    static boolean isApkVerificationForced(PackageSetting disabledPs) {
        return disabledPs != null && disabledPs.isPrivileged() && PackageManagerServiceUtils.isApkVerityEnabled();
    }

    public static boolean verifySignatures(PackageSetting pkgSetting, PackageSetting disabledPkgSetting, PackageParser.SigningDetails parsedSignatures, boolean compareCompat, boolean compareRecover) throws PackageManagerException {
        boolean match;
        String packageName = pkgSetting.name;
        boolean compatMatch = false;
        if (pkgSetting.signatures.mSigningDetails.signatures != null) {
            boolean bl = match = parsedSignatures.checkCapability(pkgSetting.signatures.mSigningDetails, 1) || pkgSetting.signatures.mSigningDetails.checkCapability(parsedSignatures, 8);
            if (!match && compareCompat) {
                compatMatch = match = PackageManagerServiceUtils.matchSignaturesCompat(packageName, pkgSetting.signatures, parsedSignatures);
            }
            if (!match && compareRecover) {
                boolean bl2 = match = PackageManagerServiceUtils.matchSignaturesRecover(packageName, pkgSetting.signatures.mSigningDetails, parsedSignatures, 1) || PackageManagerServiceUtils.matchSignaturesRecover(packageName, parsedSignatures, pkgSetting.signatures.mSigningDetails, 8);
            }
            if (!match && PackageManagerServiceUtils.isApkVerificationForced(disabledPkgSetting)) {
                match = PackageManagerServiceUtils.matchSignatureInSystem(pkgSetting, disabledPkgSetting);
            }
            if (!match) {
                throw new PackageManagerException(-7, "Package " + packageName + " signatures do not match previously installed version; ignoring!");
            }
        }
        if (pkgSetting.sharedUser != null && pkgSetting.sharedUser.signatures.mSigningDetails != PackageParser.SigningDetails.UNKNOWN) {
            boolean bl = match = parsedSignatures.checkCapability(pkgSetting.sharedUser.signatures.mSigningDetails, 2) || pkgSetting.sharedUser.signatures.mSigningDetails.checkCapability(parsedSignatures, 2);
            if (!match && compareCompat) {
                match = PackageManagerServiceUtils.matchSignaturesCompat(packageName, pkgSetting.sharedUser.signatures, parsedSignatures);
            }
            if (!match && compareRecover) {
                match = PackageManagerServiceUtils.matchSignaturesRecover(packageName, pkgSetting.sharedUser.signatures.mSigningDetails, parsedSignatures, 2) || PackageManagerServiceUtils.matchSignaturesRecover(packageName, parsedSignatures, pkgSetting.sharedUser.signatures.mSigningDetails, 2);
                compatMatch |= match;
            }
            if (!match) {
                throw new PackageManagerException(-8, "Package " + packageName + " has no signatures that match those in shared user " + pkgSetting.sharedUser.name + "; ignoring!");
            }
        }
        return compatMatch;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int decompressFile(File srcFile, File dstFile) throws ErrnoException {
        if (PackageManagerService.DEBUG_COMPRESSION) {
            Slog.i("PackageManager", "Decompress file; src: " + srcFile.getAbsolutePath() + ", dst: " + dstFile.getAbsolutePath());
        }
        try {
            Throwable throwable = null;
            try (GZIPInputStream fileIn = new GZIPInputStream(new FileInputStream(srcFile));){
                int n;
                FileOutputStream fileOut = new FileOutputStream(dstFile, false);
                Throwable throwable2 = null;
                try {
                    FileUtils.copy(fileIn, fileOut);
                    Os.chmod(dstFile.getAbsolutePath(), 420);
                    n = 1;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            PackageManagerServiceUtils.$closeResource(throwable2, fileOut);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                PackageManagerServiceUtils.$closeResource(throwable2, fileOut);
                return n;
            }
        }
        catch (IOException e) {
            PackageManagerServiceUtils.logCriticalInfo(6, "Failed to decompress file; src: " + srcFile.getAbsolutePath() + ", dst: " + dstFile.getAbsolutePath());
            return -110;
        }
    }

    public static File[] getCompressedFiles(String codePath) {
        File stubCodePath = new File(codePath);
        String stubName = stubCodePath.getName();
        int idx = stubName.lastIndexOf("-Stub");
        if (idx < 0 || stubName.length() != idx + "-Stub".length()) {
            return null;
        }
        File stubParentDir = stubCodePath.getParentFile();
        if (stubParentDir == null) {
            Slog.e("PackageManager", "Unable to determine stub parent dir for codePath: " + codePath);
            return null;
        }
        File compressedPath = new File(stubParentDir, stubName.substring(0, idx));
        Object[] files = compressedPath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".gz");
            }
        });
        if (PackageManagerService.DEBUG_COMPRESSION && files != null && files.length > 0) {
            Slog.i("PackageManager", "getCompressedFiles[" + codePath + "]: " + Arrays.toString(files));
        }
        return files;
    }

    public static boolean compressedFileExists(String codePath) {
        File[] compressedFiles = PackageManagerServiceUtils.getCompressedFiles(codePath);
        return compressedFiles != null && compressedFiles.length > 0;
    }
}

