/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageParser;
import android.content.pm.dex.ArtManager;
import android.content.pm.dex.DexMetadataHelper;
import android.os.FileUtils;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.WorkSource;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.pm.CompilerStats;
import com.android.server.pm.Installer;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.PackageManagerServiceCompilerMapping;
import com.android.server.pm.dex.DexManager;
import com.android.server.pm.dex.DexoptOptions;
import com.android.server.pm.dex.DexoptUtils;
import com.android.server.pm.dex.PackageDexUsage;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PackageDexOptimizer {
    private static final String TAG = "PackageManager.DexOptimizer";
    static final String OAT_DIR_NAME = "oat";
    public static final int DEX_OPT_SKIPPED = 0;
    public static final int DEX_OPT_PERFORMED = 1;
    public static final int DEX_OPT_FAILED = -1;
    private static final long WAKELOCK_TIMEOUT_MS = 660000L;
    public static final String SKIP_SHARED_LIBRARY_CHECK = "&";
    @GuardedBy(value="mInstallLock")
    private final Installer mInstaller;
    private final Object mInstallLock;
    @GuardedBy(value="mInstallLock")
    private final PowerManager.WakeLock mDexoptWakeLock;
    private volatile boolean mSystemReady;

    PackageDexOptimizer(Installer installer, Object installLock, Context context, String wakeLockTag) {
        this.mInstaller = installer;
        this.mInstallLock = installLock;
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mDexoptWakeLock = powerManager.newWakeLock(1, wakeLockTag);
    }

    protected PackageDexOptimizer(PackageDexOptimizer from) {
        this.mInstaller = from.mInstaller;
        this.mInstallLock = from.mInstallLock;
        this.mDexoptWakeLock = from.mDexoptWakeLock;
        this.mSystemReady = from.mSystemReady;
    }

    static boolean canOptimizePackage(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int performDexOpt(PackageParser.Package pkg, String[] sharedLibraries, String[] instructionSets, CompilerStats.PackageStats packageStats, PackageDexUsage.PackageUseInfo packageUseInfo, DexoptOptions options) {
        if (pkg.applicationInfo.uid == -1) {
            throw new IllegalArgumentException("Dexopt for " + pkg.packageName + " has invalid uid.");
        }
        if (!PackageDexOptimizer.canOptimizePackage(pkg)) {
            return 0;
        }
        Object object = this.mInstallLock;
        synchronized (object) {
            int n;
            long acquireTime = this.acquireWakeLockLI(pkg.applicationInfo.uid);
            try {
                n = this.performDexOptLI(pkg, sharedLibraries, instructionSets, packageStats, packageUseInfo, options);
                this.releaseWakeLockLI(acquireTime);
            }
            catch (Throwable throwable) {
                this.releaseWakeLockLI(acquireTime);
                throw throwable;
            }
            return n;
        }
    }

    @GuardedBy(value="mInstallLock")
    private int performDexOptLI(PackageParser.Package pkg, String[] sharedLibraries, String[] targetInstructionSets, CompilerStats.PackageStats packageStats, PackageDexUsage.PackageUseInfo packageUseInfo, DexoptOptions options) {
        String[] instructionSets = targetInstructionSets != null ? targetInstructionSets : InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
        String[] dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets);
        List<String> paths = pkg.getAllCodePaths();
        int sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
        if (sharedGid == -1) {
            Slog.wtf(TAG, "Well this is awkward; package " + pkg.applicationInfo.name + " had UID " + pkg.applicationInfo.uid, new Throwable());
            sharedGid = 9999;
        }
        boolean[] pathsWithCode = new boolean[paths.size()];
        pathsWithCode[0] = (pkg.applicationInfo.flags & 4) != 0;
        for (int i = 1; i < paths.size(); ++i) {
            pathsWithCode[i] = (pkg.splitFlags[i - 1] & 4) != 0;
        }
        String[] classLoaderContexts = DexoptUtils.getClassLoaderContexts(pkg.applicationInfo, sharedLibraries, pathsWithCode);
        if (paths.size() != classLoaderContexts.length) {
            Object[] splitCodePaths = pkg.applicationInfo.getSplitCodePaths();
            throw new IllegalStateException("Inconsistent information between PackageParser.Package and its ApplicationInfo. pkg.getAllCodePaths=" + paths + " pkg.applicationInfo.getBaseCodePath=" + pkg.applicationInfo.getBaseCodePath() + " pkg.applicationInfo.getSplitCodePaths=" + (splitCodePaths == null ? "null" : Arrays.toString(splitCodePaths)));
        }
        int result = 0;
        for (int i = 0; i < paths.size(); ++i) {
            if (!pathsWithCode[i]) continue;
            if (classLoaderContexts[i] == null) {
                throw new IllegalStateException("Inconsistent information in the package structure. A split is marked to contain code but has no dependency listed. Index=" + i + " path=" + paths.get(i));
            }
            String path = paths.get(i);
            if (options.getSplitName() != null && !options.getSplitName().equals(new File(path).getName())) continue;
            String profileName = ArtManager.getProfileName(i == 0 ? null : pkg.splitNames[i - 1]);
            String dexMetadataPath = null;
            if (options.isDexoptInstallWithDexMetadata()) {
                File dexMetadataFile = DexMetadataHelper.findDexMetadataForFile(new File(path));
                dexMetadataPath = dexMetadataFile == null ? null : dexMetadataFile.getAbsolutePath();
            }
            boolean isUsedByOtherApps = options.isDexoptAsSharedLibrary() || packageUseInfo.isUsedByOtherApps(path);
            String compilerFilter = this.getRealCompilerFilter(pkg.applicationInfo, options.getCompilerFilter(), isUsedByOtherApps);
            boolean profileUpdated = options.isCheckForProfileUpdates() && this.isProfileUpdated(pkg, sharedGid, profileName, compilerFilter);
            int dexoptFlags = this.getDexFlags(pkg, compilerFilter, options);
            for (String dexCodeIsa : dexCodeInstructionSets) {
                int newResult = this.dexOptPath(pkg, path, dexCodeIsa, compilerFilter, profileUpdated, classLoaderContexts[i], dexoptFlags, sharedGid, packageStats, options.isDowngrade(), profileName, dexMetadataPath, options.getCompilationReason());
                if (result == -1 || newResult == 0) continue;
                result = newResult;
            }
        }
        return result;
    }

    @GuardedBy(value="mInstallLock")
    private int dexOptPath(PackageParser.Package pkg, String path, String isa, String compilerFilter, boolean profileUpdated, String classLoaderContext, int dexoptFlags, int uid, CompilerStats.PackageStats packageStats, boolean downgrade, String profileName, String dexMetadataPath, int compilationReason) {
        int dexoptNeeded = this.getDexoptNeeded(path, isa, compilerFilter, classLoaderContext, profileUpdated, downgrade);
        if (Math.abs(dexoptNeeded) == 0) {
            return 0;
        }
        String oatDir = this.createOatDirIfSupported(pkg, isa);
        Log.i(TAG, "Running dexopt (dexoptNeeded=" + dexoptNeeded + ") on: " + path + " pkg=" + pkg.applicationInfo.packageName + " isa=" + isa + " dexoptFlags=" + this.printDexoptFlags(dexoptFlags) + " targetFilter=" + compilerFilter + " oatDir=" + oatDir + " classLoaderContext=" + classLoaderContext);
        try {
            long startTime = System.currentTimeMillis();
            this.mInstaller.dexopt(path, uid, pkg.packageName, isa, dexoptNeeded, oatDir, dexoptFlags, compilerFilter, pkg.volumeUuid, classLoaderContext, pkg.applicationInfo.seInfo, false, pkg.applicationInfo.targetSdkVersion, profileName, dexMetadataPath, this.getAugmentedReasonName(compilationReason, dexMetadataPath != null));
            if (packageStats != null) {
                long endTime = System.currentTimeMillis();
                packageStats.setCompileTime(path, (int)(endTime - startTime));
            }
            return 1;
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, "Failed to dexopt", e);
            return -1;
        }
    }

    private String getAugmentedReasonName(int compilationReason, boolean useDexMetadata) {
        String annotation = useDexMetadata ? "-dm" : "";
        return PackageManagerServiceCompilerMapping.getReasonName(compilationReason) + annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dexOptSecondaryDexPath(ApplicationInfo info, String path, PackageDexUsage.DexUseInfo dexUseInfo, DexoptOptions options) {
        if (info.uid == -1) {
            throw new IllegalArgumentException("Dexopt for path " + path + " has invalid uid.");
        }
        Object object = this.mInstallLock;
        synchronized (object) {
            int n;
            long acquireTime = this.acquireWakeLockLI(info.uid);
            try {
                n = this.dexOptSecondaryDexPathLI(info, path, dexUseInfo, options);
                this.releaseWakeLockLI(acquireTime);
            }
            catch (Throwable throwable) {
                this.releaseWakeLockLI(acquireTime);
                throw throwable;
            }
            return n;
        }
    }

    @GuardedBy(value="mInstallLock")
    private long acquireWakeLockLI(int uid) {
        if (!this.mSystemReady) {
            return -1L;
        }
        this.mDexoptWakeLock.setWorkSource(new WorkSource(uid));
        this.mDexoptWakeLock.acquire(660000L);
        return SystemClock.elapsedRealtime();
    }

    @GuardedBy(value="mInstallLock")
    private void releaseWakeLockLI(long acquireTime) {
        if (acquireTime < 0L) {
            return;
        }
        try {
            long duration;
            if (this.mDexoptWakeLock.isHeld()) {
                this.mDexoptWakeLock.release();
            }
            if ((duration = SystemClock.elapsedRealtime() - acquireTime) >= 660000L) {
                Slog.wtf(TAG, "WakeLock " + this.mDexoptWakeLock.getTag() + " time out. Operation took " + duration + " ms. Thread: " + Thread.currentThread().getName());
            }
        }
        catch (Exception e) {
            Slog.wtf(TAG, "Error while releasing " + this.mDexoptWakeLock.getTag() + " lock", e);
        }
    }

    @GuardedBy(value="mInstallLock")
    private int dexOptSecondaryDexPathLI(ApplicationInfo info, String path, PackageDexUsage.DexUseInfo dexUseInfo, DexoptOptions options) {
        if (options.isDexoptOnlySharedDex() && !dexUseInfo.isUsedByOtherApps()) {
            return 0;
        }
        String compilerFilter = this.getRealCompilerFilter(info, options.getCompilerFilter(), dexUseInfo.isUsedByOtherApps());
        int dexoptFlags = this.getDexFlags(info, compilerFilter, options) | 0x20;
        if (info.deviceProtectedDataDir != null && FileUtils.contains(info.deviceProtectedDataDir, path)) {
            dexoptFlags |= 0x100;
        } else if (info.credentialProtectedDataDir != null && FileUtils.contains(info.credentialProtectedDataDir, path)) {
            dexoptFlags |= 0x80;
        } else {
            Slog.e(TAG, "Could not infer CE/DE storage for package " + info.packageName);
            return -1;
        }
        Log.d(TAG, "Running dexopt on: " + path + " pkg=" + info.packageName + " isa=" + dexUseInfo.getLoaderIsas() + " dexoptFlags=" + this.printDexoptFlags(dexoptFlags) + " target-filter=" + compilerFilter);
        String classLoaderContext = SKIP_SHARED_LIBRARY_CHECK;
        int reason = options.getCompilationReason();
        try {
            for (String isa : dexUseInfo.getLoaderIsas()) {
                this.mInstaller.dexopt(path, info.uid, info.packageName, isa, 0, null, dexoptFlags, compilerFilter, info.volumeUuid, classLoaderContext, info.seInfoUser, options.isDowngrade(), info.targetSdkVersion, null, null, PackageManagerServiceCompilerMapping.getReasonName(reason));
            }
            return 1;
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, "Failed to dexopt", e);
            return -1;
        }
    }

    protected int adjustDexoptNeeded(int dexoptNeeded) {
        return dexoptNeeded;
    }

    protected int adjustDexoptFlags(int dexoptFlags) {
        return dexoptFlags;
    }

    void dumpDexoptState(IndentingPrintWriter pw, PackageParser.Package pkg, PackageDexUsage.PackageUseInfo useInfo) {
        String[] instructionSets = InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
        String[] dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets);
        List<String> paths = pkg.getAllCodePathsExcludingResourceOnly();
        for (String path : paths) {
            Map<String, PackageDexUsage.DexUseInfo> dexUseInfoMap;
            pw.println("path: " + path);
            pw.increaseIndent();
            for (String isa : dexCodeInstructionSets) {
                try {
                    DexFile.OptimizationInfo info = DexFile.getDexFileOptimizationInfo(path, isa);
                    pw.println(isa + ": [status=" + info.getStatus() + "] [reason=" + info.getReason() + "]");
                }
                catch (IOException ioe) {
                    pw.println(isa + ": [Exception]: " + ioe.getMessage());
                }
            }
            if (useInfo.isUsedByOtherApps(path)) {
                pw.println("used by other apps: " + useInfo.getLoadingPackages(path));
            }
            if (!(dexUseInfoMap = useInfo.getDexUseInfoMap()).isEmpty()) {
                pw.println("known secondary dex files:");
                pw.increaseIndent();
                for (Map.Entry<String, PackageDexUsage.DexUseInfo> e : dexUseInfoMap.entrySet()) {
                    String dex = e.getKey();
                    PackageDexUsage.DexUseInfo dexUseInfo = e.getValue();
                    pw.println(dex);
                    pw.increaseIndent();
                    pw.println("class loader context: " + dexUseInfo.getClassLoaderContext());
                    if (dexUseInfo.isUsedByOtherApps()) {
                        pw.println("used by other apps: " + dexUseInfo.getLoadingPackages());
                    }
                    pw.decreaseIndent();
                }
                pw.decreaseIndent();
            }
            pw.decreaseIndent();
        }
    }

    private String getRealCompilerFilter(ApplicationInfo info, String targetCompilerFilter, boolean isUsedByOtherApps) {
        boolean vmSafeMode;
        int flags = info.flags;
        boolean bl = vmSafeMode = (flags & 0x4000) != 0;
        if (info.isPrivilegedApp() && DexManager.isPackageSelectedToRunOob(info.packageName)) {
            return "verify";
        }
        if (vmSafeMode) {
            return DexFile.getSafeModeCompilerFilter(targetCompilerFilter);
        }
        if (DexFile.isProfileGuidedCompilerFilter(targetCompilerFilter) && isUsedByOtherApps) {
            return PackageManagerServiceCompilerMapping.getCompilerFilterForReason(6);
        }
        return targetCompilerFilter;
    }

    private int getDexFlags(PackageParser.Package pkg, String compilerFilter, DexoptOptions options) {
        return this.getDexFlags(pkg.applicationInfo, compilerFilter, options);
    }

    private boolean isAppImageEnabled() {
        return SystemProperties.get("dalvik.vm.appimageformat", "").length() > 0;
    }

    private int getDexFlags(ApplicationInfo info, String compilerFilter, DexoptOptions options) {
        int flags = info.flags;
        boolean debuggable = (flags & 2) != 0;
        boolean isProfileGuidedFilter = DexFile.isProfileGuidedCompilerFilter(compilerFilter);
        boolean isPublic = !info.isForwardLocked() && (!isProfileGuidedFilter || options.isDexoptInstallWithDexMetadata());
        int profileFlag = isProfileGuidedFilter ? 16 : 0;
        int hiddenApiFlag = info.getHiddenApiEnforcementPolicy() == 0 ? 0 : 1024;
        int compilationReason = options.getCompilationReason();
        boolean generateCompactDex = true;
        switch (compilationReason) {
            case 0: 
            case 1: 
            case 2: {
                generateCompactDex = false;
            }
        }
        boolean generateAppImage = isProfileGuidedFilter && (info.splitDependencies == null || !info.requestsIsolatedSplitLoading()) && this.isAppImageEnabled();
        int dexFlags = (isPublic ? 2 : 0) | (debuggable ? 4 : 0) | profileFlag | (options.isBootComplete() ? 8 : 0) | (options.isDexoptIdleBackgroundJob() ? 512 : 0) | (generateCompactDex ? 2048 : 0) | (generateAppImage ? 4096 : 0) | hiddenApiFlag;
        return this.adjustDexoptFlags(dexFlags);
    }

    private int getDexoptNeeded(String path, String isa, String compilerFilter, String classLoaderContext, boolean newProfile, boolean downgrade) {
        int dexoptNeeded;
        try {
            dexoptNeeded = DexFile.getDexOptNeeded(path, isa, compilerFilter, classLoaderContext, newProfile, downgrade);
        }
        catch (IOException ioe) {
            Slog.w(TAG, "IOException reading apk: " + path, ioe);
            return -1;
        }
        return this.adjustDexoptNeeded(dexoptNeeded);
    }

    private boolean isProfileUpdated(PackageParser.Package pkg, int uid, String profileName, String compilerFilter) {
        if (!DexFile.isProfileGuidedCompilerFilter(compilerFilter)) {
            return false;
        }
        try {
            return this.mInstaller.mergeProfiles(uid, pkg.packageName, profileName);
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, "Failed to merge profiles", e);
            return false;
        }
    }

    private String createOatDirIfSupported(PackageParser.Package pkg, String dexInstructionSet) {
        if (!pkg.canHaveOatDir()) {
            return null;
        }
        File codePath = new File(pkg.codePath);
        if (codePath.isDirectory()) {
            File oatDir = PackageDexOptimizer.getOatDir(codePath);
            try {
                this.mInstaller.createOatDir(oatDir.getAbsolutePath(), dexInstructionSet);
            }
            catch (Installer.InstallerException e) {
                Slog.w(TAG, "Failed to create oat dir", e);
                return null;
            }
            return oatDir.getAbsolutePath();
        }
        return null;
    }

    static File getOatDir(File codePath) {
        return new File(codePath, OAT_DIR_NAME);
    }

    void systemReady() {
        this.mSystemReady = true;
    }

    private String printDexoptFlags(int flags) {
        ArrayList<String> flagsList = new ArrayList<String>();
        if ((flags & 8) == 8) {
            flagsList.add("boot_complete");
        }
        if ((flags & 4) == 4) {
            flagsList.add("debuggable");
        }
        if ((flags & 0x10) == 16) {
            flagsList.add("profile_guided");
        }
        if ((flags & 2) == 2) {
            flagsList.add("public");
        }
        if ((flags & 0x20) == 32) {
            flagsList.add("secondary");
        }
        if ((flags & 0x40) == 64) {
            flagsList.add("force");
        }
        if ((flags & 0x80) == 128) {
            flagsList.add("storage_ce");
        }
        if ((flags & 0x100) == 256) {
            flagsList.add("storage_de");
        }
        if ((flags & 0x200) == 512) {
            flagsList.add("idle_background_job");
        }
        if ((flags & 0x400) == 1024) {
            flagsList.add("enable_hidden_api_checks");
        }
        return String.join((CharSequence)",", flagsList);
    }

    public static class ForcedUpdatePackageDexOptimizer
    extends PackageDexOptimizer {
        public ForcedUpdatePackageDexOptimizer(Installer installer, Object installLock, Context context, String wakeLockTag) {
            super(installer, installLock, context, wakeLockTag);
        }

        public ForcedUpdatePackageDexOptimizer(PackageDexOptimizer from) {
            super(from);
        }

        @Override
        protected int adjustDexoptNeeded(int dexoptNeeded) {
            if (dexoptNeeded == 0) {
                return -3;
            }
            return dexoptNeeded;
        }

        @Override
        protected int adjustDexoptFlags(int flags) {
            return flags | 0x40;
        }
    }
}

