/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.ISchedulingPolicyService;
import android.os.Process;
import android.util.Log;
import com.android.server.SystemServerInitThreadPool;

public class SchedulingPolicyService
extends ISchedulingPolicyService.Stub {
    private static final String TAG = "SchedulingPolicyService";
    private static final int PRIORITY_MIN = 1;
    private static final int PRIORITY_MAX = 3;
    private static final String[] MEDIA_PROCESS_NAMES = new String[]{"media.codec"};
    private final IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        @Override
        public void binderDied() {
            SchedulingPolicyService.this.requestCpusetBoost(false, null);
        }
    };
    private int mBoostedPid = -1;
    private IBinder mClient;

    public SchedulingPolicyService() {
        SystemServerInitThreadPool.get().submit(() -> {
            IBinder.DeathRecipient deathRecipient = this.mDeathRecipient;
            synchronized (deathRecipient) {
                int[] nativePids;
                if (this.mBoostedPid == -1 && (nativePids = Process.getPidsForCommands(MEDIA_PROCESS_NAMES)) != null && nativePids.length == 1) {
                    this.mBoostedPid = nativePids[0];
                    this.disableCpusetBoost(nativePids[0]);
                }
            }
        }, "SchedulingPolicyService.<init>");
    }

    @Override
    public int requestPriority(int pid, int tid, int prio, boolean isForApp) {
        if (!this.isPermitted() || prio < 1 || prio > 3 || Process.getThreadGroupLeader(tid) != pid) {
            return -1;
        }
        if (Binder.getCallingUid() != 1002) {
            try {
                Process.setThreadGroup(tid, !isForApp ? 4 : 6);
            }
            catch (RuntimeException e) {
                Log.e(TAG, "Failed setThreadGroup: " + e);
                return -1;
            }
        }
        try {
            Process.setThreadScheduler(tid, 0x40000001, prio);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Failed setThreadScheduler: " + e);
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requestCpusetBoost(boolean enable, IBinder client) {
        if (Binder.getCallingPid() != Process.myPid() && Binder.getCallingUid() != 1013) {
            return -1;
        }
        int[] nativePids = Process.getPidsForCommands(MEDIA_PROCESS_NAMES);
        if (nativePids == null || nativePids.length != 1) {
            Log.e(TAG, "requestCpusetBoost: can't find media.codec process");
            return -1;
        }
        IBinder.DeathRecipient deathRecipient = this.mDeathRecipient;
        synchronized (deathRecipient) {
            if (enable) {
                return this.enableCpusetBoost(nativePids[0], client);
            }
            return this.disableCpusetBoost(nativePids[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enableCpusetBoost(int pid, IBinder client) {
        if (this.mBoostedPid == pid) {
            return 0;
        }
        this.mBoostedPid = -1;
        if (this.mClient != null) {
            try {
                this.mClient.unlinkToDeath(this.mDeathRecipient, 0);
            }
            catch (Exception exception) {
            }
            finally {
                this.mClient = null;
            }
        }
        try {
            client.linkToDeath(this.mDeathRecipient, 0);
            Log.i(TAG, "Moving " + pid + " to group " + 5);
            Process.setProcessGroup(pid, 5);
            this.mBoostedPid = pid;
            this.mClient = client;
            return 0;
        }
        catch (Exception e) {
            Log.e(TAG, "Failed enableCpusetBoost: " + e);
            try {
                client.unlinkToDeath(this.mDeathRecipient, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int disableCpusetBoost(int pid) {
        int boostedPid = this.mBoostedPid;
        this.mBoostedPid = -1;
        if (this.mClient != null) {
            try {
                this.mClient.unlinkToDeath(this.mDeathRecipient, 0);
            }
            catch (Exception exception) {
            }
            finally {
                this.mClient = null;
            }
        }
        if (boostedPid == pid) {
            try {
                Log.i(TAG, "Moving " + pid + " back to group default");
                Process.setProcessGroup(pid, -1);
            }
            catch (Exception e) {
                Log.w(TAG, "Couldn't move pid " + pid + " back to group default");
            }
        }
        return 0;
    }

    private boolean isPermitted() {
        if (Binder.getCallingPid() == Process.myPid()) {
            return true;
        }
        switch (Binder.getCallingUid()) {
            case 1002: 
            case 1041: 
            case 1047: {
                return true;
            }
        }
        return false;
    }
}

