/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.RouteInfo;
import com.android.server.net.BaseNetworkObserver;
import com.android.server.net.DnsServerRepository;
import java.util.Arrays;

public class NetlinkTracker
extends BaseNetworkObserver {
    private final String TAG;
    private final String mInterfaceName;
    private final Callback mCallback;
    private final LinkProperties mLinkProperties;
    private DnsServerRepository mDnsServerRepository;
    private static final boolean DBG = false;

    public NetlinkTracker(String iface, Callback callback) {
        this.TAG = "NetlinkTracker/" + iface;
        this.mInterfaceName = iface;
        this.mCallback = callback;
        this.mLinkProperties = new LinkProperties();
        this.mLinkProperties.setInterfaceName(this.mInterfaceName);
        this.mDnsServerRepository = new DnsServerRepository();
    }

    private void maybeLog(String operation, String iface, LinkAddress address) {
    }

    private void maybeLog(String operation, Object o) {
    }

    @Override
    public void interfaceRemoved(String iface) {
        this.maybeLog("interfaceRemoved", iface);
        if (this.mInterfaceName.equals(iface)) {
            this.clearLinkProperties();
            this.mCallback.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addressUpdated(String iface, LinkAddress address) {
        if (this.mInterfaceName.equals(iface)) {
            boolean changed;
            this.maybeLog("addressUpdated", iface, address);
            NetlinkTracker netlinkTracker = this;
            synchronized (netlinkTracker) {
                changed = this.mLinkProperties.addLinkAddress(address);
            }
            if (changed) {
                this.mCallback.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addressRemoved(String iface, LinkAddress address) {
        if (this.mInterfaceName.equals(iface)) {
            boolean changed;
            this.maybeLog("addressRemoved", iface, address);
            NetlinkTracker netlinkTracker = this;
            synchronized (netlinkTracker) {
                changed = this.mLinkProperties.removeLinkAddress(address);
            }
            if (changed) {
                this.mCallback.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void routeUpdated(RouteInfo route) {
        if (this.mInterfaceName.equals(route.getInterface())) {
            boolean changed;
            this.maybeLog("routeUpdated", route);
            NetlinkTracker netlinkTracker = this;
            synchronized (netlinkTracker) {
                changed = this.mLinkProperties.addRoute(route);
            }
            if (changed) {
                this.mCallback.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void routeRemoved(RouteInfo route) {
        if (this.mInterfaceName.equals(route.getInterface())) {
            boolean changed;
            this.maybeLog("routeRemoved", route);
            NetlinkTracker netlinkTracker = this;
            synchronized (netlinkTracker) {
                changed = this.mLinkProperties.removeRoute(route);
            }
            if (changed) {
                this.mCallback.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interfaceDnsServerInfo(String iface, long lifetime, String[] addresses) {
        if (this.mInterfaceName.equals(iface)) {
            this.maybeLog("interfaceDnsServerInfo", Arrays.toString(addresses));
            boolean changed = this.mDnsServerRepository.addServers(lifetime, addresses);
            if (changed) {
                NetlinkTracker netlinkTracker = this;
                synchronized (netlinkTracker) {
                    this.mDnsServerRepository.setDnsServersOn(this.mLinkProperties);
                }
                this.mCallback.update();
            }
        }
    }

    public synchronized LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public synchronized void clearLinkProperties() {
        this.mDnsServerRepository = new DnsServerRepository();
        this.mLinkProperties.clear();
        this.mLinkProperties.setInterfaceName(this.mInterfaceName);
    }

    public static interface Callback {
        public void update();
    }
}

